/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.python.testGeneration;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringBackendKt;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.std.FilePathPrivacyWrapperKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.python.context.PythonContextUtils;
import com.intellij.ml.llm.tokenizer.Tokenizer;
import com.intellij.ml.llm.tokenizer.fus.PromptSource;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyReferenceExpression;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001c\u0010\t\u001a\u0004\u0018\u00010\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0000\u001a$\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0014\u001a\u00020\bH\u0002\u001a$\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0000\u00a8\u0006\u001c"}, d2={"getPresentableNameAndDescription", "Lkotlin/Pair;", "Lcom/intellij/ml/llm/privacy/PSString;", "element", "Lcom/intellij/psi/PsiElement;", "tokenizer", "Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "maxTextTokens", "", "getRelativePath", "path", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "getRelevantElements", "", "elem", "getClassDescription", "clazz", "Lcom/jetbrains/python/psi/PyClass;", "maxClassTextTokens", "getFunctionDescription", "function", "Lcom/jetbrains/python/psi/PyFunction;", "getDescription", "file", "Lcom/jetbrains/python/psi/PyFile;", "fileContents", "intellij.ml.llm.python"})
@SourceDebugExtension(value={"SMAP\nPythonTestsPromptBuildUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonTestsPromptBuildUtil.kt\ncom/intellij/ml/llm/python/testGeneration/PythonTestsPromptBuildUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,129:1\n1563#2:130\n1634#2,3:131\n774#2:134\n865#2,2:135\n996#3:137\n1025#3,3:138\n1028#3,3:148\n382#4,7:141\n126#5:151\n153#5,3:152\n*S KotlinDebug\n*F\n+ 1 PythonTestsPromptBuildUtil.kt\ncom/intellij/ml/llm/python/testGeneration/PythonTestsPromptBuildUtilKt\n*L\n64#1:130\n64#1:131,3\n65#1:134\n65#1:135,2\n81#1:137\n81#1:138,3\n81#1:148,3\n81#1:141,7\n82#1:151\n82#1:152,3\n*E\n"})
public final class PythonTestsPromptBuildUtilKt {
    @Nullable
    public static final Pair<PSString, PSString> getPresentableNameAndDescription(@NotNull PsiElement element2, @NotNull Tokenizer tokenizer, int maxTextTokens) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        if (PrivacyPathCheckerKt.isAiIgnoreBlocked(element2)) {
            return null;
        }
        PsiElement psiElement = element2;
        if (psiElement instanceof PyFunction) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((PsiNamedElement)element2).getName()};
            PSString functionName = ConstantsKt.getPrivacyConst((String)"function `%s`").format(pSStringConvertibleArray);
            PSString pSString = PythonTestsPromptBuildUtilKt.getFunctionDescription((PyFunction)element2, tokenizer, maxTextTokens);
            if (pSString == null) {
                return null;
            }
            PSString functionDescription = pSString;
            pair = TuplesKt.to((Object)functionName, (Object)functionDescription);
        } else if (psiElement instanceof PyClass) {
            PSStringConvertible[] functionDescription = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((PsiNamedElement)element2).getName()};
            PSString className = ConstantsKt.getPrivacyConst((String)"class `%s`").format(functionDescription);
            PSString pSString = PythonTestsPromptBuildUtilKt.getClassDescription((PyClass)element2, tokenizer, maxTextTokens);
            if (pSString == null) {
                return null;
            }
            PSString classDescription = pSString;
            pair = TuplesKt.to((Object)className, (Object)classDescription);
        } else {
            pair = null;
        }
        return pair;
    }

    public static /* synthetic */ Pair getPresentableNameAndDescription$default(PsiElement psiElement, Tokenizer tokenizer, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 4000;
        }
        return PythonTestsPromptBuildUtilKt.getPresentableNameAndDescription(psiElement, tokenizer, n);
    }

    @Nullable
    public static final PSString getRelativePath(@Nullable Path path, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (path == null) {
            return null;
        }
        String string = project2.getBasePath();
        if (string == null) {
            return null;
        }
        File base = new File(string);
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return FilePathPrivacyWrapperKt.getRelativePathPrivacySafe((File)base, (File)file);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PsiElement> getRelevantElements(@NotNull PsiElement elem) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        boolean bl;
        PsiElement it;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Sequence $this$filterTo$iv$iv;
        Collection object;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)elem, PyClass.class);
        if (pyClass == null) {
            pyClass = PsiTreeUtil.getParentOfType((PsiElement)elem, PyFunction.class);
        }
        PyClass container2 = pyClass;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)elem, PyReferenceExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        Iterable $this$map$iv2 = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it2;
            PyReferenceExpression pyReferenceExpression = (PyReferenceExpression)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            object.add(it2.getReference());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo232 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiPolyVariantReference it2 = (PsiPolyVariantReference)element$iv$iv;
            boolean bl3 = false;
            if (!(!it2.isSoft())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List refs = (List)destination$iv$iv;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)elem.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex index = projectFileIndex;
        $this$filterTo$iv$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)refs), PythonTestsPromptBuildUtilKt::getRelevantElements$lambda$2), PythonTestsPromptBuildUtilKt::getRelevantElements$lambda$3), PythonTestsPromptBuildUtilKt::getRelevantElements$lambda$4), arg_0 -> PythonTestsPromptBuildUtilKt.getRelevantElements$lambda$5(index, arg_0)), PythonTestsPromptBuildUtilKt::getRelevantElements$lambda$6), arg_0 -> PythonTestsPromptBuildUtilKt.getRelevantElements$lambda$7(elem, container2, arg_0));
        boolean $i$f$groupBy = false;
        void $i$f$filterTo232 = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object e : $this$groupByTo$iv$iv) {
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            it = (PsiElement)e;
            bl = false;
            PsiElement key$iv$iv = it;
            Map map2 = destination$iv$iv2;
            PsiElement key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(e);
        }
        $this$groupBy$iv = destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo2 = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            list$iv$iv = entry;
            object = destination$iv$iv3;
            bl = false;
            object.add((PsiElement)CollectionsKt.first((List)((List)it.getValue())));
        }
        List resolved = CollectionsKt.toList((Iterable)((List)destination$iv$iv3));
        return resolved;
    }

    private static final PSString getClassDescription(PyClass clazz, Tokenizer tokenizer, int maxClassTextTokens) {
        PsiFile psiFile = clazz.getContainingFile();
        PyFile pyFile = psiFile instanceof PyFile ? (PyFile)psiFile : null;
        if (pyFile == null) {
            return null;
        }
        PyFile file = pyFile;
        PSString classText = (PSString)ApplicationManager.getApplication().runReadAction(() -> PythonTestsPromptBuildUtilKt.getClassDescription$lambda$0(clazz, tokenizer, maxClassTextTokens));
        Intrinsics.checkNotNull((Object)classText);
        return PythonTestsPromptBuildUtilKt.getDescription(file, classText);
    }

    static /* synthetic */ PSString getClassDescription$default(PyClass pyClass, Tokenizer tokenizer, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 4000;
        }
        return PythonTestsPromptBuildUtilKt.getClassDescription(pyClass, tokenizer, n);
    }

    private static final PSString getFunctionDescription(PyFunction function, Tokenizer tokenizer, int maxTextTokens) {
        PsiFile psiFile = function.getContainingFile();
        PyFile pyFile = psiFile instanceof PyFile ? (PyFile)psiFile : null;
        if (pyFile == null) {
            return null;
        }
        PyFile file = pyFile;
        PSString functionWithContextText = (PSString)ApplicationManager.getApplication().runReadAction(() -> PythonTestsPromptBuildUtilKt.getFunctionDescription$lambda$0(function, tokenizer, maxTextTokens));
        Intrinsics.checkNotNull((Object)functionWithContextText);
        return PythonTestsPromptBuildUtilKt.getDescription(file, functionWithContextText);
    }

    static /* synthetic */ PSString getFunctionDescription$default(PyFunction pyFunction, Tokenizer tokenizer, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 4000;
        }
        return PythonTestsPromptBuildUtilKt.getFunctionDescription(pyFunction, tokenizer, n);
    }

    @NotNull
    public static final PSString getDescription(@NotNull PyFile file, @NotNull PSString fileContents) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileContents, (String)"fileContents");
        VirtualFile virtualFile2 = file.getVirtualFile();
        Path path = virtualFile2 != null ? VirtualFileUtil.toNioPathOrNull((VirtualFile)virtualFile2) : null;
        Project project2 = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        PSString pSString = PythonTestsPromptBuildUtilKt.getRelativePath(path, project2);
        if (pSString == null) {
            pSString = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)file).getName();
        }
        PSString filePath = pSString;
        return PSStringKt.buildStringPrivacySafe(arg_0 -> PythonTestsPromptBuildUtilKt.getDescription$lambda$0(filePath, file, fileContents, arg_0));
    }

    private static final PsiElement getRelevantElements$lambda$2(PsiPolyVariantReference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.resolve();
    }

    private static final boolean getRelevantElements$lambda$3(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !PrivacyPathCheckerKt.isAiIgnoreBlocked(it);
    }

    private static final boolean getRelevantElements$lambda$4(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PyFunction || it instanceof PyClass;
    }

    private static final boolean getRelevantElements$lambda$5(ProjectFileIndex $index, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $index.isInContent(it.getContainingFile().getVirtualFile());
    }

    private static final PsiElement getRelevantElements$lambda$6(PsiElement it) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof PyFunction) {
            PyClass pyClass = ((PyFunction)it).getContainingClass();
            if (pyClass == null) {
                pyClass = it;
            }
            psiElement = (PsiElement)pyClass;
        } else {
            psiElement = it;
        }
        return psiElement;
    }

    private static final boolean getRelevantElements$lambda$7(PsiElement $elem, Object $container, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)$elem) && !Intrinsics.areEqual((Object)it, (Object)$container);
    }

    private static final PSString getClassDescription$lambda$0(PyClass $clazz, Tokenizer $tokenizer, int $maxClassTextTokens) {
        PSString it = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)$clazz).getText();
        boolean bl = false;
        it = $tokenizer.count((String)it.unwrap()) >= $maxClassTextTokens ? PythonContextUtils.getClassSignatureText$default(PythonContextUtils.INSTANCE, $clazz, null, 2, null) : it;
        boolean bl2 = false;
        return PSStringBackendKt.trim($tokenizer, it, $maxClassTextTokens, PromptSource.PYTHON_TEST_PROMPT_BUILD_CLASS_DESCRIPTION);
    }

    private static final PSString getFunctionDescription$lambda$0(PyFunction $function, Tokenizer $tokenizer, int $maxTextTokens) {
        PSString it = PythonContextUtils.getFunctionFullContextText$default(PythonContextUtils.INSTANCE, $function, $tokenizer, 0, 0, 0, 28, null);
        boolean bl = false;
        it = $tokenizer.count((String)it.unwrap()) >= $maxTextTokens ? ExtensionsKtKt.getPrivacySafe((PsiNamedElement)$function).getText() : it;
        boolean bl2 = false;
        return PSStringBackendKt.trim($tokenizer, it, $maxTextTokens, PromptSource.PYTHON_FUNCTION_FULL_CONTEXT_FUNCTION_TEXT);
    }

    private static final Unit getDescription$lambda$0(PSString $filePath, PyFile $file, PSString $fileContents, ConcatenateBuilder $this$buildStringPrivacySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$buildStringPrivacySafe, (String)"$this$buildStringPrivacySafe");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{$filePath};
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"File: %s").format(pSStringConvertibleArray));
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"```python"));
        List list = $file.getImportBlock();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getImportBlock(...)");
        PSStringKt.joinToString$default((Iterable)list, (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)"\n")), null, null, (int)0, null, PythonTestsPromptBuildUtilKt::getDescription$lambda$0$0, (int)30, null);
        $this$buildStringPrivacySafe.appendLine($fileContents.trim());
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"```"));
        return Unit.INSTANCE;
    }

    private static final PrivacySafe getDescription$lambda$0$0(PyImportStatementBase it) {
        Intrinsics.checkNotNull((Object)it);
        return (PrivacySafe)ExtensionsKtKt.getPrivacySafe((PsiElement)it).getText();
    }
}

