/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.python.writeDocumentation;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.ml.llm.core.LLMDocumentationSupportWithBlockComments;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPromptService;
import com.intellij.ml.llm.grazie.tasks.documentation.WdPromptCustomization;
import com.intellij.ml.llm.grazie.tasks.documentation.WdPromptOptions;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.python.context.PythonContextUtils;
import com.intellij.ml.llm.python.privacy.ExtensionsKtKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.jetbrains.python.ast.PyAstDocStringOwner;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyPlainStringElement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 72\u00020\u0001:\u00017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u001e\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J2\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00192\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010!\u001a\u00020\"*\u00020 2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00192\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u000f2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0017\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u0014\u001a\u00020\u000fH\u0017\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u000fH\u0017J\u0010\u00100\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0012\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u000206H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\u00a8\u00068"}, d2={"Lcom/intellij/ml/llm/python/writeDocumentation/LLMPythonDocumentationSupport;", "Lcom/intellij/ml/llm/core/LLMDocumentationSupportWithBlockComments;", "<init>", "()V", "emptyDocumentation", "", "getEmptyDocumentation", "()Ljava/lang/String;", "commentStart", "getCommentStart", "commentEnd", "getCommentEnd", "emptyDocWithoutNewLines", "getEmptyDocWithoutNewLines$intellij_ml_llm_python", "getDocComment", "Lcom/intellij/psi/PsiElement;", "element", "findExampleDoc", "Lkotlin/Pair;", "Lcom/intellij/ml/llm/privacy/PSString;", "documentationTarget", "updateDoc", "", "newDocText", "getSelectedClassesAndFunctions", "", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "classes", "Lcom/jetbrains/python/psi/PyClass;", "functions", "Lcom/jetbrains/python/psi/PyFunction;", "selectionModel", "Lcom/intellij/openapi/editor/SelectionModel;", "intersectsElement", "", "findDocTargetsInSelection", "root", "findNearestDocumentationTargetForCaret", "editor", "Lcom/intellij/openapi/editor/Editor;", "isModulePyDocStringGenerationAllowedHere", "pyFile", "Lcom/jetbrains/python/psi/PyFile;", "findNearestDocumentationTarget", "computeFeedbackInlayOffset", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Integer;", "reformatDocumentation", "getDocumentationTargetText", "promptModel", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptOptions;", "promptCustomization", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptCustomization;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.ml.llm.python"})
@SourceDebugExtension(value={"SMAP\nLLMPythonDocumentationSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMPythonDocumentationSupport.kt\ncom/intellij/ml/llm/python/writeDocumentation/LLMPythonDocumentationSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,249:1\n774#2:250\n865#2,2:251\n808#2,11:253\n774#2:264\n865#2,2:265\n2423#2,14:267\n*S KotlinDebug\n*F\n+ 1 LLMPythonDocumentationSupport.kt\ncom/intellij/ml/llm/python/writeDocumentation/LLMPythonDocumentationSupport\n*L\n60#1:250\n60#1:251,2\n93#1:253,11\n93#1:264\n93#1:265,2\n95#1:267,14\n*E\n"})
public final class LLMPythonDocumentationSupport
implements LLMDocumentationSupportWithBlockComments {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String GOOGLE_CLASS_DOCSTRING_SAMPLE = "\n    Brief summary of what the class does.\n\n    Detailed description of the class, its purpose, and usage.\n\n    Attributes:\n        attribute1 (type): Description of attribute1.\n        attribute2 (type): Description of attribute2.\n    ";
    @NotNull
    private static final String NUMPY_CLASS_DOCSTRING_SAMPLE = "\n    Summary of what the class does.\n    \n    Detailed description of the class, its purpose, and usage.\n\n    Attributes\n    ----------\n    attribute1 : type\n        Description of attribute1.\n    attribute2 : type\n        Description of attribute2.\n    ";
    @NotNull
    private static final String SPHINX_CLASS_DOCSTRING_SAMPLE = "\n    Summary of what the class does.\n    \n    Detailed description of the class, its purpose, and usage.\n\n    :ivar attribute1: Description of attribute1.\n    :type attribute1: type\n    :ivar attribute2: Description of attribute2.\n    :type attribute2: type\n    ";
    @NotNull
    private static final String PLAIN_CLASS_DOCSTRING_SAMPLE = "\n    Brief summary of what the class does.\n\n    Detailed description of the class, its purpose, and usage.\n    ";
    @NotNull
    private static final String MODULE_DOCSTRING_SAMPLE = "\n    A one-line summary of the module or program, terminated by a period.\n\n    Leave one blank line.  The rest of this docstring should contain an\n    overall description of the module or program.  Optionally, it may also\n    contain a brief description of exported classes and functions and/or usage\n    examples.\n    \n    Docstrings that do not provide any new information should not be used.\n    ";

    @NotNull
    public String getEmptyDocumentation() {
        return "\"\"\"\n\n\"\"\"";
    }

    @NotNull
    public String getCommentStart() {
        return "\"\"\"";
    }

    @NotNull
    public String getCommentEnd() {
        return "\"\"\"";
    }

    @NotNull
    public final String getEmptyDocWithoutNewLines$intellij_ml_llm_python() {
        return "\"\"\"\"\"\"";
    }

    @Nullable
    public PsiElement getDocComment(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (PrivacyPathCheckerKt.isAiIgnoreBlocked(element2)) {
            return null;
        }
        PyDocStringOwner pyDocStringOwner = element2 instanceof PyDocStringOwner ? (PyDocStringOwner)element2 : null;
        return (PsiElement)(pyDocStringOwner != null ? pyDocStringOwner.getDocStringExpression() : null);
    }

    @Nullable
    public Pair<PSString, PSString> findExampleDoc(@NotNull PsiElement documentationTarget) {
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        return null;
    }

    public void updateDoc(@NotNull PsiElement documentationTarget, @NotNull String newDocText) {
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        Intrinsics.checkNotNullParameter((Object)newDocText, (String)"newDocText");
        if (!(documentationTarget instanceof PyDocStringOwner)) {
            throw new IncorrectOperationException();
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)((PyDocStringOwner)documentationTarget).getProject());
        Document document2 = documentManager.getDocument(((PyDocStringOwner)documentationTarget).getContainingFile());
        if (document2 == null) {
            return;
        }
        Document document3 = document2;
        documentManager.commitDocument(document3);
        PyDocstringGenerator pyDocstringGenerator = PyDocstringGenerator.forDocStringOwner((PyAstDocStringOwner)((PyAstDocStringOwner)documentationTarget));
        Intrinsics.checkNotNullExpressionValue((Object)pyDocstringGenerator, (String)"forDocStringOwner(...)");
        PyDocstringGenerator docstringGenerator = pyDocstringGenerator;
        docstringGenerator.buildAndInsert(newDocText);
    }

    private final List<PsiNameIdentifierOwner> getSelectedClassesAndFunctions(List<? extends PyClass> classes2, List<? extends PyFunction> functions, SelectionModel selectionModel) {
        PyClass it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = classes2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PyClass)element$iv$iv;
            boolean bl = false;
            if (!this.intersectsElement(selectionModel, (PsiElement)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = functions;
        Collection collection = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PyFunction)element$iv$iv;
            boolean bl = false;
            if (!this.intersectsElement(selectionModel, (PsiElement)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    private final boolean intersectsElement(SelectionModel $this$intersectsElement, PsiElement element2) {
        return $this$intersectsElement.getSelectionStart() < PsiTreeUtilKt.getEndOffset((PsiElement)element2) && $this$intersectsElement.getSelectionEnd() > PsiTreeUtilKt.getStartOffset((PsiElement)element2);
    }

    @NotNull
    public List<PsiElement> findDocTargetsInSelection(@NotNull PsiElement root, @NotNull SelectionModel selectionModel) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        PsiElement psiElement = CollectHighlightsUtil.findCommonParent((PsiElement)root, (int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd());
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement commonParent = psiElement;
        if (commonParent instanceof PyFile) {
            List list = ((PyFile)commonParent).getTopLevelClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTopLevelClasses(...)");
            List list2 = ((PyFile)commonParent).getTopLevelFunctions();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTopLevelFunctions(...)");
            return this.getSelectedClassesAndFunctions(list, list2, selectionModel);
        }
        PsiElement psiElement2 = this.findNearestDocumentationTarget(commonParent);
        if (psiElement2 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement closestNamedElement = psiElement2;
        if (!(closestNamedElement instanceof PyClass) || this.containsElement(selectionModel, closestNamedElement)) {
            return CollectionsKt.listOf((Object)closestNamedElement);
        }
        PyClass[] pyClassArray = ((PyClass)closestNamedElement).getNestedClasses();
        Intrinsics.checkNotNullExpressionValue((Object)pyClassArray, (String)"getNestedClasses(...)");
        List list = ArraysKt.toList((Object[])pyClassArray);
        PyFunction[] pyFunctionArray = ((PyClass)closestNamedElement).getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)pyFunctionArray, (String)"getMethods(...)");
        return this.getSelectedClassesAndFunctions(list, ArraysKt.toList((Object[])pyFunctionArray), selectionModel);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PsiElement findNearestDocumentationTargetForCaret(@NotNull Editor editor2) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        PsiElement psiElement2 = PsiUtilBase.getElementAtCaret((Editor)editor2);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement element2 = psiElement2;
        if (PrivacyPathCheckerKt.isAiIgnoreBlocked(element2)) {
            return null;
        }
        PsiNamedElement closestNamedElement = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiNamedElement.class, (boolean)false);
        int caretOffset = editor2.getCaretModel().getOffset();
        if (closestNamedElement instanceof PyFile && this.isModulePyDocStringGenerationAllowedHere((PyFile)closestNamedElement, element2)) {
            psiElement = (PsiElement)closestNamedElement;
        } else if (!(closestNamedElement instanceof PyFile)) {
            psiElement = this.findNearestDocumentationTarget(element2);
        } else {
            Object v5;
            void $this$minByOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            List list = ((PyFile)closestNamedElement).getTopLevelClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTopLevelClasses(...)");
            Iterable iterable = list;
            List list2 = ((PyFile)closestNamedElement).getTopLevelFunctions();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTopLevelFunctions(...)");
            Iterable iterable2 = CollectionsKt.union((Iterable)iterable, (Iterable)list2);
            boolean $i$f$filterIsInstance = false;
            void var7_7 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PsiNameIdentifierOwner)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PsiNameIdentifierOwner it = (PsiNameIdentifierOwner)element$iv$iv;
                boolean bl = false;
                if (!(it.getTextRange().getStartOffset() >= caretOffset)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v5 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v5 = minElem$iv;
                } else {
                    PsiNameIdentifierOwner it = (PsiNameIdentifierOwner)minElem$iv;
                    boolean bl = false;
                    int minValue$iv = it.getTextRange().getStartOffset() - caretOffset;
                    do {
                        Object e$iv = iterator$iv.next();
                        PsiNameIdentifierOwner it2 = (PsiNameIdentifierOwner)e$iv;
                        $i$a$-minByOrNull-LLMPythonDocumentationSupport$findNearestDocumentationTargetForCaret$2 = false;
                        int v$iv = it2.getTextRange().getStartOffset() - caretOffset;
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v5 = minElem$iv;
                }
            }
            psiElement = v5;
        }
        return psiElement;
    }

    private final boolean isModulePyDocStringGenerationAllowedHere(PyFile pyFile, PsiElement element2) {
        if (Companion.isPyDocStringElement(element2)) {
            return true;
        }
        List list = pyFile.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStatements(...)");
        PyStatement pyStatement = (PyStatement)CollectionsKt.firstOrNull((List)list);
        if (pyStatement == null) {
            return true;
        }
        PyStatement firstStatement = pyStatement;
        boolean isBeforeAnyStatement = PsiTreeUtilKt.getStartOffset((PsiElement)element2) < PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)firstStatement));
        boolean isStartOfTheFile = PsiTreeUtilKt.getStartOffset((PsiElement)element2) == 0;
        return isBeforeAnyStatement || isStartOfTheFile;
    }

    @Nullable
    public PsiElement findNearestDocumentationTarget(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (PrivacyPathCheckerKt.isAiIgnoreBlocked(element2)) {
            return null;
        }
        PsiNamedElement namedParent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiNamedElement.class, (boolean)false);
        if (Companion.isPyDocStringElement(element2) && namedParent instanceof PyFile) {
            return (PsiElement)namedParent;
        }
        if (element2 instanceof PyFunction || element2 instanceof PyClass) {
            return (PsiElement)((PsiNameIdentifierOwner)element2);
        }
        PsiNameIdentifierOwner closestIdentifierOwner = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiNameIdentifierOwner.class);
        if (!(closestIdentifierOwner instanceof PyFunction)) {
            PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element2, PyFunction.class);
            if (pyFunction == null) {
                return (PsiElement)closestIdentifierOwner;
            }
            return (PsiElement)pyFunction;
        }
        return (PsiElement)closestIdentifierOwner;
    }

    @RequiresReadLock
    @Nullable
    public Integer computeFeedbackInlayOffset(@NotNull PsiElement documentationTarget) {
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        PsiElement docComment = this.getDocComment(documentationTarget);
        if (docComment == null) {
            return null;
        }
        String documentText = docComment.getText();
        Intrinsics.checkNotNull((Object)documentText);
        int commentCloseIndex = StringsKt.lastIndexOf$default((CharSequence)documentText, (String)this.getCommentEnd(), (int)0, (boolean)false, (int)6, null);
        if (commentCloseIndex < 0) {
            return PsiTreeUtilKt.getEndOffset((PsiElement)docComment);
        }
        return PsiTreeUtilKt.getStartOffset((PsiElement)docComment) + commentCloseIndex;
    }

    @RequiresWriteLock
    public void reformatDocumentation(@NotNull PsiElement documentationTarget) {
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        if (!(documentationTarget instanceof PyDocStringOwner)) {
            return;
        }
        PyStringLiteralExpression pyStringLiteralExpression = ((PyDocStringOwner)documentationTarget).getDocStringExpression();
        if (pyStringLiteralExpression == null) {
            return;
        }
        PyStringLiteralExpression docstring = pyStringLiteralExpression;
        Project project2 = ((PyDocStringOwner)documentationTarget).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        String string = PyIndentUtil.getElementIndent((PsiElement)((PsiElement)docstring));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementIndent(...)");
        String indent = string;
        String text2 = docstring.getText();
        String string2 = PyIndentUtil.changeIndent((String)text2, (boolean)true, (String)indent);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"changeIndent(...)");
        String newText = string2;
        PyExpression pyExpression = PyElementGenerator.getInstance((Project)project3).createDocstring(newText).getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"getExpression(...)");
        PyExpression newDocstring = pyExpression;
        docstring.replace((PsiElement)newDocstring);
    }

    @NotNull
    public PSString getDocumentationTargetText(@NotNull PsiElement documentationTarget) {
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        if (!(documentationTarget instanceof PyDocStringOwner)) {
            return PythonContextUtils.getContextForElement$default(PythonContextUtils.INSTANCE, documentationTarget, 0, 0, 6, null).getContext();
        }
        PsiElement elementWithoutDoc = documentationTarget.copy();
        PyDocStringOwner pyDocStringOwner = elementWithoutDoc instanceof PyDocStringOwner ? (PyDocStringOwner)elementWithoutDoc : null;
        if (pyDocStringOwner != null && (pyDocStringOwner = pyDocStringOwner.getDocStringExpression()) != null) {
            pyDocStringOwner.delete();
        }
        Intrinsics.checkNotNull((Object)elementWithoutDoc);
        return PythonContextUtils.getContextForElement$default(PythonContextUtils.INSTANCE, elementWithoutDoc, 0, 0, 6, null).getContext();
    }

    @Nullable
    public WdPromptOptions promptModel(@NotNull PsiElement documentationTarget) {
        String string;
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        if (!(documentationTarget instanceof PyDocStringOwner)) {
            return null;
        }
        PyDocstringGenerator pyDocstringGenerator = PyDocstringGenerator.forDocStringOwner((PyAstDocStringOwner)((PyAstDocStringOwner)documentationTarget)).withInferredParameters(true);
        Intrinsics.checkNotNullExpressionValue((Object)pyDocstringGenerator, (String)"withInferredParameters(...)");
        PyDocstringGenerator generator = pyDocstringGenerator;
        DocStringFormat docStringFormat = generator.getDocStringFormat();
        Intrinsics.checkNotNullExpressionValue((Object)docStringFormat, (String)"getDocStringFormat(...)");
        DocStringFormat docStringFormat2 = docStringFormat;
        PyDocStringOwner pyDocStringOwner = (PyDocStringOwner)documentationTarget;
        if (pyDocStringOwner instanceof PyClass) {
            string = StringsKt.trimIndent((String)(switch (WhenMappings.$EnumSwitchMapping$0[docStringFormat2.ordinal()]) {
                case 1 -> GOOGLE_CLASS_DOCSTRING_SAMPLE;
                case 2 -> NUMPY_CLASS_DOCSTRING_SAMPLE;
                case 3 -> SPHINX_CLASS_DOCSTRING_SAMPLE;
                default -> PLAIN_CLASS_DOCSTRING_SAMPLE;
            }));
        } else {
            string = pyDocStringOwner instanceof PyFile ? "A one-line summary of the module or program, terminated by a period.\n\nLeave one blank line.  The rest of this docstring should contain an\noverall description of the module or program.  Optionally, it may also\ncontain a brief description of exported classes and functions and/or usage\nexamples.\n\nDocstrings that do not provide any new information should not be used." : (String)ExtensionsKtKt.getPrivacySafe(generator).buildDocString().unwrap();
        }
        String example = string;
        PSString exampleWithProperIndent = ExtensionsKtKt.getPyIndentUtilPrivacySafe().changeIndent(example, true, "");
        return (WdPromptOptions)new WdPromptOptions.Python(ExtensionsKtKt.getPrivacySafe(docStringFormat2).getName(), exampleWithProperIndent);
    }

    @Nullable
    public WdPromptCustomization promptCustomization(@NotNull Project project2) {
        WdPromptCustomization.User user;
        PSString pSString;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        AISystemLibraryPrompt aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.getInstance(project2).findPrompt("AIAssistant.WriteDocumentation.Python");
        if (aISystemLibraryPrompt != null && (pSString = aISystemLibraryPrompt.getContent()) != null) {
            PSString it = pSString;
            boolean bl = false;
            user = new WdPromptCustomization.User(it);
        } else {
            user = null;
        }
        return (WdPromptCustomization)user;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/python/writeDocumentation/LLMPythonDocumentationSupport$Companion;", "", "<init>", "()V", "isPyDocStringElement", "", "element", "Lcom/intellij/psi/PsiElement;", "GOOGLE_CLASS_DOCSTRING_SAMPLE", "", "NUMPY_CLASS_DOCSTRING_SAMPLE", "SPHINX_CLASS_DOCSTRING_SAMPLE", "PLAIN_CLASS_DOCSTRING_SAMPLE", "MODULE_DOCSTRING_SAMPLE", "intellij.ml.llm.python"})
    @SourceDebugExtension(value={"SMAP\nLLMPythonDocumentationSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMPythonDocumentationSupport.kt\ncom/intellij/ml/llm/python/writeDocumentation/LLMPythonDocumentationSupport$Companion\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,249:1\n67#2:250\n*S KotlinDebug\n*F\n+ 1 LLMPythonDocumentationSupport.kt\ncom/intellij/ml/llm/python/writeDocumentation/LLMPythonDocumentationSupport$Companion\n*L\n194#1:250\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isPyDocStringElement(@NotNull PsiElement element2) {
            void $this$parentOfType$iv;
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            if (!(element2 instanceof PyPlainStringElement)) {
                return false;
            }
            PsiElement psiElement = element2;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            PyStringLiteralExpression pyStringLiteralExpression = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PyStringLiteralExpression.class, (boolean)true);
            return pyStringLiteralExpression != null ? pyStringLiteralExpression.isDocString() : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DocStringFormat.values().length];
            try {
                nArray[DocStringFormat.GOOGLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocStringFormat.NUMPY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocStringFormat.REST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

