/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rider.csharp.docgen;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPromptService;
import com.intellij.ml.llm.grazie.tasks.documentation.WdPromptCustomization;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.rider.docgen.DocGenUtilKt;
import com.intellij.ml.llm.rider.docgen.RiderLLMDocumentationSupportBase;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/rider/csharp/docgen/FSharpLLMDocumentationSupport;", "Lcom/intellij/ml/llm/rider/docgen/RiderLLMDocumentationSupportBase;", "<init>", "()V", "isIntentionEnabled", "", "()Z", "emptyDocumentation", "", "getEmptyDocumentation", "()Ljava/lang/String;", "parameterTag", "Lcom/intellij/ml/llm/privacy/PSString;", "getParameterTag", "()Lcom/intellij/ml/llm/privacy/PSString;", "returnTag", "getReturnTag", "buildDocFromSuggestion", "suggestion", "containsCompleteDoc", "useChatCodeContextProvider", "promptCustomization", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptCustomization;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.rider.csharp"})
public final class FSharpLLMDocumentationSupport
extends RiderLLMDocumentationSupportBase {
    public boolean isIntentionEnabled() {
        return PluginManager.getInstance().findEnabledPlugin(PluginId.Companion.getId("com.jetbrains.rider.fsharp")) != null;
    }

    @NotNull
    public String getEmptyDocumentation() {
        return "///";
    }

    @NotNull
    public PSString getParameterTag() {
        return ConstantsKt.getPrivacyConst((String)"<param>");
    }

    @NotNull
    public PSString getReturnTag() {
        return ConstantsKt.getPrivacyConst((String)"<return>");
    }

    @NotNull
    public String buildDocFromSuggestion(@NotNull String suggestion) {
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        return DocGenUtilKt.parseXmlCommentSuggestion(suggestion, this.getEmptyDocumentation()).getDocCode();
    }

    public boolean containsCompleteDoc(@NotNull String suggestion) {
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        return DocGenUtilKt.parseXmlCommentSuggestion(suggestion, this.getEmptyDocumentation()).isFinished();
    }

    public boolean useChatCodeContextProvider() {
        return true;
    }

    @Nullable
    public WdPromptCustomization promptCustomization(@NotNull Project project2) {
        WdPromptCustomization.User user;
        PSString pSString;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        AISystemLibraryPrompt aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.getInstance(project2).findPrompt("AIAssistant.WriteDocumentation.FSharp");
        if (aISystemLibraryPrompt != null && (pSString = aISystemLibraryPrompt.getContent()) != null) {
            PSString it = pSString;
            boolean bl = false;
            user = new WdPromptCustomization.User(it);
        } else {
            user = null;
        }
        return (WdPromptCustomization)user;
    }
}

