/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rider.daemon;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.ml.llm.editor.common.progress.AICaretAttributeKeys;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptHighlightingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.InlinePromptHighlighterModel;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/rider/daemon/RiderInlinePromptModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;)V", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "initialize", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "compare", "move", "startOffset", "", "endOffset", "intellij.ml.llm.rider"})
@SourceDebugExtension(value={"SMAP\nRiderInlinePromptModelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderInlinePromptModelHandler.kt\ncom/intellij/ml/llm/rider/daemon/RiderInlinePromptModelHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,56:1\n57#2:57\n35#2,2:58\n*S KotlinDebug\n*F\n+ 1 RiderInlinePromptModelHandler.kt\ncom/intellij/ml/llm/rider/daemon/RiderInlinePromptModelHandler\n*L\n23#1:57\n23#1:58,2\n*E\n"})
public final class RiderInlinePromptModelHandler
implements IProtocolHighlighterModelHandler {
    @Nullable
    private final Project project;
    @NotNull
    private final Editor editor;

    public RiderInlinePromptModelHandler(@Nullable Project project2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.project = project2;
        this.editor = editor2;
    }

    public boolean accept(@NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return model instanceof InlinePromptHighlighterModel;
    }

    public void initialize(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        if (!(highlighter instanceof RangeHighlighterEx)) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("RangeHighlighterEx was expected but got " + highlighter.getClass());
            return;
        }
        Project project2 = this.project;
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        PsiFile psiFile = PlatformTextControlUtilsKt.getPsiFile((Editor)this.editor);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        highlighter.setTextAttributesKey(AICaretAttributeKeys.INLINE_PROMPT_ATTRS);
        Document document2 = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        TextRange textRange = ((RangeHighlighterEx)highlighter).getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        HighlightInfo add = InlinePromptHighlightingUtil.INSTANCE.processInlinePromptHighlighting(project3, file, this.editor, document2, textRange);
        add.setHighlighter((RangeHighlighterEx)highlighter);
    }

    public boolean compare(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        return HighlighterModelAgnosticComparator.INSTANCE.compare(model, highlighter);
    }

    @Nullable
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        InlinePromptHighlighterModel $this$move_u24lambda_u240 = (InlinePromptHighlighterModel)model;
        boolean bl = false;
        return (HighlighterModel)new InlinePromptHighlighterModel($this$move_u24lambda_u240.getLayer(), $this$move_u24lambda_u240.isExactRange(), $this$move_u24lambda_u240.getDocumentVersion(), $this$move_u24lambda_u240.isGreedyToLeft(), $this$move_u24lambda_u240.isGreedyToRight(), $this$move_u24lambda_u240.isThinErrorStripeMark(), $this$move_u24lambda_u240.getTextToHighlight(), $this$move_u24lambda_u240.getTextAttributesKey(), $this$move_u24lambda_u240.getId(), $this$move_u24lambda_u240.getProperties(), startOffset, endOffset);
    }
}

