/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rider.docgen;

import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPromptService;
import com.intellij.ml.llm.grazie.tasks.documentation.WdPromptCustomization;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.rider.docgen.RiderLLMDocumentationSupportBase;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/rider/docgen/CppLLMDocumentationSupport;", "Lcom/intellij/ml/llm/rider/docgen/RiderLLMDocumentationSupportBase;", "<init>", "()V", "emptyDocumentation", "", "getEmptyDocumentation", "()Ljava/lang/String;", "commentStart", "commentEnd", "buildDocFromSuggestion", "suggestion", "containsCompleteDoc", "", "useChatCodeContextProvider", "promptCustomization", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptCustomization;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.rider"})
public final class CppLLMDocumentationSupport
extends RiderLLMDocumentationSupportBase {
    @NotNull
    private final String commentStart;
    @NotNull
    private final String commentEnd;

    public CppLLMDocumentationSupport() {
        this.commentStart = "/**";
        this.commentEnd = "*/";
    }

    @NotNull
    public String getEmptyDocumentation() {
        return "/**\n*\n*/";
    }

    @NotNull
    public String buildDocFromSuggestion(@NotNull String suggestion) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        int startIndex = StringsKt.indexOf$default((CharSequence)suggestion, (String)this.commentStart, (int)0, (boolean)false, (int)6, null);
        if (startIndex < 0) {
            return "";
        }
        String string = suggestion.substring(startIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String docComment = string;
        int endIndex = StringsKt.indexOf$default((CharSequence)docComment, (String)this.commentEnd, (int)this.commentStart.length(), (boolean)false, (int)4, null);
        if (endIndex < 0) {
            object = docComment + this.commentEnd;
        } else {
            String string2 = docComment.substring(0, endIndex + this.commentEnd.length());
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        return object;
    }

    public boolean containsCompleteDoc(@NotNull String suggestion) {
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        int startIndex = StringsKt.indexOf$default((CharSequence)suggestion, (String)this.commentStart, (int)0, (boolean)false, (int)6, null);
        if (startIndex < 0) {
            return false;
        }
        return StringsKt.indexOf$default((CharSequence)suggestion, (String)this.commentEnd, (int)(startIndex + this.commentStart.length()), (boolean)false, (int)4, null) > 0;
    }

    public boolean useChatCodeContextProvider() {
        return true;
    }

    @Nullable
    public WdPromptCustomization promptCustomization(@NotNull Project project2) {
        WdPromptCustomization.User user;
        PSString pSString;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        AISystemLibraryPrompt aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.getInstance(project2).findPrompt("AIAssistant.WriteDocumentation.cpp");
        if (aISystemLibraryPrompt != null && (pSString = aISystemLibraryPrompt.getContent()) != null) {
            PSString it = pSString;
            boolean bl = false;
            user = new WdPromptCustomization.User(it);
        } else {
            user = null;
        }
        return (WdPromptCustomization)user;
    }
}

