/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rider.test.generation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.llmInstaller.api.LlmActivationStateListener;
import com.intellij.ml.llm.chat.icons.MLLlmChatIcons;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPromptService;
import com.intellij.ml.llm.core.promptLibrary.variables.AIAssistantPromptLibraryVariable;
import com.intellij.ml.llm.core.promptLibrary.variables.AIAssistantPromptLibraryVariableKt;
import com.intellij.ml.llm.errorExplanation.PsiUtilsKt;
import com.intellij.ml.llm.intentions.AiaCustomIntention;
import com.intellij.ml.llm.intentions.IntentionsUtilsKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.rider.RiderLLMBaseBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\r\u0010\f\u001a\u00070\u0007\u00a2\u0006\u0002\b\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\r\u0010\u0012\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0013H\u0016J$\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J%\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J \u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/rider/test/generation/GenerateTestsWithJunieIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/ml/llm/intentions/AiaCustomIntention;", "Lcom/intellij/openapi/util/Iconable;", "<init>", "()V", "ORG_JETBRAINS_JUNIE", "", "EXTENSION_POINT_HEADER", "SENDER", "startInWriteAction", "", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getText", "Lcom/intellij/codeInspection/util/IntentionName;", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "invoke", "", "junieMessage", "intellij.ml.llm.rider"})
public final class GenerateTestsWithJunieIntention
implements IntentionAction,
AiaCustomIntention,
Iconable {
    @NotNull
    private final String ORG_JETBRAINS_JUNIE;
    @NotNull
    private final String EXTENSION_POINT_HEADER;
    @NotNull
    private final String SENDER;

    public GenerateTestsWithJunieIntention() {
        this.ORG_JETBRAINS_JUNIE = "org.jetbrains.junie";
        this.EXTENSION_POINT_HEADER = "extension_point";
        this.SENDER = "rider_junie_generate_tests";
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return RiderLLMBaseBundle.Companion.message("intention.family.name.get.family.name", new Object[0]);
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon2 = MLLlmChatIcons.Junie;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Junie");
        return icon2;
    }

    @NotNull
    public String getText() {
        return RiderLLMBaseBundle.Companion.message("intention.name.tests.with.junie", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        PluginId id = PluginId.Companion.getId(this.ORG_JETBRAINS_JUNIE);
        if (!PluginManagerCore.isLoaded((PluginId)id) || PluginManagerCore.isDisabled((PluginId)id)) {
            return false;
        }
        return editor2 != null && psiFile != null && psiFile.isWritable() && IntentionsUtilsKt.findSelectedElement$default((Editor)editor2, (PsiFile)psiFile, null, (int)4, null) != null;
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor2, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (editor2 == null || psiFile == null) {
            return;
        }
        String message = this.junieMessage(editor2, psiFile, project2);
        ((LlmActivationStateListener)project2.getMessageBus().syncPublisher(LlmActivationStateListener.Companion.getTOPIC())).productActivationStateChanged(this.SENDER, message);
    }

    private final String junieMessage(Editor editor2, PsiFile psiFile, Project project2) {
        PsiElement selectedElement = IntentionsUtilsKt.findSelectedElement$default((Editor)editor2, (PsiFile)psiFile, null, (int)4, null);
        AISystemLibraryPrompt prompt2 = AISystemLibraryPromptService.Companion.getInstance(project2).findPrompt("AIAssistant.GenerateTests.Rider");
        Object object = psiFile.getVirtualFile();
        if (object == null || (object = object.getPath()) == null) {
            String string = psiFile.getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        }
        Object fileName = object;
        if (selectedElement == null) {
            return this.EXTENSION_POINT_HEADER + " generate test for " + (String)fileName;
        }
        int lineStart = PsiUtilsKt.getLineNumber$default((PsiElement)selectedElement, (boolean)false, (int)1, null) + 1;
        int lineEnd = PsiUtilsKt.getLineNumber((PsiElement)selectedElement, (boolean)false) + 1;
        AISystemLibraryPrompt aISystemLibraryPrompt = prompt2;
        if (aISystemLibraryPrompt == null || (aISystemLibraryPrompt = aISystemLibraryPrompt.getContent()) == null) {
            aISystemLibraryPrompt = ConstantsKt.getPrivacyConst((String)"");
        }
        String string = (String)AIAssistantPromptLibraryVariableKt.getDollarVariable((AIAssistantPromptLibraryVariable)AIAssistantPromptLibraryVariable.SELECTION).unwrap();
        String string2 = selectedElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String content2 = (String)aISystemLibraryPrompt.replace(string, (PrivacySafe)ConstantsKt.getPrivacyConst((String)string2)).replace((String)AIAssistantPromptLibraryVariableKt.getDollarVariable((AIAssistantPromptLibraryVariable)AIAssistantPromptLibraryVariable.FILE).unwrap(), (PrivacySafe)ConstantsKt.getPrivacyConst((String)fileName)).replace((String)AIAssistantPromptLibraryVariableKt.getDollarVariable((AIAssistantPromptLibraryVariable)AIAssistantPromptLibraryVariable.LINES).unwrap(), (PrivacySafe)ConstantsKt.getPrivacyConst((String)(lineStart + "-" + lineEnd))).unwrap();
        return this.EXTENSION_POINT_HEADER + " " + content2;
    }
}

