/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.chronicles.events.listeners;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.riderNext.NextRegistryKt;
import com.intellij.ml.llm.riderNext.latest.chronicles.ChronicleEntry;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.ChronicleEvent;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.ChroniclesEvents;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u0014\u0010\n\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u0014\u0010\u000b\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/chronicles/events/listeners/ChroniclesBreakpointListener;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointListener;", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "breakpointAdded", "", "breakpoint", "breakpointRemoved", "breakpointChanged", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
public final class ChroniclesBreakpointListener
implements XBreakpointListener<XBreakpoint<?>> {
    @NotNull
    private final Project project;
    public static final int $stable = 8;

    public ChroniclesBreakpointListener(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    public void breakpointAdded(@NotNull XBreakpoint<?> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (!NextRegistryKt.isChroniclesEnabled()) {
            return;
        }
        if (!breakpoint.isEnabled()) {
            return;
        }
        ChroniclesEvents.Companion.getInstance(this.project).add(new ChronicleEvent.Atomic(new ChronicleEntry.BreakpointSet(XBreakpointUtilKt.getDisplayText(breakpoint), 0L, 2, null)));
    }

    public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (!NextRegistryKt.isChroniclesEnabled()) {
            return;
        }
        ChroniclesEvents.Companion.getInstance(this.project).add(new ChronicleEvent.Atomic(new ChronicleEntry.BreakpointRemoved(XBreakpointUtilKt.getDisplayText(breakpoint), 0L, 2, null)));
    }

    public void breakpointChanged(@NotNull XBreakpoint<?> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
    }
}

