/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.chronicles.events.listeners;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.riderNext.NextRegistryKt;
import com.intellij.ml.llm.riderNext.latest.chronicles.ChronicleEntry;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.ChronicleEvent;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.ChroniclesEvents;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskListener;
import com.intellij.task.ProjectTaskManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/chronicles/events/listeners/ChroniclesBuildListener;", "Lcom/intellij/task/ProjectTaskListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "started", "", "context", "Lcom/intellij/task/ProjectTaskContext;", "finished", "result", "Lcom/intellij/task/ProjectTaskManager$Result;", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
public final class ChroniclesBuildListener
implements ProjectTaskListener {
    @NotNull
    private final Project project;
    public static final int $stable = 8;

    public ChroniclesBuildListener(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    public void started(@NotNull ProjectTaskContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!NextRegistryKt.isChroniclesEnabled()) {
            return;
        }
        Object object = context2.getRunConfiguration();
        if (object == null || (object = object.getName()) == null) {
            object = "Unknown";
        }
        Object runConfiguration = object;
        ChroniclesEvents.Companion.getInstance(this.project).add(new ChronicleEvent.Atomic(new ChronicleEntry.BuildStart((String)runConfiguration, 0L, 2, null)));
    }

    public void finished(@NotNull ProjectTaskManager.Result result2) {
        Object runConfiguration;
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (!NextRegistryKt.isChroniclesEnabled()) {
            return;
        }
        Object object = result2.getContext().getRunConfiguration();
        if (object == null || (object = object.getName()) == null) {
            object = runConfiguration = "Unknown";
        }
        if (result2.isAborted()) {
            ChroniclesEvents.Companion.getInstance(this.project).add(new ChronicleEvent.Atomic(new ChronicleEntry.BuildFailed((String)runConfiguration, "Aborted", 0L, 4, null)));
            return;
        }
        if (result2.hasErrors()) {
            ChroniclesEvents.Companion.getInstance(this.project).add(new ChronicleEvent.Atomic(new ChronicleEntry.BuildFailed((String)runConfiguration, "Errors", 0L, 4, null)));
        } else {
            ChroniclesEvents.Companion.getInstance(this.project).add(new ChronicleEvent.Atomic(new ChronicleEntry.BuildSuccess((String)runConfiguration, 0L, 2, null)));
        }
    }
}

