/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.chronicles.events.listeners;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.riderNext.NextRegistryKt;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.ChroniclesEvents;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.mergeableEvents.DocumentChanges;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/chronicles/events/listeners/ChroniclesDocumentListener;", "Lcom/intellij/openapi/editor/event/BulkAwareDocumentListener;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "chronicles", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/events/ChroniclesEvents;", "getChronicles", "()Lcom/intellij/ml/llm/riderNext/latest/chronicles/events/ChroniclesEvents;", "chronicles$delegate", "Lkotlin/Lazy;", "beforeDocumentChangeNonBulk", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChangedNonBulk", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
public final class ChroniclesDocumentListener
implements BulkAwareDocumentListener {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final Project project;
    @Nullable
    private final VirtualFile file;
    @NotNull
    private final Lazy chronicles$delegate;
    public static final int $stable = 8;

    public ChroniclesDocumentListener(@NotNull EditorImpl editor2, @NotNull Project project2, @Nullable VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.editor = editor2;
        this.project = project2;
        this.file = file;
        this.chronicles$delegate = LazyKt.lazy(() -> ChroniclesDocumentListener.chronicles_delegate$lambda$0(this));
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final VirtualFile getFile() {
        return this.file;
    }

    private final ChroniclesEvents getChronicles() {
        Lazy lazy = this.chronicles$delegate;
        return (ChroniclesEvents)lazy.getValue();
    }

    public void beforeDocumentChangeNonBulk(@NotNull DocumentEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!NextRegistryKt.isChroniclesEnabled()) {
            return;
        }
        ChroniclesEvents chroniclesEvents = this.getChronicles();
        CharSequence charSequence = this.editor.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        chroniclesEvents.add(new DocumentChanges(event2, charSequence, this.file, 0L, 8, null));
    }

    public void documentChangedNonBulk(@NotNull DocumentEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!NextRegistryKt.isChroniclesEnabled()) {
            return;
        }
        ChroniclesEvents chroniclesEvents = this.getChronicles();
        CharSequence charSequence = this.editor.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        chroniclesEvents.add(new DocumentChanges(event2, charSequence, this.file, 0L, 8, null));
    }

    private static final ChroniclesEvents chronicles_delegate$lambda$0(ChroniclesDocumentListener this$0) {
        return ChroniclesEvents.Companion.getInstance(this$0.project);
    }
}

