/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.chronicles.events.listeners;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.riderNext.NextRegistryKt;
import com.intellij.ml.llm.riderNext.latest.chronicles.ChronicleEntry;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.ChronicleEvent;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.ChroniclesEvents;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.listeners.ChroniclesUtilsKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/chronicles/events/listeners/ChroniclesFileEditorListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "getCaretPositionInfo", "Lkotlin/Pair;", "", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChroniclesFileEditorListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChroniclesFileEditorListener.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/events/listeners/ChroniclesFileEditorListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class ChroniclesFileEditorListener
implements FileEditorManagerListener {
    @NotNull
    private final Project project;
    public static final int $stable = 8;

    public ChroniclesFileEditorListener(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event2) {
        Object object;
        Object path;
        block10: {
            block9: {
                Pair<Integer, Integer> it;
                Object object2;
                Pair<Integer, Integer> positionInfo;
                block8: {
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                        if (!NextRegistryKt.isChroniclesEnabled()) {
                            return;
                        }
                        VirtualFile newFile = event2.getNewFile();
                        positionInfo = this.getCaretPositionInfo(event2);
                        object2 = newFile;
                        if (object2 == null || (object2 = object2.getPath()) == null) break block7;
                        it = object2;
                        boolean bl = false;
                        String string = ChroniclesUtilsKt.checkAndAdjustPath((String)it, this.project);
                        object2 = string;
                        if (string != null) break block8;
                    }
                    return;
                }
                path = object2;
                object = positionInfo;
                if (object == null) break block9;
                it = object;
                boolean bl = false;
                String string = " (line: " + it.getFirst() + ", column: " + it.getSecond() + ")";
                object = string;
                if (string != null) break block10;
            }
            object = "";
        }
        Object position = object;
        ChroniclesEvents.Companion.getInstance(this.project).add(new ChronicleEvent.Atomic(new ChronicleEntry.FileSwitch((String)path, (String)position, 0L, 4, null)));
    }

    private final Pair<Integer, Integer> getCaretPositionInfo(FileEditorManagerEvent event2) {
        FileEditor fileEditor = event2.getNewEditor();
        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        if (textEditor == null) {
            return null;
        }
        TextEditor newEditor = textEditor;
        Editor editor2 = newEditor.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        Caret caret = editor3.getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        Caret caret2 = caret;
        Document document2 = editor3.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document document3 = document2;
        int offset = caret2.getOffset();
        int line = document3.getLineNumber(offset);
        int lineStartOffset = document3.getLineStartOffset(line);
        int column = offset - lineStartOffset;
        return new Pair((Object)(line + 1), (Object)(column + 1));
    }
}

