/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.chronicles.events.storage;

import com.intellij.ml.llm.riderNext.latest.chronicles.ChronicleEntry;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u001a#\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007\u001a\n\u0010\b\u001a\u00020\u0006*\u00020\u0002\u00a8\u0006\t"}, d2={"fromCsv", "Lkotlin/Result;", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/ChronicleEntry;", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/ChronicleEntry$Companion;", "csvLine", "", "", "(Lcom/intellij/ml/llm/riderNext/latest/chronicles/ChronicleEntry$Companion;Ljava/util/List;)Ljava/lang/Object;", "toCsv", "intellij.ml.llm.riderNext.latest"})
public final class ChroniclesEventExtensionsKt {
    @NotNull
    public static final Object fromCsv(@NotNull ChronicleEntry.Companion $this$fromCsv, @NotNull List<String> csvLine) {
        ChronicleEntry chronicleEntry;
        Object e2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$fromCsv, (String)"<this>");
        Intrinsics.checkNotNullParameter(csvLine, (String)"csvLine");
        if (csvLine.size() < 4) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid csv line length: " + csvLine.size())));
        }
        Long l2 = StringsKt.toLongOrNull((String)csvLine.get(0));
        if (l2 == null) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid timestamp: " + csvLine.get(0))));
        }
        long timestamp = l2;
        String type2 = csvLine.get(1);
        String caption = csvLine.get(2);
        String payload = csvLine.get(3);
        String extra = (String)CollectionsKt.getOrNull(csvLine, (int)4);
        Base64.Default base64 = Base64.Default;
        try {
            object = Base64.decode$default((Base64)((Base64)base64), (CharSequence)caption, (int)0, (int)0, (int)6, null);
            object = new String((byte[])object, Charsets.UTF_8);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable e2) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Failed to decode base64 caption: " + caption + ", error: " + e2.getMessage())));
        }
        Object captionDecoded = object;
        try {
            e2 = Base64.decode$default((Base64)((Base64)base64), (CharSequence)payload, (int)0, (int)0, (int)6, null);
            e2 = new String((byte[])e2, Charsets.UTF_8);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable e3) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Failed to decode base64 caption: " + caption + ", error: " + e3.getMessage())));
        }
        Object payloadDecoded = e2;
        String string = type2;
        if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.FileSwitch.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.FileSwitch((String)captionDecoded, (String)payloadDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.FindInFile.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.FindInFile((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.FindInPath.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.FindInPath((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.FindUsages.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.FindUsages((String)captionDecoded, (String)payloadDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.GotoDeclaration.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.GotoDeclaration((String)captionDecoded, (String)payloadDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.Idle.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.Idle(timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.Run.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.Run((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.Shutdown.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.Shutdown(timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.Startup.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.Startup(timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.Tests.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.Tests((String)captionDecoded, (String)payloadDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.DocumentChange.class.getSimpleName())) {
            if (extra == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Missing extra for DocumentChange event")));
            }
            Long l3 = StringsKt.toLongOrNull((String)extra);
            if (l3 == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid extra for DocumentChange event: " + extra)));
            }
            duration = l3;
            chronicleEntry = new ChronicleEntry.DocumentChange((String)captionDecoded, (String)payloadDecoded, duration, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.BreakpointSet.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.BreakpointSet((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.BreakpointRemoved.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.BreakpointRemoved((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.BreakpointHit.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.BreakpointHit((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.DebugStart.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.DebugStart((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.DebugStop.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.DebugStop((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.BuildStart.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.BuildStart((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.BuildSuccess.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.BuildSuccess((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.BuildFailed.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.BuildFailed((String)captionDecoded, (String)payloadDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.NewFile.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.NewFile((String)captionDecoded, extra, (String)payloadDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.DeleteFile.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.DeleteFile((String)captionDecoded, extra, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.MoveFile.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.MoveFile((String)captionDecoded, (String)payloadDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.CopyFile.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.CopyFile((String)captionDecoded, (String)payloadDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.ChangeBranches.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.ChangeBranches((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.AiCodeGeneration.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.AiCodeGeneration((String)captionDecoded, (String)payloadDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.Scroll.class.getSimpleName())) {
            if (extra == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Missing extra for Scroll event")));
            }
            Long l4 = StringsKt.toLongOrNull((String)extra);
            if (l4 == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid extra for Scroll event: " + extra)));
            }
            duration = l4;
            chronicleEntry = new ChronicleEntry.Scroll((String)captionDecoded, duration, timestamp);
        } else {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Unknown event type: " + type2)));
        }
        ChronicleEntry event2 = chronicleEntry;
        return Result.constructor-impl((Object)event2);
    }

    @NotNull
    public static final String toCsv(@NotNull ChronicleEntry $this$toCsv) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$toCsv, (String)"<this>");
        Base64.Default base64 = Base64.Default;
        String type2 = $this$toCsv.getClass().getSimpleName();
        ChronicleEntry chronicleEntry = $this$toCsv;
        if (chronicleEntry instanceof ChronicleEntry.FileSwitch) {
            string2 = ((ChronicleEntry.FileSwitch)$this$toCsv).getPath();
        } else if (chronicleEntry instanceof ChronicleEntry.FindInFile) {
            string2 = ((ChronicleEntry.FindInFile)$this$toCsv).getSearchPattern();
        } else if (chronicleEntry instanceof ChronicleEntry.FindInPath) {
            string2 = ((ChronicleEntry.FindInPath)$this$toCsv).getSearchPattern();
        } else if (chronicleEntry instanceof ChronicleEntry.FindUsages) {
            string2 = ((ChronicleEntry.FindUsages)$this$toCsv).getToken();
        } else if (chronicleEntry instanceof ChronicleEntry.GotoDeclaration) {
            string2 = ((ChronicleEntry.GotoDeclaration)$this$toCsv).getToken();
        } else if (chronicleEntry instanceof ChronicleEntry.Idle) {
            string2 = "";
        } else if (chronicleEntry instanceof ChronicleEntry.Run) {
            string2 = ((ChronicleEntry.Run)$this$toCsv).getConfigName();
        } else if (chronicleEntry instanceof ChronicleEntry.Shutdown) {
            string2 = "";
        } else if (chronicleEntry instanceof ChronicleEntry.Startup) {
            string2 = "";
        } else if (chronicleEntry instanceof ChronicleEntry.Tests) {
            string2 = ((ChronicleEntry.Tests)$this$toCsv).getOverview();
        } else if (chronicleEntry instanceof ChronicleEntry.DocumentChange) {
            string2 = ((ChronicleEntry.DocumentChange)$this$toCsv).getPath();
        } else if (chronicleEntry instanceof ChronicleEntry.BreakpointSet) {
            string2 = ((ChronicleEntry.BreakpointSet)$this$toCsv).getDisplayText();
        } else if (chronicleEntry instanceof ChronicleEntry.BreakpointRemoved) {
            string2 = ((ChronicleEntry.BreakpointRemoved)$this$toCsv).getDisplayText();
        } else if (chronicleEntry instanceof ChronicleEntry.BreakpointHit) {
            string2 = ((ChronicleEntry.BreakpointHit)$this$toCsv).getMessage();
        } else if (chronicleEntry instanceof ChronicleEntry.DebugStart) {
            string2 = ((ChronicleEntry.DebugStart)$this$toCsv).getConfigName();
        } else if (chronicleEntry instanceof ChronicleEntry.DebugStop) {
            string2 = ((ChronicleEntry.DebugStop)$this$toCsv).getConfigName();
        } else if (chronicleEntry instanceof ChronicleEntry.BuildStart) {
            string2 = ((ChronicleEntry.BuildStart)$this$toCsv).getRunConfiguration();
        } else if (chronicleEntry instanceof ChronicleEntry.BuildSuccess) {
            string2 = ((ChronicleEntry.BuildSuccess)$this$toCsv).getRunConfiguration();
        } else if (chronicleEntry instanceof ChronicleEntry.BuildFailed) {
            string2 = ((ChronicleEntry.BuildFailed)$this$toCsv).getRunConfiguration();
        } else if (chronicleEntry instanceof ChronicleEntry.Scroll) {
            string2 = ((ChronicleEntry.Scroll)$this$toCsv).getPath();
        } else if (chronicleEntry instanceof ChronicleEntry.ChangeBranches) {
            string2 = ((ChronicleEntry.ChangeBranches)$this$toCsv).getBranchName();
        } else if (chronicleEntry instanceof ChronicleEntry.NewFile) {
            string2 = ((ChronicleEntry.NewFile)$this$toCsv).getPath();
        } else if (chronicleEntry instanceof ChronicleEntry.DeleteFile) {
            string2 = ((ChronicleEntry.DeleteFile)$this$toCsv).getPath();
        } else if (chronicleEntry instanceof ChronicleEntry.MoveFile) {
            string2 = ((ChronicleEntry.MoveFile)$this$toCsv).getFromPath();
        } else if (chronicleEntry instanceof ChronicleEntry.CopyFile) {
            string2 = ((ChronicleEntry.CopyFile)$this$toCsv).getFromPath();
        } else if (chronicleEntry instanceof ChronicleEntry.AiCodeGeneration) {
            string2 = ((ChronicleEntry.AiCodeGeneration)$this$toCsv).getSummary();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String captionRaw = string2;
        Base64 base642 = (Base64)base64;
        String string3 = captionRaw;
        byte[] byArray = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String captionBase64 = Base64.encode$default((Base64)base642, (byte[])byArray, (int)0, (int)0, (int)6, null);
        ChronicleEntry chronicleEntry2 = $this$toCsv;
        if (chronicleEntry2 instanceof ChronicleEntry.FileSwitch) {
            string = ((ChronicleEntry.FileSwitch)$this$toCsv).getPosition();
        } else if (chronicleEntry2 instanceof ChronicleEntry.FindInFile) {
            string = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.FindInPath) {
            string = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.FindUsages) {
            string = ((ChronicleEntry.FindUsages)$this$toCsv).getPosition();
        } else if (chronicleEntry2 instanceof ChronicleEntry.GotoDeclaration) {
            string = ((ChronicleEntry.GotoDeclaration)$this$toCsv).getPosition();
        } else if (chronicleEntry2 instanceof ChronicleEntry.Idle) {
            string = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.Run) {
            string = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.Shutdown) {
            string = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.Startup) {
            string = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.Tests) {
            string = ((ChronicleEntry.Tests)$this$toCsv).getDetails();
        } else if (chronicleEntry2 instanceof ChronicleEntry.DocumentChange) {
            string = ((ChronicleEntry.DocumentChange)$this$toCsv).getDiff();
        } else if (chronicleEntry2 instanceof ChronicleEntry.BreakpointSet) {
            string = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.BreakpointRemoved) {
            string = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.BreakpointHit) {
            string = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.DebugStart) {
            string = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.DebugStop) {
            string = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.BuildStart) {
            string = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.BuildSuccess) {
            string = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.BuildFailed) {
            string = ((ChronicleEntry.BuildFailed)$this$toCsv).getReason();
        } else if (chronicleEntry2 instanceof ChronicleEntry.Scroll) {
            string = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.ChangeBranches) {
            string = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.NewFile) {
            string = ((ChronicleEntry.NewFile)$this$toCsv).getContent();
        } else if (chronicleEntry2 instanceof ChronicleEntry.DeleteFile) {
            string = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.MoveFile) {
            string = ((ChronicleEntry.MoveFile)$this$toCsv).getToPath();
        } else if (chronicleEntry2 instanceof ChronicleEntry.CopyFile) {
            string = ((ChronicleEntry.CopyFile)$this$toCsv).getToPath();
        } else if (chronicleEntry2 instanceof ChronicleEntry.AiCodeGeneration) {
            string = ((ChronicleEntry.AiCodeGeneration)$this$toCsv).getDiff();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String payloadRaw = string;
        Base64 base643 = (Base64)base64;
        String string4 = payloadRaw;
        byte[] byArray2 = string4.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        String payloadBase64 = Base64.encode$default((Base64)base643, (byte[])byArray2, (int)0, (int)0, (int)6, null);
        ChronicleEntry chronicleEntry3 = $this$toCsv;
        String extra = chronicleEntry3 instanceof ChronicleEntry.DocumentChange ? String.valueOf(((ChronicleEntry.DocumentChange)$this$toCsv).getDurationMs()) : (chronicleEntry3 instanceof ChronicleEntry.Scroll ? String.valueOf(((ChronicleEntry.Scroll)$this$toCsv).getDurationMs()) : (chronicleEntry3 instanceof ChronicleEntry.NewFile ? ((ChronicleEntry.NewFile)$this$toCsv).getCommand() : (chronicleEntry3 instanceof ChronicleEntry.DeleteFile ? ((ChronicleEntry.DeleteFile)$this$toCsv).getCommand() : "")));
        return $this$toCsv.getTimestamp() + "," + type2 + "," + captionBase64 + "," + payloadBase64 + "," + extra;
    }
}

