/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.chronicles.view;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.riderNext.latest.chronicles.ChronicleEntry;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChronicleDetails;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChronicleKind;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChronicleNavigate;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChronicleNavigateKt;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChroniclePresenter$;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChroniclePresenterWithDetails;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.Transient;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 02\u00020\u0001:\u000201B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eBI\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\r\u0010\u0012J\b\u0010\"\u001a\u0004\u0018\u00010#J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0005H\u0016J \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0016\u00a8\u00062\u0080\u00e5\b\u0002\u0080\u00e5\b\u0004\u0080\u00e5\b\u0006\u0080\u00e5\b\u0007\u0080\u00e5\b\t"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChroniclePresenter;", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChronicleDetails;", "id", "", "title", "", "append", "kind", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChronicleKind;", "timestamp", "", "entry", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/ChronicleEntry;", "<init>", "(ILjava/lang/String;Ljava/lang/String;Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChronicleKind;JLcom/intellij/ml/llm/riderNext/latest/chronicles/ChronicleEntry;)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IILjava/lang/String;Ljava/lang/String;Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChronicleKind;JLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getId", "()I", "getTitle", "()Ljava/lang/String;", "getAppend", "getKind", "()Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChronicleKind;", "getTimestamp", "()J", "getEntry$annotations", "()V", "getEntry", "()Lcom/intellij/ml/llm/riderNext/latest/chronicles/ChronicleEntry;", "caption", "getCaption", "getNavigate", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChronicleNavigate;", "getDetails", "Ljava/awt/Component;", "project", "Lcom/intellij/openapi/project/Project;", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "Companion", "$serializer", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
public class ChroniclePresenter
implements ChronicleDetails {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    @NotNull
    private final String title;
    @NotNull
    private final String append;
    @NotNull
    private final ChronicleKind kind;
    private final long timestamp;
    @Nullable
    private final ChronicleEntry entry;
    public static final int $stable = 8;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public ChroniclePresenter(int id, @NotNull String title, @NotNull String append, @NotNull ChronicleKind kind, long timestamp, @Nullable ChronicleEntry entry) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)append, (String)"append");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        this.id = id;
        this.title = title;
        this.append = append;
        this.kind = kind;
        this.timestamp = timestamp;
        this.entry = entry;
    }

    public /* synthetic */ ChroniclePresenter(int n, String string, String string2, ChronicleKind chronicleKind, long l2, ChronicleEntry chronicleEntry, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            chronicleEntry = null;
        }
        this(n, string, string2, chronicleKind, l2, chronicleEntry);
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getAppend() {
        return this.append;
    }

    @NotNull
    public final ChronicleKind getKind() {
        return this.kind;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public final ChronicleEntry getEntry() {
        return this.entry;
    }

    @Transient
    public static /* synthetic */ void getEntry$annotations() {
    }

    @NotNull
    public final String getCaption() {
        return this.title + " " + this.append;
    }

    @Nullable
    public final ChronicleNavigate getNavigate() {
        ChronicleEntry chronicleEntry = this.entry;
        return chronicleEntry != null ? ChronicleNavigateKt.createNavigate(chronicleEntry) : null;
    }

    @Override
    @Nullable
    public Component getDetails(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return null;
    }

    @NotNull
    public String toString() {
        return "Chronicle(chronicle_id='" + this.id + "', caption='" + this.getCaption() + "', timestamp=" + Companion.formatChronicleDateTime(this.timestamp) + ")";
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self(ChroniclePresenter self, CompositeEncoder output, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output.encodeIntElement(serialDesc, 0, self.id);
        output.encodeStringElement(serialDesc, 1, self.title);
        output.encodeStringElement(serialDesc, 2, self.append);
        output.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)lazyArray[3].getValue(), (Object)self.kind);
        output.encodeLongElement(serialDesc, 4, self.timestamp);
    }

    public /* synthetic */ ChroniclePresenter(int seen0, int id, String title, String append, ChronicleKind kind, long timestamp, SerializationConstructorMarker serializationConstructorMarker) {
        if (31 != (0x1F & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)31, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.id = id;
        this.title = title;
        this.append = append;
        this.kind = kind;
        this.timestamp = timestamp;
        this.entry = null;
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> ChronicleKind.Companion.serializer()), null};
        $childSerializers = lazyArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChroniclePresenter$Companion;", "", "<init>", "()V", "formatChronicleDateTime", "", "timestamp", "", "fromEvent", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChroniclePresenter;", "id", "", "entry", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/ChronicleEntry;", "serializer", "Lkotlinx/serialization/KSerializer;", "intellij.ml.llm.riderNext.latest"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String formatChronicleDateTime(long timestamp) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss - dd-MM-yyyy");
            String string = dateFormat.format(new Date(timestamp));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        @NotNull
        public final ChroniclePresenter fromEvent(int id, @NotNull ChronicleEntry entry) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Object append = "";
            ChronicleEntry chronicleEntry = entry;
            if (chronicleEntry instanceof ChronicleEntry.Idle) {
                pair = TuplesKt.to((Object)"Long idle", (Object)((Object)ChronicleKind.Idle));
            } else if (chronicleEntry instanceof ChronicleEntry.Shutdown) {
                pair = TuplesKt.to((Object)"Shut down", (Object)((Object)ChronicleKind.Shutdown));
            } else if (chronicleEntry instanceof ChronicleEntry.Startup) {
                pair = TuplesKt.to((Object)"Startup", (Object)((Object)ChronicleKind.Startup));
            } else if (chronicleEntry instanceof ChronicleEntry.Run) {
                pair = TuplesKt.to((Object)("Run " + ((ChronicleEntry.Run)entry).getConfigName()), (Object)((Object)ChronicleKind.Run));
            } else {
                if (chronicleEntry instanceof ChronicleEntry.Tests) {
                    return new ChroniclePresenterWithDetails(id, ((ChronicleEntry.Tests)entry).getDetails(), ((ChronicleEntry.Tests)entry).getOverview(), "", ChronicleKind.Tests, ((ChronicleEntry.Tests)entry).getTimestamp(), entry);
                }
                if (chronicleEntry instanceof ChronicleEntry.FileSwitch) {
                    append = ((ChronicleEntry.FileSwitch)entry).getPosition();
                    fileName = StringsKt.substringAfterLast$default((String)((ChronicleEntry.FileSwitch)entry).getPath(), (String)"/", null, (int)2, null);
                    pair = TuplesKt.to((Object)("Switched to file: " + fileName), (Object)((Object)ChronicleKind.FileSwitch));
                } else if (chronicleEntry instanceof ChronicleEntry.FindUsages) {
                    append = ((ChronicleEntry.FindUsages)entry).getPosition();
                    pair = TuplesKt.to((Object)("Find Usages: " + ((ChronicleEntry.FindUsages)entry).getToken()), (Object)((Object)ChronicleKind.FindUsages));
                } else if (chronicleEntry instanceof ChronicleEntry.FindInFile) {
                    pair = TuplesKt.to((Object)("Search Pattern: " + ((ChronicleEntry.FindInFile)entry).getSearchPattern()), (Object)((Object)ChronicleKind.FindInFile));
                } else if (chronicleEntry instanceof ChronicleEntry.FindInPath) {
                    pair = TuplesKt.to((Object)("Search Pattern: " + ((ChronicleEntry.FindInPath)entry).getSearchPattern()), (Object)((Object)ChronicleKind.FindInPath));
                } else if (chronicleEntry instanceof ChronicleEntry.GotoDeclaration) {
                    append = ((ChronicleEntry.GotoDeclaration)entry).getPosition();
                    pair = TuplesKt.to((Object)("Goto Declaration Or Usages: " + ((ChronicleEntry.GotoDeclaration)entry).getToken()), (Object)((Object)ChronicleKind.GotoDeclaration));
                } else {
                    if (chronicleEntry instanceof ChronicleEntry.DocumentChange) {
                        String append2 = "during " + ((ChronicleEntry.DocumentChange)entry).getDurationMs() + "ms";
                        String fileName = StringsKt.substringAfterLast$default((String)((ChronicleEntry.DocumentChange)entry).getPath(), (String)"/", null, (int)2, null);
                        String title = "Document change: " + fileName;
                        return new ChroniclePresenterWithDetails(id, ((ChronicleEntry.DocumentChange)entry).getDiff(), title, append2, ChronicleKind.CodeChanges, ((ChronicleEntry.DocumentChange)entry).getTimestamp(), entry);
                    }
                    if (chronicleEntry instanceof ChronicleEntry.BreakpointSet) {
                        pair = TuplesKt.to((Object)("Breakpoint set: " + ((ChronicleEntry.BreakpointSet)entry).getDisplayText()), (Object)((Object)ChronicleKind.BreakpointSet));
                    } else if (chronicleEntry instanceof ChronicleEntry.BreakpointRemoved) {
                        pair = TuplesKt.to((Object)("Breakpoint removed: " + ((ChronicleEntry.BreakpointRemoved)entry).getDisplayText()), (Object)((Object)ChronicleKind.BreakpointRemoved));
                    } else if (chronicleEntry instanceof ChronicleEntry.BreakpointHit) {
                        pair = TuplesKt.to((Object)("Stopped on breakpoint " + ((ChronicleEntry.BreakpointHit)entry).getMessage()), (Object)((Object)ChronicleKind.BreakpointHit));
                    } else if (chronicleEntry instanceof ChronicleEntry.DebugStart) {
                        pair = TuplesKt.to((Object)("Debug started: " + ((ChronicleEntry.DebugStart)entry).getConfigName()), (Object)((Object)ChronicleKind.DebugStart));
                    } else if (chronicleEntry instanceof ChronicleEntry.DebugStop) {
                        pair = TuplesKt.to((Object)("Debug stopped: " + ((ChronicleEntry.DebugStop)entry).getConfigName()), (Object)((Object)ChronicleKind.DebugStop));
                    } else if (chronicleEntry instanceof ChronicleEntry.BuildStart) {
                        pair = TuplesKt.to((Object)("Build started: " + ((ChronicleEntry.BuildStart)entry).getRunConfiguration()), (Object)((Object)ChronicleKind.BuildStart));
                    } else if (chronicleEntry instanceof ChronicleEntry.BuildSuccess) {
                        pair = TuplesKt.to((Object)("Build success: " + ((ChronicleEntry.BuildSuccess)entry).getRunConfiguration()), (Object)((Object)ChronicleKind.BuildSuccess));
                    } else if (chronicleEntry instanceof ChronicleEntry.BuildFailed) {
                        append = ((ChronicleEntry.BuildFailed)entry).getReason();
                        pair = TuplesKt.to((Object)("Build failed: " + ((ChronicleEntry.BuildFailed)entry).getRunConfiguration()), (Object)((Object)ChronicleKind.BuildFailed));
                    } else if (chronicleEntry instanceof ChronicleEntry.Scroll) {
                        append = "(" + ((ChronicleEntry.Scroll)entry).getDurationMs() + "ms)";
                        fileName = StringsKt.substringAfterLast$default((String)((ChronicleEntry.Scroll)entry).getPath(), (String)"/", null, (int)2, null);
                        pair = TuplesKt.to((Object)("Scroll in: " + fileName), (Object)((Object)ChronicleKind.Scroll));
                    } else if (chronicleEntry instanceof ChronicleEntry.ChangeBranches) {
                        pair = TuplesKt.to((Object)("Checkout branch: " + ((ChronicleEntry.ChangeBranches)entry).getBranchName()), (Object)((Object)ChronicleKind.ChangeBranches));
                    } else {
                        if (chronicleEntry instanceof ChronicleEntry.NewFile) {
                            String title = "New file " + ((ChronicleEntry.NewFile)entry).getCommand() + ": " + ((ChronicleEntry.NewFile)entry).getPath();
                            return new ChroniclePresenterWithDetails(id, ((ChronicleEntry.NewFile)entry).getContent(), title, "", ChronicleKind.NewFile, ((ChronicleEntry.NewFile)entry).getTimestamp(), entry);
                        }
                        if (chronicleEntry instanceof ChronicleEntry.DeleteFile) {
                            pair = TuplesKt.to((Object)("Deleted file " + ((ChronicleEntry.DeleteFile)entry).getCommand() + ": " + ((ChronicleEntry.DeleteFile)entry).getPath()), (Object)((Object)ChronicleKind.DeleteFile));
                        } else if (chronicleEntry instanceof ChronicleEntry.MoveFile) {
                            pair = TuplesKt.to((Object)("Moved file: " + ((ChronicleEntry.MoveFile)entry).getFromPath() + " -> " + ((ChronicleEntry.MoveFile)entry).getToPath()), (Object)((Object)ChronicleKind.MoveFile));
                        } else if (chronicleEntry instanceof ChronicleEntry.CopyFile) {
                            pair = TuplesKt.to((Object)("Copied file: " + ((ChronicleEntry.CopyFile)entry).getFromPath() + " -> " + ((ChronicleEntry.CopyFile)entry).getToPath()), (Object)((Object)ChronicleKind.CopyFile));
                        } else {
                            if (chronicleEntry instanceof ChronicleEntry.AiCodeGeneration) {
                                return new ChroniclePresenterWithDetails(id, ((ChronicleEntry.AiCodeGeneration)entry).getDiff(), ((ChronicleEntry.AiCodeGeneration)entry).getSummary(), "", ChronicleKind.AiCodeGeneration, ((ChronicleEntry.AiCodeGeneration)entry).getTimestamp(), entry);
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
            }
            Pair pair2 = pair;
            String title = (String)pair2.component1();
            ChronicleKind kind = (ChronicleKind)((Object)pair2.component2());
            return new ChroniclePresenter(id, title, (String)append, kind, entry.getTimestamp(), entry);
        }

        @NotNull
        public final KSerializer<ChroniclePresenter> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

