/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.chronicles.view;

import com.intellij.ml.llm.riderNext.latest.chronicles.ai.RecapAgentResult;
import com.intellij.ml.llm.riderNext.latest.chronicles.ai.RecapLLMLog;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.storage.ChroniclesStorage;
import com.intellij.ml.llm.riderNext.latest.chronicles.statistics.RecapRating;
import com.intellij.ml.llm.riderNext.latest.chronicles.statistics.RecapStatisticsAggregator;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChroniclePresenterAISection;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.RecapViewModel;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.text.DateFormatUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PairSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a4\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\t\u001a \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\"\u0010\u0010\u0000\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"SAVE_CHRONICLES", "", "SAVE_CHRONICLES_CSV_FILE", "dumpRecap", "", "viewModel", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapViewModel;", "saveZip", "chroniclesPath", "Ljava/nio/file/Path;", "llmLog", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/ai/RecapLLMLog;", "recapJson", "ratesJson", "outputZip", "stringToFile", "stream", "Ljava/util/zip/ZipOutputStream;", "string", "fileName", "intellij.ml.llm.riderNext.latest"})
@SourceDebugExtension(value={"SMAP\ndumpRecap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dumpRecap.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/view/DumpRecapKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1#2:83\n205#3:84\n205#3:89\n1563#4:85\n1634#4,3:86\n*S KotlinDebug\n*F\n+ 1 dumpRecap.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/view/DumpRecapKt\n*L\n36#1:84\n39#1:89\n38#1:85\n38#1:86,3\n*E\n"})
public final class DumpRecapKt {
    @NlsSafe
    @NotNull
    private static final String SAVE_CHRONICLES = "Save Chronicles";
    @NlsSafe
    @NotNull
    private static final String SAVE_CHRONICLES_CSV_FILE = "Save chronicles.csv file";

    /*
     * WARNING - void declaration
     */
    public static final void dumpRecap(@NotNull RecapViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor(SAVE_CHRONICLES, SAVE_CHRONICLES_CSV_FILE, "zip");
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, viewModel.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
        FileSaverDialog dialog2 = fileSaverDialog;
        String filename = "recap_" + viewModel.getProject().getName() + "_" + DateFormatUtil.formatDateTime((long)Clock.getTime()) + ".zip";
        VirtualFileWrapper wrapper = dialog2.save(filename);
        if (wrapper != null) {
            String string;
            String string2;
            Path target = wrapper.getFile().toPath();
            Path chroniclesPath = ChroniclesStorage.Companion.getInstance(viewModel.getProject()).getCsvPath();
            RecapAgentResult recapAgentResult = RecapStatisticsAggregator.Companion.getInstance(viewModel.getProject()).getCurrent();
            RecapLLMLog llmLog = recapAgentResult != null ? recapAgentResult.getLog() : null;
            List<ChroniclePresenterAISection> list = viewModel.getAiGroups();
            if (list != null) {
                void this_$iv;
                List<ChroniclePresenterAISection> it = list;
                boolean bl = false;
                Json json = (Json)Json.Default;
                List<ChroniclePresenterAISection> value$iv = it;
                boolean $i$f$encodeToString = false;
                this_$iv.getSerializersModule();
                string2 = this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(ChroniclePresenterAISection.Companion.serializer()), value$iv);
            } else {
                string2 = null;
            }
            String recapJson = string2;
            List<ChroniclePresenterAISection> list2 = viewModel.getAiGroups();
            if (list2 != null) {
                void this_$iv;
                void $this$mapTo$iv$iv;
                List<ChroniclePresenterAISection> presenter = list2;
                boolean bl = false;
                Iterable $this$map$iv = presenter;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ChroniclePresenterAISection chroniclePresenterAISection = (ChroniclePresenterAISection)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(TuplesKt.to((Object)it.getCaption(), (Object)((Object)it.getRating())));
                }
                List pairs = (List)destination$iv$iv;
                $this$map$iv = (Json)Json.Default;
                List value$iv = pairs;
                boolean $i$f$encodeToString = false;
                this_$iv.getSerializersModule();
                string = this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer((KSerializer)new PairSerializer((KSerializer)StringSerializer.INSTANCE, RecapRating.Companion.serializer())), (Object)value$iv);
            } else {
                string = null;
            }
            String ratesJson = string;
            try {
                Intrinsics.checkNotNull((Object)target);
                DumpRecapKt.saveZip(chroniclesPath, llmLog, recapJson, ratesJson, target);
            }
            catch (Exception e) {
                System.out.println((Object)("Failed to save recap: " + e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveZip(@NotNull Path chroniclesPath, @Nullable RecapLLMLog llmLog, @Nullable String recapJson, @Nullable String ratesJson, @NotNull Path outputZip) {
        Intrinsics.checkNotNullParameter((Object)chroniclesPath, (String)"chroniclesPath");
        Intrinsics.checkNotNullParameter((Object)outputZip, (String)"outputZip");
        Closeable closeable = new FileOutputStream(outputZip.toFile());
        Throwable throwable = null;
        try {
            FileOutputStream fos = (FileOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new ZipOutputStream(fos);
            Throwable throwable2 = null;
            try {
                ZipOutputStream zos = (ZipOutputStream)closeable2;
                boolean bl2 = false;
                String entryName = ((Object)chroniclesPath.getFileName()).toString();
                zos.putNextEntry(new ZipEntry(entryName));
                Closeable closeable3 = new FileInputStream(chroniclesPath.toFile());
                Throwable throwable3 = null;
                try {
                    FileInputStream input2 = (FileInputStream)closeable3;
                    boolean bl3 = false;
                    long l2 = ByteStreamsKt.copyTo$default((InputStream)input2, (OutputStream)zos, (int)0, (int)2, null);
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                zos.closeEntry();
                if (llmLog != null) {
                    DumpRecapKt.stringToFile(zos, llmLog.getChronicles30min(), "chronicles30min.json");
                    DumpRecapKt.stringToFile(zos, llmLog.getResponse30min(), "response30min.json");
                    DumpRecapKt.stringToFile(zos, llmLog.getChronicles2h(), "chronicles2h.json");
                    DumpRecapKt.stringToFile(zos, llmLog.getResponse2h(), "response2h.json");
                }
                if (recapJson != null) {
                    DumpRecapKt.stringToFile(zos, recapJson, "recap.json");
                }
                if (ratesJson != null) {
                    DumpRecapKt.stringToFile(zos, ratesJson, "rates.json");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void stringToFile(ZipOutputStream stream, String string, String fileName) {
        stream.putNextEntry(new ZipEntry(fileName));
        String string2 = string;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ByteStreamsKt.copyTo$default((InputStream)new ByteArrayInputStream(byArray), (OutputStream)stream, (int)0, (int)2, null);
        stream.closeEntry();
    }
}

