/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.frozen.insight.impl.view.comment;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.ml.llm.riderNext.latest.frozen.insight.impl.view.comment.AIInsightComment;
import com.intellij.ml.llm.riderNext.latest.ui.editor.AIDaemonPresenter;
import com.intellij.ml.llm.riderNext.latest.ui.editor.cards.AIDaemonDescriptor;
import com.intellij.ml.llm.riderNext.latest.ui.editor.cards.AIDaemonId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ApplicationKt;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u000fH\u0016J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/insight/impl/view/comment/AIInsightCommentsContainer;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "inlays", "", "Lcom/intellij/ml/llm/riderNext/latest/ui/editor/cards/AIDaemonId;", "Lcom/intellij/ml/llm/riderNext/latest/frozen/insight/impl/view/comment/AIInsightComment;", "disposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "addOrUpdate", "", "presenter", "Lcom/intellij/ml/llm/riderNext/latest/ui/editor/AIDaemonPresenter$Comment;", "insight", "Lcom/intellij/ml/llm/riderNext/latest/ui/editor/cards/AIDaemonDescriptor;", "setupFolding", "range", "Lcom/intellij/openapi/editor/RangeMarker;", "comment", "removeFolding", "foldRegion", "Lcom/intellij/openapi/editor/FoldRegion;", "removeFoldingImpl", "dispose", "setupDispose", "parent", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
public final class AIInsightCommentsContainer
implements Disposable {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final Map<AIDaemonId, AIInsightComment> inlays;
    @NotNull
    private final AtomicBoolean disposed;
    public static final int $stable = 8;

    public AIInsightCommentsContainer(@NotNull EditorImpl editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.inlays = new LinkedHashMap();
        this.disposed = new AtomicBoolean(false);
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @RequiresEdt
    public final void addOrUpdate(@NotNull AIDaemonPresenter.Comment presenter, @NotNull AIDaemonDescriptor insight) {
        Intrinsics.checkNotNullParameter((Object)presenter, (String)"presenter");
        Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
        AIInsightComment aIInsightComment = this.inlays.get(insight.getId());
        if (aIInsightComment != null) {
            AIInsightComment it = aIInsightComment;
            boolean bl = false;
            it.update(presenter);
            return;
        }
        AIInsightComment comment = AIInsightComment.Companion.show(this.editor, presenter, insight);
        if (presenter.getAddFolding()) {
            this.setupFolding(insight.getRange(), comment);
        }
        this.inlays.put(insight.getId(), comment);
        this.setupDispose(comment, insight);
    }

    private final void setupFolding(RangeMarker range, AIInsightComment comment) {
        this.editor.getFoldingModel().runBatchFoldingOperation(() -> AIInsightCommentsContainer.setupFolding$lambda$0(this, range, comment));
    }

    private final void removeFolding(FoldRegion foldRegion) {
        if (this.editor.isDisposed()) {
            return;
        }
        if (ApplicationKt.getApplication().isDispatchThread()) {
            this.removeFoldingImpl(foldRegion);
        } else {
            ApplicationKt.getApplication().invokeLater(() -> AIInsightCommentsContainer.removeFolding$lambda$0(this, foldRegion));
        }
    }

    private final void removeFoldingImpl(FoldRegion foldRegion) {
        this.editor.getFoldingModel().runBatchFoldingOperation(() -> AIInsightCommentsContainer.removeFoldingImpl$lambda$0(this, foldRegion));
    }

    public void dispose() {
        if (this.disposed.getAndSet(true)) {
            return;
        }
        for (AIInsightComment inlay : this.inlays.values()) {
            Disposer.dispose((Disposable)inlay);
        }
        this.inlays.clear();
    }

    private final void setupDispose(AIInsightComment comment, AIDaemonDescriptor parent) {
        Disposer.tryRegister((Disposable)parent, (Disposable)comment);
    }

    private static final void setupFolding$lambda$0(AIInsightCommentsContainer this$0, RangeMarker $range, AIInsightComment $comment) {
        int start2 = DocumentUtil.getLineStartIndentedOffset((Document)((Document)this$0.editor.getDocument()), (int)this$0.editor.getDocument().getLineNumber($range.getStartOffset()));
        int end = DocumentUtil.getLineEndOffset((int)$range.getEndOffset(), (Document)((Document)this$0.editor.getDocument()));
        int startLineEndOffset = DocumentUtil.getLineEndOffset((int)$range.getStartOffset(), (Document)((Document)this$0.editor.getDocument()));
        String string = this$0.editor.getDocument().getText(new TextRange(start2, startLineEndOffset));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String placeholder = string;
        FoldRegion foldRegion = this$0.editor.getFoldingModel().addFoldRegion(start2, end, placeholder);
        if (foldRegion != null) {
            CodeFoldingManagerImpl.markAsNotPersistent((FoldRegion)foldRegion);
            if ($comment.getDisposed()) {
                this$0.removeFolding(foldRegion);
            } else {
                DisposerUtilKt.whenDisposed((Disposable)$comment, () -> AIInsightCommentsContainer.setupFolding$lambda$0$0(this$0, foldRegion));
            }
        }
    }

    private static final Unit setupFolding$lambda$0$0(AIInsightCommentsContainer this$0, FoldRegion $foldRegion) {
        this$0.removeFolding($foldRegion);
        return Unit.INSTANCE;
    }

    private static final void removeFolding$lambda$0(AIInsightCommentsContainer this$0, FoldRegion $foldRegion) {
        this$0.removeFoldingImpl($foldRegion);
    }

    private static final void removeFoldingImpl$lambda$0(AIInsightCommentsContainer this$0, FoldRegion $foldRegion) {
        this$0.editor.getFoldingModel().removeFoldRegion($foldRegion);
    }
}

