/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.frozen.insight.impl.view.docComment;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.codeInsight.hints.presentation.InputHandler;
import com.intellij.lang.Language;
import com.intellij.ml.llm.core.ui.XNextThemeHelper;
import com.intellij.ml.llm.riderNext.latest.frozen.insight.impl.view.common.AIInsightGutterIconRenderer;
import com.intellij.ml.llm.riderNext.latest.frozen.insight.impl.view.common.AIInsightLineMarkerRenderer;
import com.intellij.ml.llm.riderNext.latest.ui.editor.AIDaemonPresenter;
import com.intellij.ml.llm.riderNext.latest.ui.editor.cards.AIDaemonDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0001@B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0014\u0010'\u001a\u00020\u00062\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0016J\u0014\u0010(\u001a\u00020\u00062\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0016J,\u0010)\u001a\u00020%2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u000202H\u0002J\u0018\u00103\u001a\u00020%2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020%H\u0016J\u0016\u00109\u001a\u0004\u0018\u00010:2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0016J\b\u0010;\u001a\u00020%H\u0002J\b\u0010<\u001a\u00020%H\u0002J\u0010\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020?H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/insight/impl/view/docComment/AIInsightDocCommentRenderer;", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer;", "Lcom/intellij/codeInsight/hints/presentation/InputHandler;", "presenter", "Lcom/intellij/ml/llm/riderNext/latest/ui/editor/AIDaemonPresenter$DocComment;", "indentChars", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "range", "Lcom/intellij/openapi/editor/RangeMarker;", "insight", "Lcom/intellij/ml/llm/riderNext/latest/ui/editor/cards/AIDaemonDescriptor;", "<init>", "(Lcom/intellij/ml/llm/riderNext/latest/ui/editor/AIDaemonPresenter$DocComment;ILcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/openapi/editor/RangeMarker;Lcom/intellij/ml/llm/riderNext/latest/ui/editor/cards/AIDaemonDescriptor;)V", "getPresenter", "()Lcom/intellij/ml/llm/riderNext/latest/ui/editor/AIDaemonPresenter$DocComment;", "setPresenter", "(Lcom/intellij/ml/llm/riderNext/latest/ui/editor/AIDaemonPresenter$DocComment;)V", "getIndentChars", "()I", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getRange", "()Lcom/intellij/openapi/editor/RangeMarker;", "getInsight", "()Lcom/intellij/ml/llm/riderNext/latest/ui/editor/cards/AIDaemonDescriptor;", "mouseEntered", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "lines", "", "", "update", "", "getUpdatedText", "calcWidthInPixels", "calcHeightInPixels", "paint", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getIndentPx", "metrics", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer$Companion$MyFontMetrics;", "mouseMoved", "event", "Ljava/awt/event/MouseEvent;", "translated", "Ljava/awt/Point;", "mouseExited", "calcGutterIconRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "showLineOnGutter", "hideLineOnGutter", "getMaxWidth", "fontMetrics", "Ljava/awt/FontMetrics;", "Companion", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAIInsightDocCommentRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIInsightDocCommentRenderer.kt\ncom/intellij/ml/llm/riderNext/latest/frozen/insight/impl/view/docComment/AIInsightDocCommentRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class AIInsightDocCommentRenderer
extends HintRenderer
implements InputHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private AIDaemonPresenter.DocComment presenter;
    private final int indentChars;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final RangeMarker range;
    @NotNull
    private final AIDaemonDescriptor insight;
    private boolean mouseEntered;
    @Nullable
    private RangeHighlighter highlighter;
    @Nullable
    private Inlay<?> inlay;
    @NotNull
    private List<String> lines;
    public static final int $stable = 8;

    public AIInsightDocCommentRenderer(@NotNull AIDaemonPresenter.DocComment presenter, int indentChars, @NotNull EditorImpl editor2, @NotNull RangeMarker range, @NotNull AIDaemonDescriptor insight) {
        Intrinsics.checkNotNullParameter((Object)presenter, (String)"presenter");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
        super(presenter.getDoc());
        this.presenter = presenter;
        this.indentChars = indentChars;
        this.editor = editor2;
        this.range = range;
        this.insight = insight;
        Disposer.tryRegister((Disposable)this.insight, () -> AIInsightDocCommentRenderer._init_$lambda$0(this));
        this.lines = this.getUpdatedText();
    }

    @NotNull
    public final AIDaemonPresenter.DocComment getPresenter() {
        return this.presenter;
    }

    public final void setPresenter(@NotNull AIDaemonPresenter.DocComment docComment) {
        Intrinsics.checkNotNullParameter((Object)docComment, (String)"<set-?>");
        this.presenter = docComment;
    }

    public final int getIndentChars() {
        return this.indentChars;
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final RangeMarker getRange() {
        return this.range;
    }

    @NotNull
    public final AIDaemonDescriptor getInsight() {
        return this.insight;
    }

    public final void update(@NotNull AIDaemonPresenter.DocComment presenter) {
        Intrinsics.checkNotNullParameter((Object)presenter, (String)"presenter");
        this.presenter = presenter;
        this.lines = this.getUpdatedText();
    }

    private final List<String> getUpdatedText() {
        FontMetrics fontMetrics = this.getFontMetrics$((Editor)this.editor, true).getMetrics();
        return AIInsightDocCommentRenderer.Companion.wrapText(this.presenter.getDoc(), fontMetrics, this.getMaxWidth(fontMetrics));
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        int indentPx;
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        int textWidth = super.calcWidthInPixels(inlay);
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        HintRenderer.Companion.MyFontMetrics metrics = this.getFontMetrics$(editor2, true);
        int extraPadding = indentPx = this.getIndentPx(metrics);
        return Math.min(textWidth + indentPx + extraPadding, this.getMaxWidth(metrics.getMetrics()));
    }

    public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return super.calcHeightInPixels(inlay) * Math.max(this.lines.size(), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        this.inlay = inlay;
        Paint paint = XNextThemeHelper.INSTANCE.getButtonAiXNextDoubleColorBorder().getGradientPaint(r);
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        HintRenderer.Companion.MyFontMetrics metrics = this.getFontMetrics$(editor2, true);
        int indentPx = this.getIndentPx(metrics);
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            GraphicsUtil.setupAAPainting((Graphics)g2);
            g2.setPaint(paint);
            g2.setFont(metrics.getMetrics().getFont());
            Iterator iterator = ((Iterable)this.lines).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                String line = (String)iterator.next();
                g2.drawString(line, r.x + indentPx, r.y + inlay.getEditor().getAscent() + index * inlay.getEditor().getLineHeight());
            }
        }
        finally {
            g2.dispose();
        }
    }

    private final int getIndentPx(HintRenderer.Companion.MyFontMetrics metrics) {
        return metrics.getMetrics().charWidth(' ') * (this.indentChars + 1);
    }

    public void mouseMoved(@NotNull MouseEvent event2, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        if (this.mouseEntered) {
            return;
        }
        this.hideLineOnGutter();
        this.showLineOnGutter();
        this.mouseEntered = true;
    }

    public void mouseExited() {
        if (!this.mouseEntered) {
            return;
        }
        this.hideLineOnGutter();
        this.mouseEntered = false;
    }

    @Nullable
    public GutterIconRenderer calcGutterIconRenderer(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return new AIInsightGutterIconRenderer(this.presenter.getGutterActionsFactory(), this.insight);
    }

    /*
     * WARNING - void declaration
     */
    private final void showLineOnGutter() {
        void it;
        RangeHighlighter rangeHighlighter;
        RangeHighlighter rangeHighlighter2 = rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(this.range.getStartOffset(), this.range.getEndOffset(), 6000, null, HighlighterTargetArea.LINES_IN_RANGE);
        AIInsightDocCommentRenderer aIInsightDocCommentRenderer = this;
        boolean bl = false;
        it.setLineMarkerRenderer((LineMarkerRenderer)new AIInsightLineMarkerRenderer(false));
        aIInsightDocCommentRenderer.highlighter = rangeHighlighter;
    }

    private final void hideLineOnGutter() {
        block0: {
            RangeHighlighter rangeHighlighter = this.highlighter;
            if (rangeHighlighter == null) break block0;
            RangeHighlighter it = rangeHighlighter;
            boolean bl = false;
            this.editor.getMarkupModel().removeHighlighter(it);
        }
    }

    private final int getMaxWidth(FontMetrics fontMetrics) {
        Project project2 = this.editor.getProject();
        Intrinsics.checkNotNull((Object)project2);
        int margin = CodeStyle.getSettings((Project)project2).getRightMargin(Language.ANY);
        return margin * fontMetrics.charWidth('m');
    }

    private static final void _init_$lambda$0(AIInsightDocCommentRenderer this$0) {
        this$0.hideLineOnGutter();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/insight/impl/view/docComment/AIInsightDocCommentRenderer$Companion;", "", "<init>", "()V", "format", "", "input", "wrapText", "", "text", "fontMetrics", "Ljava/awt/FontMetrics;", "lineWidth", "", "intellij.ml.llm.riderNext.latest"})
    public static final class Companion {
        private Companion() {
        }

        private final String format(String input2) {
            return "// " + input2;
        }

        private final List<String> wrapText(String text2, FontMetrics fontMetrics, int lineWidth) {
            String[] stringArray = new String[]{" "};
            List words = StringsKt.split$default((CharSequence)text2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            List lines2 = new ArrayList();
            StringBuilder currentLine = new StringBuilder();
            for (String word : words) {
                int lineWidthWithWord = fontMetrics.stringWidth(currentLine + " " + word);
                if (lineWidthWithWord > lineWidth && ((CharSequence)currentLine).length() > 0) {
                    String string = currentLine.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    lines2.add(this.format(string));
                    currentLine = new StringBuilder(word);
                    continue;
                }
                if (!StringsKt.isBlank((CharSequence)currentLine)) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
            }
            if (((CharSequence)currentLine).length() > 0) {
                String string = currentLine.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                lines2.add(this.format(string));
            }
            return lines2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

