/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.frozen.nextStep;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.riderNext.latest.frozen.nextStep.AgentFailure;
import com.intellij.ml.llm.riderNext.latest.frozen.nextStep.AgentResultWithLog;
import com.intellij.ml.llm.riderNext.latest.frozen.nextStep.CurrentStateChroniclesAgent;
import com.intellij.ml.llm.riderNext.latest.frozen.nextStep.FolderType;
import com.intellij.ml.llm.riderNext.latest.frozen.nextStep.IntentClassificationAgent;
import com.intellij.ml.llm.riderNext.latest.frozen.nextStep.IntentVerificationAgent;
import com.intellij.ml.llm.riderNext.latest.frozen.nextStep.NextStepSuggestService;
import com.intellij.ml.llm.riderNext.latest.frozen.nextStep.ProcessingTiming;
import com.intellij.ml.llm.riderNext.latest.frozen.nextStep.RunNextStepOnDatasetAction;
import com.intellij.ml.llm.riderNext.latest.frozen.nextStep.RunNextStepOnDatasetActionKt;
import com.intellij.ml.llm.riderNext.latest.frozen.nextStep.ScenarioResult;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.io.File;
import java.io.FileFilter;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\u0016J&\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\u0016J&\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u001e\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u001bH\u0082@\u00a2\u0006\u0002\u0010!J.\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0002J \u0010&\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a8\u0006("}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/nextStep/RunNextStepOnDatasetAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "detectFolderType", "Lcom/intellij/ml/llm/riderNext/latest/frozen/nextStep/FolderType;", "folder", "Ljava/io/File;", "actionPerformed", "processDatasets", "project", "Lcom/intellij/openapi/project/Project;", "datasetFolder", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/project/Project;Ljava/io/File;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processSingleDataset", "processSingleScenario", "scenarioFolder", "generateSummaryTable", "", "scenarioResults", "", "Lcom/intellij/ml/llm/riderNext/latest/frozen/nextStep/ScenarioResult;", "displaySummaryTable", "summaryTable", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processDataset", "datasetDir", "mockAgentDataDir", "Ljava/nio/file/Path;", "runCalculations", "scenarioDir", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRunNextStepOnDatasetAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunNextStepOnDatasetAction.kt\ncom/intellij/ml/llm/riderNext/latest/frozen/nextStep/RunNextStepOnDatasetAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,991:1\n774#2:992\n865#2,2:993\n774#2:995\n865#2,2:996\n1869#2,2:998\n774#2:1000\n865#2,2:1001\n1869#2:1003\n1869#2,2:1004\n1870#2:1006\n1869#2,2:1007\n1878#2,3:1009\n*S KotlinDebug\n*F\n+ 1 RunNextStepOnDatasetAction.kt\ncom/intellij/ml/llm/riderNext/latest/frozen/nextStep/RunNextStepOnDatasetAction\n*L\n591#1:992\n591#1:993,2\n606#1:995\n606#1:996,2\n606#1:998,2\n625#1:1000\n625#1:1001,2\n625#1:1003\n626#1:1004,2\n625#1:1006\n647#1:1007,2\n963#1:1009,3\n*E\n"})
public final class RunNextStepOnDatasetAction
extends AnAction
implements DumbAware {
    public static final int $stable = 8;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    private final FolderType detectFolderType(File folder) {
        boolean hasCurrentStepTxt = new File(folder, "current_step.txt").exists();
        boolean hasCurrentStepPatch = new File(folder, "current_step.patch").exists();
        if (hasCurrentStepTxt || hasCurrentStepPatch) {
            return FolderType.SCENARIO_FOLDER;
        }
        File scenariosDir = new File(folder, "scenarios");
        if (scenariosDir.exists() && scenariosDir.isDirectory()) {
            return FolderType.DATASET_FOLDER;
        }
        File[] fileArray = folder.listFiles(RunNextStepOnDatasetAction::detectFolderType$lambda$0);
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        for (File subdir : fileArray) {
            File subScenariosDir = new File(subdir, "scenarios");
            if (!subScenariosDir.exists() || !subScenariosDir.isDirectory()) continue;
            return FolderType.DATA_FOLDER;
        }
        return FolderType.UNKNOWN;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        RunNextStepOnDatasetActionKt.access$setActionSanitizedTime$p(RunNextStepOnDatasetActionKt.access$generateSanitizedTimeString());
        String defaultFolderName = "output_temp_" + RunNextStepOnDatasetActionKt.access$getActionSanitizedTime$p();
        String result2 = Messages.showInputDialog((Project)project3, (String)"Enter output folder name:", (String)"Output Folder Name", (Icon)Messages.getQuestionIcon(), (String)defaultFolderName, null);
        Object object = result2;
        if (object == null) {
            object = defaultFolderName;
        }
        RunNextStepOnDatasetActionKt.access$setOutputFolderName$p((String)object);
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, true, false, false, false, false).withTitle("Select Folder").withDescription("Select a data folder, dataset folder, or scenario folder");
        VirtualFile virtualFile2 = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)project3, null);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        File selectedFolder = new File(virtualFile3.getPath());
        if (!selectedFolder.exists() || !selectedFolder.isDirectory()) {
            NotificationGroupManager.getInstance().getNotificationGroup("ijNext.notifications").createNotification("Invalid folder", "Selected folder does not exist or is not a directory", NotificationType.ERROR).notify(project3);
            return;
        }
        FolderType folderType = this.detectFolderType(selectedFolder);
        if (folderType == FolderType.UNKNOWN) {
            NotificationGroupManager.getInstance().getNotificationGroup("ijNext.notifications").createNotification("Invalid folder structure", "The selected folder does not match any expected structure (data folder, dataset folder, or scenario folder)", NotificationType.ERROR).notify(project3);
            return;
        }
        String taskTitle = switch (WhenMappings.$EnumSwitchMapping$0[folderType.ordinal()]) {
            case 1 -> "Processing Multiple Datasets";
            case 2 -> "Processing Dataset: " + selectedFolder.getName();
            case 3 -> "Processing Scenario: " + selectedFolder.getName();
            default -> "Processing";
        };
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project3, taskTitle, folderType, this, selectedFolder){
            final /* synthetic */ Project $project;
            final /* synthetic */ FolderType $folderType;
            final /* synthetic */ RunNextStepOnDatasetAction this$0;
            final /* synthetic */ File $selectedFolder;
            {
                this.$project = $project;
                this.$folderType = $folderType;
                this.this$0 = $receiver;
                this.$selectedFolder = $selectedFolder;
                super($project, $taskTitle, false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$folderType, this.this$0, this.$project, this.$selectedFolder, indicator, null){
                    int label;
                    final /* synthetic */ FolderType $folderType;
                    final /* synthetic */ RunNextStepOnDatasetAction this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ File $selectedFolder;
                    final /* synthetic */ ProgressIndicator $indicator;
                    {
                        this.$folderType = $folderType;
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$selectedFolder = $selectedFolder;
                        this.$indicator = $indicator;
                        super(2, $completion);
                    }

                    /*
                     * Exception decompiling
                     */
                    public final Object invokeSuspend(Object $result) {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CASE]], but top level block is 6[SWITCH]
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                         *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                         *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                         *     at org.benf.cfr.reader.bytecode.analysis.types.MethodPrototype.dumpAppropriatelyCastedArgumentString(MethodPrototype.java:562)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.MemberFunctionInvokation.dumpInner(MemberFunctionInvokation.java:63)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                         *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                         *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                         *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private final Object processDatasets(Project project, File datasetFolder, ProgressIndicator indicator, Continuation<? super Unit> $completion) {
        if (!($completion instanceof processDatasets.1)) ** GOTO lbl-1000
        var15_5 = $completion;
        if ((var15_5.label & -2147483648) != 0) {
            var15_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                /* synthetic */ Object result;
                final /* synthetic */ RunNextStepOnDatasetAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RunNextStepOnDatasetAction.access$processDatasets(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var16_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Registry.Companion.get("llm.riderNext.mockAgentActions").setValue(true);
                v0 = project.getBasePath();
                Intrinsics.checkNotNull((Object)v0);
                var6_8 = new String[]{"mockAgentData"};
                mockAgentDataDir = Paths.get(v0, var6_8);
                if (!Files.exists(mockAgentDataDir, new LinkOption[0])) {
                    Files.createDirectories(mockAgentDataDir, new FileAttribute[0]);
                }
                if ((v1 = datasetFolder.listFiles((FileFilter)LambdaMetafactory.metafactory(null, null, null, (Ljava/io/File;)Z, processDatasets$lambda$0(java.io.File ), (Ljava/io/File;)Z)())) == null) {
                    v1 = new File[]{};
                }
                datasetDirs = v1;
                indicator.setText("Found " + datasetDirs.length + " datasets");
                indicator.setIndeterminate(false);
                allScenarioResults = new ArrayList<E>();
                var9_17 = datasetDirs.length;
                for (var8_14 = 0; var8_14 < var9_17; ++var8_14) {
                    index = var8_14;
                    datasetDir = datasetDirs[var8_14];
                    indicator.setText("Processing dataset " + (index + 1) + "/" + datasetDirs.length + ": " + datasetDir.getName());
                    indicator.setFraction((double)index / (double)datasetDirs.length);
                    try {
                        Intrinsics.checkNotNull((Object)datasetDir);
                        Intrinsics.checkNotNull((Object)mockAgentDataDir);
                        datasetResults = this.processDataset(project, datasetDir, indicator, mockAgentDataDir);
                        allScenarioResults.addAll((Collection)datasetResults);
                        continue;
                    }
                    catch (Exception e) {
                        RunNextStepOnDatasetActionKt.access$getLOG$p().error("Error processing dataset " + datasetDir.getName(), (Throwable)e);
                        NotificationGroupManager.getInstance().getNotificationGroup("ijNext.notifications").createNotification("Error processing dataset", "Error processing dataset " + datasetDir.getName() + ": " + e.getMessage(), NotificationType.ERROR).notify(project);
                    }
                }
                Registry.Companion.get("llm.riderNext.mockAgentActions").resetToDefault();
                if (((Collection)allScenarioResults).isEmpty() == false) {
                    summaryTable = this.generateSummaryTable(allScenarioResults);
                    $continuation.L$0 = project;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)datasetFolder);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)indicator);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)mockAgentDataDir);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)datasetDirs);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)allScenarioResults);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)summaryTable);
                    $continuation.label = 1;
                    v2 = this.displaySummaryTable(project, summaryTable, (Continuation<? super Unit>)$continuation);
                    if (v2 == var16_7) {
                        return var16_7;
                    }
                }
                ** GOTO lbl69
            }
            case 1: {
                summaryTable = (String)$continuation.L$6;
                allScenarioResults = (List)$continuation.L$5;
                datasetDirs = (File[])$continuation.L$4;
                mockAgentDataDir = (Path)$continuation.L$3;
                indicator = (ProgressIndicator)$continuation.L$2;
                datasetFolder = (File)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl69:
                // 2 sources

                NotificationGroupManager.getInstance().getNotificationGroup("ijNext.notifications").createNotification("Datasets processed", "All datasets have been processed", NotificationType.INFORMATION).notify(project);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object processSingleDataset(Project project, File datasetFolder, ProgressIndicator indicator, Continuation<? super Unit> $completion) {
        if (!($completion instanceof processSingleDataset.1)) ** GOTO lbl-1000
        var10_5 = $completion;
        if ((var10_5.label & -2147483648) != 0) {
            var10_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ RunNextStepOnDatasetAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RunNextStepOnDatasetAction.access$processSingleDataset(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Registry.Companion.get("llm.riderNext.mockAgentActions").setValue(true);
                v0 = project.getBasePath();
                Intrinsics.checkNotNull((Object)v0);
                var6_8 = new String[]{"mockAgentData"};
                mockAgentDataDir = Paths.get(v0, var6_8);
                if (!Files.exists(mockAgentDataDir, new LinkOption[0])) {
                    Files.createDirectories(mockAgentDataDir, new FileAttribute[0]);
                }
                indicator.setText("Processing dataset: " + datasetFolder.getName());
                indicator.setIndeterminate(false);
                allScenarioResults = new ArrayList<E>();
                try {
                    Intrinsics.checkNotNull((Object)mockAgentDataDir);
                    datasetResults = this.processDataset(project, datasetFolder, indicator, mockAgentDataDir);
                    allScenarioResults.addAll((Collection)datasetResults);
                }
                catch (Exception e) {
                    RunNextStepOnDatasetActionKt.access$getLOG$p().error("Error processing dataset " + datasetFolder.getName(), (Throwable)e);
                    NotificationGroupManager.getInstance().getNotificationGroup("ijNext.notifications").createNotification("Error processing dataset", "Error processing dataset " + datasetFolder.getName() + ": " + e.getMessage(), NotificationType.ERROR).notify(project);
                }
                Registry.Companion.get("llm.riderNext.mockAgentActions").resetToDefault();
                if (((Collection)allScenarioResults).isEmpty() == false) {
                    summaryTable = this.generateSummaryTable(allScenarioResults);
                    $continuation.L$0 = project;
                    $continuation.L$1 = datasetFolder;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)indicator);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)mockAgentDataDir);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)allScenarioResults);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)summaryTable);
                    $continuation.label = 1;
                    v1 = this.displaySummaryTable(project, summaryTable, (Continuation<? super Unit>)$continuation);
                    if (v1 == var11_7) {
                        return var11_7;
                    }
                }
                ** GOTO lbl56
            }
            case 1: {
                summaryTable = (String)$continuation.L$5;
                allScenarioResults = (List)$continuation.L$4;
                mockAgentDataDir = (Path)$continuation.L$3;
                indicator = (ProgressIndicator)$continuation.L$2;
                datasetFolder = (File)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl56:
                // 2 sources

                NotificationGroupManager.getInstance().getNotificationGroup("ijNext.notifications").createNotification("Dataset processed", "Dataset " + datasetFolder.getName() + " has been processed", NotificationType.INFORMATION).notify(project);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object processSingleScenario(Project project, File scenarioFolder, ProgressIndicator indicator, Continuation<? super Unit> $completion) {
        if (!($completion instanceof processSingleScenario.1)) ** GOTO lbl-1000
        var20_5 = $completion;
        if ((var20_5.label & -2147483648) != 0) {
            var20_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                /* synthetic */ Object result;
                final /* synthetic */ RunNextStepOnDatasetAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RunNextStepOnDatasetAction.access$processSingleScenario(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var21_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Registry.Companion.get("llm.riderNext.mockAgentActions").setValue(true);
                v0 = project.getBasePath();
                Intrinsics.checkNotNull((Object)v0);
                var6_8 = new String[]{"mockAgentData"};
                mockAgentDataDir = Paths.get(v0, var6_8);
                if (!Files.exists(mockAgentDataDir, new LinkOption[0])) {
                    Files.createDirectories(mockAgentDataDir, new FileAttribute[0]);
                }
                indicator.setText("Processing scenario 1/1: " + scenarioFolder.getName());
                indicator.setIndeterminate(false);
                if (Intrinsics.areEqual((Object)scenarioFolder.getParentFile().getName(), (Object)"scenarios")) {
                    v1 = scenarioFolder.getParentFile().getParentFile();
                } else {
                    tempDatasetFolder = new File(scenarioFolder.getParentFile(), "temp_dataset_" + scenarioFolder.getName());
                    if (!tempDatasetFolder.exists()) {
                        tempDatasetFolder.mkdirs();
                    }
                    v1 = tempDatasetFolder;
                }
                datasetFolder = v1;
                allScenarioResults = new ArrayList<E>();
                try {
                    v2 = ChangeListManager.getInstance((Project)project);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                    changeListManager = v2;
                    shelveChangesManager = ShelveChangesManager.getInstance((Project)project);
                    v3 = changeListManager.getAllChanges();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getAllChanges(...)");
                    changes = v3;
                    if (changes.isEmpty() == false) {
                        shelveChangesManager.shelveChanges(changes, "Shelved before scenario processing", true);
                    }
                    try {
                        patchFile = new File(scenarioFolder, "current_step.patch");
                        if (patchFile.exists()) {
                            indicator.setText2("Applying patch for scenario 1/1: " + scenarioFolder.getName());
                            patchVirtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(patchFile);
                            if (patchVirtualFile != null) {
                                v4 = patchVirtualFile.contentsToByteArray();
                                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"contentsToByteArray(...)");
                                var14_25 = v4;
                                patchContent = new String(var14_25, Charsets.UTF_8);
                                v5 = new PatchReader((CharSequence)patchContent).readTextPatches();
                                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"readTextPatches(...)");
                                patches /* !! */  = CollectionsKt.toMutableList((Collection)v5);
                                v6 = LocalFileSystem.getInstance();
                                v7 = project.getBasePath();
                                Intrinsics.checkNotNull((Object)v7);
                                projectBaseDir = v6.findFileByPath(v7);
                                if (projectBaseDir != null) {
                                    Intrinsics.checkNotNull((Object)patches /* !! */ , (String)"null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.openapi.diff.impl.patch.FilePatch>");
                                    filePatches = TypeIntrinsics.asMutableList((Object)patches /* !! */ );
                                    patchApplier = new PatchApplier(project, projectBaseDir, filePatches, null, null);
                                    try {
                                        patchApplier.execute(false, false);
                                    }
                                    catch (UnsupportedOperationException e) {
                                        RunNextStepOnDatasetActionKt.access$getLOG$p().warn("Failed to apply patch due to running in internal mode: " + e.getMessage());
                                        NotificationGroupManager.getInstance().getNotificationGroup("ijNext.notifications").createNotification("Patch application skipped", "Failed to apply patch due to running in internal mode. The scenario processing will continue without applying the patch.", NotificationType.WARNING).notify(project);
                                    }
                                }
                            }
                        }
                        if (!(currentStepFile = new File(scenarioFolder, "current_step.txt")).exists()) {
                            throw new Exception("No current_step.txt file found in scenario folder");
                        }
                        patches /* !! */  = new String[]{"read_chronicles.txt"};
                        targetFile = Paths.get(mockAgentDataDir.toString(), (String[])patches /* !! */ );
                        patches /* !! */  = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        Files.copy(currentStepFile.toPath(), targetFile, (CopyOption[])patches /* !! */ );
                        indicator.setText2("Running calculations for scenario 1/1: " + scenarioFolder.getName());
                        Intrinsics.checkNotNull((Object)datasetFolder);
                        scenarioResult = this.runCalculations(project, datasetFolder, scenarioFolder);
                        patchFile = allScenarioResults.add(scenarioResult);
                    }
                    catch (Throwable var12_24) {
                        v8 = changeListManager.getAllChanges();
                        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getAllChanges(...)");
                        localChanges = v8;
                        if (localChanges.isEmpty() == false) {
                            indicator.setText2("Reverting changes after scenario 1/1: " + scenarioFolder.getName());
                            new RollbackWorker(project).doRollback(localChanges, true);
                        }
                        v9 = shelveChangesManager.getShelvedChangeLists();
                        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getShelvedChangeLists(...)");
                        shelvedChangeLists = v9;
                        if (((Collection)shelvedChangeLists).isEmpty() == false) {
                            lastShelvedChangeList = (ShelvedChangeList)CollectionsKt.first((List)shelvedChangeLists);
                            shelveChangesManager.unshelveChangeList(lastShelvedChangeList, null, null, null, false);
                        }
                        throw var12_24;
                    }
                    v10 = changeListManager.getAllChanges();
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"getAllChanges(...)");
                    localChanges = v10;
                    if (localChanges.isEmpty() == false) {
                        indicator.setText2("Reverting changes after scenario 1/1: " + scenarioFolder.getName());
                        new RollbackWorker(project).doRollback(localChanges, true);
                    }
                    v11 = shelveChangesManager.getShelvedChangeLists();
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getShelvedChangeLists(...)");
                    shelvedChangeLists = v11;
                    if (((Collection)shelvedChangeLists).isEmpty() == false) {
                        lastShelvedChangeList = (ShelvedChangeList)CollectionsKt.first((List)shelvedChangeLists);
                        shelveChangesManager.unshelveChangeList(lastShelvedChangeList, null, null, null, false);
                    }
                }
                catch (Exception e) {
                    RunNextStepOnDatasetActionKt.access$getLOG$p().error("Error processing scenario " + scenarioFolder.getName(), (Throwable)e);
                    NotificationGroupManager.getInstance().getNotificationGroup("ijNext.notifications").createNotification("Error processing scenario", "Error processing scenario " + scenarioFolder.getName() + ": " + e.getMessage(), NotificationType.ERROR).notify(project);
                    v12 = e.getMessage();
                    if (v12 == null) {
                        v12 = "Unknown error";
                    }
                    failures = CollectionsKt.listOf((Object)new AgentFailure("ScenarioProcessing", v12));
                    v13 = datasetFolder.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"getName(...)");
                    v14 = scenarioFolder.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"getName(...)");
                    failedResult = new ScenarioResult(v13, v14, new ProcessingTiming(0L, 0L, null, 7, null), null, null, CollectionsKt.emptyList(), failures);
                    allScenarioResults.add(failedResult);
                }
                Registry.Companion.get("llm.riderNext.mockAgentActions").resetToDefault();
                if (((Collection)allScenarioResults).isEmpty() == false) {
                    summaryTable = this.generateSummaryTable(allScenarioResults);
                    $continuation.L$0 = project;
                    $continuation.L$1 = scenarioFolder;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)indicator);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)mockAgentDataDir);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)datasetFolder);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)allScenarioResults);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)summaryTable);
                    $continuation.label = 1;
                    v15 = this.displaySummaryTable(project, summaryTable, (Continuation<? super Unit>)$continuation);
                    if (v15 == var21_7) {
                        return var21_7;
                    }
                }
                ** GOTO lbl151
            }
            case 1: {
                summaryTable = (String)$continuation.L$6;
                allScenarioResults = (List)$continuation.L$5;
                datasetFolder = (File)$continuation.L$4;
                mockAgentDataDir = (Path)$continuation.L$3;
                indicator = (ProgressIndicator)$continuation.L$2;
                scenarioFolder = (File)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v15 = $result;
lbl151:
                // 2 sources

                NotificationGroupManager.getInstance().getNotificationGroup("ijNext.notifications").createNotification("Scenario processed", "Scenario " + scenarioFolder.getName() + " has been processed", NotificationType.INFORMATION).notify(project);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final String generateSummaryTable(List<ScenarioResult> scenarioResults) {
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        StringBuilder summary2 = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String currentTime = dateFormat.format(new Date());
        summary2.append("# Dataset Processing Summary").append('\n');
        summary2.append("Generated: " + currentTime).append('\n');
        summary2.append('\n');
        int totalScenarios = scenarioResults.size();
        Iterable $this$filter$iv = scenarioResults;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
            ScenarioResult it = (ScenarioResult)element$iv$iv2;
            boolean bl = false;
            if (!it.getHasFailures()) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        int failedScenarios = ((List)destination$iv$iv).size();
        int successfulScenarios = totalScenarios - failedScenarios;
        summary2.append("## Overall Statistics").append('\n');
        summary2.append("- Total scenarios processed: " + totalScenarios).append('\n');
        summary2.append("- Successful scenarios: " + successfulScenarios).append('\n');
        summary2.append("- Failed scenarios: " + failedScenarios).append('\n');
        summary2.append('\n');
        summary2.append("## Successful Scenarios").append('\n');
        if (successfulScenarios > 0) {
            void $this$forEach$iv;
            Object element$iv$iv2;
            summary2.append("| Dataset | Scenario | Chronicles Time | Intent Time | Verification Time | Total Time |").append('\n');
            summary2.append("|---------|----------|----------------|-------------|-------------------|------------|").append('\n');
            Iterable $this$filter$iv2 = scenarioResults;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            element$iv$iv2 = $this$filterTo$iv$iv.iterator();
            while (element$iv$iv2.hasNext()) {
                element$iv$iv = element$iv$iv2.next();
                ScenarioResult it = (ScenarioResult)element$iv$iv;
                boolean bl = false;
                if (!(!it.getHasFailures())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScenarioResult result2 = (ScenarioResult)element$iv;
                boolean bl = false;
                ProcessingTiming timing = result2.getTiming();
                summary2.append("| " + result2.getDatasetName() + " | " + result2.getScenarioName() + " | " + timing.formatTime(timing.getChroniclesAgentTime()) + " | " + timing.formatTime(timing.getIntentClassificationTime()) + " | " + timing.formatTime(CollectionsKt.sumOfLong((Iterable)timing.getVerificationTimes())) + " | " + timing.formatTime(timing.getTotalTime()) + " |").append('\n');
            }
        } else {
            summary2.append("No successful scenarios.").append('\n');
        }
        summary2.append('\n');
        summary2.append("## Failed Scenarios").append('\n');
        if (failedScenarios > 0) {
            void $this$forEach$iv;
            summary2.append("| Dataset | Scenario | Failed Agent | Error Message | Completed Stages |").append('\n');
            summary2.append("|---------|----------|--------------|---------------|------------------|").append('\n');
            Iterable $this$filter$iv3 = scenarioResults;
            boolean $i$f$filter3 = false;
            $this$filterTo$iv$iv = $this$filter$iv3;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            Iterator bl = $this$filterTo$iv$iv.iterator();
            while (bl.hasNext()) {
                element$iv$iv = bl.next();
                ScenarioResult it = (ScenarioResult)element$iv$iv;
                boolean bl2 = false;
                if (!it.getHasFailures()) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv3 = (List)destination$iv$iv3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScenarioResult result3 = (ScenarioResult)element$iv;
                boolean bl3 = false;
                Iterable $this$forEach$iv2 = result3.getFailures();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    AgentFailure failure = (AgentFailure)element$iv2;
                    boolean bl4 = false;
                    List completedStages = new ArrayList();
                    if (result3.getChroniclesResult() != null) {
                        completedStages.add("Chronicles");
                    }
                    if (result3.getIntentResult() != null) {
                        completedStages.add("Intent");
                    }
                    if (!((Collection)result3.getVerificationResults()).isEmpty()) {
                        completedStages.add("Verification (" + result3.getVerificationResults().size() + ")");
                    }
                    summary2.append("| " + result3.getDatasetName() + " | " + result3.getScenarioName() + " | " + failure.getAgentName() + " | " + StringsKt.take((String)failure.getErrorMessage(), (int)50) + (failure.getErrorMessage().length() > 50 ? "..." : "") + " | " + CollectionsKt.joinToString$default((Iterable)completedStages, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " |").append('\n');
                }
            }
        } else {
            summary2.append("No failed scenarios.").append('\n');
        }
        summary2.append('\n');
        summary2.append("## Scenario Details").append('\n');
        summary2.append("| Dataset | Scenario | Current Step | Next Step | Verification Results |").append('\n');
        summary2.append("|---------|----------|--------------|-----------|---------------------|").append('\n');
        Iterable $this$forEach$iv = scenarioResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScenarioResult result4 = (ScenarioResult)element$iv;
            boolean bl = false;
            String currentStepSummary = StringsKt.take((String)StringsKt.replace$default((String)result4.getCurrentStepSummary(), (String)"\n", (String)" ", (boolean)false, (int)4, null), (int)50) + (result4.getCurrentStepSummary().length() > 50 ? "..." : "");
            String nextStepSummary = StringsKt.take((String)StringsKt.replace$default((String)result4.getNextStepSummary(), (String)"\n", (String)" ", (boolean)false, (int)4, null), (int)50) + (result4.getNextStepSummary().length() > 50 ? "..." : "");
            String verificationSummary = result4.getVerificationResults().isEmpty() ? "None" : result4.getVerificationResults().size() + " results";
            summary2.append("| " + result4.getDatasetName() + " | " + result4.getScenarioName() + " | " + currentStepSummary + " | " + nextStepSummary + " | " + verificationSummary + " |").append('\n');
        }
        String string = summary2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final Object displaySummaryTable(Project project2, String summaryTable, Continuation<? super Unit> $completion) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String currentTime = dateFormat.format(new Date());
        String fileName = "dataset_processing_summary_" + currentTime + ".md";
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FileEditor[]>, Object>(fileName, summaryTable, project2, null){
            int label;
            final /* synthetic */ String $fileName;
            final /* synthetic */ String $summaryTable;
            final /* synthetic */ Project $project;
            {
                this.$fileName = $fileName;
                this.$summaryTable = $summaryTable;
                this.$project = $project;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        LightVirtualFile virtualFile2 = new LightVirtualFile(this.$fileName, (FileType)PlainTextFileType.INSTANCE, (CharSequence)this.$summaryTable);
                        return FileEditorManager.getInstance((Project)this.$project).openFile((VirtualFile)virtualFile2, true);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super FileEditor[]> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<ScenarioResult> processDataset(Project project2, File datasetDir, ProgressIndicator indicator, Path mockAgentDataDir) {
        List scenarioResults;
        ShelveChangesManager shelveChangesManager;
        block17: {
            indicator.setText2("Shelving uncommitted changes");
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            shelveChangesManager = ShelveChangesManager.getInstance((Project)project2);
            Collection collection = changeListManager2.getAllChanges();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllChanges(...)");
            Collection changes2 = collection;
            if (!changes2.isEmpty()) {
                shelveChangesManager.shelveChanges(changes2, "Shelved before dataset processing", true);
            }
            scenarioResults = new ArrayList();
            try {
                File scenariosDir = new File(datasetDir, "scenarios");
                if (!scenariosDir.exists() || !scenariosDir.isDirectory()) break block17;
                File[] fileArray = scenariosDir.listFiles(RunNextStepOnDatasetAction::processDataset$lambda$0);
                if (fileArray == null) {
                    fileArray = new File[]{};
                }
                File[] scenarioDirs = fileArray;
                int n = scenarioDirs.length;
                for (int i = 0; i < n; ++i) {
                    int scenarioIndex = i;
                    File scenarioDir = scenarioDirs[i];
                    indicator.setText2("Processing scenario " + (scenarioIndex + 1) + "/" + scenarioDirs.length + ": " + scenarioDir.getName());
                    try {
                        Collection localChanges;
                        File currentStepFile;
                        Object patches;
                        File patchFile = new File(scenarioDir, "current_step.patch");
                        if (patchFile.exists()) {
                            indicator.setText2("Applying patch for scenario " + (scenarioIndex + 1) + "/" + scenarioDirs.length + ": " + scenarioDir.getName());
                            VirtualFile patchVirtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(patchFile);
                            if (patchVirtualFile != null) {
                                byte[] byArray;
                                Intrinsics.checkNotNullExpressionValue((Object)patchVirtualFile.contentsToByteArray(), (String)"contentsToByteArray(...)");
                                String patchContent = new String(byArray, Charsets.UTF_8);
                                List list = new PatchReader((CharSequence)patchContent).readTextPatches();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readTextPatches(...)");
                                patches = CollectionsKt.toMutableList((Collection)list);
                                LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                                String string = project2.getBasePath();
                                Intrinsics.checkNotNull((Object)string);
                                VirtualFile projectBaseDir = localFileSystem.findFileByPath(string);
                                if (projectBaseDir != null) {
                                    Intrinsics.checkNotNull((Object)patches, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.openapi.diff.impl.patch.FilePatch>");
                                    List filePatches = TypeIntrinsics.asMutableList((Object)patches);
                                    PatchApplier patchApplier = new PatchApplier(project2, projectBaseDir, filePatches, null, null);
                                    try {
                                        patchApplier.execute(false, false);
                                    }
                                    catch (UnsupportedOperationException e) {
                                        RunNextStepOnDatasetActionKt.access$getLOG$p().warn("Failed to apply patch due to running in internal mode: " + e.getMessage());
                                        NotificationGroupManager.getInstance().getNotificationGroup("ijNext.notifications").createNotification("Patch application skipped", "Failed to apply patch due to running in internal mode. The dataset processing will continue without applying the patch.", NotificationType.WARNING).notify(project2);
                                    }
                                }
                            }
                        } else {
                            RunNextStepOnDatasetActionKt.access$getLOG$p().warn("No patch file found in scenario " + scenarioDir.getName());
                        }
                        if ((currentStepFile = new File(scenarioDir, "current_step.txt")).exists()) {
                            patches = new String[]{"read_chronicles.txt"};
                            Path targetFile = Paths.get(((Object)mockAgentDataDir).toString(), (String[])patches);
                            patches = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                            Files.copy(currentStepFile.toPath(), targetFile, (CopyOption[])patches);
                            indicator.setText2("Running calculations for scenario " + (scenarioIndex + 1) + "/" + scenarioDirs.length + ": " + scenarioDir.getName());
                            Intrinsics.checkNotNull((Object)scenarioDir);
                            ScenarioResult scenarioResult = this.runCalculations(project2, datasetDir, scenarioDir);
                            scenarioResults.add(scenarioResult);
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)changeListManager2.getAllChanges(), (String)"getAllChanges(...)");
                        if (!(!localChanges.isEmpty())) continue;
                        indicator.setText2("Reverting changes after scenario " + (scenarioIndex + 1) + "/" + scenarioDirs.length + ": " + scenarioDir.getName());
                        new RollbackWorker(project2).doRollback(localChanges, true);
                        continue;
                    }
                    catch (Exception e) {
                        Collection localChanges;
                        RunNextStepOnDatasetActionKt.access$getLOG$p().error("Error processing scenario " + scenarioDir.getName(), (Throwable)e);
                        NotificationGroupManager.getInstance().getNotificationGroup("ijNext.notifications").createNotification("Error processing scenario", "Error processing scenario " + scenarioDir.getName() + ": " + e.getMessage(), NotificationType.ERROR).notify(project2);
                        String string = e.getMessage();
                        if (string == null) {
                            string = "Unknown error";
                        }
                        List failures = CollectionsKt.listOf((Object)new AgentFailure("ScenarioProcessing", string));
                        String string2 = datasetDir.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        String string3 = scenarioDir.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                        ScenarioResult failedResult = new ScenarioResult(string2, string3, new ProcessingTiming(0L, 0L, null, 7, null), null, null, CollectionsKt.emptyList(), failures);
                        scenarioResults.add(failedResult);
                        Intrinsics.checkNotNullExpressionValue((Object)changeListManager2.getAllChanges(), (String)"getAllChanges(...)");
                        if (!(!localChanges.isEmpty())) continue;
                        new RollbackWorker(project2).doRollback(localChanges, true);
                    }
                }
            }
            catch (Throwable throwable) {
                List list = shelveChangesManager.getShelvedChangeLists();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getShelvedChangeLists(...)");
                List shelvedChangeLists = list;
                if (!((Collection)shelvedChangeLists).isEmpty()) {
                    ShelvedChangeList lastShelvedChangeList = (ShelvedChangeList)CollectionsKt.first((List)shelvedChangeLists);
                    shelveChangesManager.unshelveChangeList(lastShelvedChangeList, null, null, null, false);
                }
                throw throwable;
            }
        }
        List list = shelveChangesManager.getShelvedChangeLists();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getShelvedChangeLists(...)");
        List shelvedChangeLists = list;
        if (!((Collection)shelvedChangeLists).isEmpty()) {
            ShelvedChangeList lastShelvedChangeList = (ShelvedChangeList)CollectionsKt.first((List)shelvedChangeLists);
            shelveChangesManager.unshelveChangeList(lastShelvedChangeList, null, null, null, false);
        }
        return scenarioResults;
    }

    /*
     * WARNING - void declaration
     */
    private final ScenarioResult runCalculations(Project project2, File datasetDir, File scenarioDir) {
        File outputTempDir = new File(scenarioDir, RunNextStepOnDatasetActionKt.access$getOutputFolderName$p());
        if (!outputTempDir.exists()) {
            outputTempDir.mkdirs();
        }
        List failures = new ArrayList();
        Ref.ObjectRef chroniclesResult = new Ref.ObjectRef();
        Ref.ObjectRef intentResult = new Ref.ObjectRef();
        List verificationResults = new ArrayList();
        List verifiedFeatureIds = new ArrayList();
        Ref.LongRef chroniclesAgentTime = new Ref.LongRef();
        Ref.LongRef intentClassificationTime = new Ref.LongRef();
        List verificationTimes = new ArrayList();
        Ref.LongRef verificationStageStartNs = new Ref.LongRef();
        verificationStageStartNs.element = -1L;
        CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project2, chroniclesAgentTime, (Ref.ObjectRef<CurrentStateChroniclesAgent.CurrentStateChroniclesResult>)chroniclesResult, outputTempDir, (List<AgentFailure>)failures, (Ref.ObjectRef<AgentResultWithLog<IntentClassificationAgent.IntentClassificationAgentResult>>)intentResult, intentClassificationTime, verificationStageStartNs, (List<AgentResultWithLog<IntentVerificationAgent.IntentVerificationAgentResult>>)verificationResults, (List<Long>)verificationTimes, (List<String>)verifiedFeatureIds, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            long J$0;
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ Ref.LongRef $chroniclesAgentTime;
            final /* synthetic */ Ref.ObjectRef<CurrentStateChroniclesAgent.CurrentStateChroniclesResult> $chroniclesResult;
            final /* synthetic */ File $outputTempDir;
            final /* synthetic */ List<AgentFailure> $failures;
            final /* synthetic */ Ref.ObjectRef<AgentResultWithLog<IntentClassificationAgent.IntentClassificationAgentResult>> $intentResult;
            final /* synthetic */ Ref.LongRef $intentClassificationTime;
            final /* synthetic */ Ref.LongRef $verificationStageStartNs;
            final /* synthetic */ List<AgentResultWithLog<IntentVerificationAgent.IntentVerificationAgentResult>> $verificationResults;
            final /* synthetic */ List<Long> $verificationTimes;
            final /* synthetic */ List<String> $verifiedFeatureIds;
            {
                this.$project = $project;
                this.$chroniclesAgentTime = $chroniclesAgentTime;
                this.$chroniclesResult = $chroniclesResult;
                this.$outputTempDir = $outputTempDir;
                this.$failures = $failures;
                this.$intentResult = $intentResult;
                this.$intentClassificationTime = $intentClassificationTime;
                this.$verificationStageStartNs = $verificationStageStartNs;
                this.$verificationResults = $verificationResults;
                this.$verificationTimes = $verificationTimes;
                this.$verifiedFeatureIds = $verifiedFeatureIds;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        chroniclesAgent = new CurrentStateChroniclesAgent(this.$project);
                        chroniclesStartTime = System.currentTimeMillis();
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)chroniclesAgent);
                        this.J$0 = chroniclesStartTime;
                        this.label = 1;
                        v0 = chroniclesAgent.run((Continuation<? super CurrentStateChroniclesAgent.CurrentStateChroniclesResult>)((Continuation)this));
                        ** if (v0 != var11_2) goto lbl15
lbl14:
                        // 1 sources

                        return var11_2;
lbl15:
                        // 1 sources

                        ** GOTO lbl23
                    }
                    case 1: {
                        chroniclesStartTime = this.J$0;
                        chroniclesAgent = (CurrentStateChroniclesAgent)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl23:
                        // 2 sources

                        result = (CurrentStateChroniclesAgent.CurrentStateChroniclesResult)v0;
                        this.$chroniclesAgentTime.element = System.currentTimeMillis() - chroniclesStartTime;
                        this.$chroniclesResult.element = result;
                        if (result == null) ** GOTO lbl66
                        currentStepFile = new File(this.$outputTempDir, "current_step.txt");
                        FilesKt.writeText$default((File)currentStepFile, (String)result.toString(), null, (int)2, null);
                        $this$service$iv = (ComponentManager)this.$project;
                        $i$f$service = false;
                        serviceClass$iv = NextStepSuggestService.class;
                        v1 = $this$service$iv.getService(serviceClass$iv);
                        if (v1 == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        nextStepService = (NextStepSuggestService)v1;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)chroniclesAgent);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)result);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)currentStepFile);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)nextStepService);
                        this.J$0 = chroniclesStartTime;
                        this.label = 2;
                        v2 = nextStepService.calculateVerifiedNextStepsAsync$intellij_ml_llm_riderNext_latest(result).collect(new FlowCollector(this.$intentResult, this.$intentClassificationTime, chroniclesStartTime, this.$chroniclesAgentTime, this.$outputTempDir, this.$verificationStageStartNs, this.$verificationResults, this.$verificationTimes, this.$verifiedFeatureIds){
                            final /* synthetic */ Ref.ObjectRef<AgentResultWithLog<IntentClassificationAgent.IntentClassificationAgentResult>> $intentResult;
                            final /* synthetic */ Ref.LongRef $intentClassificationTime;
                            final /* synthetic */ long $chroniclesStartTime;
                            final /* synthetic */ Ref.LongRef $chroniclesAgentTime;
                            final /* synthetic */ File $outputTempDir;
                            final /* synthetic */ Ref.LongRef $verificationStageStartNs;
                            final /* synthetic */ List<AgentResultWithLog<IntentVerificationAgent.IntentVerificationAgentResult>> $verificationResults;
                            final /* synthetic */ List<Long> $verificationTimes;
                            final /* synthetic */ List<String> $verifiedFeatureIds;
                            {
                                this.$intentResult = $intentResult;
                                this.$intentClassificationTime = $intentClassificationTime;
                                this.$chroniclesStartTime = $chroniclesStartTime;
                                this.$chroniclesAgentTime = $chroniclesAgentTime;
                                this.$outputTempDir = $outputTempDir;
                                this.$verificationStageStartNs = $verificationStageStartNs;
                                this.$verificationResults = $verificationResults;
                                this.$verificationTimes = $verificationTimes;
                                this.$verifiedFeatureIds = $verifiedFeatureIds;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object emit(NextStepSuggestService.VerificationData data2, Continuation<? super Unit> $completion) {
                                Object featureIdFromData2;
                                if (data2.getIntentResult() != null) {
                                    this.$intentResult.element = data2.getIntentResult();
                                    this.$intentClassificationTime.element = System.currentTimeMillis() - this.$chroniclesStartTime - this.$chroniclesAgentTime.element;
                                    File nextStepRawFile = new File(this.$outputTempDir, "next_step_raw.txt");
                                    Object object = this.$intentResult.element;
                                    Intrinsics.checkNotNull((Object)object);
                                    IntentClassificationAgent.IntentClassificationAgentResult intentClassificationAgentResult = (IntentClassificationAgent.IntentClassificationAgentResult)((AgentResultWithLog)object).getResult();
                                    Object object2 = this.$intentResult.element;
                                    Intrinsics.checkNotNull((Object)object2);
                                    FilesKt.writeText$default((File)nextStepRawFile, (String)intentClassificationAgentResult.toString(((AgentResultWithLog)object2).getLog()), null, (int)2, null);
                                    if (this.$verificationStageStartNs.element < 0L) {
                                        this.$verificationStageStartNs.element = System.nanoTime();
                                    }
                                }
                                if (data2.getVerificationResult() != null) {
                                    long nowNs = System.nanoTime();
                                    if (this.$verificationStageStartNs.element < 0L) {
                                        this.$verificationStageStartNs.element = nowNs;
                                    }
                                    this.$verificationResults.add(data2.getVerificationResult());
                                    long elapsedMs = (nowNs - this.$verificationStageStartNs.element) / 1000000L;
                                    this.$verificationTimes.add(Boxing.boxLong((long)elapsedMs));
                                    this.$verificationStageStartNs.element = nowNs;
                                    File verificationDir = new File(this.$outputTempDir, "verification_results");
                                    if (!verificationDir.exists()) {
                                        verificationDir.mkdirs();
                                    }
                                    File verificationFile = new File(verificationDir, "verification_result_" + this.$verificationResults.size() + ".txt");
                                    FilesKt.writeText$default((File)verificationFile, (String)data2.getVerificationResult().getResult().toString(data2.getVerificationResult().getLog()), null, (int)2, null);
                                    if (data2.getVerificationResult().getResult().isVerified()) {
                                        featureIdFromData2 = data2.getSuggestionFeatureId();
                                        if (featureIdFromData2 != null) {
                                            this.$verifiedFeatureIds.add((String)featureIdFromData2);
                                        } else if (this.$intentResult.element != null) {
                                            int index = this.$verificationResults.size() - 1;
                                            Object object = this.$intentResult.element;
                                            Intrinsics.checkNotNull((Object)object);
                                            if (index < ((IntentClassificationAgent.IntentClassificationAgentResult)((AgentResultWithLog)object).getResult()).getFeatureSuggestions().size()) {
                                                Object object3 = this.$intentResult.element;
                                                Intrinsics.checkNotNull((Object)object3);
                                                String featureId = ((IntentClassificationAgent.IntentClassificationAgentResult)((AgentResultWithLog)object3).getResult()).getFeatureSuggestions().get(index).getFeatureId();
                                                this.$verifiedFeatureIds.add(featureId);
                                            }
                                        }
                                    }
                                }
                                if (data2.isComplete()) {
                                    CharSequence charSequence;
                                    Object object;
                                    File nextStepVerifiedFile;
                                    StringBuilder summaryContent = new StringBuilder();
                                    summaryContent.append("Verification Results Summary").append('\n');
                                    summaryContent.append("==========================").append('\n');
                                    summaryContent.append('\n');
                                    Iterable $this$forEachIndexed$iv = this.$verificationResults;
                                    boolean $i$f$forEachIndexed = false;
                                    int index$iv22 = 0;
                                    for (T item$iv : $this$forEachIndexed$iv) {
                                        void result2;
                                        int featureIdFromData2;
                                        if ((featureIdFromData2 = index$iv22++) < 0) {
                                            CollectionsKt.throwIndexOverflow();
                                        }
                                        AgentResultWithLog index = (AgentResultWithLog)item$iv;
                                        int index2 = featureIdFromData2;
                                        boolean bl = false;
                                        summaryContent.append("Verification Result " + (index2 + 1) + ":").append('\n');
                                        summaryContent.append("Verified: " + ((IntentVerificationAgent.IntentVerificationAgentResult)result2.getResult()).isVerified()).append('\n');
                                        summaryContent.append("Instructions: " + ((IntentVerificationAgent.IntentVerificationAgentResult)result2.getResult()).getSpecificInstructions()).append('\n');
                                        summaryContent.append("Parameters: " + ((IntentVerificationAgent.IntentVerificationAgentResult)result2.getResult()).getVerifiedParameters()).append('\n');
                                        summaryContent.append('\n');
                                    }
                                    File summaryFile2 = new File(this.$outputTempDir, "next_step_verified_summary.txt");
                                    String string = summaryContent.toString();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                                    FilesKt.writeText$default((File)summaryFile2, (String)string, null, (int)2, null);
                                    File file = nextStepVerifiedFile = new File(this.$outputTempDir, "next_step_verified_eval.txt");
                                    CharSequence index$iv22 = CollectionsKt.joinToString$default((Iterable)this.$verifiedFeatureIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                                    if (index$iv22.length() == 0) {
                                        object = file;
                                        boolean bl = false;
                                        charSequence = "None";
                                        file = object;
                                    } else {
                                        charSequence = index$iv22;
                                    }
                                    FilesKt.writeText$default((File)file, (String)((String)charSequence), null, (int)2, null);
                                    if (this.$intentResult.element != null) {
                                        CharSequence charSequence2;
                                        void $this$mapTo$iv$iv;
                                        Object object4 = this.$intentResult.element;
                                        Intrinsics.checkNotNull((Object)object4);
                                        Iterable $this$map$iv = ((IntentClassificationAgent.IntentClassificationAgentResult)((AgentResultWithLog)object4).getResult()).getFeatureSuggestions();
                                        boolean $i$f$map = false;
                                        featureIdFromData2 = $this$map$iv;
                                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                        boolean $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            void it;
                                            IntentClassificationAgent.IntentClassificationFeatureSuggestion intentClassificationFeatureSuggestion = (IntentClassificationAgent.IntentClassificationFeatureSuggestion)item$iv$iv;
                                            object = destination$iv$iv;
                                            boolean bl = false;
                                            object.add(it.getFeatureId());
                                        }
                                        List allFeatureIds = (List)destination$iv$iv;
                                        File nextStepRawEvalFile = new File(this.$outputTempDir, "next_step_raw_eval.txt");
                                        Object object5 = nextStepRawEvalFile;
                                        CharSequence charSequence3 = CollectionsKt.joinToString$default((Iterable)allFeatureIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                                        if (charSequence3.length() == 0) {
                                            object = object5;
                                            boolean bl = false;
                                            charSequence2 = "None";
                                            object5 = object;
                                        } else {
                                            charSequence2 = charSequence3;
                                        }
                                        FilesKt.writeText$default((File)object5, (String)((String)charSequence2), null, (int)2, null);
                                    }
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        ** if (v2 != var11_2) goto lbl45
lbl44:
                        // 1 sources

                        return var11_2;
lbl45:
                        // 1 sources

                        ** GOTO lbl66
                    }
                    case 2: {
                        chroniclesStartTime = this.J$0;
                        nextStepService = (NextStepSuggestService)this.L$3;
                        currentStepFile = (File)this.L$2;
                        result = (CurrentStateChroniclesAgent.CurrentStateChroniclesResult)this.L$1;
                        chroniclesAgent = (CurrentStateChroniclesAgent)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                        }
                        catch (Exception e) {
                            RunNextStepOnDatasetActionKt.access$getLOG$p().error("Error running chronicles agent", (Throwable)e);
                            v3 = e.getMessage();
                            if (v3 == null) {
                                v3 = "Unknown error";
                            }
                            this.$failures.add(new AgentFailure("ChroniclesAgent", v3));
                            if (this.$chroniclesAgentTime.element != 0L) ** GOTO lbl66
                            this.$chroniclesAgentTime.element = System.currentTimeMillis() - chroniclesStartTime;
                        }
lbl66:
                        // 5 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        try {
            List entries2 = new ArrayList();
            entries2.add("  \"CurrentStateChroniclesAgent\": " + chroniclesAgentTime.element);
            entries2.add("  \"IntentClassificationAgent\": " + intentClassificationTime.element);
            Iterable $this$forEachIndexed$iv = verificationTimes;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void t;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                long l2 = ((Number)item$iv).longValue();
                int index = n;
                boolean bl = false;
                entries2.add("  \"IntentVerificationAgent " + (index + 1) + "\": " + (long)t);
            }
            StringBuilder $this$runCalculations_u24lambda_u241 = $i$f$forEachIndexed = new StringBuilder();
            boolean bl = false;
            $this$runCalculations_u24lambda_u241.append("{\n");
            $this$runCalculations_u24lambda_u241.append(CollectionsKt.joinToString$default((Iterable)entries2, (CharSequence)",\n", null, null, (int)0, null, null, (int)62, null));
            $this$runCalculations_u24lambda_u241.append("\n}\n");
            String timeJson = $i$f$forEachIndexed.toString();
            File nextStepTimeFile = new File(outputTempDir, "next_step_time.txt");
            FilesKt.writeText$default((File)nextStepTimeFile, (String)timeJson, null, (int)2, null);
        }
        catch (Exception e) {
            RunNextStepOnDatasetActionKt.access$getLOG$p().warn("Failed to write next_step_time.txt: " + e.getMessage());
        }
        String string = datasetDir.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = scenarioDir.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return new ScenarioResult(string, string2, new ProcessingTiming(chroniclesAgentTime.element, intentClassificationTime.element, verificationTimes), (CurrentStateChroniclesAgent.CurrentStateChroniclesResult)chroniclesResult.element, (AgentResultWithLog)intentResult.element, verificationResults, failures);
    }

    private static final boolean detectFolderType$lambda$0(File file) {
        return file.isDirectory();
    }

    private static final boolean processDatasets$lambda$0(File file) {
        return file.isDirectory();
    }

    private static final boolean processDataset$lambda$0(File file) {
        return file.isDirectory();
    }

    public static final /* synthetic */ Object access$processDatasets(RunNextStepOnDatasetAction $this, Project project2, File datasetFolder, ProgressIndicator indicator, Continuation $completion) {
        return $this.processDatasets(project2, datasetFolder, indicator, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$processSingleDataset(RunNextStepOnDatasetAction $this, Project project2, File datasetFolder, ProgressIndicator indicator, Continuation $completion) {
        return $this.processSingleDataset(project2, datasetFolder, indicator, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$processSingleScenario(RunNextStepOnDatasetAction $this, Project project2, File scenarioFolder, ProgressIndicator indicator, Continuation $completion) {
        return $this.processSingleScenario(project2, scenarioFolder, indicator, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$displaySummaryTable(RunNextStepOnDatasetAction $this, Project project2, String summaryTable, Continuation $completion) {
        return $this.displaySummaryTable(project2, summaryTable, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FolderType.values().length];
            try {
                nArray[FolderType.DATA_FOLDER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FolderType.DATASET_FOLDER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FolderType.SCENARIO_FOLDER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

