/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.frozen.recap.lvcs;

import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.lvcs.GetDiffKt;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.lvcs.RecapLVCSChange;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.lvcs.RecapLVCSChunk;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.lvcs.RecapLVCSTimestamp;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.vcs.RecapLatestCommits;
import com.intellij.ml.llm.tokenizer.Tokenizer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a@\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a8\u0006\u0011"}, d2={"getChangesDiffs", "Ljava/util/ArrayList;", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/lvcs/RecapLVCSChunk;", "Lkotlin/collections/ArrayList;", "changesNewToLatest", "", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/lvcs/RecapLVCSChange;", "localHistoryImpl", "Lcom/intellij/history/integration/LocalHistoryImpl;", "tokenizer", "Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "latestCommits", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/vcs/RecapLatestCommits;", "isChangeEarlierThanCommit", "", "change", "chunksAreEmpty", "intellij.ml.llm.riderNext.latest"})
public final class RecapLVCSDiffKt {
    private static final ArrayList<RecapLVCSChunk> getChangesDiffs(List<RecapLVCSChange> changesNewToLatest, LocalHistoryImpl localHistoryImpl, Tokenizer tokenizer, RecapLatestCommits latestCommits) {
        ArrayList<RecapLVCSChunk> chunks = new ArrayList<RecapLVCSChunk>();
        int currentLength = 0;
        for (RecapLVCSChange change : changesNewToLatest) {
            String str;
            StringBuilder chunk;
            if (Intrinsics.areEqual((Object)change.getChangeName(), (Object)"External change")) continue;
            String string = change.getChangeName();
            if ((string != null ? StringsKt.startsWith$default((String)string, (String)"Commit changes:", (boolean)false, (int)2, null) : false) || (chunk = GetDiffKt.getDiff(change, localHistoryImpl)) == null) continue;
            if (latestCommits != null && RecapLVCSDiffKt.isChangeEarlierThanCommit(latestCommits, change, chunks.isEmpty())) break;
            Intrinsics.checkNotNullExpressionValue((Object)chunk.toString(), (String)"toString(...)");
            int chunkLength = tokenizer.count(str);
            if (currentLength + chunkLength > 16000) break;
            chunks.add(new RecapLVCSChunk(str, new RecapLVCSTimestamp(change.getTimestamp())));
            currentLength += chunkLength;
        }
        return chunks;
    }

    private static final boolean isChangeEarlierThanCommit(RecapLatestCommits latestCommits, RecapLVCSChange change, boolean chunksAreEmpty) {
        if (latestCommits.getNoChangesAfterLatestCommit()) {
            if (latestCommits.getBeforeLatestCommit() == null) {
                return false;
            }
            if (change.getTimestamp() < latestCommits.getBeforeLatestCommit().getTimestamp()) {
                return !chunksAreEmpty;
            }
            return false;
        }
        if (change.getTimestamp() < latestCommits.getLatestCommit().getTimestamp()) {
            if (chunksAreEmpty) {
                latestCommits.setNoChangesAfterLatestCommit(true);
                return false;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ ArrayList access$getChangesDiffs(List changesNewToLatest, LocalHistoryImpl localHistoryImpl, Tokenizer tokenizer, RecapLatestCommits latestCommits) {
        return RecapLVCSDiffKt.getChangesDiffs(changesNewToLatest, localHistoryImpl, tokenizer, latestCommits);
    }
}

