/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.git.selfReview.agent.rulesCollection.manual.action;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0012\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\b\u0010\u0017\u001a\u00020\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u0010H\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u0006\u0010\u001c\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/agent/rulesCollection/manual/action/InlineSizer;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "panel", "Ljavax/swing/JPanel;", "leftPanel", "input", "Lcom/intellij/ui/components/JBTextArea;", "sendButton", "Lcom/intellij/ui/InplaceButton;", "statusIcon", "Lcom/intellij/ui/components/JBLabel;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljavax/swing/JPanel;Ljavax/swing/JPanel;Lcom/intellij/ui/components/JBTextArea;Lcom/intellij/ui/InplaceButton;Lcom/intellij/ui/components/JBLabel;)V", "hgap", "", "currentTotalWidth", "attach", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "computeContentWidth", "buttonWidth", "iconWidth", "applySizes", "totalWidth", "rows", "recalcSize", "intellij.ml.llm.riderNext.latest.git"})
@SourceDebugExtension(value={"SMAP\nInlineSizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineSizer.kt\ncom/intellij/ml/llm/riderNext/latest/git/selfReview/agent/rulesCollection/manual/action/InlineSizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class InlineSizer {
    @NotNull
    private final Editor editor;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final JPanel leftPanel;
    @NotNull
    private final JBTextArea input;
    @NotNull
    private final InplaceButton sendButton;
    @NotNull
    private final JBLabel statusIcon;
    private final int hgap;
    private int currentTotalWidth;

    public InlineSizer(@NotNull Editor editor2, @NotNull JPanel panel2, @NotNull JPanel leftPanel, @NotNull JBTextArea input2, @NotNull InplaceButton sendButton, @NotNull JBLabel statusIcon) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)leftPanel, (String)"leftPanel");
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        Intrinsics.checkNotNullParameter((Object)sendButton, (String)"sendButton");
        Intrinsics.checkNotNullParameter((Object)statusIcon, (String)"statusIcon");
        this.editor = editor2;
        this.panel = panel2;
        this.leftPanel = leftPanel;
        this.input = input2;
        this.sendButton = sendButton;
        this.statusIcon = statusIcon;
        this.hgap = JBUI.scale((int)6);
    }

    public final void attach(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        this.input.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ InlineSizer this$0;
            {
                this.this$0 = $receiver;
            }

            public void insertUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.recalcSize();
            }

            public void removeUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.recalcSize();
            }

            public void changedUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.recalcSize();
            }
        });
        this.editor.getScrollingModel().addVisibleAreaListener(arg_0 -> InlineSizer.attach$lambda$0(this, arg_0), (Disposable)inlay);
        this.recalcSize();
    }

    private final int computeContentWidth() {
        return this.editor.getScrollingModel().getVisibleArea().width;
    }

    private final int buttonWidth() {
        Icon icon2 = this.sendButton.getIcon();
        int iconW = icon2 != null ? icon2.getIconWidth() : this.sendButton.getPreferredSize().width;
        return this.sendButton.isVisible() ? iconW + JBUI.scale((int)8) : 0;
    }

    private final int iconWidth() {
        return this.statusIcon.getPreferredSize().width;
    }

    private final void applySizes(int totalWidth, int rows) {
        Insets pInsets = this.leftPanel.getInsets();
        int desiredBtnW = this.buttonWidth();
        int desiredIconW = this.iconWidth();
        int centerW = Math.max(50, totalWidth - pInsets.left - pInsets.right - desiredBtnW - desiredIconW - this.hgap * 2);
        FontMetrics fm = this.input.getFontMetrics(this.input.getFont());
        int lineH = fm.getHeight();
        int tfH = rows * lineH + this.input.getInsets().top + this.input.getInsets().bottom;
        this.sendButton.setPreferredSize(new Dimension(desiredBtnW, tfH));
        this.statusIcon.setPreferredSize(new Dimension(desiredIconW, tfH));
        this.input.setPreferredSize(new Dimension(centerW, tfH));
        this.leftPanel.setPreferredSize(new Dimension(totalWidth, tfH + pInsets.top + pInsets.bottom));
        Insets outerInsets = this.panel.getInsets();
        this.panel.setPreferredSize(new Dimension(this.computeContentWidth(), tfH + outerInsets.top + outerInsets.bottom));
        this.panel.revalidate();
        this.panel.repaint();
    }

    /*
     * WARNING - void declaration
     */
    public final void recalcSize() {
        int n;
        int explicitLines;
        int longest;
        int viewportW = this.computeContentWidth();
        int minTotal = (int)((double)viewportW * 0.7);
        int maxTotal = viewportW;
        if (this.currentTotalWidth == 0) {
            this.currentTotalWidth = minTotal;
        }
        if (this.currentTotalWidth > maxTotal) {
            this.currentTotalWidth = maxTotal;
        }
        Insets pInsets = this.leftPanel.getInsets();
        int desiredBtnW = this.buttonWidth();
        int desiredIconW = this.iconWidth();
        int centerW = 0;
        centerW = Math.max(50, this.currentTotalWidth - pInsets.left - pInsets.right - desiredBtnW - desiredIconW - this.hgap * 2);
        FontMetrics fm = this.input.getFontMetrics(this.input.getFont());
        String text2 = this.input.getText();
        Intrinsics.checkNotNull((Object)text2);
        if (((CharSequence)text2).length() == 0) {
            v0 = 0;
        } else {
            char[] cArray = new char[]{'\n'};
            Iterator iterator = ((Iterable)StringsKt.split$default((CharSequence)text2, (char[])cArray, (boolean)false, (int)0, (int)6, null)).iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            String it = (String)iterator.next();
            boolean bl = false;
            int n2 = fm.stringWidth(it);
            while (iterator.hasNext()) {
                String it232 = (String)iterator.next();
                boolean bl2 = false;
                int it232 = fm.stringWidth(it232);
                if (n2 >= it232) continue;
                n2 = it232;
            }
            v0 = longest = n2;
        }
        if (longest > centerW && this.currentTotalWidth < maxTotal) {
            int neededCenter = longest;
            int neededTotal = neededCenter + pInsets.left + pInsets.right + desiredBtnW + desiredIconW + this.hgap * 2;
            this.currentTotalWidth = Math.min(maxTotal, Math.max(this.currentTotalWidth, neededTotal));
            centerW = Math.max(50, this.currentTotalWidth - pInsets.left - pInsets.right - desiredBtnW - desiredIconW - this.hgap * 2);
        }
        if (((CharSequence)text2).length() == 0) {
            v1 = 1;
        } else {
            char[] neededTotal = new char[]{'\n'};
            v1 = explicitLines = StringsKt.split$default((CharSequence)text2, (char[])neededTotal, (boolean)false, (int)0, (int)6, null).size();
        }
        if (this.currentTotalWidth < maxTotal) {
            n = explicitLines;
        } else {
            int needed;
            int n2;
            InlineSizer $this$recalcSize_u24lambda_u241 = this;
            boolean bl = false;
            int perLine = centerW <= 0 ? 1 : centerW;
            if (((CharSequence)text2).length() == 0) {
                n2 = 1;
            } else {
                Object object = new char[]{'\n'};
                object = StringsKt.split$default((CharSequence)text2, (char[])object, (boolean)false, (int)0, (int)6, null);
                int n4 = 0;
                for (Object t : object) {
                    void line;
                    String string = (String)t;
                    int n5 = n4;
                    boolean bl2 = false;
                    int w = fm.stringWidth((String)line);
                    int n6 = w <= 0 ? 1 : Math.max(1, (int)Math.ceil((double)w / (double)perLine));
                    n4 = n5 + n6;
                }
                n2 = n4;
            }
            n = needed = RangesKt.coerceAtLeast((int)n2, (int)1);
        }
        int reqRows = n;
        this.applySizes(this.currentTotalWidth, reqRows);
    }

    private static final void attach$lambda$0(InlineSizer this$0, VisibleAreaEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.recalcSize();
    }
}

