/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.rider.insight;

import com.intellij.ml.llm.riderNext.latest.frozen.insight.AIInsightService;
import com.intellij.ml.llm.riderNext.latest.rider.insight.AIInsightFromHighlighter;
import com.intellij.ml.llm.riderNext.latest.rider.insight.AiInsightHighlighterModelHandlerKt;
import com.intellij.ml.llm.riderNext.latest.rider.insight.annotator.RiderAnnotatorInsight;
import com.intellij.ml.llm.riderNext.latest.rider.insight.commentChangeSuggestion.CommentChangeSuggestionInsight;
import com.intellij.ml.llm.riderNext.latest.rider.insight.regexExample.RegexExampleInsight;
import com.intellij.ml.llm.riderNext.latest.rider.insight.renameSuggestion.RenameSuggestionInsight;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rider.model.AnnotatorHighlighterModel;
import com.jetbrains.rider.model.CommentChangeSuggestionHighlighterModel;
import com.jetbrains.rider.model.InsightsHighlighterModel;
import com.jetbrains.rider.model.RegexExampleHighlighterModel;
import com.jetbrains.rider.model.RenameSuggestionHighlighterModel;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u001b\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001dH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/rider/insight/AIInsightHighlighterContainer;", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/impl/EditorImpl;Lkotlinx/coroutines/CoroutineScope;)V", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "insights", "", "", "Lcom/intellij/ml/llm/riderNext/latest/rider/insight/AIInsightFromHighlighter;", "afterAdded", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "createInsightFromHighlighterModel", "model", "Lcom/jetbrains/rider/model/InsightsHighlighterModel;", "afterUpdated", "beforeRemoved", "beforeBulkRemove", "highlighters", "", "intellij.ml.llm.riderNext.latest.rider"})
@SourceDebugExtension(value={"SMAP\nAIInsightHighlighterContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIInsightHighlighterContainer.kt\ncom/intellij/ml/llm/riderNext/latest/rider/insight/AIInsightHighlighterContainer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1#2:105\n13#3:106\n1869#4,2:107\n*S KotlinDebug\n*F\n+ 1 AIInsightHighlighterContainer.kt\ncom/intellij/ml/llm/riderNext/latest/rider/insight/AIInsightHighlighterContainer\n*L\n60#1:106\n30#1:107,2\n*E\n"})
public final class AIInsightHighlighterContainer
implements FrontendMarkupAdapterListener {
    @NotNull
    private final Project project;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Map<Long, AIInsightFromHighlighter> insights;

    public AIInsightHighlighterContainer(@NotNull Lifetime lifetime, @NotNull Project project2, @NotNull EditorImpl editor2, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project2;
        this.editor = editor2;
        this.scope = scope;
        this.insights = new LinkedHashMap();
        lifetime.onTermination(() -> AIInsightHighlighterContainer._init_$lambda$0(this));
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        InsightsHighlighterModel insightsHighlighterModel = (InsightsHighlighterModel)AiInsightHighlighterModelHandlerKt.getAiInsightHighlighterKey().get((UserDataHolder)highlighter);
        if (insightsHighlighterModel == null) {
            return;
        }
        InsightsHighlighterModel model = insightsHighlighterModel;
        AIInsightFromHighlighter aIInsightFromHighlighter = this.createInsightFromHighlighterModel(model, highlighter);
        if (aIInsightFromHighlighter == null) {
            return;
        }
        AIInsightFromHighlighter insight = aIInsightFromHighlighter;
        Map<Long, AIInsightFromHighlighter> map2 = this.insights;
        synchronized (map2) {
            Unit unit;
            boolean bl = false;
            AIInsightFromHighlighter aIInsightFromHighlighter2 = this.insights.put(model.getId(), insight);
            if (aIInsightFromHighlighter2 != null) {
                AIInsightFromHighlighter it = aIInsightFromHighlighter2;
                boolean bl2 = false;
                Disposer.dispose((Disposable)it);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        AIInsightService.Companion.getInstance(this.project).addOrUpdate(insight);
    }

    private final AIInsightFromHighlighter createInsightFromHighlighterModel(InsightsHighlighterModel model, RangeHighlighterEx highlighter) {
        AIInsightFromHighlighter aIInsightFromHighlighter;
        InsightsHighlighterModel insightsHighlighterModel = model;
        if (insightsHighlighterModel instanceof AnnotatorHighlighterModel) {
            aIInsightFromHighlighter = new RiderAnnotatorInsight(model.getInsightId(), (RangeMarker)highlighter, this.editor, this.scope);
        } else if (insightsHighlighterModel instanceof RenameSuggestionHighlighterModel) {
            aIInsightFromHighlighter = new RenameSuggestionInsight(((RenameSuggestionHighlighterModel)model).getOldName(), ((RenameSuggestionHighlighterModel)model).getNewName(), model.getId(), model.getInsightId(), (RangeMarker)highlighter, this.editor);
        } else if (insightsHighlighterModel instanceof CommentChangeSuggestionHighlighterModel) {
            aIInsightFromHighlighter = new CommentChangeSuggestionInsight(Intrinsics.areEqual((Object)((CommentChangeSuggestionHighlighterModel)model).getNewText(), (Object)"") ? null : ((CommentChangeSuggestionHighlighterModel)model).getNewText(), model.getInsightId(), (RangeMarker)highlighter, this.editor);
        } else if (insightsHighlighterModel instanceof RegexExampleHighlighterModel) {
            aIInsightFromHighlighter = new RegexExampleInsight((RegexExampleHighlighterModel)model, model.getInsightId(), (RangeMarker)highlighter, this.editor);
        } else {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(AIInsightHighlighterContainer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unknown model: " + model.getClass().getName());
            aIInsightFromHighlighter = null;
        }
        return aIInsightFromHighlighter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterUpdated(@NotNull RangeHighlighterEx highlighter) {
        AIInsightFromHighlighter aIInsightFromHighlighter;
        Object object;
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        InsightsHighlighterModel insightsHighlighterModel = (InsightsHighlighterModel)AiInsightHighlighterModelHandlerKt.getAiInsightHighlighterKey().get((UserDataHolder)highlighter);
        if (insightsHighlighterModel == null) {
            return;
        }
        InsightsHighlighterModel model = insightsHighlighterModel;
        Map<Long, AIInsightFromHighlighter> map2 = this.insights;
        synchronized (map2) {
            boolean bl = false;
            object = this.insights.get(model.getId());
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var6_3
            aIInsightFromHighlighter = object;
        }
        if (aIInsightFromHighlighter == null) {
            return;
        }
        AIInsightFromHighlighter insight = aIInsightFromHighlighter;
        AIInsightService insightService = AIInsightService.Companion.getInstance(this.project);
        if (!Intrinsics.areEqual((Object)insight.getBackendId(), (Object)model.getInsightId())) {
            AIInsightFromHighlighter aIInsightFromHighlighter2 = this.createInsightFromHighlighterModel(model, highlighter);
            if (aIInsightFromHighlighter2 == null) {
                return;
            }
            AIInsightFromHighlighter insight2 = aIInsightFromHighlighter2;
            object = this.insights;
            synchronized (object) {
                Unit unit;
                boolean bl = false;
                AIInsightFromHighlighter aIInsightFromHighlighter3 = this.insights.put(model.getId(), insight2);
                if (aIInsightFromHighlighter3 != null) {
                    AIInsightFromHighlighter it = aIInsightFromHighlighter3;
                    boolean bl2 = false;
                    Disposer.dispose((Disposable)it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
            insightService.addOrUpdate(insight2);
        } else {
            insightService.addOrUpdate(insight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
        AIInsightFromHighlighter aIInsightFromHighlighter;
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        InsightsHighlighterModel insightsHighlighterModel = (InsightsHighlighterModel)AiInsightHighlighterModelHandlerKt.getAiInsightHighlighterKey().get((UserDataHolder)highlighter);
        if (insightsHighlighterModel == null) {
            return;
        }
        InsightsHighlighterModel model = insightsHighlighterModel;
        Map<Long, AIInsightFromHighlighter> map2 = this.insights;
        synchronized (map2) {
            boolean bl = false;
            aIInsightFromHighlighter = this.insights.remove(model.getId());
        }
        AIInsightFromHighlighter insight = aIInsightFromHighlighter;
        if (insight != null) {
            Disposer.dispose((Disposable)insight);
        }
    }

    public void beforeBulkRemove(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        for (RangeHighlighterEx rangeHighlighterEx : highlighters) {
            this.beforeRemoved(rangeHighlighterEx);
        }
    }

    private static final Unit _init_$lambda$0(AIInsightHighlighterContainer this$0) {
        Iterable $this$forEach$iv = this$0.insights.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AIInsightFromHighlighter it = (AIInsightFromHighlighter)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        return Unit.INSTANCE;
    }
}

