/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rust.context;

import com.intellij.ml.llm.core.chat.context.traverser.ChatAttachmentWithSourcePosition;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.rust.context.RsCodeDependencyCollectorKt;
import com.intellij.ml.llm.rust.privacy.RsReferenceElementBasePrivacyWrapperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsReferenceElement;
import org.rust.lang.core.psi.ext.RsReferenceElementBase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/rust/context/ReferenceAndTarget;", "", "referenceElement", "Lorg/rust/lang/core/psi/ext/RsReferenceElement;", "targetElement", "Lorg/rust/lang/core/psi/ext/RsElement;", "<init>", "(Lorg/rust/lang/core/psi/ext/RsReferenceElement;Lorg/rust/lang/core/psi/ext/RsElement;)V", "getReferenceElement", "()Lorg/rust/lang/core/psi/ext/RsReferenceElement;", "getTargetElement", "()Lorg/rust/lang/core/psi/ext/RsElement;", "toAttachment", "Lcom/intellij/ml/llm/core/chat/context/traverser/ChatAttachmentWithSourcePosition;", "fromAttachment", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.rust"})
final class ReferenceAndTarget {
    @NotNull
    private final RsReferenceElement referenceElement;
    @NotNull
    private final RsElement targetElement;

    public ReferenceAndTarget(@NotNull RsReferenceElement referenceElement, @NotNull RsElement targetElement) {
        Intrinsics.checkNotNullParameter((Object)referenceElement, (String)"referenceElement");
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        this.referenceElement = referenceElement;
        this.targetElement = targetElement;
    }

    @NotNull
    public final RsReferenceElement getReferenceElement() {
        return this.referenceElement;
    }

    @NotNull
    public final RsElement getTargetElement() {
        return this.targetElement;
    }

    @NotNull
    public final ChatAttachmentWithSourcePosition toAttachment(@NotNull ChatAttachmentWithSourcePosition fromAttachment) {
        PSString pSString;
        Intrinsics.checkNotNullParameter((Object)fromAttachment, (String)"fromAttachment");
        PSString referenceName = RsReferenceElementBasePrivacyWrapperKt.getPrivacySafe((RsReferenceElementBase)this.referenceElement).getReferenceName();
        if (referenceName == null) {
            pSString = ConstantsKt.getEMPTY();
        } else {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{referenceName};
            pSString = ConstantsKt.getPrivacyConst((String)"`%s` declaration").format(pSStringConvertibleArray);
        }
        PSString name = pSString;
        return RsCodeDependencyCollectorKt.access$toAttachment(this.targetElement, RsCodeDependencyCollectorKt.access$locationComment(this.targetElement, this.referenceElement), fromAttachment, name);
    }

    @NotNull
    public final RsReferenceElement component1() {
        return this.referenceElement;
    }

    @NotNull
    public final RsElement component2() {
        return this.targetElement;
    }

    @NotNull
    public final ReferenceAndTarget copy(@NotNull RsReferenceElement referenceElement, @NotNull RsElement targetElement) {
        Intrinsics.checkNotNullParameter((Object)referenceElement, (String)"referenceElement");
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        return new ReferenceAndTarget(referenceElement, targetElement);
    }

    public static /* synthetic */ ReferenceAndTarget copy$default(ReferenceAndTarget referenceAndTarget, RsReferenceElement rsReferenceElement, RsElement rsElement, int n, Object object) {
        if ((n & 1) != 0) {
            rsReferenceElement = referenceAndTarget.referenceElement;
        }
        if ((n & 2) != 0) {
            rsElement = referenceAndTarget.targetElement;
        }
        return referenceAndTarget.copy(rsReferenceElement, rsElement);
    }

    @NotNull
    public String toString() {
        return "ReferenceAndTarget(referenceElement=" + this.referenceElement + ", targetElement=" + this.targetElement + ")";
    }

    public int hashCode() {
        int result2 = this.referenceElement.hashCode();
        result2 = result2 * 31 + this.targetElement.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReferenceAndTarget)) {
            return false;
        }
        ReferenceAndTarget referenceAndTarget = (ReferenceAndTarget)other;
        if (!Intrinsics.areEqual((Object)this.referenceElement, (Object)referenceAndTarget.referenceElement)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.targetElement, (Object)referenceAndTarget.targetElement);
    }
}

