/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rust.fix.generate;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.rust.fix.generate.PromptGenerator;
import com.intellij.psi.PsiNamedElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/rust/fix/generate/AdtPromptGenerator;", "Lcom/intellij/ml/llm/rust/fix/generate/PromptGenerator;", "trait", "Lorg/rust/lang/core/psi/RsTraitItem;", "typeRef", "Lorg/rust/lang/core/psi/RsTypeReference;", "<init>", "(Lorg/rust/lang/core/psi/RsTraitItem;Lorg/rust/lang/core/psi/RsTypeReference;)V", "type", "Lorg/rust/lang/core/types/ty/TyAdt;", "createReferenceItemsText", "Lcom/intellij/ml/llm/privacy/PSString;", "createGuideline", "intellij.ml.llm.rust"})
final class AdtPromptGenerator
extends PromptGenerator {
    @NotNull
    private final TyAdt type;

    public AdtPromptGenerator(@NotNull RsTraitItem trait, @NotNull RsTypeReference typeRef) {
        Intrinsics.checkNotNullParameter((Object)trait, (String)"trait");
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        super(trait, typeRef);
        Ty ty = ExtensionsKt.getNormType((RsTypeReference)typeRef);
        Intrinsics.checkNotNull((Object)ty, (String)"null cannot be cast to non-null type org.rust.lang.core.types.ty.TyAdt");
        this.type = (TyAdt)ty;
    }

    @Override
    @NotNull
    protected PSString createReferenceItemsText() {
        PSString itemText = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)this.type.getItem()).getText();
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{itemText, super.createReferenceItemsText()};
        return ConstantsKt.getPrivacyConst((String)"```rust\n%s\n```\n%s").format(pSStringConvertibleArray);
    }

    @Override
    @NotNull
    protected PSString createGuideline() {
        return ConstantsKt.getPrivacyConst((String)"1. Provide the item declaration and impl block. Do not provide intermediate changes for the same code fragment.\n2. You MUST NOT write explanation, summarization or any other text or code snippets after the list of code updates.\n3. You MUST preserve the original program semantics/behavior.\n4. You MUST NOT generate unsafe code blocks.\n5. You MUST use any potential api calls that might be needed for the implementation if that would result in a more similar code style to the existing one.\n6. You can add needed properties to the item declaration.\n7. You MUST provide item declaration and impl block as a two separate code updates.");
    }
}

