/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rust.fix.generate;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.rust.fix.generate.AdtPromptGenerator;
import com.intellij.ml.llm.rust.fix.generate.AllTypePromptGenerator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.ext.RsTraitItemKt;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\"\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH$J\u0006\u0010\u000f\u001a\u00020\rJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/rust/fix/generate/PromptGenerator;", "", "trait", "Lorg/rust/lang/core/psi/RsTraitItem;", "typeRef", "Lorg/rust/lang/core/psi/RsTypeReference;", "<init>", "(Lorg/rust/lang/core/psi/RsTraitItem;Lorg/rust/lang/core/psi/RsTypeReference;)V", "getTrait", "()Lorg/rust/lang/core/psi/RsTraitItem;", "getTypeRef", "()Lorg/rust/lang/core/psi/RsTypeReference;", "createReferenceItemsText", "Lcom/intellij/ml/llm/privacy/PSString;", "createGuideline", "createPrompt", "findOtherKnownImplementations", "Companion", "intellij.ml.llm.rust"})
@SourceDebugExtension(value={"SMAP\nRsGenerateTraitItemsFixIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsGenerateTraitItemsFixIntention.kt\ncom/intellij/ml/llm/rust/fix/generate/PromptGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n774#2:232\n865#2,2:233\n1563#2:235\n1634#2,3:236\n*S KotlinDebug\n*F\n+ 1 RsGenerateTraitItemsFixIntention.kt\ncom/intellij/ml/llm/rust/fix/generate/PromptGenerator\n*L\n149#1:232\n149#1:233,2\n150#1:235\n150#1:236,3\n*E\n"})
abstract class PromptGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RsTraitItem trait;
    @NotNull
    private final RsTypeReference typeRef;

    public PromptGenerator(@NotNull RsTraitItem trait, @NotNull RsTypeReference typeRef) {
        Intrinsics.checkNotNullParameter((Object)trait, (String)"trait");
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        this.trait = trait;
        this.typeRef = typeRef;
    }

    @NotNull
    protected final RsTraitItem getTrait() {
        return this.trait;
    }

    @NotNull
    protected final RsTypeReference getTypeRef() {
        return this.typeRef;
    }

    @NotNull
    protected PSString createReferenceItemsText() {
        PSString traitText = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)this.trait).getText();
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{traitText};
        return ConstantsKt.getPrivacyConst((String)"```rust\n%s\n```").format(pSStringConvertibleArray);
    }

    @NotNull
    protected abstract PSString createGuideline();

    @NotNull
    public final PSString createPrompt() {
        PSString traitName = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)this.trait).getName();
        PSString itemName = ExtensionsKtKt.getPrivacySafe((PsiElement)this.typeRef).getText();
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{traitName, itemName, this.createReferenceItemsText(), this.findOtherKnownImplementations(this.trait), this.createGuideline()};
        return ConstantsKt.getPrivacyConst((String)"Implement the trait `%s` for the item `%s`.\n\n%s\n\nOther known implementations:%s\n\n*Guideline:*\n%s").format(pSStringConvertibleArray);
    }

    /*
     * WARNING - void declaration
     */
    private final PSString findOtherKnownImplementations(RsTraitItem trait) {
        void $this$mapTo$iv$iv;
        RsImplItem it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)RsTraitItemKt.searchForImplementations((RsTraitItem)trait);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (RsImplItem)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getTypeReference(), (Object)this.typeRef))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PSString pSString;
            Ty type2;
            it = (RsImplItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PSString implText = ExtensionsKtKt.getPrivacySafe((PsiElement)it).getText();
            RsTypeReference rsTypeReference = it.getTypeReference();
            Object object = type2 = rsTypeReference != null ? ExtensionsKt.getNormType((RsTypeReference)rsTypeReference) : null;
            if (type2 instanceof TyAdt) {
                PSString itemText = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)((TyAdt)type2).getItem()).getText();
                PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{itemText, implText};
                pSString = ConstantsKt.getPrivacyConst((String)"\n```rust\n%s\n```\n```rust\n%s\n```").format(pSStringConvertibleArray);
            } else {
                PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{implText};
                pSString = ConstantsKt.getPrivacyConst((String)"\n```rust\n%s\n```").format(pSStringConvertibleArray);
            }
            collection.add(pSString);
        }
        return PSStringKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, (int)31, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/rust/fix/generate/PromptGenerator$Companion;", "", "<init>", "()V", "getGenerator", "Lcom/intellij/ml/llm/rust/fix/generate/PromptGenerator;", "trait", "Lorg/rust/lang/core/psi/RsTraitItem;", "typeRef", "Lorg/rust/lang/core/psi/RsTypeReference;", "intellij.ml.llm.rust"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PromptGenerator getGenerator(@NotNull RsTraitItem trait, @NotNull RsTypeReference typeRef) {
            Intrinsics.checkNotNullParameter((Object)trait, (String)"trait");
            Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
            return ExtensionsKt.getNormType((RsTypeReference)typeRef) instanceof TyAdt ? (PromptGenerator)new AdtPromptGenerator(trait, typeRef) : (PromptGenerator)new AllTypePromptGenerator(trait, typeRef);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

