/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff;

import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.ml.llm.vcs.diff.groupedDiff.ChangesGroup;
import com.intellij.ml.llm.vcs.diff.groupedDiff.GroupedDiffRequest;
import com.intellij.ml.llm.vcs.diff.groupedDiff.GroupedLineStatusTracker;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.GroupedDiffData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.DiffTitleWithDetailsCustomizers;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\r\u0010 \u001a\u00070!\u00a2\u0006\u0002\b\"H\u0016J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/GroupedDiffRequestProducer;", "Lcom/intellij/diff/chains/DiffRequestProducer;", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "currentGroup", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/ChangesGroup;", "data", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupedDiffData;", "<init>", "(Lcom/intellij/openapi/vcs/changes/Change;Lcom/intellij/ml/llm/vcs/diff/groupedDiff/ChangesGroup;Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupedDiffData;)V", "getChange", "()Lcom/intellij/openapi/vcs/changes/Change;", "getCurrentGroup", "()Lcom/intellij/ml/llm/vcs/diff/groupedDiff/ChangesGroup;", "getData", "()Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupedDiffData;", "createRequest", "Lcom/intellij/diff/requests/DiffRequest;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createTitleCustomizers", "", "Lcom/intellij/diff/DiffEditorTitleCustomizer;", "createSimpleRequest", "Lcom/intellij/diff/requests/SimpleDiffRequest;", "createGroupedDiffRequest", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/GroupedDiffRequest;", "request", "Lcom/intellij/diff/requests/ContentDiffRequest;", "getName", "", "Lorg/jetbrains/annotations/Nls;", "process", "getFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "Companion", "intellij.ml.llm.vcs.diff"})
public final class GroupedDiffRequestProducer
implements DiffRequestProducer,
ChangeDiffRequestChain.Producer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Change change;
    @NotNull
    private final ChangesGroup currentGroup;
    @NotNull
    private final GroupedDiffData data;
    @NotNull
    private static final Logger LOG;

    public GroupedDiffRequestProducer(@NotNull Change change, @NotNull ChangesGroup currentGroup, @NotNull GroupedDiffData data2) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter((Object)currentGroup, (String)"currentGroup");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.change = change;
        this.currentGroup = currentGroup;
        this.data = data2;
    }

    @NotNull
    public final Change getChange() {
        return this.change;
    }

    @NotNull
    public final ChangesGroup getCurrentGroup() {
        return this.currentGroup;
    }

    @NotNull
    public final GroupedDiffData getData() {
        return this.data;
    }

    private final DiffRequest createRequest(UserDataHolder context2, ProgressIndicator indicator) {
        SimpleDiffRequest request2 = this.createSimpleRequest(context2, indicator);
        DiffUtil.addTitleCustomizers((DiffRequest)((DiffRequest)request2), this.createTitleCustomizers());
        DiffRequest localRequest = this.createGroupedDiffRequest((ContentDiffRequest)request2);
        if (localRequest != null) {
            return localRequest;
        }
        return (DiffRequest)request2;
    }

    private final List<DiffEditorTitleCustomizer> createTitleCustomizers() {
        return DiffTitleWithDetailsCustomizers.getTitleCustomizers((Project)this.data.getProject(), (Change)this.change, null, null);
    }

    private final SimpleDiffRequest createSimpleRequest(UserDataHolder context2, ProgressIndicator indicator) {
        ContentRevision bRev = this.change.getBeforeRevision();
        ContentRevision aRev = this.change.getAfterRevision();
        if (bRev == null && aRev == null) {
            LOG.warn("Both revision contents are empty");
            throw new DiffRequestProducerException(DiffBundle.message((String)"error.cant.show.diff.content.not.found", (Object[])new Object[0]));
        }
        if (bRev != null) {
            ChangeDiffRequestProducer.checkContentRevision((Project)this.data.getProject(), (ContentRevision)bRev, (UserDataHolder)context2, (ProgressIndicator)indicator);
        }
        if (aRev != null) {
            ChangeDiffRequestProducer.checkContentRevision((Project)this.data.getProject(), (ContentRevision)aRev, (UserDataHolder)context2, (ProgressIndicator)indicator);
        }
        Object editorTabTitle = null;
        String string = ChangeDiffRequestProducer.getRequestTitle((Change)this.change);
        Intrinsics.checkNotNull((Object)string);
        String title = string;
        indicator.setIndeterminate(true);
        DiffContent diffContent = ChangeDiffRequestProducer.createContent((Project)this.data.getProject(), (ContentRevision)bRev, (UserDataHolder)context2, (ProgressIndicator)indicator);
        Intrinsics.checkNotNullExpressionValue((Object)diffContent, (String)"createContent(...)");
        DiffContent content1 = diffContent;
        DiffContent diffContent2 = ChangeDiffRequestProducer.createContent((Project)this.data.getProject(), (ContentRevision)aRev, (UserDataHolder)context2, (ProgressIndicator)indicator);
        Intrinsics.checkNotNullExpressionValue((Object)diffContent2, (String)"createContent(...)");
        DiffContent content2 = diffContent2;
        Object userLeftRevisionTitle = null;
        String string2 = ChangeDiffRequestProducer.getRevisionTitle((ContentRevision)bRev, (String)ChangeDiffRequestProducer.getBaseVersion());
        Intrinsics.checkNotNull((Object)string2);
        String beforeRevisionTitle = string2;
        Object userRightRevisionTitle = null;
        String string3 = ChangeDiffRequestProducer.getRevisionTitle((ContentRevision)aRev, (String)ChangeDiffRequestProducer.getYourVersion());
        Intrinsics.checkNotNull((Object)string3);
        String afterRevisionTitle = string3;
        SimpleDiffRequest request2 = new SimpleDiffRequest(title, content1, content2, beforeRevisionTitle, afterRevisionTitle);
        boolean bRevCurrent = bRev instanceof CurrentContentRevision;
        boolean aRevCurrent = aRev instanceof CurrentContentRevision;
        if (bRevCurrent && !aRevCurrent) {
            request2.putUserData(DiffUserDataKeys.MASTER_SIDE, (Object)Side.LEFT);
        }
        if (!bRevCurrent && aRevCurrent) {
            request2.putUserData(DiffUserDataKeys.MASTER_SIDE, (Object)Side.RIGHT);
        }
        return request2;
    }

    private final GroupedDiffRequest createGroupedDiffRequest(ContentDiffRequest request2) {
        DocumentContent content2;
        List list = request2.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
        List contents = list;
        if (contents.size() != 2) {
            return null;
        }
        Object object = Side.LEFT.select(contents);
        DocumentContent content1 = object instanceof DocumentContent ? (DocumentContent)object : null;
        Object object2 = Side.RIGHT.select(contents);
        DocumentContent documentContent = content2 = object2 instanceof DocumentContent ? (DocumentContent)object2 : null;
        if (content1 == null || content2 == null) {
            return null;
        }
        return new GroupedDiffRequest(this.data.getProject(), String.valueOf(this.currentGroup.getId()), this.currentGroup.getName(), request2, new GroupedLineStatusTracker(this.change, this.data.getGroups()), this.data);
    }

    @NotNull
    public String getName() {
        String string = this.getFilePath().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        return this.createRequest(context2, indicator);
    }

    @NotNull
    public FilePath getFilePath() {
        FilePath filePath = ChangesUtil.getFilePath((Change)this.change);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        return filePath;
    }

    @NotNull
    public FileStatus getFileStatus() {
        FileStatus fileStatus = this.change.getFileStatus();
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getFileStatus(...)");
        return fileStatus;
    }

    static {
        Logger logger = Logger.getInstance(GroupedDiffRequestProducer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/GroupedDiffRequestProducer$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.ml.llm.vcs.diff"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

