/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff.commit.actions;

import com.intellij.ml.llm.vcs.diff.groupedDiff.LLMVcsDiffBundle;
import com.intellij.ml.llm.vcs.diff.groupedDiff.commit.AIDiffSettings;
import com.intellij.ml.llm.vcs.diff.groupedDiff.commit.AIDiffSplitService;
import com.intellij.ml.llm.vcs.diff.groupedDiff.commit.actions.UpdateAIDiff;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.AnActionLink;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/commit/actions/UpdateAIDiff;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "<init>", "()V", "UP_TO_DATE_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "HOVER_TOOLBAR_KEY", "SECONDARY_TEXT_COLOR", "Lcom/intellij/ui/JBColor;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "updateCustomComponent", "", "component", "installToolbarHoverTracking", "link", "Lcom/intellij/ui/components/AnActionLink;", "applyTextAccordingToState", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.ml.llm.vcs.diff"})
@SourceDebugExtension(value={"SMAP\nUpdateAIDiff.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateAIDiff.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/commit/actions/UpdateAIDiff\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,143:1\n30#2,2:144\n30#2,2:146\n*S KotlinDebug\n*F\n+ 1 UpdateAIDiff.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/commit/actions/UpdateAIDiff\n*L\n130#1:144,2\n140#1:146,2\n*E\n"})
public final class UpdateAIDiff
extends AnAction
implements CustomComponentAction {
    @NotNull
    private final Key<Boolean> UP_TO_DATE_KEY;
    @NotNull
    private final Key<Boolean> HOVER_TOOLBAR_KEY;
    @NotNull
    private final JBColor SECONDARY_TEXT_COLOR;

    public UpdateAIDiff() {
        Key key = Key.create((String)"ai.diff.up.to.date");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.UP_TO_DATE_KEY = key;
        Key key2 = Key.create((String)"ai.diff.hover.toolbar");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        this.HOVER_TOOLBAR_KEY = key2;
        JBColor jBColor = JBColor.lazy(UpdateAIDiff::SECONDARY_TEXT_COLOR$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"lazy(...)");
        this.SECONDARY_TEXT_COLOR = jBColor;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        String string = presentation2.getText();
        if (string == null) {
            string = "";
        }
        AnActionLink link2 = new AnActionLink(string, (AnAction)this, place);
        JBColor gray = this.SECONDARY_TEXT_COLOR;
        link2.setForeground((Color)gray);
        link2.setMargin((Insets)JBUI.insetsLeft((int)4));
        link2.putClientProperty(this.HOVER_TOOLBAR_KEY, (Object)false);
        this.installToolbarHoverTracking(link2, presentation2);
        return (JComponent)link2;
    }

    public void updateCustomComponent(@NotNull JComponent component2, @NotNull Presentation presentation2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        AnActionLink anActionLink = component2 instanceof AnActionLink ? (AnActionLink)component2 : null;
        if (anActionLink == null) {
            return;
        }
        AnActionLink link2 = anActionLink;
        this.applyTextAccordingToState(link2, presentation2);
        link2.setEnabled(presentation2.isEnabled());
        link2.setVisible(presentation2.isVisible());
        JBColor gray = this.SECONDARY_TEXT_COLOR;
        link2.setForeground((Color)gray);
    }

    private final void installToolbarHoverTracking(AnActionLink link2, Presentation presentation2) {
        UpdateAIDiff.installToolbarHoverTracking$tryAttach(link2, this, presentation2);
        link2.addHierarchyListener(arg_0 -> UpdateAIDiff.installToolbarHoverTracking$lambda$1(link2, this, presentation2, arg_0));
    }

    private final void applyTextAccordingToState(AnActionLink link2, Presentation presentation2) {
        boolean upToDate = Intrinsics.areEqual((Object)presentation2.getClientProperty(this.UP_TO_DATE_KEY), (Object)true);
        boolean hoverToolbar = Intrinsics.areEqual((Object)link2.getClientProperty(this.HOVER_TOOLBAR_KEY), (Object)true);
        if (upToDate) {
            link2.setText(hoverToolbar ? LLMVcsDiffBundle.message("llm.action.updateAiDiff.recalculate.text", new Object[0]) : "");
        } else {
            String string = presentation2.getText();
            if (string == null) {
                string = "";
            }
            link2.setText(string);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        boolean featureEnabled;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        boolean bl = featureEnabled = project2 != null && Registry.Companion.is("llm.grouped.diff.enabled");
        if (!featureEnabled) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<AIDiffSplitService> serviceClass$iv = AIDiffSplitService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        AIDiffSplitService splitService = (AIDiffSplitService)object;
        boolean toggleOn = AIDiffSettings.Companion.getInstance(project2).isShowAIDiff();
        boolean upToDate = splitService.isUpToDateCached();
        e.getPresentation().setEnabledAndVisible(toggleOn && splitService.hasAiChangeLists() && !splitService.isBusy());
        e.getPresentation().putClientProperty(this.UP_TO_DATE_KEY, (Object)upToDate);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        ComponentManager $this$service$iv = (ComponentManager)project3;
        boolean $i$f$service = false;
        Class<AIDiffSplitService> serviceClass$iv = AIDiffSplitService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        AIDiffSplitService service = (AIDiffSplitService)object;
        service.startSplit(true);
    }

    private static final Color SECONDARY_TEXT_COLOR$lambda$0() {
        return UIUtil.getLabelInfoForeground();
    }

    private static final void installToolbarHoverTracking$attach(AnActionLink $link, UpdateAIDiff this$0, Presentation $presentation, JComponent toolbar) {
        Key key = Key.create((String)"ai.diff.toolbar.listener.installed");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        Key diffToolbarListenerInstalledKey = key;
        if (Intrinsics.areEqual((Object)toolbar.getClientProperty(diffToolbarListenerInstalledKey), (Object)true)) {
            return;
        }
        toolbar.putClientProperty(diffToolbarListenerInstalledKey, true);
        MouseAdapter l2 = new MouseAdapter($link, this$0, $presentation, toolbar){
            final /* synthetic */ AnActionLink $link;
            final /* synthetic */ UpdateAIDiff this$0;
            final /* synthetic */ Presentation $presentation;
            final /* synthetic */ JComponent $toolbar;
            {
                this.$link = $link;
                this.this$0 = $receiver;
                this.$presentation = $presentation;
                this.$toolbar = $toolbar;
            }

            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$link.putClientProperty((Object)UpdateAIDiff.access$getHOVER_TOOLBAR_KEY$p(this.this$0), (Object)true);
                UpdateAIDiff.access$applyTextAccordingToState(this.this$0, this.$link, this.$presentation);
            }

            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.$toolbar);
                boolean inside = this.$toolbar.contains(p);
                this.$link.putClientProperty((Object)UpdateAIDiff.access$getHOVER_TOOLBAR_KEY$p(this.this$0), (Object)inside);
                UpdateAIDiff.access$applyTextAccordingToState(this.this$0, this.$link, this.$presentation);
            }

            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.$toolbar);
                boolean inside = this.$toolbar.contains(p);
                boolean was = Intrinsics.areEqual((Object)this.$link.getClientProperty((Object)UpdateAIDiff.access$getHOVER_TOOLBAR_KEY$p(this.this$0)), (Object)true);
                if (was != inside) {
                    this.$link.putClientProperty((Object)UpdateAIDiff.access$getHOVER_TOOLBAR_KEY$p(this.this$0), (Object)inside);
                    UpdateAIDiff.access$applyTextAccordingToState(this.this$0, this.$link, this.$presentation);
                }
            }
        };
        toolbar.addMouseListener(l2);
        toolbar.addMouseMotionListener(l2);
        $link.addHierarchyListener(arg_0 -> UpdateAIDiff.installToolbarHoverTracking$attach$lambda$0($link, toolbar, l2, diffToolbarListenerInstalledKey, arg_0));
    }

    private static final void installToolbarHoverTracking$attach$lambda$0(AnActionLink $link, JComponent $toolbar, installToolbarHoverTracking.attach.l.1 $l, Key $diffToolbarListenerInstalledKey, HierarchyEvent it) {
        if (!$link.isShowing()) {
            try {
                $toolbar.removeMouseListener($l);
                $toolbar.removeMouseMotionListener($l);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            $toolbar.putClientProperty($diffToolbarListenerInstalledKey, false);
        }
    }

    private static final void installToolbarHoverTracking$tryAttach(AnActionLink $link, UpdateAIDiff this$0, Presentation $presentation) {
        JComponent toolbar;
        Container container2 = SwingUtilities.getAncestorOfClass(ActionToolbarImpl.class, (Component)$link);
        JComponent jComponent = toolbar = container2 instanceof JComponent ? (JComponent)container2 : null;
        if (toolbar != null) {
            UpdateAIDiff.installToolbarHoverTracking$attach($link, this$0, $presentation, toolbar);
        }
    }

    private static final void installToolbarHoverTracking$lambda$1(AnActionLink $link, UpdateAIDiff this$0, Presentation $presentation, HierarchyEvent it) {
        if ($link.isShowing()) {
            UpdateAIDiff.installToolbarHoverTracking$tryAttach($link, this$0, $presentation);
        }
    }

    public static final /* synthetic */ Key access$getHOVER_TOOLBAR_KEY$p(UpdateAIDiff $this) {
        return $this.HOVER_TOOLBAR_KEY;
    }

    public static final /* synthetic */ void access$applyTextAccordingToState(UpdateAIDiff $this, AnActionLink link2, Presentation presentation2) {
        $this.applyTextAccordingToState(link2, presentation2);
    }
}

