/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff.diffViewer;

import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.Range;
import com.intellij.ml.llm.vcs.diff.groupedDiff.GroupedLineStatusTracker;
import com.intellij.ml.llm.vcs.diff.groupedDiff.GroupedRange;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalTrackerDiffUtil;
import com.intellij.openapi.vcs.ex.RangeExclusionState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J0\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/diffViewer/GroupedDiffUtils;", "", "<init>", "()V", "computeDifferences", "Ljava/lang/Runnable;", "tracker", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/GroupedLineStatusTracker;", "document1", "Lcom/intellij/openapi/editor/Document;", "document2", "activeGroupId", "", "textDiffProvider", "Lcom/intellij/diff/tools/util/text/TwosideTextDiffProvider;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "handler", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerDiffHandler;", "handleValidData", "diffData", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/diffViewer/GroupedDiffUtils$TrackerDiffData;", "TrackerDiffData", "intellij.ml.llm.vcs.diff"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGroupedDiffUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupedDiffUtils.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/diffViewer/GroupedDiffUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1563#2:81\n1634#2,3:82\n*S KotlinDebug\n*F\n+ 1 GroupedDiffUtils.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/diffViewer/GroupedDiffUtils\n*L\n55#1:81\n55#1:82,3\n*E\n"})
public final class GroupedDiffUtils {
    @NotNull
    public static final GroupedDiffUtils INSTANCE = new GroupedDiffUtils();

    private GroupedDiffUtils() {
    }

    @JvmStatic
    @NotNull
    public static final Runnable computeDifferences(@NotNull GroupedLineStatusTracker tracker, @NotNull Document document1, @NotNull Document document2, @NotNull String activeGroupId, @NotNull TwosideTextDiffProvider textDiffProvider, @NotNull ProgressIndicator indicator, @NotNull LocalTrackerDiffUtil.LocalTrackerDiffHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)document1, (String)"document1");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document2");
        Intrinsics.checkNotNullParameter((Object)activeGroupId, (String)"activeGroupId");
        Intrinsics.checkNotNullParameter((Object)textDiffProvider, (String)"textDiffProvider");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        indicator.checkCanceled();
        TrackerDiffData data2 = (TrackerDiffData)ActionsKt.runReadAction(() -> GroupedDiffUtils.computeDifferences$lambda$0(tracker, document2, document1));
        return INSTANCE.handleValidData(data2, handler2, textDiffProvider, indicator, activeGroupId);
    }

    /*
     * WARNING - void declaration
     */
    private final Runnable handleValidData(TrackerDiffData diffData, LocalTrackerDiffUtil.LocalTrackerDiffHandler handler2, TwosideTextDiffProvider textDiffProvider, ProgressIndicator indicator, String activeGroupId) {
        void $this$mapTo$iv$iv;
        List<GroupedRange> ranges2 = diffData.getRanges();
        boolean isContentsEqual = ranges2.isEmpty();
        CharSequence[] charSequenceArray = new CharSequence[]{diffData.getVcsText(), diffData.getLocalText()};
        CharSequence[] texts = charSequenceArray;
        if (textDiffProvider.isHighlightingDisabled()) {
            return handler2.done(isContentsEqual, texts, CollectionsKt.emptyList());
        }
        Iterable $this$map$iv = ranges2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GroupedRange groupedRange = (GroupedRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Range(it.getBeforeLine1(), it.getBeforeLine2(), it.getAfterLine1(), it.getAfterLine2()));
        }
        List linesRanges = (List)destination$iv$iv;
        boolean areVCSBoundedActionsDisabled = textDiffProvider.noFitnessForParticularPurposePromised();
        List list = textDiffProvider.compare(diffData.getVcsText(), diffData.getLocalText(), linesRanges, indicator);
        Intrinsics.checkNotNull((Object)list);
        List newFragments = list;
        List toggleableLineRanges = new ArrayList();
        int n = ((Collection)ranges2).size();
        for (int i = 0; i < n; ++i) {
            Object object;
            GroupedRange localRange = ranges2.get(i);
            Range lineRange = (Range)linesRanges.get(i);
            LocalTrackerDiffUtil.LineFragmentData rangesFragmentData = new LocalTrackerDiffUtil.LineFragmentData(activeGroupId, localRange.getGroupId(), (RangeExclusionState)RangeExclusionState.Included.INSTANCE, CollectionsKt.emptyList());
            Collection<LocalTrackerDiffUtil.ToggleableLineRange> collection = newFragments;
            boolean bl = 0 <= i ? i < collection.size() : false;
            if (bl) {
                object = collection.get(i);
            } else {
                int it = i;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !areVCSBoundedActionsDisabled) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                object = CollectionsKt.emptyList();
            }
            List newFragment = (List)object;
            collection = toggleableLineRanges;
            Intrinsics.checkNotNull((Object)newFragment);
            collection.add(new LocalTrackerDiffUtil.ToggleableLineRange(lineRange, newFragment, rangesFragmentData));
        }
        return handler2.done(isContentsEqual, areVCSBoundedActionsDisabled, texts, toggleableLineRanges);
    }

    private static final TrackerDiffData computeDifferences$lambda$0(GroupedLineStatusTracker $tracker, Document $document2, Document $document1) {
        List<GroupedRange> ranges2 = $tracker.getRanges();
        CharSequence charSequence = $document2.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence localText = charSequence;
        CharSequence charSequence2 = $document1.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getImmutableCharSequence(...)");
        CharSequence vcsText = charSequence2;
        CharSequence trackerVcsText = $tracker.getVcsText();
        TrackerDiffData diffData = new TrackerDiffData(ranges2, localText, vcsText, trackerVcsText);
        return diffData;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J7\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/diffViewer/GroupedDiffUtils$TrackerDiffData;", "", "ranges", "", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/GroupedRange;", "localText", "", "vcsText", "trackerVcsText", "<init>", "(Ljava/util/List;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V", "getRanges", "()Ljava/util/List;", "getLocalText", "()Ljava/lang/CharSequence;", "getVcsText", "getTrackerVcsText", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.vcs.diff"})
    private static final class TrackerDiffData {
        @NotNull
        private final List<GroupedRange> ranges;
        @NotNull
        private final CharSequence localText;
        @NotNull
        private final CharSequence vcsText;
        @NotNull
        private final CharSequence trackerVcsText;

        public TrackerDiffData(@NotNull List<GroupedRange> ranges2, @NotNull CharSequence localText, @NotNull CharSequence vcsText, @NotNull CharSequence trackerVcsText) {
            Intrinsics.checkNotNullParameter(ranges2, (String)"ranges");
            Intrinsics.checkNotNullParameter((Object)localText, (String)"localText");
            Intrinsics.checkNotNullParameter((Object)vcsText, (String)"vcsText");
            Intrinsics.checkNotNullParameter((Object)trackerVcsText, (String)"trackerVcsText");
            this.ranges = ranges2;
            this.localText = localText;
            this.vcsText = vcsText;
            this.trackerVcsText = trackerVcsText;
        }

        @NotNull
        public final List<GroupedRange> getRanges() {
            return this.ranges;
        }

        @NotNull
        public final CharSequence getLocalText() {
            return this.localText;
        }

        @NotNull
        public final CharSequence getVcsText() {
            return this.vcsText;
        }

        @NotNull
        public final CharSequence getTrackerVcsText() {
            return this.trackerVcsText;
        }

        @NotNull
        public final List<GroupedRange> component1() {
            return this.ranges;
        }

        @NotNull
        public final CharSequence component2() {
            return this.localText;
        }

        @NotNull
        public final CharSequence component3() {
            return this.vcsText;
        }

        @NotNull
        public final CharSequence component4() {
            return this.trackerVcsText;
        }

        @NotNull
        public final TrackerDiffData copy(@NotNull List<GroupedRange> ranges2, @NotNull CharSequence localText, @NotNull CharSequence vcsText, @NotNull CharSequence trackerVcsText) {
            Intrinsics.checkNotNullParameter(ranges2, (String)"ranges");
            Intrinsics.checkNotNullParameter((Object)localText, (String)"localText");
            Intrinsics.checkNotNullParameter((Object)vcsText, (String)"vcsText");
            Intrinsics.checkNotNullParameter((Object)trackerVcsText, (String)"trackerVcsText");
            return new TrackerDiffData(ranges2, localText, vcsText, trackerVcsText);
        }

        public static /* synthetic */ TrackerDiffData copy$default(TrackerDiffData trackerDiffData, List list, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, Object object) {
            if ((n & 1) != 0) {
                list = trackerDiffData.ranges;
            }
            if ((n & 2) != 0) {
                charSequence = trackerDiffData.localText;
            }
            if ((n & 4) != 0) {
                charSequence2 = trackerDiffData.vcsText;
            }
            if ((n & 8) != 0) {
                charSequence3 = trackerDiffData.trackerVcsText;
            }
            return trackerDiffData.copy(list, charSequence, charSequence2, charSequence3);
        }

        @NotNull
        public String toString() {
            return "TrackerDiffData(ranges=" + this.ranges + ", localText=" + this.localText + ", vcsText=" + this.vcsText + ", trackerVcsText=" + this.trackerVcsText + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.ranges).hashCode();
            result2 = result2 * 31 + this.localText.hashCode();
            result2 = result2 * 31 + this.vcsText.hashCode();
            result2 = result2 * 31 + this.trackerVcsText.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TrackerDiffData)) {
                return false;
            }
            TrackerDiffData trackerDiffData = (TrackerDiffData)other;
            if (!Intrinsics.areEqual(this.ranges, trackerDiffData.ranges)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.localText, (Object)trackerDiffData.localText)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.vcsText, (Object)trackerDiffData.vcsText)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.trackerVcsText, (Object)trackerDiffData.trackerVcsText);
        }
    }
}

