/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff.diffViewer;

import com.intellij.codeInsight.codeVision.ui.model.RangeCodeVisionModel;
import com.intellij.codeInsight.codeVision.ui.model.richText.RichText;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionRichTextPainter;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.formatting.visualLayer.VirtualFormattingInlaysInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.LightweightHint;
import com.intellij.util.IconUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\t\u0018\u0000 82\u00020\u00012\u00020\u0002:\u00018B<\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u000f\b\u0002\u0010\u0007\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0014\u0010\u0018\u001a\u00020\u00102\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0016J,\u0010\u001b\u001a\u00020\f2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\"\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010&\u001a\u00020'J\u001a\u0010(\u001a\u00020\f2\u0006\u0010$\u001a\u00020%2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aJ1\u0010)\u001a\u00020\f2\u000b\u0010*\u001a\u00070\b\u00a2\u0006\u0002\b\t2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010+\u001a\u00020\fH\u0002J0\u0010,\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u000200H\u0002J\u0018\u00101\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010/\u001a\u000200H\u0002J\u0018\u00102\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010/\u001a\u000200H\u0002J\u0018\u00103\u001a\u0002002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00104\u001a\u00020\u00102\u0006\u00105\u001a\u000200H\u0002J\u0014\u00106\u001a\u00020\u00102\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002J\b\u00107\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0015\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/diffViewer/TextWithIconInlayRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "Lcom/intellij/openapi/Disposable;", "richText", "Lcom/intellij/codeInsight/codeVision/ui/model/richText/RichText;", "icon", "Ljavax/swing/Icon;", "tooltip", "", "Lorg/jetbrains/annotations/Nls;", "onClick", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/codeInsight/codeVision/ui/model/richText/RichText;Ljavax/swing/Icon;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "iconGap", "", "getIconGap", "()I", "currentHint", "Lcom/intellij/ui/LightweightHint;", "lastTooltipText", "painter", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionRichTextPainter;", "calcWidthInPixels", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "paint", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "processHover", "", "point", "Ljava/awt/Point;", "vp", "Lcom/intellij/openapi/editor/VisualPosition;", "processClick", "showTooltip", "text", "hideTooltip", "doPaintIcon", "x", "y", "targetHeight", "", "getActualIconWidth", "getActualIconHeight", "getIconScale", "ceilToInt", "value", "calculateIndentShift", "dispose", "Companion", "intellij.ml.llm.vcs.diff"})
public final class TextWithIconInlayRenderer
implements EditorCustomElementRenderer,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RichText richText;
    @Nullable
    private final Icon icon;
    @Nullable
    private final String tooltip;
    @Nullable
    private final Function0<Unit> onClick;
    @Nullable
    private LightweightHint currentHint;
    @Nullable
    private String lastTooltipText;
    @NotNull
    private final CodeVisionRichTextPainter<RichText> painter;
    private static final float ICON_SCALE_FACTOR = 1.1f;

    public TextWithIconInlayRenderer(@NotNull RichText richText, @Nullable Icon icon2, @Nullable String tooltip, @Nullable Function0<Unit> onClick) {
        Intrinsics.checkNotNullParameter((Object)richText, (String)"richText");
        this.richText = richText;
        this.icon = icon2;
        this.tooltip = tooltip;
        this.onClick = onClick;
        this.painter = new CodeVisionRichTextPainter(TextWithIconInlayRenderer::painter$lambda$0, null, 2, null);
    }

    public /* synthetic */ TextWithIconInlayRenderer(RichText richText, Icon icon2, String string, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            function0 = null;
        }
        this(richText, icon2, string, (Function0<Unit>)function0);
    }

    private final int getIconGap() {
        return JBUI.scale((int)6);
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        Dimension textSize = this.painter.size(editor3, RangeCodeVisionModel.InlayState.NORMAL, (Object)this.richText);
        Font font = editor3.getColorsScheme().getFont(EditorFontType.PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font baseFont = font;
        float targetIconHeight = baseFont.getSize2D();
        int widthForIcon = this.icon != null ? this.getActualIconWidth(this.icon, targetIconHeight) + this.getIconGap() : 0;
        int indentShift = inlay.isValid() ? this.calculateIndentShift(inlay) : 0;
        return indentShift + widthForIcon + textSize.width;
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        if (this.richText.getLength() == 0) {
            return;
        }
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        Font font = editor3.getColorsScheme().getFont(EditorFontType.PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font baseFont = font;
        FontMetrics fm = editor3.getContentComponent().getFontMetrics(baseFont);
        float targetIconHeight = baseFont.getSize2D();
        int shift = this.calculateIndentShift(inlay);
        int textX = targetRegion.x + shift;
        float regionCenterY = (float)targetRegion.y + (float)targetRegion.height / 2.0f;
        int baselineY = MathKt.roundToInt((float)(regionCenterY + (float)(fm.getAscent() - fm.getDescent()) / 2.0f));
        if (this.icon != null) {
            int iconX = textX;
            int iconHeight = this.getActualIconHeight(this.icon, targetIconHeight);
            int iconY = MathKt.roundToInt((float)(regionCenterY - (float)iconHeight / 2.0f));
            this.doPaintIcon(this.icon, g, iconX, iconY, targetIconHeight);
            textX += this.getActualIconWidth(this.icon, targetIconHeight) + this.getIconGap();
        }
        this.painter.paint(editor3, textAttributes, g, (Object)this.richText, new Point(textX, baselineY), RangeCodeVisionModel.InlayState.NORMAL, false, null);
    }

    public final boolean processHover(@NotNull Point point, @NotNull Inlay<?> inlay, @NotNull VisualPosition vp) {
        block3: {
            block5: {
                String text2;
                block4: {
                    CharSequence charSequence;
                    Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                    Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                    Intrinsics.checkNotNullParameter((Object)vp, (String)"vp");
                    Rectangle bounds = inlay.getBounds();
                    text2 = this.tooltip;
                    if (bounds == null || !bounds.contains(point) || (charSequence = (CharSequence)text2) == null || charSequence.length() == 0) break block3;
                    if (!Intrinsics.areEqual((Object)text2, (Object)this.lastTooltipText)) break block4;
                    LightweightHint lightweightHint = this.currentHint;
                    if (lightweightHint != null ? lightweightHint.isVisible() : false) break block5;
                }
                this.hideTooltip();
                this.showTooltip(text2, inlay, point, vp);
            }
            return true;
        }
        this.hideTooltip();
        return false;
    }

    public final void processClick(@NotNull Point point, @NotNull Inlay<?> inlay) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Rectangle rectangle = inlay.getBounds();
            boolean bl = rectangle != null ? rectangle.contains(point) : false;
            if (!bl) break block1;
            Function0<Unit> function0 = this.onClick;
            if (function0 != null) {
                function0.invoke();
            }
        }
    }

    private final void showTooltip(String text2, Inlay<?> inlay, Point point, VisualPosition vp) {
        String escaped = XmlStringUtil.escapeString((String)text2);
        LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel((String)escaped, null, null, null));
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        HintManagerImpl manager = HintManagerImpl.getInstanceImpl();
        Point location = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)editor3, (VisualPosition)vp, (short)1);
        manager.showEditorHint(hint, editor3, location, 42, 0, false);
        this.currentHint = hint;
        this.lastTooltipText = text2;
    }

    private final void hideTooltip() {
        LightweightHint lightweightHint = this.currentHint;
        if (lightweightHint != null) {
            lightweightHint.hide();
        }
        this.currentHint = null;
        this.lastTooltipText = null;
    }

    private final void doPaintIcon(Icon icon2, Graphics g, int x, int y, float targetHeight) {
        Icon scaledIcon = IconUtil.scale((Icon)icon2, null, (float)this.getIconScale(icon2, targetHeight));
        scaledIcon.paintIcon(null, g, x, y);
    }

    private final int getActualIconWidth(Icon icon2, float targetHeight) {
        return this.ceilToInt((float)icon2.getIconWidth() * this.getIconScale(icon2, targetHeight));
    }

    private final int getActualIconHeight(Icon icon2, float targetHeight) {
        return this.ceilToInt((float)icon2.getIconHeight() * this.getIconScale(icon2, targetHeight));
    }

    private final float getIconScale(Icon icon2, float targetHeight) {
        return targetHeight / (float)icon2.getIconHeight() * 1.1f;
    }

    private final int ceilToInt(float value2) {
        return (int)Math.ceil(value2 + 0.01f);
    }

    private final int calculateIndentShift(Inlay<?> inlay) {
        int firstOnLine;
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        Document document2 = editor3.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document doc = document2;
        int lineNumber = doc.getLineNumber(inlay.getOffset()) + (inlay.getPlacement() == Inlay.Placement.BELOW_LINE ? 1 : 0);
        if (lineNumber >= doc.getLineCount()) {
            return 0;
        }
        int lineStartOffset = doc.getLineStartOffset(lineNumber);
        int lineEndOffset = doc.getLineEndOffset(lineNumber);
        CharSequence charSequence = doc.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence chars = charSequence;
        int anchorOffset = firstOnLine = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStartOffset, (int)lineEndOffset, (String)" \t");
        if (firstOnLine >= lineEndOffset) {
            for (int ln = lineNumber + 1; ln < doc.getLineCount(); ++ln) {
                int end;
                int start2 = doc.getLineStartOffset(ln);
                int first = CharArrayUtil.shiftForward((CharSequence)chars, (int)start2, (int)(end = doc.getLineEndOffset(ln)), (String)" \t");
                if (first >= end) continue;
                anchorOffset = first;
                break;
            }
        }
        int vfmtRightShift = VirtualFormattingInlaysInfo.Companion.measureVirtualFormattingInlineInlays(editor3, anchorOffset, anchorOffset);
        return editor3.offsetToXY((int)anchorOffset, (boolean)false, (boolean)false).x + vfmtRightShift;
    }

    public void dispose() {
    }

    private static final RichText painter$lambda$0(RichText it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/diffViewer/TextWithIconInlayRenderer$Companion;", "", "<init>", "()V", "ICON_SCALE_FACTOR", "", "intellij.ml.llm.vcs.diff"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

