/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest;

import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import com.intellij.ml.llm.vcs.diff.groupedDiff.ChangesGroup;
import com.intellij.ml.llm.vcs.diff.groupedDiff.FileChangeSubset;
import com.intellij.ml.llm.vcs.diff.groupedDiff.GroupedRange;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.AnnotatedDiffResponse;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.AnnotatedGroup;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.ChangeWithFileNotInGroupError;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.DiffGroup;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.ErrorList;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.FileSummary;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.FileWithoutChangesInGroupError;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.Group;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.GroupsAnalysis;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.LineChange;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.NonExistingGroupError;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.RowRange;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.UnassignedChangeError;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.vcs.changes.Change;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011H\u0002J\b\u0010\u001f\u001a\u00020\u001cH\u0002J\u0006\u0010 \u001a\u00020\u001cJ\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#J2\u0010$\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\"\u001a\u00020#2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010&\u001a\u00020'H\u0002J&\u0010(\u001a\u0004\u0018\u00010\u00122\u0006\u0010)\u001a\u00020\n2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00120\u000fH\u0002J\u001c\u0010+\u001a\u00020\u001c2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J$\u0010,\u001a\u00020\u001c2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010&\u001a\u00020'H\u0002J>\u0010-\u001a\u00020\u001c2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000f2\u0006\u0010&\u001a\u00020'H\u0002JL\u0010.\u001a\u00020\u001c2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000f2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010&\u001a\u00020'H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR#\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00060"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/DiffAnalysis;", "", "groupsAnalysis", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupsAnalysis;", "<init>", "(Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupsAnalysis;)V", "getGroupsAnalysis", "()Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupsAnalysis;", "lineChanges", "Ljava/util/SortedMap;", "", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/LineChange;", "getLineChanges", "()Ljava/util/SortedMap;", "fileToGroups", "", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/Group;", "getFileToGroups", "()Ljava/util/Map;", "results", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/ChangesGroup;", "getResults", "()Ljava/util/List;", "mapFilesToGroups", "groupResponse", "updateGroupsForFilesWithOnlyOneGroup", "", "updateMissingGroupsWithFallback", "createResults", "updateResults", "updateResultsAfterAnnotatedDiffResponse", "analyzeAnnotatedDiffResponse", "annotatedDiffResponse", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/AnnotatedDiffResponse;", "mapAnnotatedGroupsToGroups", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/AnnotatedGroup;", "errorList", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/ErrorList;", "findGroupForLineNumber", "lineNumber", "annotatedGroupToGroup", "propagateGroupsFromAdjacentLines", "validateAllChangesAssigned", "validateChangesHaveFilesInGroup", "validateFilesHaveChangesInGroup", "Companion", "intellij.ml.llm.vcs.diff"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDiffAnalysis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffAnalysis.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/DiffAnalysis\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,459:1\n1563#2:460\n1634#2,2:461\n774#2:463\n865#2,2:464\n1491#2:466\n1516#2,3:467\n1519#2,3:477\n1563#2:490\n1634#2,3:491\n1068#2:498\n1636#2:499\n1068#2:500\n1563#2:501\n1634#2,3:502\n774#2:505\n865#2,2:506\n1563#2:508\n1634#2,3:509\n382#3,7:470\n136#4,9:480\n216#4:489\n217#4:496\n145#4:497\n1#5:494\n1#5:495\n*S KotlinDebug\n*F\n+ 1 DiffAnalysis.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/DiffAnalysis\n*L\n102#1:460\n102#1:461,2\n108#1:463\n108#1:464,2\n109#1:466\n109#1:467,3\n109#1:477,3\n114#1:490\n114#1:491,3\n119#1:498\n102#1:499\n128#1:500\n170#1:501\n170#1:502,3\n389#1:505\n389#1:506,2\n389#1:508\n389#1:509,3\n109#1:470,7\n110#1:480,9\n110#1:489\n110#1:496\n110#1:497\n110#1:495\n*E\n"})
public final class DiffAnalysis {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GroupsAnalysis groupsAnalysis;
    @NotNull
    private final SortedMap<Integer, LineChange> lineChanges;
    @NotNull
    private final Map<TextFilePatch, List<Group>> fileToGroups;
    @NotNull
    private final List<ChangesGroup> results;

    public DiffAnalysis(@NotNull GroupsAnalysis groupsAnalysis) {
        Intrinsics.checkNotNullParameter((Object)groupsAnalysis, (String)"groupsAnalysis");
        this.groupsAnalysis = groupsAnalysis;
        this.lineChanges = Companion.createLineChangesMap(this.groupsAnalysis.getPatchInfo().getFilePatches());
        this.fileToGroups = this.mapFilesToGroups(this.groupsAnalysis.getGroupList());
        this.results = this.createResults();
        this.updateGroupsForFilesWithOnlyOneGroup();
        this.updateResults();
    }

    @NotNull
    public final GroupsAnalysis getGroupsAnalysis() {
        return this.groupsAnalysis;
    }

    @NotNull
    public final SortedMap<Integer, LineChange> getLineChanges() {
        return this.lineChanges;
    }

    @NotNull
    public final Map<TextFilePatch, List<Group>> getFileToGroups() {
        return this.fileToGroups;
    }

    @NotNull
    public final List<ChangesGroup> getResults() {
        return this.results;
    }

    private final Map<TextFilePatch, List<Group>> mapFilesToGroups(List<Group> groupResponse) {
        Map fileToGroups = new LinkedHashMap();
        for (Group group : groupResponse) {
            for (FileSummary fileSummary : group.getFiles()) {
                TextFilePatch textFilePatch = fileSummary.getTextFilePatch();
                if (textFilePatch == null) continue;
                fileToGroups.computeIfAbsent(textFilePatch, arg_0 -> DiffAnalysis.mapFilesToGroups$lambda$1(DiffAnalysis::mapFilesToGroups$lambda$0, arg_0)).add(group);
            }
        }
        return fileToGroups;
    }

    public final void updateGroupsForFilesWithOnlyOneGroup() {
        for (Map.Entry<TextFilePatch, List<Group>> entry : this.fileToGroups.entrySet()) {
            TextFilePatch filePatch = entry.getKey();
            List<Group> groups = entry.getValue();
            if (groups.size() != 1) continue;
            Group singleGroup = (Group)CollectionsKt.first(groups);
            for (LineChange lineChange : this.lineChanges.values()) {
                if (!Intrinsics.areEqual((Object)lineChange.getTextFilePatch(), (Object)filePatch)) continue;
                lineChange.setGroup(singleGroup);
            }
        }
    }

    public final void updateMissingGroupsWithFallback() {
        Group group = (Group)CollectionsKt.firstOrNull(this.groupsAnalysis.getGroupList());
        if (group == null) {
            return;
        }
        Group fallbackGroup = group;
        for (LineChange lineChange : this.lineChanges.values()) {
            if (lineChange.getGroup() != null) continue;
            List<Group> list = this.fileToGroups.get(lineChange.getTextFilePatch());
            if (list == null || (list = (Group)CollectionsKt.firstOrNull(list)) == null) {
                list = fallbackGroup;
            }
            List<Group> candidate = list;
            lineChange.setGroup((DiffGroup)((Object)candidate));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ChangesGroup> createResults() {
        void $this$mapTo$iv$iv;
        Map<TextFilePatch, Change> patchToChange = this.groupsAnalysis.getPatchInfo().getFileToChange();
        Iterable $this$map$iv = this.groupsAnalysis.getGroupList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$sortedByDescending$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            void $this$groupByTo$iv$iv;
            Object $this$groupBy$iv;
            FileSummary it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void group;
            Group group2 = (Group)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = group.getFiles();
            boolean $i$f$filter = false;
            void var13_13 = $this$filter$iv;
            Object destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (FileSummary)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getTextFilePatch() != null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                void $this$getOrPut$iv$iv$iv;
                it = (FileSummary)element$iv$iv;
                boolean bl3 = false;
                TextFilePatch key$iv$iv = it.getTextFilePatch();
                Object object2 = destination$iv$iv2;
                TextFilePatch key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv2;
            boolean $i$f$mapNotNull = false;
            $this$groupByTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                TextFilePatch patch;
                FileChangeSubset fileChangeSubset;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl5 = false;
                Map.Entry entry = element$iv$iv;
                boolean bl6 = false;
                TextFilePatch textFilePatch = (TextFilePatch)entry.getKey();
                List summaries = (List)entry.getValue();
                if (textFilePatch == null) {
                    fileChangeSubset = null;
                } else if (patchToChange.get(patch) == null) {
                    fileChangeSubset = null;
                } else {
                    Change change;
                    Double d;
                    void $this$mapTo$iv$iv2;
                    Iterable $this$map$iv2 = summaries;
                    boolean $i$f$map2 = false;
                    Iterable iterable3 = $this$map$iv2;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it2;
                        FileSummary fileSummary = (FileSummary)item$iv$iv2;
                        Collection collection2 = destination$iv$iv3;
                        boolean bl7 = false;
                        collection2.add(it2.getSummary());
                    }
                    String mergedSummary = (String)PSStringKt.joinToString$default((Iterable)((List)destination$iv$iv3), (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)"\n")), null, null, (int)0, null, (int)30, null).unwrap();
                    Iterator iterator2 = ((Iterable)summaries).iterator();
                    if (!iterator2.hasNext()) {
                        d = null;
                    } else {
                        FileSummary it3 = (FileSummary)iterator2.next();
                        boolean bl8 = false;
                        double d2 = it3.getImportance();
                        while (iterator2.hasNext()) {
                            FileSummary it4 = (FileSummary)iterator2.next();
                            $i$a$-maxOfOrNull-DiffAnalysis$createResults$1$files$3$maxImportance$1 = false;
                            double d3 = it4.getImportance();
                            d2 = Math.max(d2, d3);
                        }
                        d = d2;
                    }
                    double maxImportance = d != null ? d : 0.0;
                    fileChangeSubset = new FileChangeSubset(change, null, mergedSummary, maxImportance, true);
                }
                if (fileChangeSubset == null) continue;
                FileChangeSubset it$iv$iv = fileChangeSubset;
                boolean bl9 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv2;
            boolean $i$f$sortedByDescending = false;
            List files = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    FileChangeSubset it = (FileChangeSubset)b;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(it.getImportance());
                    it = (FileChangeSubset)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getImportance()));
                }
            });
            collection.add(new ChangesGroup(group.getId(), (String)group.getTitle().unwrap(), (String)group.getSummary().unwrap(), group.getImportance(), files));
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ChangesGroup it = (ChangesGroup)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getImportance());
                it = (ChangesGroup)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getImportance()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void updateResults() {
        void $this$mapTo$iv$iv2;
        List sequentialBlocks = new ArrayList();
        List currentBlock = new ArrayList();
        for (LineChange lineChange : this.lineChanges.values()) {
            if (lineChange.getGroup() == null) continue;
            if (currentBlock.isEmpty()) {
                Intrinsics.checkNotNull((Object)lineChange);
                currentBlock.add(lineChange);
                continue;
            }
            LineChange lastLineChange = (LineChange)CollectionsKt.last((List)currentBlock);
            int currentLineNumber = lineChange.getPatchLine().getPatchFileLineNumber();
            int lastLineNumber = lastLineChange.getPatchLine().getPatchFileLineNumber();
            if (Intrinsics.areEqual((Object)lineChange.getGroup(), (Object)lastLineChange.getGroup()) && Intrinsics.areEqual((Object)lineChange.getTextFilePatch(), (Object)lastLineChange.getTextFilePatch()) && currentLineNumber == lastLineNumber + 1) {
                Intrinsics.checkNotNull((Object)lineChange);
                currentBlock.add(lineChange);
                continue;
            }
            if (!((Collection)currentBlock).isEmpty()) {
                sequentialBlocks.add(CollectionsKt.toList((Iterable)currentBlock));
            }
            Object[] objectArray = new LineChange[1];
            Intrinsics.checkNotNull((Object)lineChange);
            objectArray[0] = lineChange;
            currentBlock = CollectionsKt.mutableListOf((Object[])objectArray);
        }
        if (!((Collection)currentBlock).isEmpty()) {
            sequentialBlocks.add(CollectionsKt.toList((Iterable)currentBlock));
        }
        Iterable $this$map$iv = sequentialBlocks;
        boolean $i$f$map22 = false;
        Iterable currentLineNumber = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void block;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LineChange firstLine = (LineChange)CollectionsKt.first((List)block);
            LineChange lastLine = (LineChange)CollectionsKt.last((List)block);
            int n = firstLine.getLineAfter();
            int n2 = lastLine.getEndLineAfter();
            int n3 = firstLine.getLineBefore();
            int n4 = lastLine.getEndLineBefore();
            DiffGroup diffGroup = firstLine.getGroup();
            Intrinsics.checkNotNull((Object)diffGroup, (String)"null cannot be cast to non-null type com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.Group");
            collection.add(new GroupedRange(n, n2, n3, n4, String.valueOf(((Group)diffGroup).getId())));
        }
        List groupedRanges = (List)destination$iv$iv;
        Map fileGroupToRanges = new LinkedHashMap();
        Iterator $i$f$map22 = ((Iterable)sequentialBlocks).iterator();
        int $this$mapTo$iv$iv2 = 0;
        while ($i$f$map22.hasNext()) {
            int index = $this$mapTo$iv$iv2++;
            List block = (List)$i$f$map22.next();
            LineChange firstLine = (LineChange)CollectionsKt.first((List)block);
            TextFilePatch textFilePatch = firstLine.getTextFilePatch();
            DiffGroup diffGroup = firstLine.getGroup();
            Intrinsics.checkNotNull((Object)diffGroup, (String)"null cannot be cast to non-null type com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.Group");
            Pair key = new Pair((Object)textFilePatch, (Object)((Group)diffGroup));
            fileGroupToRanges.computeIfAbsent(key, arg_0 -> DiffAnalysis.updateResults$lambda$2(DiffAnalysis::updateResults$lambda$1, arg_0)).add(groupedRanges.get(index));
        }
        Map changeAndGroupToSubset = new LinkedHashMap();
        for (ChangesGroup group : this.results) {
            for (FileChangeSubset subset : group.getFiles()) {
                changeAndGroupToSubset.put(new Pair((Object)subset.getChange(), (Object)group.getId()), subset);
            }
        }
        Map<TextFilePatch, Change> patchToChange = this.groupsAnalysis.getPatchInfo().getFileToChange();
        for (Map.Entry entry : fileGroupToRanges.entrySet()) {
            FileChangeSubset subset;
            int groupId;
            Change change;
            Pair fileGroupPair = (Pair)entry.getKey();
            List ranges2 = (List)entry.getValue();
            TextFilePatch textFilePatch = (TextFilePatch)fileGroupPair.component1();
            Group group = (Group)fileGroupPair.component2();
            if (patchToChange.get(textFilePatch) == null || (FileChangeSubset)changeAndGroupToSubset.get(new Pair((Object)change, (Object)(groupId = group.getId()))) == null) continue;
            subset.setChanges(ranges2);
            subset.setPending(false);
        }
    }

    public final void updateResultsAfterAnnotatedDiffResponse() {
        this.updateMissingGroupsWithFallback();
        this.updateResults();
    }

    public final void analyzeAnnotatedDiffResponse(@NotNull AnnotatedDiffResponse annotatedDiffResponse) {
        Intrinsics.checkNotNullParameter((Object)annotatedDiffResponse, (String)"annotatedDiffResponse");
        GroupsAnalysis groupsAnalysis = this.groupsAnalysis;
        SortedMap<Integer, LineChange> lineChanges = this.lineChanges;
        List<Group> groupResponse = groupsAnalysis.getGroupList();
        ErrorList errorList = groupsAnalysis.getErrorList();
        Map<AnnotatedGroup, Group> annotatedGroupToGroup = this.mapAnnotatedGroupsToGroups(annotatedDiffResponse, groupResponse, errorList);
        Companion.updateGroupsInLineChangesMap(lineChanges, (Function4<? super TextFilePatch, ? super PatchLine, ? super Integer, ? super Integer, ? extends DiffGroup>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> DiffAnalysis.analyzeAnnotatedDiffResponse$lambda$0(this, annotatedGroupToGroup, arg_0, arg_1, arg_2, arg_3)));
        this.updateGroupsForFilesWithOnlyOneGroup();
        Map<TextFilePatch, List<Group>> fileToGroups = this.fileToGroups;
        this.propagateGroupsFromAdjacentLines(lineChanges);
        this.validateAllChangesAssigned(lineChanges, errorList);
        this.validateChangesHaveFilesInGroup(lineChanges, fileToGroups, errorList);
        this.validateFilesHaveChangesInGroup(groupResponse, fileToGroups, lineChanges, errorList);
    }

    private final Map<AnnotatedGroup, Group> mapAnnotatedGroupsToGroups(AnnotatedDiffResponse annotatedDiffResponse, List<Group> groupResponse, ErrorList errorList) {
        Map result2 = new LinkedHashMap();
        for (AnnotatedGroup annotatedGroup : annotatedDiffResponse.getGroups()) {
            Object v0;
            block3: {
                Iterable iterable = groupResponse;
                for (Object t : iterable) {
                    Group it = (Group)t;
                    boolean bl = false;
                    if (!(it.getId() == annotatedGroup.getId())) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            Group group = v0;
            if (group != null) {
                result2.put(annotatedGroup, group);
                continue;
            }
            errorList.addError(new NonExistingGroupError(PSStringOperatorsKt.toPSString((int)annotatedGroup.getId()), annotatedGroup.getRows()));
        }
        return result2;
    }

    private final Group findGroupForLineNumber(int lineNumber, Map<AnnotatedGroup, Group> annotatedGroupToGroup) {
        for (Map.Entry<AnnotatedGroup, Group> entry : annotatedGroupToGroup.entrySet()) {
            AnnotatedGroup annotatedGroup = entry.getKey();
            Group group = entry.getValue();
            for (RowRange rowRange : annotatedGroup.getRows()) {
                if (lineNumber < rowRange.getRowStart() || lineNumber > rowRange.getRowEnd()) continue;
                return group;
            }
        }
        return null;
    }

    private final void propagateGroupsFromAdjacentLines(SortedMap<Integer, LineChange> lineChanges) {
        LineChange previousLineChange = null;
        for (LineChange lineChange : lineChanges.values()) {
            if (lineChange.getGroup() == null && previousLineChange != null) {
                int currentLineNumber = lineChange.getPatchLine().getPatchFileLineNumber();
                int previousLineNumber = previousLineChange.getPatchLine().getPatchFileLineNumber();
                if (previousLineChange.getGroup() != null && currentLineNumber == previousLineNumber + 1) {
                    lineChange.setGroup(previousLineChange.getGroup());
                }
            }
            previousLineChange = lineChange;
        }
        LineChange nextLineChange = null;
        Collection<LineChange> collection = lineChanges.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        for (LineChange lineChange : CollectionsKt.reversed((Iterable)collection)) {
            if (lineChange.getGroup() == null && nextLineChange != null) {
                int currentLineNumber = lineChange.getPatchLine().getPatchFileLineNumber();
                int nextLineNumber = nextLineChange.getPatchLine().getPatchFileLineNumber();
                if (nextLineChange.getGroup() != null && nextLineNumber == currentLineNumber + 1) {
                    lineChange.setGroup(nextLineChange.getGroup());
                }
            }
            nextLineChange = lineChange;
        }
    }

    private final void validateAllChangesAssigned(SortedMap<Integer, LineChange> lineChanges, ErrorList errorList) {
        for (LineChange lineChange : lineChanges.values()) {
            if (lineChange.getGroup() != null) continue;
            errorList.addError(new UnassignedChangeError(lineChange.getTextFilePatch(), lineChange.getPatchLine()));
        }
    }

    private final void validateChangesHaveFilesInGroup(SortedMap<Integer, LineChange> lineChanges, Map<TextFilePatch, ? extends List<Group>> fileToGroups, ErrorList errorList) {
        for (LineChange lineChange : lineChanges.values()) {
            List allowedGroups;
            DiffGroup group = lineChange.getGroup();
            if (group == null) continue;
            List list = fileToGroups.get(lineChange.getTextFilePatch());
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            if (CollectionsKt.contains((Iterable)(allowedGroups = list), (Object)group)) continue;
            errorList.addError(new ChangeWithFileNotInGroupError(lineChange.getTextFilePatch(), lineChange.getPatchLine(), (Group)group, allowedGroups));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateFilesHaveChangesInGroup(List<Group> groupResponse, Map<TextFilePatch, ? extends List<Group>> fileToGroups, SortedMap<Integer, LineChange> lineChanges, ErrorList errorList) {
        Map fileToAssignedGroups = new LinkedHashMap();
        for (LineChange lineChange : lineChanges.values()) {
            DiffGroup group = lineChange.getGroup();
            if (group == null) continue;
            fileToAssignedGroups.computeIfAbsent(lineChange.getTextFilePatch(), arg_0 -> DiffAnalysis.validateFilesHaveChangesInGroup$lambda$1(DiffAnalysis::validateFilesHaveChangesInGroup$lambda$0, arg_0)).add((Group)group);
        }
        for (Group group : groupResponse) {
            for (FileSummary fileSummary : group.getFiles()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                LineChange it;
                void $this$filterTo$iv$iv;
                Set assignedGroups;
                TextFilePatch textFilePatch = fileSummary.getTextFilePatch();
                if (textFilePatch == null) continue;
                Set set = (Set)fileToAssignedGroups.get(textFilePatch);
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                if ((assignedGroups = set).contains(group)) continue;
                Collection<LineChange> collection = lineChanges.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (LineChange)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getTextFilePatch(), (Object)textFilePatch)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (LineChange)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it.getPatchLine());
                }
                List allChanges = (List)destination$iv$iv;
                List list = fileToGroups.get(textFilePatch);
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List allGroups = list;
                errorList.addError(new FileWithoutChangesInGroupError(group, textFilePatch, allGroups, allChanges));
            }
        }
    }

    private static final List mapFilesToGroups$lambda$0(TextFilePatch it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List mapFilesToGroups$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List updateResults$lambda$1(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List updateResults$lambda$2(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final DiffGroup analyzeAnnotatedDiffResponse$lambda$0(DiffAnalysis this$0, Map $annotatedGroupToGroup, TextFilePatch textFilePatch, PatchLine line, int n, int n2) {
        Intrinsics.checkNotNullParameter((Object)textFilePatch, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this$0.findGroupForLineNumber(line.getPatchFileLineNumber(), $annotatedGroupToGroup);
    }

    private static final Set validateFilesHaveChangesInGroup$lambda$0(TextFilePatch it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set validateFilesHaveChangesInGroup$lambda$1(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJB\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052&\u0010\u000e\u001a\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/DiffAnalysis$Companion;", "", "<init>", "()V", "createLineChangesMap", "Ljava/util/SortedMap;", "", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/LineChange;", "filePatches", "", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "updateGroupsInLineChangesMap", "", "lineChanges", "groupCalculator", "Lkotlin/Function4;", "Lcom/intellij/openapi/diff/impl/patch/PatchLine;", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/DiffGroup;", "intellij.ml.llm.vcs.diff"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SortedMap<Integer, LineChange> createLineChangesMap(@NotNull List<? extends TextFilePatch> filePatches) {
            Intrinsics.checkNotNullParameter(filePatches, (String)"filePatches");
            TreeMap result2 = new TreeMap();
            for (TextFilePatch textFilePatch : filePatches) {
                for (PatchHunk hunk : textFilePatch.getHunks()) {
                    int lineBefore = hunk.getStartLineBefore();
                    if (lineBefore == -1) {
                        lineBefore = 0;
                    }
                    int lineAfter = hunk.getStartLineAfter();
                    block7: for (PatchLine line : hunk.getLines()) {
                        switch (WhenMappings.$EnumSwitchMapping$0[line.getType().ordinal()]) {
                            case 1: {
                                ++lineBefore;
                                ++lineAfter;
                                continue block7;
                            }
                            case 2: {
                                Map map2 = result2;
                                Integer n = line.getPatchFileLineNumber();
                                Intrinsics.checkNotNull((Object)line);
                                map2.put(n, new LineChange(line, textFilePatch, null, lineBefore, lineAfter));
                                ++lineAfter;
                                continue block7;
                            }
                            case 3: {
                                Map map3 = result2;
                                Integer n = line.getPatchFileLineNumber();
                                Intrinsics.checkNotNull((Object)line);
                                map3.put(n, new LineChange(line, textFilePatch, null, lineBefore, lineAfter));
                                ++lineBefore;
                                continue block7;
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            return result2;
        }

        public final void updateGroupsInLineChangesMap(@NotNull SortedMap<Integer, LineChange> lineChanges, @NotNull Function4<? super TextFilePatch, ? super PatchLine, ? super Integer, ? super Integer, ? extends DiffGroup> groupCalculator) {
            Intrinsics.checkNotNullParameter(lineChanges, (String)"lineChanges");
            Intrinsics.checkNotNullParameter(groupCalculator, (String)"groupCalculator");
            for (LineChange entry : lineChanges.values()) {
                entry.setGroup((DiffGroup)groupCalculator.invoke((Object)entry.getTextFilePatch(), (Object)entry.getPatchLine(), (Object)entry.getLineBefore(), (Object)entry.getLineAfter()));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PatchLine.Type.values().length];
                try {
                    nArray[PatchLine.Type.CONTEXT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PatchLine.Type.ADD.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PatchLine.Type.REMOVE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

