/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.ErrorList;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.FileNotInAnyGroupError;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.FileSummary;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.Group;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.GroupFileNotFoundError;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.GroupResponse;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.PatchInfo;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupsAnalysis;", "", "patchInfo", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/PatchInfo;", "groupResponse", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupResponse;", "errorList", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/ErrorList;", "<init>", "(Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/PatchInfo;Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupResponse;Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/ErrorList;)V", "getPatchInfo", "()Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/PatchInfo;", "getGroupResponse", "()Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupResponse;", "getErrorList", "()Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/ErrorList;", "groupList", "", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/Group;", "getGroupList", "()Ljava/util/List;", "buildFileSummaryMap", "", "validateAllFilesInGroups", "Companion", "intellij.ml.llm.vcs.diff"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGroupsAnalysis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupsAnalysis.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupsAnalysis\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,125:1\n774#2:126\n865#2,2:127\n1374#2:129\n1460#2,5:130\n1491#2:135\n1516#2,3:136\n1519#2,3:146\n774#2:149\n865#2,2:150\n382#3,7:139\n*S KotlinDebug\n*F\n+ 1 GroupsAnalysis.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupsAnalysis\n*L\n40#1:126\n40#1:127,2\n112#1:129\n112#1:130,5\n112#1:135\n112#1:136,3\n112#1:146,3\n114#1:149\n114#1:150,2\n112#1:139,7\n*E\n"})
public final class GroupsAnalysis {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PatchInfo patchInfo;
    @NotNull
    private final GroupResponse groupResponse;
    @NotNull
    private final ErrorList errorList;
    @NotNull
    private final List<Group> groupList;

    private GroupsAnalysis(PatchInfo patchInfo, GroupResponse groupResponse, ErrorList errorList) {
        this.patchInfo = patchInfo;
        this.groupResponse = groupResponse;
        this.errorList = errorList;
        this.groupList = this.groupResponse.getGroups();
    }

    @NotNull
    public final PatchInfo getPatchInfo() {
        return this.patchInfo;
    }

    @NotNull
    public final GroupResponse getGroupResponse() {
        return this.groupResponse;
    }

    @NotNull
    public final ErrorList getErrorList() {
        return this.errorList;
    }

    @NotNull
    public final List<Group> getGroupList() {
        return this.groupList;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildFileSummaryMap() {
        for (Group group : this.groupList) {
            for (FileSummary fileSummary : group.getFiles()) {
                TextFilePatch matchingFile;
                TextFilePatch textFilePatch;
                Object v2;
                TextFilePatch it;
                Iterable iterable;
                PSString filePathName;
                PSString filePath;
                block13: {
                    char[] cArray = new char[]{'`'};
                    PSString pSString = fileSummary.getPath().trim(cArray);
                    cArray = new char[]{'\''};
                    filePath = pSString.trim(cArray);
                    filePathName = PSString.substringAfterLast$default((PSString)filePath, (String)"/", null, (int)2, null);
                    iterable = this.patchInfo.getFilePatches();
                    for (Object object : iterable) {
                        it = (TextFilePatch)object;
                        boolean bl = false;
                        String string = it.getAfterName();
                        if (string == null && (string = it.getBeforeName()) == null) {
                            string = "";
                        }
                        if (!Intrinsics.areEqual((Object)string, (Object)filePath.unwrap())) continue;
                        v2 = object;
                        break block13;
                    }
                    v2 = null;
                }
                if ((textFilePatch = (TextFilePatch)v2) == null) {
                    Object v5;
                    block14: {
                        iterable = this.patchInfo.getFilePatches();
                        for (Object object : iterable) {
                            it = (TextFilePatch)object;
                            boolean bl = false;
                            String string = it.getBeforeName();
                            if (string == null && (string = it.getAfterName()) == null) {
                                string = "";
                            }
                            if (!Intrinsics.areEqual((Object)string, (Object)filePath.unwrap())) continue;
                            v5 = object;
                            break block14;
                        }
                        v5 = null;
                    }
                    textFilePatch = v5;
                }
                if ((matchingFile = textFilePatch) == null) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = this.patchInfo.getFilePatches();
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        TextFilePatch it2 = (TextFilePatch)element$iv$iv;
                        boolean bl = false;
                        String string = it2.getAfterName();
                        if (string == null) {
                            string = "";
                        }
                        String toFileName = StringsKt.substringAfterLast$default((String)string, (char)'/', null, (int)2, null);
                        String string2 = it2.getBeforeName();
                        if (string2 == null) {
                            string2 = "";
                        }
                        String fromFileName = StringsKt.substringAfterLast$default((String)string2, (char)'/', null, (int)2, null);
                        if (!(Intrinsics.areEqual((Object)toFileName, (Object)filePathName.unwrap()) || Intrinsics.areEqual((Object)fromFileName, (Object)filePathName.unwrap()))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List matchingFilesByName = (List)destination$iv$iv;
                    if (matchingFilesByName.size() == 1) {
                        matchingFile = (TextFilePatch)CollectionsKt.first((List)matchingFilesByName);
                    }
                }
                if (matchingFile != null) {
                    fileSummary.setTextFilePatch(matchingFile);
                    continue;
                }
                this.errorList.addError(new GroupFileNotFoundError(group.getTitle(), filePath));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateAllFilesInGroups() {
        void $this$filterTo$iv$iv;
        void $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        List<TextFilePatch> allFiles = this.patchInfo.getFilePatches();
        Iterable $this$flatMap$iv = this.groupList;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Group)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((Group)it).getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            it = (FileSummary)element$iv$iv;
            boolean bl = false;
            TextFilePatch key$iv$iv = ((FileSummary)it).getTextFilePatch();
            Object object2 = destination$iv$iv;
            TextFilePatch key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object filesInGroups = destination$iv$iv;
        Iterable $this$filter$iv = allFiles;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextFilePatch file = (TextFilePatch)element$iv$iv;
            boolean bl = false;
            if (!(!filesInGroups.containsKey(file))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List filesNotInGroups = (List)destination$iv$iv2;
        if (!((Collection)filesNotInGroups).isEmpty()) {
            for (TextFilePatch file : filesNotInGroups) {
                FileNotInAnyGroupError error = new FileNotInAnyGroupError(file);
                this.errorList.addError(error);
            }
        }
    }

    public /* synthetic */ GroupsAnalysis(PatchInfo patchInfo, GroupResponse groupResponse, ErrorList errorList, DefaultConstructorMarker $constructor_marker) {
        this(patchInfo, groupResponse, errorList);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupsAnalysis$Companion;", "", "<init>", "()V", "analyzeGroups", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupsAnalysis;", "patchInfo", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/PatchInfo;", "groupResponse", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupResponse;", "errorList", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/ErrorList;", "intellij.ml.llm.vcs.diff"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GroupsAnalysis analyzeGroups(@NotNull PatchInfo patchInfo, @NotNull GroupResponse groupResponse, @NotNull ErrorList errorList) {
            Intrinsics.checkNotNullParameter((Object)patchInfo, (String)"patchInfo");
            Intrinsics.checkNotNullParameter((Object)groupResponse, (String)"groupResponse");
            Intrinsics.checkNotNullParameter((Object)errorList, (String)"errorList");
            GroupsAnalysis result2 = new GroupsAnalysis(patchInfo, groupResponse, errorList, null);
            result2.buildFileSummaryMap();
            result2.validateAllFilesInGroups();
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

