/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff.ui;

import com.intellij.ml.llm.vcs.diff.groupedDiff.ChangesGroup;
import com.intellij.ml.llm.vcs.diff.groupedDiff.ChangesGroupKt;
import com.intellij.ml.llm.vcs.diff.groupedDiff.commit.AIChangeListsGroupedDiffData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/ui/AiChangeListNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserChangeListNode;", "project", "Lcom/intellij/openapi/project/Project;", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "listRemoteState", "Lcom/intellij/openapi/vcs/changes/ui/ChangeListRemoteState;", "aiChangeListsData", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIChangeListsGroupedDiffData;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/LocalChangeList;Lcom/intellij/openapi/vcs/changes/ui/ChangeListRemoteState;Lcom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIChangeListsGroupedDiffData;)V", "getAiChangeListsData", "()Lcom/intellij/ml/llm/vcs/diff/groupedDiff/commit/AIChangeListsGroupedDiffData;", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "getImportanceFor", "", "list", "(Lcom/intellij/openapi/vcs/changes/LocalChangeList;)Ljava/lang/Double;", "compareUserObjects", "", "o2", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "intellij.ml.llm.vcs.diff"})
public final class AiChangeListNode
extends ChangesBrowserChangeListNode {
    @NotNull
    private final LocalChangeList changeList;
    @NotNull
    private final AIChangeListsGroupedDiffData aiChangeListsData;

    public AiChangeListNode(@NotNull Project project2, @NotNull LocalChangeList changeList, @NotNull ChangeListRemoteState listRemoteState, @NotNull AIChangeListsGroupedDiffData aiChangeListsData) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        Intrinsics.checkNotNullParameter((Object)listRemoteState, (String)"listRemoteState");
        Intrinsics.checkNotNullParameter((Object)aiChangeListsData, (String)"aiChangeListsData");
        super(project2, (ChangeList)changeList, listRemoteState);
        this.changeList = changeList;
        this.aiChangeListsData = aiChangeListsData;
    }

    @NotNull
    public final AIChangeListsGroupedDiffData getAiChangeListsData() {
        return this.aiChangeListsData;
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
        super.render(renderer2, selected, expanded, hasFocus);
        ChangesGroup changesGroup = this.aiChangeListsData.getGroups().get(this.changeList.getId());
        Double importance = changesGroup != null ? Double.valueOf(changesGroup.getImportance()) : null;
        Icon icon2 = ChangesGroupKt.getIconByImportance(importance);
        renderer2.setIcon(icon2);
    }

    private final Double getImportanceFor(LocalChangeList list) {
        ChangesGroup changesGroup = this.aiChangeListsData.getGroups().get(list.getId());
        return changesGroup != null ? Double.valueOf(changesGroup.getImportance()) : null;
    }

    public int compareUserObjects(@NotNull ChangeList o2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        Object l1 = this.userObject;
        if (l1 instanceof LocalChangeList && o2 instanceof LocalChangeList) {
            int byWeight;
            Double w1 = this.getImportanceFor((LocalChangeList)l1);
            Double w2 = this.getImportanceFor((LocalChangeList)o2);
            if (w1 != null && w2 != null && (byWeight = -Double.compare(w1, w2)) != 0) {
                return byWeight;
            }
        }
        return super.compareUserObjects(o2);
    }
}

