/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.ignoreFile;

import com.intellij.ml.llm.codeGeneration.popup.AICodeGenerationPopupUtils;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.vcs.LLMVcsBundle;
import com.intellij.ml.llm.vcs.context.ignoreFile.IgnoreFileAiGenerationService;
import com.intellij.ml.llm.vcs.ignoreFile.IgnoreFileAiGenerationUsagesCollector;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/vcs/ignoreFile/IgnoreFileAiGenerationNotificationPanel;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "onGenerateButtonClicked", "", "ignoreFile", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "onDismissPanelClicked", "updateNotification", "intellij.ml.llm.vcs"})
@SourceDebugExtension(value={"SMAP\nIgnoreFileAiGenerationNotificationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IgnoreFileAiGenerationNotificationPanel.kt\ncom/intellij/ml/llm/vcs/ignoreFile/IgnoreFileAiGenerationNotificationPanel\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,81:1\n30#2,2:82\n30#2,2:84\n30#2,2:86\n*S KotlinDebug\n*F\n+ 1 IgnoreFileAiGenerationNotificationPanel.kt\ncom/intellij/ml/llm/vcs/ignoreFile/IgnoreFileAiGenerationNotificationPanel\n*L\n58#1:82,2\n73#1:84,2\n32#1:86,2\n*E\n"})
public final class IgnoreFileAiGenerationNotificationPanel
implements EditorNotificationProvider {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project2, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Registry.Companion.get("vcs.ignore.file.ai.generation.enabled").asBoolean()) {
            return null;
        }
        if (!(file.getFileType() instanceof IgnoreFileType)) {
            return null;
        }
        return arg_0 -> IgnoreFileAiGenerationNotificationPanel.collectNotificationData$lambda$0(file, project2, this, arg_0);
    }

    private final void onGenerateButtonClicked(Project project2, VirtualFile ignoreFile, EditorEx editor2) {
        this.updateNotification(project2);
        IgnoreFileAiGenerationUsagesCollector.INSTANCE.onNotificationGenerationInvoked(ignoreFile);
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<IgnoreFileAiGenerationService> serviceClass$iv = IgnoreFileAiGenerationService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((IgnoreFileAiGenerationService)object).invokeInEditorCodeGeneration(ignoreFile, editor2, (Function0<Unit>)((Function0)() -> IgnoreFileAiGenerationNotificationPanel.onGenerateButtonClicked$lambda$0(ignoreFile)), (Function0<Unit>)((Function0)() -> IgnoreFileAiGenerationNotificationPanel.onGenerateButtonClicked$lambda$1(ignoreFile, this, project2)));
    }

    private final void onDismissPanelClicked(Project project2, VirtualFile file) {
        IgnoreFileAiGenerationUsagesCollector.INSTANCE.onNotificationDismissed(file);
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<IgnoreFileAiGenerationService> serviceClass$iv = IgnoreFileAiGenerationService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((IgnoreFileAiGenerationService)object).hideNotificationsForFile(file);
        this.updateNotification(project2);
    }

    private final void updateNotification(Project project2) {
        EditorNotifications.getInstance((Project)project2).removeNotificationsForProvider((EditorNotificationProvider)this);
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$0(VirtualFile $file, Project $project, IgnoreFileAiGenerationNotificationPanel this$0, FileEditor editor2) {
        EditorNotificationPanel editorNotificationPanel;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!(editor2 instanceof TextEditorImpl)) {
            return null;
        }
        if ($file.getLength() > 0L) {
            return null;
        }
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<IgnoreFileAiGenerationService> serviceClass$iv = IgnoreFileAiGenerationService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        if (!((IgnoreFileAiGenerationService)object).isNotificationsAllowed($file)) {
            return null;
        }
        if (AICodeGenerationPopupUtils.INSTANCE.getActivePromptInCode((Editor)((TextEditorImpl)editor2).getEditor()) != null) {
            return null;
        }
        if (PrivacyPathCheckerKt.isAiIgnoreBlocked($project, $file)) {
            return null;
        }
        EditorNotificationPanel $this$collectNotificationData_u24lambda_u240_u240 = editorNotificationPanel = new EditorNotificationPanel(EditorNotificationPanel.Status.Info);
        boolean bl = false;
        HyperlinkLabel hyperlinkLabel = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)$file.getName(), (String)"getName(...)");
        $this$collectNotificationData_u24lambda_u240_u240.setText(LLMVcsBundle.message("ignore.file.ai.generation.notification.title", (Object[])hyperlinkLabel));
        $this$collectNotificationData_u24lambda_u240_u240.createActionLabel(LLMVcsBundle.message("ignore.file.ai.generation.action.generate.label", new Object[0]), () -> IgnoreFileAiGenerationNotificationPanel.collectNotificationData$lambda$0$0$0(this$0, $project, $file, editor2));
        HyperlinkLabel $this$collectNotificationData_u24lambda_u240_u240_u242 = hyperlinkLabel = $this$collectNotificationData_u24lambda_u240_u240.createActionLabel(LLMVcsBundle.message("ignore.file.ai.generation.action.dismiss.label", new Object[0]), () -> IgnoreFileAiGenerationNotificationPanel.collectNotificationData$lambda$0$0$1(this$0, $project, $file));
        boolean bl2 = false;
        $this$collectNotificationData_u24lambda_u240_u240_u242.setToolTipText(LLMVcsBundle.message("ignore.file.ai.generation.action.dismiss.tooltip", new Object[0]));
        return editorNotificationPanel;
    }

    private static final void collectNotificationData$lambda$0$0$0(IgnoreFileAiGenerationNotificationPanel this$0, Project $project, VirtualFile $file, FileEditor $editor) {
        this$0.onGenerateButtonClicked($project, $file, ((TextEditorImpl)$editor).getEditor());
    }

    private static final void collectNotificationData$lambda$0$0$1(IgnoreFileAiGenerationNotificationPanel this$0, Project $project, VirtualFile $file) {
        this$0.onDismissPanelClicked($project, $file);
    }

    private static final Unit onGenerateButtonClicked$lambda$0(VirtualFile $ignoreFile) {
        IgnoreFileAiGenerationUsagesCollector.INSTANCE.onGenerationDiscarded($ignoreFile);
        return Unit.INSTANCE;
    }

    private static final Unit onGenerateButtonClicked$lambda$1(VirtualFile $ignoreFile, IgnoreFileAiGenerationNotificationPanel this$0, Project $project) {
        IgnoreFileAiGenerationUsagesCollector.INSTANCE.onGenerationAccepted($ignoreFile);
        this$0.updateNotification($project);
        return Unit.INSTANCE;
    }
}

