/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.metrics;

import com.intellij.ml.llm.persistenceBasedMetrics.services.PersistenceMetricsCalculationService;
import com.intellij.ml.llm.vcs.metrics.CMGMetricsManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.UrlFilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CommitCheck;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/vcs/metrics/CMGMetricsCommitHandler;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "Lcom/intellij/openapi/vcs/checkin/CommitCheck;", "Lcom/intellij/openapi/project/DumbAware;", "commitMessagePanel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "<init>", "(Lcom/intellij/openapi/vcs/CheckinProjectPanel;)V", "getExecutionOrder", "Lcom/intellij/openapi/vcs/checkin/CommitCheck$ExecutionOrder;", "isEnabled", "", "runCheck", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "(Lcom/intellij/openapi/vcs/checkin/CommitInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.vcs"})
@SourceDebugExtension(value={"SMAP\nCMGMetricsCommitHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMGMetricsCommitHandler.kt\ncom/intellij/ml/llm/vcs/metrics/CMGMetricsCommitHandler\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,33:1\n30#2,2:34\n30#2,2:38\n1869#3:36\n1870#3:40\n1#4:37\n*S KotlinDebug\n*F\n+ 1 CMGMetricsCommitHandler.kt\ncom/intellij/ml/llm/vcs/metrics/CMGMetricsCommitHandler\n*L\n25#1:34,2\n27#1:38,2\n26#1:36\n26#1:40\n*E\n"})
public final class CMGMetricsCommitHandler
extends CheckinHandler
implements CommitCheck,
DumbAware {
    @NotNull
    private final CheckinProjectPanel commitMessagePanel;

    public CMGMetricsCommitHandler(@NotNull CheckinProjectPanel commitMessagePanel) {
        Intrinsics.checkNotNullParameter((Object)commitMessagePanel, (String)"commitMessagePanel");
        this.commitMessagePanel = commitMessagePanel;
    }

    @NotNull
    public CommitCheck.ExecutionOrder getExecutionOrder() {
        return CommitCheck.ExecutionOrder.EARLY;
    }

    public boolean isEnabled() {
        return true;
    }

    @Nullable
    public Object runCheck(@NotNull CommitInfo commitInfo, @NotNull Continuation<? super CommitProblem> $completion) {
        Project project2 = this.commitMessagePanel.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        ComponentManager $this$service$iv = (ComponentManager)project3;
        boolean $i$f$service = false;
        Class<CMGMetricsManager> serviceClass$iv = CMGMetricsManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        CMGMetricsManager metricsTracker = (CMGMetricsManager)object;
        Iterable $this$forEach$iv = commitInfo.getCommittedChanges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file;
            Change it = (Change)element$iv;
            boolean bl = false;
            if (it.getVirtualFile() == null) continue;
            boolean bl2 = false;
            ComponentManager $this$service$iv2 = (ComponentManager)project3;
            boolean $i$f$service2 = false;
            Class<PersistenceMetricsCalculationService> serviceClass$iv2 = PersistenceMetricsCalculationService.class;
            Object object2 = $this$service$iv2.getService(serviceClass$iv2);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
            }
            ((PersistenceMetricsCalculationService)object2).notifyFileCommitted(new UrlFilePath(file));
        }
        String string = this.commitMessagePanel.getCommitMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommitMessage(...)");
        String submittedCommitMessage = string;
        Collection collection = this.commitMessagePanel.getSelectedChanges();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSelectedChanges(...)");
        metricsTracker.finishCalculation(submittedCommitMessage, CollectionsKt.toList((Iterable)collection));
        return null;
    }
}

