/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.selfReview.agent;

import com.intellij.ml.llm.vcs.selfReview.agent.BatchedChangesIterator;
import com.intellij.ml.llm.vcs.selfReview.agent.ChangesIterator;
import com.intellij.ml.llm.vcs.selfReview.agent.VcsAISelfReviewUtilsKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.Change;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/BatchedChangesIteratorImpl;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/BatchedChangesIterator;", "underlyingIterator", "Lcom/intellij/ml/llm/vcs/selfReview/agent/ChangesIterator;", "maxBatchSizeBytes", "", "maxFilesPerBatch", "<init>", "(Lcom/intellij/ml/llm/vcs/selfReview/agent/ChangesIterator;II)V", "dataQueue", "Lkotlin/collections/ArrayDeque;", "", "Lcom/intellij/openapi/vcs/changes/Change;", "processedCount", "totalCount", "getTotalCount", "()I", "hasNext", "", "next", "fillQueue", "", "Companion", "intellij.ml.llm.vcs"})
public final class BatchedChangesIteratorImpl
implements BatchedChangesIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChangesIterator underlyingIterator;
    private final int maxBatchSizeBytes;
    private final int maxFilesPerBatch;
    @NotNull
    private final ArrayDeque<Collection<Change>> dataQueue;
    private int processedCount;
    private final int totalCount;
    public static final int DEFAULT_MAX_BATCH_SIZE_BYTES = 102400;
    public static final int DEFAULT_MAX_FILES_PER_BATCH = 1;

    public BatchedChangesIteratorImpl(@NotNull ChangesIterator underlyingIterator, int maxBatchSizeBytes, int maxFilesPerBatch) {
        Intrinsics.checkNotNullParameter((Object)underlyingIterator, (String)"underlyingIterator");
        this.underlyingIterator = underlyingIterator;
        this.maxBatchSizeBytes = maxBatchSizeBytes;
        this.maxFilesPerBatch = maxFilesPerBatch;
        this.dataQueue = new ArrayDeque();
        this.totalCount = this.underlyingIterator.getTotalCount();
    }

    public /* synthetic */ BatchedChangesIteratorImpl(ChangesIterator changesIterator, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = Companion.defaultMaxBatchSizeBytes$intellij_ml_llm_vcs();
        }
        if ((n3 & 4) != 0) {
            n2 = Companion.defaultMaxFilesPerBatch$intellij_ml_llm_vcs();
        }
        this(changesIterator, n, n2);
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public boolean hasNext() {
        return !((Collection)this.dataQueue).isEmpty() || this.underlyingIterator.hasNext();
    }

    @Override
    @NotNull
    public Collection<Change> next() {
        if (!this.hasNext()) {
            return CollectionsKt.emptyList();
        }
        if (this.dataQueue.isEmpty()) {
            this.fillQueue();
        }
        if (this.dataQueue.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int n = this.processedCount;
        this.processedCount = n + 1;
        Collection data2 = (Collection)this.dataQueue.removeFirst();
        return data2;
    }

    private final void fillQueue() {
        int currentBatchSize = 0;
        int filesInBatch = 0;
        List batchedChanges = new ArrayList();
        while (this.underlyingIterator.hasNext() && currentBatchSize < this.maxBatchSizeBytes && filesInBatch < this.maxFilesPerBatch) {
            Change change = this.underlyingIterator.next();
            if (change == null) continue;
            int contentSize = VcsAISelfReviewUtilsKt.getRevisionsSize(change);
            if (currentBatchSize > 0 && currentBatchSize + contentSize > this.maxBatchSizeBytes) {
                this.dataQueue.add((Object)CollectionsKt.toList((Iterable)batchedChanges));
                batchedChanges.clear();
                batchedChanges.add(change);
                currentBatchSize = contentSize;
                filesInBatch = 1;
                continue;
            }
            batchedChanges.add(change);
            currentBatchSize += contentSize;
            ++filesInBatch;
        }
        if (!((Collection)batchedChanges).isEmpty()) {
            this.dataQueue.add((Object)CollectionsKt.toList((Iterable)batchedChanges));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\bJ\r\u0010\t\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/BatchedChangesIteratorImpl$Companion;", "", "<init>", "()V", "DEFAULT_MAX_BATCH_SIZE_BYTES", "", "DEFAULT_MAX_FILES_PER_BATCH", "defaultMaxBatchSizeBytes", "defaultMaxBatchSizeBytes$intellij_ml_llm_vcs", "defaultMaxFilesPerBatch", "defaultMaxFilesPerBatch$intellij_ml_llm_vcs", "intellij.ml.llm.vcs"})
    public static final class Companion {
        private Companion() {
        }

        public final int defaultMaxBatchSizeBytes$intellij_ml_llm_vcs() {
            int value2 = Registry.Companion.intValue("vcs.llm.self.review.agent.max.batch.size.kilobytes") * 1024;
            return value2 > 0 ? value2 : 102400;
        }

        public final int defaultMaxFilesPerBatch$intellij_ml_llm_vcs() {
            int value2 = Registry.Companion.intValue("vcs.llm.self.review.agent.max.files.per.batch");
            return value2 > 0 ? value2 : 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

