/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.selfReview.agent.ideformer.tools;

import ai.grazie.code.agents.core.tools.Tool;
import ai.grazie.code.agents.core.tools.ToolDescriptor;
import ai.grazie.code.agents.core.tools.ToolParameterDescriptor;
import ai.grazie.code.agents.core.tools.ToolParameterType;
import ai.grazie.code.agents.core.tools.ToolResult;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.vcs.ContentRevisionPrivacyWrapper;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.vcs.selfReview.agent.ChangeDescriptor;
import com.intellij.ml.llm.vcs.selfReview.agent.ChangeDescriptor$;
import com.intellij.ml.llm.vcs.selfReview.agent.ChangesChunksDescriptor;
import com.intellij.ml.llm.vcs.selfReview.agent.ChangesChunksDescriptor$;
import com.intellij.ml.llm.vcs.selfReview.agent.VcsAISelfReviewUtilsKt;
import com.intellij.ml.llm.vcs.selfReview.agent.ideformer.tools.GetFileDiffTool$Args$;
import com.intellij.ml.llm.vcs.selfReview.agent.ideformer.tools.GetFileDiffTool$Response$;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0019\u001aB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0002H\u0094@\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/ideformer/tools/GetFileDiffTool;", "Lai/grazie/code/agents/core/tools/Tool;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/ideformer/tools/GetFileDiffTool$Args;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/ideformer/tools/GetFileDiffTool$Response;", "project", "Lcom/intellij/openapi/project/Project;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "argsSerializer", "Lkotlinx/serialization/KSerializer;", "getArgsSerializer", "()Lkotlinx/serialization/KSerializer;", "descriptor", "Lai/grazie/code/agents/core/tools/ToolDescriptor;", "getDescriptor", "()Lai/grazie/code/agents/core/tools/ToolDescriptor;", "projectRoot", "Ljava/nio/file/Path;", "Lorg/jetbrains/annotations/NotNull;", "execute", "args", "(Lcom/intellij/ml/llm/vcs/selfReview/agent/ideformer/tools/GetFileDiffTool$Args;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Response", "Args", "intellij.ml.llm.vcs"})
@SourceDebugExtension(value={"SMAP\nGetFileDiffTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetFileDiffTool.kt\ncom/intellij/ml/llm/vcs/selfReview/agent/ideformer/tools/GetFileDiffTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1563#2:98\n1634#2,3:99\n*S KotlinDebug\n*F\n+ 1 GetFileDiffTool.kt\ncom/intellij/ml/llm/vcs/selfReview/agent/ideformer/tools/GetFileDiffTool\n*L\n77#1:98\n77#1:99,3\n*E\n"})
public final class GetFileDiffTool
extends Tool<Args, Response> {
    @NotNull
    private final Project project;
    @NotNull
    private final List<Change> changes;
    @NotNull
    private final KSerializer<Args> argsSerializer;
    @NotNull
    private final ToolDescriptor descriptor;
    @NotNull
    private final Path projectRoot;

    public GetFileDiffTool(@NotNull Project project2, @NotNull List<? extends Change> changes2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(changes2, (String)"changes");
        this.project = project2;
        this.changes = changes2;
        this.argsSerializer = Args.Companion.serializer();
        this.descriptor = new ToolDescriptor("get-file-diff", "When called, returns a representation of the differences between the version of the file before the changes and the version of the file after the changes.\nThe diff will not contain the whole file, only those parts that were changed and a few unchanged lines around those changes, if applicable.\nOnly those files listed by 'list-review-changes' will be considered for this tool.", CollectionsKt.listOf((Object)new ToolParameterDescriptor("path", "The path of the file as returned by list-review-changes.", (ToolParameterType)ToolParameterType.String.INSTANCE)), CollectionsKt.emptyList());
        VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)this.project);
        Intrinsics.checkNotNull((Object)virtualFile2);
        Path path = virtualFile2.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        this.projectRoot = path;
    }

    @NotNull
    public KSerializer<Args> getArgsSerializer() {
        return this.argsSerializer;
    }

    @NotNull
    public ToolDescriptor getDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Object execute(@NotNull Args args, @NotNull Continuation<? super Response> $completion) {
        List list;
        Object object;
        Object contentBeforeLines;
        Change change = VcsAISelfReviewUtilsKt.findChangeByRelativePath(this.changes, this.projectRoot, args.getPath());
        if (change == null) {
            throw new IllegalArgumentException("Could not find change: '" + args.getPath() + "'");
        }
        List list2 = IdeaTextPatchBuilder.buildPatch((Project)this.project, (Collection)CollectionsKt.listOf((Object)change), (Path)this.projectRoot, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"buildPatch(...)");
        List patches = list2;
        if (patches.isEmpty()) {
            throw new IllegalArgumentException("Internal error: Could not create diff patch, do not try again for path: '" + args.getPath() + "'.");
        }
        FilePatch patch = (FilePatch)CollectionsKt.first((List)patches);
        Object object2 = ExtensionsKtKt.privacySafe(change, this.project).getBeforeRevision();
        if (object2 == null || (object2 = object2.getContent()) == null || (object2 = object2.lines()) == null) {
            object2 = contentBeforeLines = CollectionsKt.emptyList();
        }
        if ((object = ExtensionsKtKt.privacySafe(change, this.project).getAfterRevision()) == null || (object = object.getContent()) == null || (object = object.lines()) == null) {
            object = CollectionsKt.emptyList();
        }
        ContentRevisionPrivacyWrapper contentAfterLines = object;
        boolean sendBeforeAndAfterLines = Registry.Companion.is("llm.self.review.send.before.and.after.content");
        ChangeDescriptor changeDescriptor = VcsAISelfReviewUtilsKt.toChangeDescriptor(change, this.projectRoot);
        boolean bl = patch instanceof BinaryFilePatch || patch instanceof ShelvedBinaryFilePatch;
        if (!(patch instanceof TextFilePatch)) {
            list = CollectionsKt.emptyList();
        } else {
            Collection<ChangesChunksDescriptor> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list3 = ((TextFilePatch)patch).getHunks();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getHunks(...)");
            Iterable iterable = list3;
            boolean bl2 = bl;
            ChangeDescriptor changeDescriptor2 = changeDescriptor;
            boolean $i$f$map = false;
            void var11_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void chunk;
                PatchHunk patchHunk = (PatchHunk)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                String contentBefore = chunk.getStartLineBefore() != -1 && chunk.getStartLineAfter() != -1 ? (String)PSStringKt.joinToString$default((Iterable)contentBeforeLines.subList(chunk.getStartLineBefore(), chunk.getEndLineBefore()), (PrivacySafe)((PrivacySafe)ConstantsKt.getNL()), null, null, (int)0, null, (int)30, null).unwrap() : "";
                String contentAfter = chunk.getEndLineBefore() != -1 && chunk.getEndLineAfter() != -1 ? (String)PSStringKt.joinToString$default((Iterable)contentAfterLines.subList(chunk.getStartLineAfter(), chunk.getEndLineAfter()), (PrivacySafe)((PrivacySafe)ConstantsKt.getNL()), null, null, (int)0, null, (int)30, null).unwrap() : "";
                collection.add(new ChangesChunksDescriptor(chunk.getStartLineBefore(), chunk.getEndLineBefore(), sendBeforeAndAfterLines ? contentBefore : null, chunk.getStartLineAfter(), chunk.getEndLineAfter(), sendBeforeAndAfterLines ? contentAfter : null));
            }
            collection = (List)destination$iv$iv;
            changeDescriptor = changeDescriptor2;
            bl = bl2;
            list = collection;
        }
        List list4 = list;
        boolean bl4 = bl;
        ChangeDescriptor changeDescriptor3 = changeDescriptor;
        return new Response(changeDescriptor3, bl4, list4);
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/ideformer/tools/GetFileDiffTool$Args;", "Lai/grazie/code/agents/core/tools/Tool$Args;", "path", "", "<init>", "(Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getPath", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_ml_llm_vcs", "$serializer", "Companion", "intellij.ml.llm.vcs"})
    public static final class Args
    implements Tool.Args {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String path;

        public Args(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final Args copy(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new Args(path);
        }

        public static /* synthetic */ Args copy$default(Args args, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = args.path;
            }
            return args.copy(string);
        }

        @NotNull
        public String toString() {
            return "Args(path=" + this.path + ")";
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            return Intrinsics.areEqual((Object)this.path, (Object)args.path);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_ml_llm_vcs(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.path);
        }

        public /* synthetic */ Args(int seen0, String path, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.path = path;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/ideformer/tools/GetFileDiffTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/ideformer/tools/GetFileDiffTool$Args;", "intellij.ml.llm.vcs"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002)*B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nB=\b\u0010\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\t\u0010\u000fJ\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\fH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J%\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0001\u00a2\u0006\u0002\b(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006+"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/ideformer/tools/GetFileDiffTool$Response;", "Lai/grazie/code/agents/core/tools/ToolResult$JSONSerializable;", "change", "Lcom/intellij/ml/llm/vcs/selfReview/agent/ChangeDescriptor;", "isBinary", "", "changes", "", "Lcom/intellij/ml/llm/vcs/selfReview/agent/ChangesChunksDescriptor;", "<init>", "(Lcom/intellij/ml/llm/vcs/selfReview/agent/ChangeDescriptor;ZLjava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILcom/intellij/ml/llm/vcs/selfReview/agent/ChangeDescriptor;ZLjava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getChange", "()Lcom/intellij/ml/llm/vcs/selfReview/agent/ChangeDescriptor;", "()Z", "getChanges", "()Ljava/util/List;", "getSerializer", "Lkotlinx/serialization/KSerializer;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_ml_llm_vcs", "$serializer", "Companion", "intellij.ml.llm.vcs"})
    public static final class Response
    implements ToolResult.JSONSerializable<Response> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ChangeDescriptor change;
        private final boolean isBinary;
        @NotNull
        private final List<ChangesChunksDescriptor> changes;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public Response(@NotNull ChangeDescriptor change, boolean isBinary, @NotNull List<ChangesChunksDescriptor> changes2) {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            Intrinsics.checkNotNullParameter(changes2, (String)"changes");
            this.change = change;
            this.isBinary = isBinary;
            this.changes = changes2;
        }

        @NotNull
        public final ChangeDescriptor getChange() {
            return this.change;
        }

        public final boolean isBinary() {
            return this.isBinary;
        }

        @NotNull
        public final List<ChangesChunksDescriptor> getChanges() {
            return this.changes;
        }

        @NotNull
        public KSerializer<Response> getSerializer() {
            return Companion.serializer();
        }

        @NotNull
        public final ChangeDescriptor component1() {
            return this.change;
        }

        public final boolean component2() {
            return this.isBinary;
        }

        @NotNull
        public final List<ChangesChunksDescriptor> component3() {
            return this.changes;
        }

        @NotNull
        public final Response copy(@NotNull ChangeDescriptor change, boolean isBinary, @NotNull List<ChangesChunksDescriptor> changes2) {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            Intrinsics.checkNotNullParameter(changes2, (String)"changes");
            return new Response(change, isBinary, changes2);
        }

        public static /* synthetic */ Response copy$default(Response response2, ChangeDescriptor changeDescriptor, boolean bl, List list, int n, Object object) {
            if ((n & 1) != 0) {
                changeDescriptor = response2.change;
            }
            if ((n & 2) != 0) {
                bl = response2.isBinary;
            }
            if ((n & 4) != 0) {
                list = response2.changes;
            }
            return response2.copy(changeDescriptor, bl, list);
        }

        @NotNull
        public String toString() {
            return "Response(change=" + this.change + ", isBinary=" + this.isBinary + ", changes=" + this.changes + ")";
        }

        public int hashCode() {
            int result2 = this.change.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isBinary);
            result2 = result2 * 31 + ((Object)this.changes).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Response)) {
                return false;
            }
            Response response2 = (Response)other;
            if (!Intrinsics.areEqual((Object)this.change, (Object)response2.change)) {
                return false;
            }
            if (this.isBinary != response2.isBinary) {
                return false;
            }
            return Intrinsics.areEqual(this.changes, response2.changes);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_ml_llm_vcs(Response self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)ChangeDescriptor$.serializer.INSTANCE, (Object)self.change);
            output.encodeBooleanElement(serialDesc, 1, self.isBinary);
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)lazyArray[2].getValue(), self.changes);
        }

        public /* synthetic */ Response(int seen0, ChangeDescriptor change, boolean isBinary, List changes2, SerializationConstructorMarker serializationConstructorMarker) {
            if (7 != (7 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)Response$$serializer.INSTANCE.getDescriptor());
            }
            this.change = change;
            this.isBinary = isBinary;
            this.changes = changes2;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)ChangesChunksDescriptor$.serializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/ideformer/tools/GetFileDiffTool$Response$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/vcs/selfReview/agent/ideformer/tools/GetFileDiffTool$Response;", "intellij.ml.llm.vcs"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Response> serializer() {
                return (KSerializer)Response$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

