/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.selfReview.ui;

import com.intellij.collaboration.ui.HtmlEditorPaneUtilKt;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ml.llm.vcs.selfReview.ui.MarkdownToHtmlConverter;
import com.intellij.ml.llm.vcs.selfReview.ui.VcsAISelfReviewDescriptionNode;
import com.intellij.ml.llm.vcs.selfReview.ui.VcsAISelfReviewFeedbackNode;
import com.intellij.ml.llm.vcs.selfReview.ui.VcsAISelfReviewTreeCellRenderer;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.components.JBHtmlPane;
import com.intellij.ui.components.JBHtmlPaneConfiguration;
import com.intellij.ui.components.JBHtmlPaneStyleConfiguration;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000S\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ@\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J,\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/ui/VcsAISelfReviewTreeCellRenderer;", "Ljavax/swing/tree/TreeCellRenderer;", "<init>", "()V", "baseCellRenderer", "com/intellij/ml/llm/vcs/selfReview/ui/VcsAISelfReviewTreeCellRenderer$baseCellRenderer$1", "Lcom/intellij/ml/llm/vcs/selfReview/ui/VcsAISelfReviewTreeCellRenderer$baseCellRenderer$1;", "markdownToHtmlConverter", "Lcom/intellij/ml/llm/vcs/selfReview/ui/MarkdownToHtmlConverter;", "setupIteractiveHTMLContentSupport", "", "tree", "Ljavax/swing/JTree;", "getTreeCellRendererComponent", "Ljava/awt/Component;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "softWrapSingleLineDescription", "Lkotlin/Pair;", "", "description", "htmlPane", "Lcom/intellij/ui/components/JBHtmlPane;", "intellij.ml.llm.vcs"})
public final class VcsAISelfReviewTreeCellRenderer
implements TreeCellRenderer {
    @NotNull
    private final baseCellRenderer.1 baseCellRenderer = new NodeRenderer(){

        public int getMinHeight() {
            return super.getMinHeight();
        }
    };
    @NotNull
    private final MarkdownToHtmlConverter markdownToHtmlConverter = new MarkdownToHtmlConverter();

    public final void setupIteractiveHTMLContentSupport(@NotNull JTree tree2) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        if (!Registry.Companion.is("vcs.self.review.allow.interactive.elements.in.problem.description.renderer", true)) {
            return;
        }
        MouseAdapter mouseListener2 = new MouseAdapter(tree2, this){
            private final Cursor initialTreeCursor;
            private JComponent lastRendererComponent;
            final /* synthetic */ JTree $tree;
            final /* synthetic */ VcsAISelfReviewTreeCellRenderer this$0;
            {
                this.$tree = $tree;
                this.this$0 = $receiver;
                this.initialTreeCursor = $tree.getCursor();
            }

            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.dispatchToRenderedComponent(this.$tree, e);
            }

            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.restoreCursor();
            }

            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.dispatchToRenderedComponent(this.$tree, e);
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.dispatchToRenderedComponent(this.$tree, e);
            }

            private final void dispatchToRenderedComponent(JTree tree2, MouseEvent e) {
                int row = tree2.getRowForLocation(e.getX(), e.getY());
                if (row < 0) {
                    return;
                }
                TreePath path = tree2.getPathForRow(row);
                Object node = path.getLastPathComponent();
                Rectangle rectangle = tree2.getPathBounds(path);
                if (rectangle == null) {
                    return;
                }
                Rectangle bounds = rectangle;
                Intrinsics.checkNotNull((Object)node);
                Component rendererComponent = this.this$0.getTreeCellRendererComponent(tree2, node, tree2.isRowSelected(row), tree2.isExpanded(row), tree2.getModel().isLeaf(node), row, false);
                if (!(rendererComponent instanceof JComponent)) {
                    this.restoreCursor();
                    return;
                }
                int x = e.getX() - bounds.x;
                int y = e.getY() - bounds.y;
                MouseEvent convertedEvent = new MouseEvent(rendererComponent, e.getID(), e.getWhen(), e.getModifiersEx(), x, y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                if (rendererComponent instanceof JEditorPane) {
                    ((JEditorPane)rendererComponent).addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
                }
                JBIterable jBIterable = UIUtil.uiTraverser((Component)rendererComponent).filter(ActionButton.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                Iterable $this$forEach$iv = (Iterable)jBIterable;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    AnActionEvent event2;
                    ActionButton button2 = (ActionButton)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)AnActionEvent.createEvent((DataContext)ActionToolbar.getDataContextFor((Component)((Component)button2)), (Presentation)button2.getPresentation(), (String)"VcsAISelfReview", (ActionUiKind)ActionUiKind.NONE, (InputEvent)convertedEvent), (String)"createEvent(...)");
                    AnAction anAction = button2.getAction();
                    Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getAction(...)");
                    ActionUtil.updateAction((AnAction)anAction, (AnActionEvent)event2);
                }
                rendererComponent.dispatchEvent(convertedEvent);
                if (e.getID() == 503) {
                    tree2.setCursor(((JComponent)rendererComponent).getCursor());
                    this.lastRendererComponent = (JComponent)rendererComponent;
                }
            }

            private final void restoreCursor() {
                this.$tree.setCursor(this.initialTreeCursor);
                this.lastRendererComponent = null;
            }
        };
        tree2.addMouseListener(mouseListener2);
        tree2.addMouseMotionListener(mouseListener2);
    }

    @Override
    @NotNull
    public Component getTreeCellRendererComponent(@NotNull JTree tree2, @NotNull Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component component2;
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        if (object instanceof VcsAISelfReviewFeedbackNode) {
            Component component3 = tree2.getCellEditor().getTreeCellEditorComponent(tree2, value2, selected, expanded, leaf, row);
            component2 = component3;
            Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"getTreeCellEditorComponent(...)");
        } else if (!(object instanceof VcsAISelfReviewDescriptionNode)) {
            Component component4 = this.baseCellRenderer.getTreeCellRendererComponent(tree2, value2, selected, expanded, leaf, row, hasFocus);
            Intrinsics.checkNotNull((Object)component4);
            component2 = component4;
        } else {
            JBHtmlPane jBHtmlPane;
            JBHtmlPane $this$getTreeCellRendererComponent_u24lambda_u240 = jBHtmlPane = new JBHtmlPane(JBHtmlPaneStyleConfiguration.Companion.builder().editorInlineContext(true).build(), JBHtmlPaneConfiguration.Companion.builder().customStyleSheet("pre {white-space: pre-wrap}").build());
            boolean bl = false;
            $this$getTreeCellRendererComponent_u24lambda_u240.setEditable(false);
            $this$getTreeCellRendererComponent_u24lambda_u240.setOpaque(false);
            $this$getTreeCellRendererComponent_u24lambda_u240.setForeground(UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus));
            $this$getTreeCellRendererComponent_u24lambda_u240.setBackground(UIUtil.getTreeBackground((boolean)selected, (boolean)hasFocus));
            $this$getTreeCellRendererComponent_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)0, (int)10, (int)0, (int)20));
            AccessibleContextUtil.setName((Component)((Component)$this$getTreeCellRendererComponent_u24lambda_u240), (String)((VcsAISelfReviewDescriptionNode)((Object)value2)).getDescription$intellij_ml_llm_vcs());
            Pair<String, Integer> pair = this.softWrapSingleLineDescription(((VcsAISelfReviewDescriptionNode)((Object)value2)).getDescription$intellij_ml_llm_vcs(), $this$getTreeCellRendererComponent_u24lambda_u240, tree2);
            String softWrappedDescription = (String)pair.component1();
            int softWrappedTextHeight = ((Number)pair.component2()).intValue();
            Project project2 = ((VcsAISelfReviewDescriptionNode)((Object)value2)).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            String htmlContent = this.markdownToHtmlConverter.convertToHtml$intellij_ml_llm_vcs(project2, softWrappedDescription);
            HtmlEditorPaneUtilKt.setHtmlBody((JEditorPane)((JEditorPane)$this$getTreeCellRendererComponent_u24lambda_u240), (String)htmlContent);
            if (softWrappedTextHeight >= 0) {
                Dimension prefSize = $this$getTreeCellRendererComponent_u24lambda_u240.getPreferredSize();
                $this$getTreeCellRendererComponent_u24lambda_u240.setPreferredSize((Dimension)JBUI.size((int)prefSize.getSize().width, (int)Math.max(softWrappedTextHeight, prefSize.height)));
            }
            component2 = (Component)jBHtmlPane;
        }
        return component2;
    }

    private final Pair<String, Integer> softWrapSingleLineDescription(String description, JBHtmlPane htmlPane, JTree tree2) {
        Pair notWrappedDescription = TuplesKt.to((Object)description, (Object)-1);
        if (StringsKt.contains$default((CharSequence)description, (CharSequence)"\n", (boolean)false, (int)2, null)) {
            return notWrappedDescription;
        }
        FontMetrics metrics = htmlPane.getFontMetrics(htmlPane.getFont());
        int textWidth = metrics.stringWidth(description);
        int lineHeight = Math.max(this.baseCellRenderer.getMinHeight(), metrics.getHeight());
        int availableWidth = tree2.getVisibleRect().width - htmlPane.getInsets().left - htmlPane.getInsets().right;
        if (textWidth <= availableWidth) {
            return notWrappedDescription;
        }
        StringBuilder result2 = new StringBuilder();
        int currentWidth = 0;
        int currentPosition = 0;
        int softWrapCount = 0;
        int totalTextHeight = lineHeight;
        while (currentPosition < description.length()) {
            char c = description.charAt(currentPosition);
            int charWidth = metrics.charWidth(c);
            result2.append(c);
            if ((currentWidth += charWidth) + charWidth <= availableWidth || c != '.' || ++currentPosition >= description.length() || !CharsKt.isWhitespace((char)description.charAt(currentPosition))) continue;
            result2.append("<br/>");
            currentWidth = 0;
            ++softWrapCount;
            totalTextHeight += lineHeight;
            ++currentPosition;
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return TuplesKt.to((Object)string, (Object)JBUIScale.scale((int)(totalTextHeight + htmlPane.getInsets().top + htmlPane.getInsets().bottom)));
    }
}

