/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.voice;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.core.chat.session.ChatSessionVm;
import com.intellij.ml.llm.core.chat.ui.chat.input.toggle.AiChatToolbarControl;
import com.intellij.ml.llm.core.chat.ui.chat.input.toggle.AiChatToolbarToggleProvider;
import com.intellij.ml.llm.voice.RegistryKt;
import com.intellij.ml.llm.voice.VoiceService;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/voice/VoiceAutoTranslateToggleProvider;", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/toggle/AiChatToolbarToggleProvider;", "<init>", "()V", "getControl", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/toggle/AiChatToolbarControl;", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionVm;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "intellij.ml.llm.voice"})
public final class VoiceAutoTranslateToggleProvider
implements AiChatToolbarToggleProvider {
    @NotNull
    public AiChatToolbarControl getControl(@NotNull ChatSessionVm chatSession, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return (AiChatToolbarControl)new AiChatToolbarControl.Toggle(scope, chatSession){
            final /* synthetic */ ChatSessionVm $chatSession;
            {
                this.$chatSession = $chatSession;
                super($scope);
            }

            public String getToggleText() {
                return "Auto-Translate";
            }

            public Icon getIcon() {
                Icon icon2 = AllIcons.General.Language;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Language");
                return icon2;
            }

            public String getTooltip() {
                return "Translate transcriptions to English automatically";
            }

            public StateFlow<Boolean> getActivatedFlow() {
                return VoiceService.Companion.getInstance(this.$chatSession.getProject()).isAutoTranslateEnabledFlow();
            }

            public StateFlow<Boolean> isDisabled() {
                return (StateFlow)StateFlowKt.MutableStateFlow((Object)(!RegistryKt.isVoiceEnabled() ? 1 : 0));
            }

            public StateFlow<Boolean> isVisible() {
                return VoiceService.Companion.getInstance(this.$chatSession.getProject()).isActiveFlow();
            }

            public Object onClick(boolean currentState, Continuation<? super Unit> $completion) {
                VoiceService.Companion.getInstance(this.$chatSession.getProject()).setAutoTranslateEnabled(!currentState);
                return Unit.INSTANCE;
            }
        };
    }
}

