/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.yaml.inlinePromptDetector;

import com.intellij.lang.ASTNode;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptCustomDetector;
import com.intellij.ml.llm.inlinePromptDetector.PromptInitiatingWords;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J*\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\tH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0011H\u0002R\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u0011*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/yaml/inlinePromptDetector/YAMLInlinePromptDetector;", "Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptCustomDetector;", "<init>", "()V", "isApplicable", "", "file", "Lcom/intellij/psi/PsiFile;", "findInlinePrompts", "Lkotlin/sequences/Sequence;", "", "Lcom/intellij/openapi/util/TextRange;", "targetRanges", "findInlinePromptInRange", "range", "getFirstWord", "", "Lcom/intellij/lang/ASTNode;", "nextLeaf", "getNextLeaf", "(Lcom/intellij/lang/ASTNode;)Lcom/intellij/lang/ASTNode;", "intellij.ml.llm.yaml.inlinePromptDetector"})
@SourceDebugExtension(value={"SMAP\nYAMLInlinePromptDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAMLInlinePromptDetector.kt\ncom/intellij/ml/llm/yaml/inlinePromptDetector/YAMLInlinePromptDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class YAMLInlinePromptDetector
implements InlinePromptCustomDetector {
    public boolean isApplicable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof YAMLFile;
    }

    @NotNull
    public Sequence<List<TextRange>> findInlinePrompts(@NotNull PsiFile file, @NotNull Sequence<? extends TextRange> targetRanges) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(targetRanges, (String)"targetRanges");
        return SequencesKt.map(targetRanges, arg_0 -> YAMLInlinePromptDetector.findInlinePrompts$lambda$0(this, file, arg_0));
    }

    private final TextRange findInlinePromptInRange(PsiFile file, TextRange range) {
        CharSequence firstWord;
        ASTNode node;
        block7: {
            block9: {
                block8: {
                    block6: {
                        ASTNode leaf;
                        ASTNode aSTNode;
                        ProgressManager.checkCanceled();
                        ASTNode aSTNode2 = file.getNode().findLeafElementAt(range.getStartOffset());
                        if (aSTNode2 == null) {
                            return null;
                        }
                        ASTNode it = aSTNode = (leaf = aSTNode2);
                        boolean bl = false;
                        Object object = !Intrinsics.areEqual((Object)it.getElementType(), (Object)YAMLTokenTypes.INDENT) ? aSTNode : null;
                        if (object == null && (object = this.getNextLeaf(leaf)) == null) {
                            return null;
                        }
                        node = object;
                        if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)YAMLElementTypes.SCALAR_PLAIN_VALUE)) break block6;
                        ASTNode aSTNode3 = node.getTreeParent();
                        if (Intrinsics.areEqual((Object)(aSTNode3 != null ? aSTNode3.getElementType() : null), (Object)YAMLElementTypes.MAPPING)) break block7;
                    }
                    if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)YAMLElementTypes.SCALAR_PLAIN_VALUE)) break block8;
                    ASTNode aSTNode = node.getTreeParent();
                    if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)YAMLElementTypes.COMPOUND_VALUE)) break block7;
                }
                if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)YAMLTokenTypes.TEXT)) break block9;
                ASTNode aSTNode = node.getTreeParent();
                if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)YAMLElementTypes.SCALAR_PLAIN_VALUE)) break block7;
            }
            return null;
        }
        if ((firstWord = this.getFirstWord(node)) == null || !PromptInitiatingWords.INSTANCE.isPromptStartsWithInitiatingWord(((Object)firstWord).toString())) {
            return null;
        }
        return new TextRange(node.getStartOffset(), range.getEndOffset());
    }

    private final CharSequence getFirstWord(ASTNode $this$getFirstWord) {
        CharSequence charSequence;
        CharSequence charSequence2 = $this$getFirstWord.getChars();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getChars(...)");
        CharSequence chars = charSequence2;
        CharSequence trimmed = StringsKt.trimStart((CharSequence)chars);
        int spaceIndex = StringsKt.indexOf$default((CharSequence)trimmed, (char)' ', (int)0, (boolean)false, (int)6, null);
        if (spaceIndex < 0) {
            return null;
        }
        CharSequence it = charSequence = trimmed.subSequence(0, spaceIndex);
        boolean bl = false;
        return !StringsKt.isBlank((CharSequence)it) ? charSequence : null;
    }

    private final ASTNode getNextLeaf(ASTNode $this$nextLeaf) {
        ASTNode aSTNode = $this$nextLeaf.getTreeNext();
        if (aSTNode == null) {
            return null;
        }
        ASTNode cur = aSTNode;
        while (true) {
            if (cur.getFirstChildNode() != null) continue;
            return cur;
        }
    }

    private static final List findInlinePrompts$lambda$0(YAMLInlinePromptDetector this$0, PsiFile $file, TextRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.listOfNotNull((Object)this$0.findInlinePromptInRange($file, it));
    }
}

