/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm;

import com.intellij.codeInsight.codeVision.ui.model.RangeCodeVisionModel;
import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.ml.llm.LLMTextInlayPainter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/LLMTextPresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "editor", "Lcom/intellij/openapi/editor/Editor;", "text", "", "hovered", "", "extraAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "skipEffect", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;ZLcom/intellij/openapi/editor/markup/TextAttributes;Z)V", "inlayState", "Lcom/intellij/codeInsight/codeVision/ui/model/RangeCodeVisionModel$InlayState;", "textPainter", "Lcom/intellij/ml/llm/LLMTextInlayPainter;", "width", "", "getWidth", "()I", "height", "getHeight", "paint", "", "g", "Ljava/awt/Graphics2D;", "attributes", "toString", "size", "Ljava/awt/Dimension;", "intellij.ml.llm.core"})
@ApiStatus.Internal
public final class LLMTextPresentation
extends BasePresentation {
    @NotNull
    private final Editor editor;
    @NotNull
    private final String text;
    private final boolean hovered;
    @Nullable
    private final TextAttributes extraAttributes;
    private final boolean skipEffect;
    @NotNull
    private final RangeCodeVisionModel.InlayState inlayState;
    @NotNull
    private final LLMTextInlayPainter textPainter;

    public LLMTextPresentation(@NotNull Editor editor, @NotNull String text, boolean hovered, @Nullable TextAttributes extraAttributes, boolean skipEffect) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.editor = editor;
        this.text = text;
        this.hovered = hovered;
        this.extraAttributes = extraAttributes;
        this.skipEffect = skipEffect;
        this.inlayState = RangeCodeVisionModel.InlayState.NORMAL;
        this.textPainter = new LLMTextInlayPainter();
    }

    public /* synthetic */ LLMTextPresentation(Editor editor, String string, boolean bl, TextAttributes textAttributes, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            textAttributes = null;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(editor, string, bl, textAttributes, bl2);
    }

    public int getWidth() {
        return this.size().width;
    }

    public int getHeight() {
        return this.size().height;
    }

    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        TextAttributes updatedAttributes = new TextAttributes();
        updatedAttributes.copyFrom(attributes);
        TextAttributes textAttributes = this.extraAttributes;
        if ((textAttributes != null ? textAttributes.getForegroundColor() : null) != null) {
            updatedAttributes.setForegroundColor(this.extraAttributes.getForegroundColor());
        }
        if (!this.skipEffect) {
            TextAttributes textAttributes2 = this.extraAttributes;
            if ((textAttributes2 != null ? textAttributes2.getEffectType() : null) != null) {
                updatedAttributes.setEffectType(this.extraAttributes.getEffectType());
            }
            TextAttributes textAttributes3 = this.extraAttributes;
            if ((textAttributes3 != null ? textAttributes3.getEffectColor() : null) != null) {
                updatedAttributes.setEffectColor(this.extraAttributes.getEffectColor());
            }
        }
        Editor editor = this.editor;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        int y = ((EditorImpl)editor).getAscent();
        this.textPainter.paint(this.editor, updatedAttributes, (Graphics)g, this.text, new Point(0, y), this.inlayState, this.hovered, null);
    }

    @NotNull
    public String toString() {
        return "LLMText(" + this.text + ")";
    }

    private final Dimension size() {
        return this.textPainter.size(this.editor, this.inlayState, this.text);
    }
}

