/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.BrowserUtil;
import com.intellij.llmInstaller.ui.LLMInstallerUIUtilKt;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.activation.data.model.AipLicense;
import com.intellij.ml.llm.activation.data.model.AipLicenseProductType;
import com.intellij.ml.llm.activation.state.manager.AiaActivationManager;
import com.intellij.ml.llm.activation.state.model.AiEnterpriseActivation;
import com.intellij.ml.llm.activation.state.model.AiProJbaActivation;
import com.intellij.ml.llm.activation.state.model.AiProJbaPending;
import com.intellij.ml.llm.activation.state.model.AiUnattendedActivation;
import com.intellij.ml.llm.activation.state.model.AiaActivation;
import com.intellij.ml.llm.activation.state.model.AiaActivationProgressing;
import com.intellij.ml.llm.activation.state.model.AiaActivationTrackUnknown;
import com.intellij.ml.llm.activation.state.model.AipLicenseChoicePending;
import com.intellij.ml.llm.activation.state.model.AipLicenseMissing;
import com.intellij.ml.llm.activation.state.model.Outcome;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.core.chat.ui.LicenseType;
import com.intellij.ml.llm.core.quota.QuotaInfo;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantAuthorizationEventLogger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupShowOptions;
import com.intellij.ui.InlineBanner;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u0004\u0018\u00010\u0001\u001aU\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0000\u0010\u000b*\u00020\f\"\u0004\b\u0001\u0010\r*\b\u0012\u0004\u0012\u0002H\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u00112\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u0002H\r\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u00150\u0013\u001a<\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0000\u0010\u000b*\u00020\f\"\u0004\b\u0001\u0010\r*\b\u0012\u0004\u0012\u0002H\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u0011\u001a2\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\n*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\u000b\u0010\u0019\u001a\u00070\u0014\u00a2\u0006\u0002\b\u001a2\u000b\u0010\u001b\u001a\u00070\u0014\u00a2\u0006\u0002\b\u001a\u001a\n\u0010\u001c\u001a\u00020\u001d*\u00020\u0017\u001a\u0011\u0010\u001e\u001a\u0004\u0018\u00010\b*\u00020\u001f\u00a2\u0006\u0002\u0010 \u001a\f\u0010!\u001a\u00020\b*\u0004\u0018\u00010\u001f\u001a\n\u0010\"\u001a\u0004\u0018\u00010\u001fH\u0007\u001a\r\u0010#\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010$\u001a\u0017\u0010%\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00152\b\u0010&\u001a\u0004\u0018\u00010\u001f\u001a\f\u0010,\u001a\u00020\u001d*\u00020-H\u0007\u001a\u0018\u0010.\u001a\u0006\u0012\u0002\b\u00030/*\u0002002\u0006\u00101\u001a\u00020\u0014H\u0007\u001a\u0014\u00102\u001a\u00020\u001d*\u0002032\u0006\u00104\u001a\u000205H\u0007\u001a\"\u00106\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0000\u0010\u000b*\u000207*\b\u0012\u0004\u0012\u0002H\u000b0\nH\u0007\u001a\f\u00106\u001a\u00020\u001d*\u000207H\u0007\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0018\u0010'\u001a\u00020\b*\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\"\u0018\u0010+\u001a\u00020\b*\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010*\u00a8\u00068"}, d2={"tariffQuotaAvailable", "Ljava/math/BigDecimal;", "Lcom/intellij/ml/llm/core/quota/QuotaInfo;", "getTariffQuotaAvailable", "(Lcom/intellij/ml/llm/core/quota/QuotaInfo;)Ljava/math/BigDecimal;", "topUpQuotaAvailable", "getTopUpQuotaAvailable", "isAvailableQuota", "", "bindTextIn", "Lcom/intellij/ui/dsl/builder/Cell;", "T", "Ljavax/swing/JEditorPane;", "V", "scope", "Lkotlinx/coroutines/CoroutineScope;", "flow", "Lkotlinx/coroutines/flow/Flow;", "transform", "Lkotlin/Function1;", "", "Lorg/jetbrains/annotations/Nls;", "trialEndedComment", "Lcom/intellij/ui/dsl/builder/Row;", "coroutineScope", "personalText", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "organizationText", "howCompletelyDisableLink", "", "isPaid", "Lcom/intellij/ml/llm/core/chat/ui/LicenseType;", "(Lcom/intellij/ml/llm/core/chat/ui/LicenseType;)Ljava/lang/Boolean;", "isValid", "getLicenseType", "isLicensePersonal", "()Ljava/lang/Boolean;", "getLicenseText", "licenseType", "licenseSelectionStage", "Lcom/intellij/ml/llm/activation/state/model/AiProJbaActivation;", "getLicenseSelectionStage", "(Lcom/intellij/ml/llm/activation/state/model/AiProJbaActivation;)Z", "isProgressing", "repack", "Lcom/intellij/ui/popup/AbstractPopup;", "findLink", "Lcom/intellij/ui/components/labels/LinkLabel;", "Lcom/intellij/ui/InlineBanner;", "text", "showAbove", "Lcom/intellij/openapi/ui/popup/JBPopup;", "component", "Ljava/awt/Component;", "greyForeground", "Ljavax/swing/JComponent;", "intellij.ml.llm.core"})
public final class AIAssistantUIUtilKt {
    @Nullable
    public static final BigDecimal getTariffQuotaAvailable(@NotNull QuotaInfo $this$tariffQuotaAvailable) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)$this$tariffQuotaAvailable, (String)"<this>");
        QuotaInfo quotaInfo = $this$tariffQuotaAvailable;
        if (quotaInfo instanceof QuotaInfo.Available) {
            QuotaInfo.QuotaDetails quotaDetails = ((QuotaInfo.Available)$this$tariffQuotaAvailable).getTariffQuota();
            bigDecimal = quotaDetails != null ? quotaDetails.getAvailable() : null;
        } else if (quotaInfo instanceof QuotaInfo.Reached) {
            bigDecimal = BigDecimal.ZERO;
        } else if (quotaInfo instanceof QuotaInfo.Error || quotaInfo instanceof QuotaInfo.Unknown) {
            bigDecimal = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bigDecimal;
    }

    @Nullable
    public static final BigDecimal getTopUpQuotaAvailable(@NotNull QuotaInfo $this$topUpQuotaAvailable) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)$this$topUpQuotaAvailable, (String)"<this>");
        QuotaInfo quotaInfo = $this$topUpQuotaAvailable;
        if (quotaInfo instanceof QuotaInfo.Available) {
            QuotaInfo.QuotaDetails quotaDetails = ((QuotaInfo.Available)$this$topUpQuotaAvailable).getTopUpQuota();
            bigDecimal = quotaDetails != null ? quotaDetails.getAvailable() : null;
        } else if (quotaInfo instanceof QuotaInfo.Reached) {
            bigDecimal = BigDecimal.ZERO;
        } else if (quotaInfo instanceof QuotaInfo.Error || quotaInfo instanceof QuotaInfo.Unknown) {
            bigDecimal = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bigDecimal;
    }

    public static final boolean isAvailableQuota(@Nullable BigDecimal $this$isAvailableQuota) {
        BigDecimal bigDecimal = $this$isAvailableQuota;
        return bigDecimal != null ? bigDecimal.signum() == 1 : false;
    }

    @NotNull
    public static final <T extends JEditorPane, V> Cell<T> bindTextIn(@NotNull Cell<? extends T> $this$bindTextIn, @NotNull CoroutineScope scope, @NotNull Flow<? extends V> flow, @NotNull Function1<? super V, String> transform) {
        Cell<? extends T> cell;
        Intrinsics.checkNotNullParameter($this$bindTextIn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(flow, (String)"flow");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Cell<? extends T> $this$bindTextIn_u24lambda_u240 = cell = $this$bindTextIn;
        boolean bl = false;
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        BuildersKt.launch((CoroutineScope)scope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(flow, $this$bindTextIn_u24lambda_u240, transform, null){
            int label;
            final /* synthetic */ Flow<V> $flow;
            final /* synthetic */ Cell<T> $this_apply;
            final /* synthetic */ Function1<V, String> $transform;
            {
                this.$flow = $flow;
                this.$this_apply = $receiver;
                this.$transform = $transform;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$flow.collect(new FlowCollector(this.$this_apply, this.$transform){
                            final /* synthetic */ Cell<T> $this_apply;
                            final /* synthetic */ Function1<V, String> $transform;
                            {
                                this.$this_apply = $receiver;
                                this.$transform = $transform;
                            }

                            public final Object emit(V value, Continuation<? super Unit> $completion) {
                                ((JEditorPane)this.$this_apply.getComponent()).setText((String)this.$transform.invoke(value));
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return cell;
    }

    @NotNull
    public static final <T extends JEditorPane, V> Cell<T> bindTextIn(@NotNull Cell<? extends T> $this$bindTextIn, @NotNull CoroutineScope scope, @NotNull Flow<? extends V> flow) {
        Intrinsics.checkNotNullParameter($this$bindTextIn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(flow, (String)"flow");
        return AIAssistantUIUtilKt.bindTextIn($this$bindTextIn, scope, flow, AIAssistantUIUtilKt::bindTextIn$lambda$1);
    }

    @NotNull
    public static final Cell<JEditorPane> trialEndedComment(@NotNull Row $this$trialEndedComment, @NotNull CoroutineScope coroutineScope, @NotNull String personalText, @NotNull String organizationText) {
        Intrinsics.checkNotNullParameter((Object)$this$trialEndedComment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)personalText, (String)"personalText");
        Intrinsics.checkNotNullParameter((Object)organizationText, (String)"organizationText");
        Cell result2 = LLMInstallerUIUtilKt.patchMinimumSize((Cell)Row.comment$default((Row)$this$trialEndedComment, (String)personalText, (int)0, AIAssistantUIUtilKt::trialEndedComment$lambda$0, (int)2, null));
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Cell<? extends JEditorPane>)result2, personalText, organizationText, null){
            int label;
            final /* synthetic */ Cell<JEditorPane> $result;
            final /* synthetic */ String $personalText;
            final /* synthetic */ String $organizationText;
            {
                this.$result = $result;
                this.$personalText = $personalText;
                this.$organizationText = $organizationText;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        boolean $i$f$service = false;
                        Class<AiaActivationManager> serviceClass$iv = AiaActivationManager.class;
                        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                        if (object2 == null) {
                            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                        }
                        this.label = 1;
                        Object object3 = ((AiaActivationManager)object2).getActivationState().collect(new FlowCollector(this.$result, this.$personalText, this.$organizationText){
                            final /* synthetic */ Cell<JEditorPane> $result;
                            final /* synthetic */ String $personalText;
                            final /* synthetic */ String $organizationText;
                            {
                                this.$result = $result;
                                this.$personalText = $personalText;
                                this.$organizationText = $organizationText;
                            }

                            public final Object emit(AiaActivation activation2, Continuation<? super Unit> $completion) {
                                AiProJbaActivation aiProJbaActivation = activation2 instanceof AiProJbaActivation ? (AiProJbaActivation)activation2 : null;
                                AipLicense activeLicense = aiProJbaActivation != null ? aiProJbaActivation.getActiveLicense() : null;
                                AipLicense aipLicense = activeLicense;
                                ((JEditorPane)this.$result.getComponent()).setText((aipLicense != null ? aipLicense.isIndividual() : true) ? this.$personalText : this.$organizationText);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return result2;
    }

    public static final void howCompletelyDisableLink(@NotNull Row $this$howCompletelyDisableLink) {
        Intrinsics.checkNotNullParameter((Object)$this$howCompletelyDisableLink, (String)"<this>");
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        $this$howCompletelyDisableLink.link(LLMBundle.message("project.settings.how.completely.disable", objectArray), AIAssistantUIUtilKt::howCompletelyDisableLink$lambda$0).applyToComponent(AIAssistantUIUtilKt::howCompletelyDisableLink$lambda$1);
    }

    @Nullable
    public static final Boolean isPaid(@NotNull LicenseType $this$isPaid) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isPaid), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$isPaid.ordinal()]) {
            case 1, 2, 3, 4 -> true;
            case 5, 6, 7, 8 -> false;
            case 9 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final boolean isValid(@Nullable LicenseType $this$isValid) {
        return $this$isValid != null && AIAssistantUIUtilKt.isPaid($this$isValid) != null;
    }

    @ApiStatus.Internal
    @Nullable
    public static final LicenseType getLicenseType() {
        LicenseType licenseType;
        block12: {
            AiaActivation aiaActivation;
            block13: {
                AiaActivation aiaActivation2;
                block11: {
                    LicenseType licenseType2 = AIAssistantUIUtil.INSTANCE.getTestLicenseType$intellij_ml_llm_core();
                    if (licenseType2 != null) {
                        LicenseType it = licenseType2;
                        boolean bl = false;
                        return it;
                    }
                    aiaActivation2 = AiaActivationManager.Companion.currentActivation();
                    aiaActivation = aiaActivation2;
                    if (!(aiaActivation instanceof AiEnterpriseActivation)) break block11;
                    licenseType = LicenseType.ENTERPRISE;
                    break block12;
                }
                if (!(aiaActivation instanceof AiProJbaActivation)) break block13;
                AipLicense activeLicense = ((AiProJbaActivation)aiaActivation2).getActiveLicense();
                if (activeLicense == null) {
                    if (AIAssistantUIUtilKt.isProgressing((AiProJbaActivation)aiaActivation2)) {
                        return null;
                    }
                    return AIAssistantUIUtilKt.getLicenseSelectionStage((AiProJbaActivation)aiaActivation2) ? LicenseType.NONE : null;
                }
                switch (WhenMappings.$EnumSwitchMapping$1[activeLicense.getProductType().ordinal()]) {
                    case 1: {
                        licenseType = LicenseType.ULTIMATE;
                        break block12;
                    }
                    case 2: {
                        licenseType = activeLicense.isIndividual() ? (activeLicense.isTrial() ? LicenseType.PRO_TRIAL : LicenseType.PRO) : (activeLicense.isTrial() ? LicenseType.BUSINESS_TRIAL : LicenseType.BUSINESS);
                        break block12;
                    }
                    case 3: {
                        licenseType = LicenseType.EAP_TRIAL;
                        break block12;
                    }
                    case 4: {
                        licenseType = LicenseType.FREE;
                        break block12;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (aiaActivation instanceof AiaActivationTrackUnknown || aiaActivation instanceof AiUnattendedActivation) {
                licenseType = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return licenseType;
    }

    @Nullable
    public static final Boolean isLicensePersonal() {
        Boolean bl;
        Boolean testLicensePersonal = AIAssistantUIUtil.INSTANCE.getTestLicensePersonal();
        if (testLicensePersonal != null) {
            return testLicensePersonal;
        }
        AiaActivation aiaActivation = AiaActivationManager.Companion.currentActivation();
        if (aiaActivation instanceof AiEnterpriseActivation) {
            bl = false;
        } else if (aiaActivation instanceof AiProJbaActivation) {
            AipLicense aipLicense = ((AiProJbaActivation)aiaActivation).getActiveLicense();
            bl = aipLicense != null ? Boolean.valueOf(aipLicense.isIndividual()) : null;
        } else if (aiaActivation instanceof AiaActivationTrackUnknown || aiaActivation instanceof AiUnattendedActivation) {
            bl = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Nullable
    public static final String getLicenseText(@Nullable LicenseType licenseType) {
        LicenseType licenseType2 = licenseType;
        return switch (licenseType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[licenseType2.ordinal()]) {
            case 1 -> LLMBundle.message("ai.hub.license.ultimate", new Object[0]);
            case 2 -> LLMBundle.message("ai.hub.license.enterprise", new Object[0]);
            case 5 -> LLMBundle.message("ai.hub.license.pro.trial", new Object[0]);
            case 3 -> LLMBundle.message("ai.hub.license.pro", new Object[0]);
            case 6 -> LLMBundle.message("ai.hub.license.business.trial", new Object[0]);
            case 4 -> LLMBundle.message("ai.hub.license.business", new Object[0]);
            case 7 -> LLMBundle.message("ai.hub.license.eap.trial", new Object[0]);
            case 8 -> LLMBundle.message("ai.hub.license.free", new Object[0]);
            case 9 -> null;
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final boolean getLicenseSelectionStage(AiProJbaActivation $this$licenseSelectionStage) {
        AiProJbaPending aiProJbaPending = (AiProJbaPending)Outcome.incompleteOrNull-impl((Object)$this$licenseSelectionStage.getOutcome-X8CKn68());
        return aiProJbaPending instanceof AipLicenseChoicePending.AipLicenseChoiceRequired || aiProJbaPending instanceof AipLicenseMissing;
    }

    private static final boolean isProgressing(AiProJbaActivation $this$isProgressing) {
        return Outcome.incompleteOrNull-impl((Object)$this$isProgressing.getOutcome-X8CKn68()) instanceof AiaActivationProgressing;
    }

    @ApiStatus.Internal
    public static final void repack(@NotNull AbstractPopup $this$repack) {
        Intrinsics.checkNotNullParameter((Object)$this$repack, (String)"<this>");
        $this$repack.getContent().validate();
        $this$repack.pack(false, true);
    }

    @ApiStatus.Internal
    @NotNull
    public static final LinkLabel<?> findLink(@NotNull InlineBanner $this$findLink, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$findLink, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object object = UIUtil.uiTraverser((Component)((Component)$this$findLink)).filter(LinkLabel.class).find(arg_0 -> AIAssistantUIUtilKt.findLink$lambda$1(arg_0 -> AIAssistantUIUtilKt.findLink$lambda$0(text, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)object);
        return (LinkLabel)object;
    }

    @ApiStatus.Internal
    public static final void showAbove(@NotNull JBPopup $this$showAbove, @NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)$this$showAbove, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        $this$showAbove.show(PopupShowOptions.Companion.aboveComponent(component));
    }

    @ApiStatus.Internal
    @NotNull
    public static final <T extends JComponent> Cell<T> greyForeground(@NotNull Cell<? extends T> $this$greyForeground) {
        Intrinsics.checkNotNullParameter($this$greyForeground, (String)"<this>");
        AIAssistantUIUtilKt.greyForeground($this$greyForeground.getComponent());
        return $this$greyForeground;
    }

    @ApiStatus.Internal
    public static final void greyForeground(@NotNull JComponent $this$greyForeground) {
        Intrinsics.checkNotNullParameter((Object)$this$greyForeground, (String)"<this>");
        $this$greyForeground.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
    }

    private static final String bindTextIn$lambda$1(Object it) {
        return String.valueOf(it);
    }

    private static final void trialEndedComment$lambda$0(HyperlinkEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BrowserUtil.open((String)"https://jb.gg/available-subscription-options-with-organizational-jetbrains-account");
    }

    private static final Unit howCompletelyDisableLink$lambda$0(ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        HelpManager.getInstance().invokeHelp("ai.assistant.settings.disable");
        AIAssistantAuthorizationEventLogger.INSTANCE.logHowToDisableAiClicked();
        return Unit.INSTANCE;
    }

    private static final Unit howCompletelyDisableLink$lambda$1(ActionLink $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setExternalLinkIcon();
        return Unit.INSTANCE;
    }

    private static final boolean findLink$lambda$0(String $text, LinkLabel it) {
        return Intrinsics.areEqual((Object)it.getText(), (Object)$text);
    }

    private static final boolean findLink$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LicenseType.values().length];
            try {
                nArray[LicenseType.ULTIMATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseType.ENTERPRISE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseType.PRO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseType.BUSINESS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseType.PRO_TRIAL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseType.BUSINESS_TRIAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseType.EAP_TRIAL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseType.FREE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseType.NONE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AipLicenseProductType.values().length];
            try {
                nArray[AipLicenseProductType.AIPU.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AipLicenseProductType.AIP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AipLicenseProductType.AIPEAP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AipLicenseProductType.AIF.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

