/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.BrowserUtil;
import com.intellij.ml.llm.AiPluginConstants;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.chat.services.AIAssistantServiceScope;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtilKt;
import com.intellij.ml.llm.core.chat.ui.LicenseType;
import com.intellij.ml.llm.core.chat.ui.NotificationUI;
import com.intellij.ml.llm.core.chat.ui.NotificationUIKt;
import com.intellij.ml.llm.core.chat.ui.RemainedQuotasInfo;
import com.intellij.ml.llm.core.providers.LlmCustomModelsSettingsManager;
import com.intellij.ml.llm.core.quota.QuotaInfo;
import com.intellij.ml.llm.core.quota.QuotaManager2;
import com.intellij.ml.llm.core.settings.LLMThirdPartyAiProvidersConfigurable;
import com.intellij.ml.llm.hub.AIHubNotificationManager;
import com.intellij.ml.llm.hub.AIHubNotificationManagerKt;
import com.intellij.ml.llm.hub.Notification;
import com.intellij.ml.llm.updates.AIAssistantUpdateChecker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorNotificationPanel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\"\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020!2\u0006\u0010\u0004\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020!2\u0006\u0010\u0004\u001a\u000203H\u0002J'\u00104\u001a\b\u0012\u0004\u0012\u00020\u0013052\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001307\"\u00020\u0013H\u0002\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020:H\u0002J\u0015\u0010;\u001a\u00070\u001b\u00a2\u0006\u0002\b<2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010=\u001a\u00020\u001fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/NotificationBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "notification", "Lcom/intellij/ml/llm/hub/Notification;", "hub", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/hub/Notification;Z)V", "scope", "Lkotlinx/coroutines/CoroutineScope;", "status", "Lcom/intellij/ui/EditorNotificationPanel$Status;", "isLicensePersonal", "isChinaRegion", "landingPlansAugmented", "Ljava/lang/Runnable;", "upgradeNow", "Lcom/intellij/ml/llm/core/chat/ui/NotificationUI$Action;", "renewNow", "upgradeToUltimate", "addTopUpCredits", "aboutTopUpCredits", "quota", "Lcom/intellij/ml/llm/core/quota/QuotaInfo$SuccessfulQuotaInfo;", "topUpQuotaAvailable", "", "quotasInfo", "Lcom/intellij/ml/llm/core/chat/ui/RemainedQuotasInfo;", "refillInDays", "", "getNotificationUI", "Lcom/intellij/ml/llm/core/chat/ui/NotificationUI;", "licenseExpiring", "Lcom/intellij/ml/llm/hub/Notification$LicenseExpiring;", "licenseExpired", "Lcom/intellij/ml/llm/hub/Notification$LicenseExpired;", "licenseExpiredTopUpFreeEnabled", "Lcom/intellij/ml/llm/hub/Notification$LicenseExpiredTopUpFreeEnabled;", "licenseExpiredTopUp", "Lcom/intellij/ml/llm/hub/Notification$LicenseExpiredTopUp;", "quotaReached", "Lcom/intellij/ml/llm/hub/Notification$QuotaReached;", "quotaReachedTopUp", "Lcom/intellij/ml/llm/hub/Notification$QuotaReachedTopUp;", "quotaReachedTopUpExhausting", "Lcom/intellij/ml/llm/hub/Notification$QuotaReachedTopUpExhausting;", "quotaReaching", "Lcom/intellij/ml/llm/hub/Notification$QuotaReaching;", "quotaReachedTopUpExhausted", "Lcom/intellij/ml/llm/hub/Notification$QuotaReachedTopUpExhausted;", "getAvailableActions", "", "actions", "", "([Lcom/intellij/ml/llm/core/chat/ui/NotificationUI$Action;)Ljava/util/List;", "getCheckedPersonalLicense", "Lcom/intellij/ml/llm/hub/Notification$LicenseDependentNotification;", "getQuotaExceedComment", "Lorg/jetbrains/annotations/Nls;", "getLicenseEndsInDaysAndLog", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nNotificationUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationUI.kt\ncom/intellij/ml/llm/core/chat/ui/NotificationBuilder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,434:1\n3919#2:435\n4434#2,2:436\n42#3,3:438\n*S KotlinDebug\n*F\n+ 1 NotificationUI.kt\ncom/intellij/ml/llm/core/chat/ui/NotificationBuilder\n*L\n396#1:435\n396#1:436,2\n153#1:438,3\n*E\n"})
final class NotificationBuilder {
    private final boolean hub;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final EditorNotificationPanel.Status status;
    private final boolean isLicensePersonal;
    private final boolean isChinaRegion;
    @NotNull
    private final Runnable landingPlansAugmented;
    @NotNull
    private final NotificationUI.Action upgradeNow;
    @NotNull
    private final NotificationUI.Action renewNow;
    @NotNull
    private final NotificationUI.Action upgradeToUltimate;
    @NotNull
    private final NotificationUI.Action addTopUpCredits;
    @NotNull
    private final NotificationUI.Action aboutTopUpCredits;
    @Nullable
    private final QuotaInfo.SuccessfulQuotaInfo quota;
    @Nullable
    private final String topUpQuotaAvailable;
    @NotNull
    private final RemainedQuotasInfo quotasInfo;
    private final int refillInDays;

    /*
     * WARNING - void declaration
     */
    public NotificationBuilder(@NotNull Project project, @NotNull Notification notification, boolean hub) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        this.hub = hub;
        this.scope = AIAssistantServiceScope.Companion.getScope(project);
        this.status = AIHubNotificationManagerKt.isWarning(notification) ? EditorNotificationPanel.Status.Warning : EditorNotificationPanel.Status.Info;
        this.isLicensePersonal = !Intrinsics.areEqual((Object)AIAssistantUIUtilKt.isLicensePersonal(), (Object)false);
        this.isChinaRegion = AIAssistantUIUtil.INSTANCE.isChinaRegion();
        this.landingPlansAugmented = () -> NotificationBuilder.landingPlansAugmented$lambda$0(this);
        this.upgradeNow = new NotificationUI.Action(NotificationUI.ActionType.UPGRADE_NOW, this.landingPlansAugmented);
        this.renewNow = new NotificationUI.Action(NotificationUI.ActionType.RENEW_NOW, this.landingPlansAugmented);
        this.upgradeToUltimate = new NotificationUI.Action(NotificationUI.ActionType.UPGRADE_TO_ULTIMATE, this.landingPlansAugmented);
        this.addTopUpCredits = new NotificationUI.Action(NotificationUI.ActionType.ADD_TOP_UP_CREDITS, NotificationBuilder::addTopUpCredits$lambda$0);
        this.aboutTopUpCredits = new NotificationUI.Action(NotificationUI.ActionType.ABOUT_TOP_UP_CREDITS, NotificationBuilder::aboutTopUpCredits$lambda$0);
        this.quota = (QuotaInfo.SuccessfulQuotaInfo)QuotaManager2.Companion.getInstance().getLastSuccessfulQuota().getValue();
        NotificationBuilder notificationBuilder = this;
        Object object = this.quota;
        if (object != null && (object = AIAssistantUIUtilKt.getTopUpQuotaAvailable((QuotaInfo)object)) != null) {
            void it;
            Object object2 = object;
            NotificationBuilder notificationBuilder2 = notificationBuilder;
            boolean bl = false;
            string = AIAssistantUIUtilKt.isAvailableQuota((BigDecimal)it) ? AIAssistantUIUtil.INSTANCE.quotaToCreditString((BigDecimal)it) : null;
            notificationBuilder = notificationBuilder2;
        } else {
            string = null;
        }
        notificationBuilder.topUpQuotaAvailable = string;
        this.quotasInfo = AIAssistantUIUtil.INSTANCE.getRemainedTariffQuotasInfo(this.quota);
        this.refillInDays = this.quotasInfo.getEndsInDays() + MathKt.getSign((int)this.quotasInfo.getEndsInHours());
    }

    @ApiStatus.Internal
    @NotNull
    public final NotificationUI getNotificationUI(@NotNull Project project, @NotNull Notification notification, boolean hub) {
        NotificationUI notificationUI;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        Notification notification2 = notification;
        if (notification2 instanceof Notification.LicenseExpiring) {
            notificationUI = this.licenseExpiring((Notification.LicenseExpiring)notification);
        } else if (notification2 instanceof Notification.LicenseExpired) {
            notificationUI = this.licenseExpired((Notification.LicenseExpired)notification);
        } else if (notification2 instanceof Notification.LicenseExpiredTopUp) {
            notificationUI = this.licenseExpiredTopUp((Notification.LicenseExpiredTopUp)notification);
        } else if (notification2 instanceof Notification.QuotaReaching) {
            notificationUI = this.quotaReaching((Notification.QuotaReaching)notification);
        } else if (notification2 instanceof Notification.QuotaReached) {
            notificationUI = this.quotaReached((Notification.QuotaReached)notification);
        } else if (notification2 instanceof Notification.QuotaReachedTopUp) {
            notificationUI = this.quotaReachedTopUp((Notification.QuotaReachedTopUp)notification);
        } else if (notification2 instanceof Notification.QuotaReachedTopUpExhausting) {
            notificationUI = this.quotaReachedTopUpExhausting((Notification.QuotaReachedTopUpExhausting)notification);
        } else if (notification2 instanceof Notification.QuotaReachedTopUpExhausted) {
            notificationUI = this.quotaReachedTopUpExhausted((Notification.QuotaReachedTopUpExhausted)notification);
        } else if (notification2 instanceof Notification.LicenseExpiredTopUpFreeEnabled) {
            notificationUI = this.licenseExpiredTopUpFreeEnabled((Notification.LicenseExpiredTopUpFreeEnabled)notification);
        } else if (Intrinsics.areEqual((Object)notification2, (Object)Notification.FREE_ENABLED.INSTANCE) || notification2 instanceof Notification.LicenseExpiredFreeEnabled) {
            Object object;
            String title = Intrinsics.areEqual((Object)notification, (Object)Notification.FREE_ENABLED.INSTANCE) || ((object = notification instanceof Notification.LicenseExpiredFreeEnabled ? (Notification.LicenseExpiredFreeEnabled)notification : null) != null && (object = object.getLicenseType()) != null ? Intrinsics.areEqual((Object)AIAssistantUIUtilKt.isPaid((LicenseType)((Object)object)), (Object)false) : false) ? LLMBundle.message("ai.hub.notification.free.enabled.title", new Object[0]) : LLMBundle.message("ai.hub.notification.license.expired.and.free.enabled.title", new Object[0]);
            notificationUI = new NotificationUI(title + LLMBundle.message("ai.hub.notification.free.enabled.message", new Object[0]), this.status, CollectionsKt.listOf((Object)this.upgradeNow), true);
        } else if (Intrinsics.areEqual((Object)notification2, (Object)Notification.THIRD_PARTY_PROVIDERS_BLOCKED.INSTANCE)) {
            notificationUI = new NotificationUI(LLMBundle.message("ai.hub.notification.third.party.providers.blocked", new Object[0]), this.status, CollectionsKt.emptyList(), false, 8, null);
        } else if (Intrinsics.areEqual((Object)notification2, (Object)Notification.NO_LOCAL_MODELS.INSTANCE)) {
            Object[] objectArray = new NotificationUI.Action[]{new NotificationUI.Action(NotificationUI.ActionType.LOCAL_MODELS_SETUP, () -> NotificationBuilder.getNotificationUI$lambda$0(project)), new NotificationUI.Action(NotificationUI.ActionType.LOCAL_MODELS_TURN_OFF, NotificationBuilder::getNotificationUI$lambda$1)};
            NotificationUI notificationUI2 = new NotificationUI(LLMBundle.message("ai.hub.notification.no.local.models", new Object[0]), this.status, CollectionsKt.listOf((Object[])objectArray), false, 8, null);
            notificationUI = notificationUI2;
        } else if (Intrinsics.areEqual((Object)notification2, (Object)Notification.UPDATE_AVAILABLE.INSTANCE)) {
            notificationUI = new NotificationUI(LLMBundle.message("ai.hub.notification.update.available", new Object[0]), this.status, CollectionsKt.listOf((Object)new NotificationUI.Action(NotificationUI.ActionType.UPDATE, () -> NotificationBuilder.getNotificationUI$lambda$2(project))), false, 8, null);
        } else if (Intrinsics.areEqual((Object)notification2, (Object)Notification.QUOTA_ALMOST_REACHED.INSTANCE)) {
            Object[] objectArray = new Object[]{85};
            NotificationUI notificationUI3 = new NotificationUI(LLMBundle.message("ai.hub.notification.quota.expiring", objectArray), this.status, CollectionsKt.emptyList(), true);
            notificationUI = notificationUI3;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return notificationUI;
    }

    private final NotificationUI licenseExpiring(Notification.LicenseExpiring notification) {
        return switch (WhenMappings.$EnumSwitchMapping$0[notification.getLicenseType().ordinal()]) {
            case 1 -> {
                Object[] var2_2 = new Object[]{this.getLicenseEndsInDaysAndLog()};
                NotificationUI v0 = new NotificationUI(LLMBundle.message("ai.hub.notification.pro.trial.expiring", var2_2), this.status, CollectionsKt.listOf((Object)this.upgradeNow), true);
                yield v0;
            }
            case 2 -> {
                Object[] var2_3 = new Object[]{this.getLicenseEndsInDaysAndLog()};
                NotificationUI v2 = new NotificationUI(LLMBundle.message("ai.hub.notification.pro.expiring", var2_3), this.status, CollectionsKt.listOf((Object)this.renewNow), true);
                yield v2;
            }
            case 3 -> {
                Object[] var2_4 = new Object[]{this.getLicenseEndsInDaysAndLog()};
                NotificationUI v3 = new NotificationUI(LLMBundle.message("ai.hub.notification.business.trial.expiring", var2_4), this.status, CollectionsKt.listOf((Object)this.upgradeNow), true);
                yield v3;
            }
            case 4 -> {
                Object[] var2_5 = new Object[]{this.getLicenseEndsInDaysAndLog()};
                NotificationUI v4 = new NotificationUI(LLMBundle.message("ai.hub.notification.business.expiring", var2_5), this.status, CollectionsKt.listOf((Object)this.renewNow), true);
                yield v4;
            }
            default -> throw new IllegalArgumentException("Unsupported license type: " + notification.getLicenseType());
        };
    }

    private final NotificationUI licenseExpired(Notification.LicenseExpired notification) {
        return switch (WhenMappings.$EnumSwitchMapping$0[notification.getLicenseType().ordinal()]) {
            case 1, 3 -> new NotificationUI(LLMBundle.message("ai.hub.notification.trial.expired", new Object[0]), this.status, CollectionsKt.listOf((Object)this.upgradeNow), true);
            case 2 -> new NotificationUI(LLMBundle.message("ai.hub.notification.pro.expired", new Object[0]), this.status, CollectionsKt.listOf((Object)this.renewNow), true);
            case 4 -> new NotificationUI(LLMBundle.message("ai.hub.notification.business.expired", new Object[0]), this.status, CollectionsKt.listOf((Object)this.renewNow), true);
            default -> throw new IllegalArgumentException("Unsupported license type: " + notification.getLicenseType());
        };
    }

    private final NotificationUI licenseExpiredTopUpFreeEnabled(Notification.LicenseExpiredTopUpFreeEnabled notification) {
        NotificationUI notificationUI;
        if (this.getCheckedPersonalLicense(notification)) {
            Object[] objectArray;
            String string;
            if (this.topUpQuotaAvailable == null) {
                string = "";
            } else if (this.hub) {
                objectArray = new Object[]{this.topUpQuotaAvailable};
                string = LLMBundle.message("ai.hub.notification.license.expired.comment.top.up.free.enabled", objectArray);
            } else {
                objectArray = new Object[]{this.topUpQuotaAvailable};
                string = LLMBundle.message("ai.hub.notification.license.expired.comment.top.up", objectArray);
            }
            String comment = string;
            objectArray = new Object[]{comment};
            NotificationUI notificationUI2 = new NotificationUI(LLMBundle.message("ai.hub.notification.license.expired.title", objectArray), this.status, CollectionsKt.listOf((Object)this.renewNow), true);
            notificationUI = notificationUI2;
        } else {
            Object[] objectArray;
            String string;
            if (this.topUpQuotaAvailable == null) {
                string = "";
            } else if (this.hub) {
                objectArray = new Object[]{this.topUpQuotaAvailable};
                string = LLMBundle.message("ai.hub.notification.license.expired.comment.commercial.top.up.free.enabled", objectArray);
            } else {
                objectArray = new Object[]{this.topUpQuotaAvailable};
                string = LLMBundle.message("ai.hub.notification.license.expired.comment.commercial.top.up", objectArray);
            }
            String comment = string;
            objectArray = new Object[]{comment};
            NotificationUI notificationUI3 = new NotificationUI(LLMBundle.message("ai.hub.notification.license.expired.title", objectArray), this.status, CollectionsKt.emptyList(), true);
            notificationUI = notificationUI3;
        }
        return notificationUI;
    }

    private final NotificationUI licenseExpiredTopUp(Notification.LicenseExpiredTopUp notification) {
        NotificationUI notificationUI;
        if (this.getCheckedPersonalLicense(notification)) {
            Object[] objectArray;
            String string;
            if (this.topUpQuotaAvailable == null) {
                string = "";
            } else {
                objectArray = new Object[]{this.topUpQuotaAvailable};
                string = LLMBundle.message("ai.hub.notification.license.expired.comment.top.up", objectArray);
            }
            String comment = string;
            objectArray = new Object[]{comment};
            NotificationUI notificationUI2 = new NotificationUI(LLMBundle.message("ai.hub.notification.license.expired.title", objectArray), this.status, CollectionsKt.listOf((Object)this.renewNow), true);
            notificationUI = notificationUI2;
        } else {
            Object[] objectArray;
            String string;
            if (this.topUpQuotaAvailable == null) {
                string = "";
            } else {
                objectArray = new Object[]{this.topUpQuotaAvailable};
                string = LLMBundle.message("ai.hub.notification.license.expired.comment.commercial.top.up", objectArray);
            }
            String comment = string;
            objectArray = new Object[]{comment};
            NotificationUI notificationUI3 = new NotificationUI(LLMBundle.message("ai.hub.notification.license.expired.title", objectArray), this.status, CollectionsKt.emptyList(), true);
            notificationUI = notificationUI3;
        }
        return notificationUI;
    }

    private final NotificationUI quotaReached(Notification.QuotaReached notification) {
        String licenseText = AIAssistantUIUtilKt.getLicenseText(notification.getLicenseType());
        return switch (WhenMappings.$EnumSwitchMapping$0[notification.getLicenseType().ordinal()]) {
            case 5 -> new NotificationUI(LLMBundle.message("ai.hub.notification.free.quota.exceeded", new Object[0]), this.status, CollectionsKt.listOf((Object)this.upgradeNow), true);
            case 3, 4 -> {
                if (AIAssistantUIUtil.INSTANCE.isSupportLlm18911()) {
                    if (this.isChinaRegion) {
                        if (notification.getLicenseType() == LicenseType.BUSINESS) {
                            Object[] var3_3 = new Object[2];
                            Intrinsics.checkNotNull((Object)licenseText);
                            Object[] var4_16 = new Object[]{this.refillInDays};
                            var3_3[1] = LLMBundle.message("ai.hub.notification.plan.quota.reached.comment.china", var4_16);
                            NotificationUI v1 = new NotificationUI(LLMBundle.message("ai.hub.notification.plan.quota.reached.title", var3_3), this.status, CollectionsKt.emptyList(), true);
                            yield v1;
                        }
                        Object[] var3_4 = new Object[1];
                        Intrinsics.checkNotNull((Object)licenseText);
                        String v2 = LLMBundle.message("ai.hub.notification.plan.quota.reached.title.china", var3_4);
                        var3_4 = new NotificationUI.Action[]{this.upgradeNow};
                        NotificationUI v3 = new NotificationUI(v2, this.status, this.getAvailableActions((NotificationUI.Action[])var3_4), true);
                        yield v3;
                    }
                    Object[] var3_5 = new Object[2];
                    Intrinsics.checkNotNull((Object)licenseText);
                    var3_5[1] = LLMBundle.message("ai.hub.notification.plan.quota.reached.comment.business", new Object[0]);
                    String v4 = LLMBundle.message("ai.hub.notification.plan.quota.reached.title", var3_5);
                    var3_5 = new NotificationUI.Action[]{this.upgradeToUltimate, this.aboutTopUpCredits};
                    NotificationUI v5 = new NotificationUI(v4, this.status, this.getAvailableActions((NotificationUI.Action[])var3_5), true);
                    yield v5;
                }
                Object[] var3_6 = new Object[2];
                Intrinsics.checkNotNull((Object)licenseText);
                var3_6[1] = this.getQuotaExceedComment(this.refillInDays);
                String v6 = LLMBundle.message("ai.hub.notification.plan.quota.reached", var3_6);
                var3_6 = new NotificationUI.Action[]{this.upgradeToUltimate};
                NotificationUI v7 = new NotificationUI(v6, this.status, this.getAvailableActions((NotificationUI.Action[])var3_6), true);
                yield v7;
            }
            case 1, 2 -> {
                if (AIAssistantUIUtil.INSTANCE.isSupportLlm18911()) {
                    if (this.isChinaRegion) {
                        if (notification.getLicenseType() == LicenseType.PRO) {
                            Object[] var3_7 = new Object[2];
                            Intrinsics.checkNotNull((Object)licenseText);
                            Object[] var4_17 = new Object[]{this.refillInDays};
                            var3_7[1] = LLMBundle.message("ai.hub.notification.plan.quota.reached.comment.china", var4_17);
                            NotificationUI v8 = new NotificationUI(LLMBundle.message("ai.hub.notification.plan.quota.reached.title", var3_7), this.status, CollectionsKt.emptyList(), true);
                            yield v8;
                        }
                        Object[] var3_8 = new Object[1];
                        Intrinsics.checkNotNull((Object)licenseText);
                        String v9 = LLMBundle.message("ai.hub.notification.plan.quota.reached.title.china", var3_8);
                        var3_8 = new NotificationUI.Action[]{this.upgradeNow};
                        NotificationUI v10 = new NotificationUI(v9, this.status, this.getAvailableActions((NotificationUI.Action[])var3_8), true);
                        yield v10;
                    }
                    Object[] var3_9 = new Object[2];
                    Intrinsics.checkNotNull((Object)licenseText);
                    var3_9[1] = LLMBundle.message("ai.hub.notification.plan.quota.reached.comment.pro", new Object[0]);
                    String v11 = LLMBundle.message("ai.hub.notification.plan.quota.reached.title", var3_9);
                    var3_9 = new NotificationUI.Action[]{this.upgradeToUltimate, this.addTopUpCredits};
                    NotificationUI v12 = new NotificationUI(v11, this.status, this.getAvailableActions((NotificationUI.Action[])var3_9), true);
                    yield v12;
                }
                Object[] var3_10 = new Object[2];
                Intrinsics.checkNotNull((Object)licenseText);
                var3_10[1] = this.getQuotaExceedComment(this.refillInDays);
                String v13 = LLMBundle.message("ai.hub.notification.plan.quota.reached", var3_10);
                var3_10 = new NotificationUI.Action[]{this.upgradeToUltimate};
                NotificationUI v14 = new NotificationUI(v13, this.status, this.getAvailableActions((NotificationUI.Action[])var3_10), true);
                yield v14;
            }
            case 6 -> {
                if (AIAssistantUIUtil.INSTANCE.isSupportLlm18911()) {
                    if (this.isLicensePersonal) {
                        Object[] var3_11 = new Object[2];
                        Intrinsics.checkNotNull((Object)licenseText);
                        var3_11[1] = "";
                        String v15 = LLMBundle.message("ai.hub.notification.plan.quota.reached.title", var3_11);
                        var3_11 = new NotificationUI.Action[]{this.addTopUpCredits};
                        NotificationUI v16 = new NotificationUI(v15, this.status, this.getAvailableActions((NotificationUI.Action[])var3_11), true);
                        yield v16;
                    }
                    Object[] var3_12 = new Object[2];
                    Intrinsics.checkNotNull((Object)licenseText);
                    var3_12[1] = LLMBundle.message("ai.hub.notification.plan.quota.reached.comment.ultimate", new Object[0]);
                    NotificationUI v17 = new NotificationUI(LLMBundle.message("ai.hub.notification.plan.quota.reached.title", var3_12), this.status, CollectionsKt.emptyList(), true);
                    yield v17;
                }
                Object[] var3_13 = new Object[1];
                Object[] var4_18 = new Object[]{this.refillInDays};
                var3_13[0] = LLMBundle.message("ai.hub.notification.quota.exceeded.contact.support", var4_18);
                NotificationUI v18 = new NotificationUI(LLMBundle.message("ai.hub.notification.ultimate.quota.exceeded", var3_13), this.status, CollectionsKt.emptyList(), true);
                yield v18;
            }
            case 7 -> {
                if (this.isChinaRegion) {
                    Object[] var3_14 = new Object[1];
                    Object[] var4_19 = new Object[]{this.refillInDays};
                    var3_14[0] = LLMBundle.message("ai.hub.notification.plan.quota.reached.comment.china", var4_19);
                    NotificationUI v19 = new NotificationUI(LLMBundle.message("ai.hub.notification.quota.reached.enterprise.title.china", var3_14), this.status, CollectionsKt.emptyList(), true);
                    yield v19;
                }
                Object[] var3_15 = new Object[1];
                Object[] var4_20 = new Object[]{this.refillInDays};
                var3_15[0] = LLMBundle.message("ai.hub.notification.quota.exceeded.contact.support", var4_20);
                NotificationUI v20 = new NotificationUI(LLMBundle.message("ai.hub.notification.quota.reached.enterprise.title", var3_15), this.status, CollectionsKt.emptyList(), true);
                yield v20;
            }
            default -> throw new IllegalArgumentException("Unsupported license type: " + notification.getLicenseType());
        };
    }

    private final NotificationUI quotaReachedTopUp(Notification.QuotaReachedTopUp notification) {
        return this.getCheckedPersonalLicense(notification) ? new NotificationUI(LLMBundle.message("ai.hub.notification.personal.quota.reached.top.up", new Object[0]), this.status, CollectionsKt.emptyList(), true) : new NotificationUI(LLMBundle.message("ai.hub.notification.commercial.quota.reached.top.up", new Object[0]), this.status, CollectionsKt.emptyList(), true);
    }

    private final NotificationUI quotaReachedTopUpExhausting(Notification.QuotaReachedTopUpExhausting notification) {
        NotificationUI notificationUI;
        if (this.getCheckedPersonalLicense(notification)) {
            Object[] objectArray = new Object[]{85, LLMBundle.message("ai.hub.notification.top.up.exhausting.comment.personal", new Object[0])};
            String string = LLMBundle.message("ai.hub.notification.top.up.exhausting.title", objectArray);
            objectArray = new NotificationUI.Action[]{this.addTopUpCredits};
            NotificationUI notificationUI2 = new NotificationUI(string, this.status, this.getAvailableActions((NotificationUI.Action[])objectArray), true);
            notificationUI = notificationUI2;
        } else {
            Object[] objectArray = new Object[]{85, LLMBundle.message("ai.hub.notification.top.up.exhausting.comment.commercial", new Object[0])};
            NotificationUI notificationUI3 = new NotificationUI(LLMBundle.message("ai.hub.notification.top.up.exhausting.title", objectArray), this.status, CollectionsKt.emptyList(), true);
            notificationUI = notificationUI3;
        }
        return notificationUI;
    }

    private final NotificationUI quotaReaching(Notification.QuotaReaching notification) {
        String licenseText = AIAssistantUIUtilKt.getLicenseText(notification.getLicenseType());
        return switch (WhenMappings.$EnumSwitchMapping$0[notification.getLicenseType().ordinal()]) {
            case 1, 2 -> {
                Object[] var3_3 = new Object[3];
                var3_3[0] = 85;
                Intrinsics.checkNotNull((Object)licenseText);
                var3_3[2] = LLMBundle.message("ai.hub.notification.plan.quota.reaching.comment.pro", new Object[0]);
                String v0 = LLMBundle.message("ai.hub.notification.plan.quota.reaching.title", var3_3);
                var3_3 = new NotificationUI.Action[]{this.upgradeToUltimate, this.addTopUpCredits};
                NotificationUI v1 = new NotificationUI(v0, this.status, this.getAvailableActions((NotificationUI.Action[])var3_3), true);
                yield v1;
            }
            case 6 -> {
                if (this.isLicensePersonal) {
                    Object[] var3_4 = new Object[3];
                    var3_4[0] = 85;
                    Intrinsics.checkNotNull((Object)licenseText);
                    var3_4[2] = LLMBundle.message("ai.hub.notification.plan.quota.reaching.comment.personal.ultimate", new Object[0]);
                    String v3 = LLMBundle.message("ai.hub.notification.plan.quota.reaching.title", var3_4);
                    var3_4 = new NotificationUI.Action[]{this.addTopUpCredits};
                    NotificationUI v4 = new NotificationUI(v3, this.status, this.getAvailableActions((NotificationUI.Action[])var3_4), true);
                    yield v4;
                }
                Object[] var3_5 = new Object[3];
                var3_5[0] = 85;
                Intrinsics.checkNotNull((Object)licenseText);
                var3_5[2] = LLMBundle.message("ai.hub.notification.plan.quota.reaching.comment.commercial.ultimate", new Object[0]);
                String v5 = LLMBundle.message("ai.hub.notification.plan.quota.reaching.title", var3_5);
                var3_5 = new NotificationUI.Action[]{this.aboutTopUpCredits};
                NotificationUI v6 = new NotificationUI(v5, this.status, this.getAvailableActions((NotificationUI.Action[])var3_5), true);
                yield v6;
            }
            case 3, 4 -> {
                Object[] var3_6 = new Object[3];
                var3_6[0] = 85;
                Intrinsics.checkNotNull((Object)licenseText);
                var3_6[2] = LLMBundle.message("ai.hub.notification.plan.quota.reaching.comment.business", new Object[0]);
                String v7 = LLMBundle.message("ai.hub.notification.plan.quota.reaching.title", var3_6);
                var3_6 = new NotificationUI.Action[]{this.upgradeToUltimate, this.aboutTopUpCredits};
                NotificationUI v8 = new NotificationUI(v7, this.status, this.getAvailableActions((NotificationUI.Action[])var3_6), true);
                yield v8;
            }
            default -> throw new IllegalArgumentException("Unsupported license type: " + notification.getLicenseType());
        };
    }

    private final NotificationUI quotaReachedTopUpExhausted(Notification.QuotaReachedTopUpExhausted notification) {
        NotificationUI notificationUI;
        if (this.getCheckedPersonalLicense(notification)) {
            NotificationUI.Action[] actionArray = new NotificationUI.Action[]{this.addTopUpCredits};
            NotificationUI notificationUI2 = new NotificationUI(LLMBundle.message("ai.hub.notification.personal.top.up.exhausted", new Object[0]), this.status, this.getAvailableActions(actionArray), true);
            notificationUI = notificationUI2;
        } else {
            NotificationUI.Action[] actionArray = new NotificationUI.Action[]{this.aboutTopUpCredits};
            NotificationUI notificationUI3 = new NotificationUI(LLMBundle.message("ai.hub.notification.commercial.top.up.exhausted", new Object[0]), this.status, this.getAvailableActions(actionArray), true);
            notificationUI = notificationUI3;
        }
        return notificationUI;
    }

    /*
     * WARNING - void declaration
     */
    private final List<NotificationUI.Action> getAvailableActions(NotificationUI.Action ... actions) {
        void $this$filterTo$iv$iv;
        NotificationUI.Action[] $this$filter$iv = actions;
        boolean $i$f$filter = false;
        NotificationUI.Action[] actionArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl2 = false;
            switch (WhenMappings.$EnumSwitchMapping$1[it.getType().ordinal()]) {
                case 1: {
                    if (!this.isChinaRegion) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: 
                case 3: {
                    bl = AIAssistantUIUtil.INSTANCE.isSupportLlm18910();
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean getCheckedPersonalLicense(Notification.LicenseDependentNotification notification) {
        switch (WhenMappings.$EnumSwitchMapping$0[notification.getLicenseType().ordinal()]) {
            case 1: 
            case 2: {
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        return this.isLicensePersonal;
    }

    private final String getQuotaExceedComment(int refillInDays) {
        String string;
        if (this.isChinaRegion) {
            Object[] objectArray = new Object[]{refillInDays};
            string = LLMBundle.message("ai.hub.notification.quota.exceeded.contact.support", objectArray);
        } else {
            string = LLMBundle.message("ai.hub.notification.quota.exceeded.upgrade.to.ultimate", new Object[0]);
        }
        return string;
    }

    private final int getLicenseEndsInDaysAndLog() {
        int n;
        Integer n2 = AIAssistantUIUtil.INSTANCE.getLicenseEndsInDays();
        if (n2 != null) {
            n = n2;
        } else {
            NotificationBuilder it = this;
            boolean bl = false;
            NotificationUIKt.access$getLog$p().info("getLicenseEndsInDays is null");
            n = 0;
        }
        return n;
    }

    private static final void landingPlansAugmented$lambda$0(NotificationBuilder this$0) {
        BuildersKt.launch$default((CoroutineScope)this$0.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = AiPluginConstants.INSTANCE.getRegionalLandingUrl((Continuation<? super String>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        BrowserUtil.open((String)((String)v0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void addTopUpCredits$lambda$0() {
        BrowserUtil.browse((String)"https://jetbrains.com/shop/buy?item=P:N:AIGC");
    }

    private static final void aboutTopUpCredits$lambda$0() {
        BrowserUtil.browse((String)"https://www.jetbrains.com/help/ai-assistant/licensing-and-subscriptions.html#top-up-ai-credits-faq");
    }

    private static final void getNotificationUI$lambda$0(Project $project) {
        ShowSettingsUtil.getInstance().showSettingsDialog($project, LLMThirdPartyAiProvidersConfigurable.class);
    }

    private static final void getNotificationUI$lambda$1() {
        boolean $i$f$service = false;
        Class<LlmCustomModelsSettingsManager> serviceClass$iv = LlmCustomModelsSettingsManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((LlmCustomModelsSettingsManager)object).setLocalModeEnabled(false);
        AIHubNotificationManager.Companion.getInstance().markGotIt(SetsKt.setOf((Object)Notification.NO_LOCAL_MODELS.INSTANCE));
    }

    private static final void getNotificationUI$lambda$2(Project $project) {
        AIAssistantUpdateChecker.Companion.getInstance().showUpdateDialog($project);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LicenseType.values().length];
            try {
                nArray[LicenseType.PRO_TRIAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseType.PRO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseType.BUSINESS_TRIAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseType.BUSINESS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseType.FREE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseType.ULTIMATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseType.ENTERPRISE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[NotificationUI.ActionType.values().length];
            try {
                nArray[NotificationUI.ActionType.UPGRADE_TO_ULTIMATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationUI.ActionType.ADD_TOP_UP_CREDITS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationUI.ActionType.ABOUT_TOP_UP_CREDITS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

