/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.models;

import com.intellij.ide.RegionUrlMapper;
import com.intellij.ml.llm.core.models.ForceModelEvent;
import com.intellij.ml.llm.core.models.LlmChatConfig;
import com.intellij.ml.llm.core.models.LlmInfoService;
import com.intellij.ml.llm.core.models.LlmInfoServiceKt;
import com.intellij.ml.llm.core.models.ModelCost;
import com.intellij.ml.llm.core.models.ModelDescription;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.UriUtilKt;
import com.intellij.util.io.HttpRequests;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.future.FutureKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002>?B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010!\u001a\u00020\fH\u0002J\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0007J\u000e\u0010#\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010$J\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0014J\u000e\u0010*\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0014J\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00140,2\u0006\u0010)\u001a\u00020\u0014J\u000e\u0010-\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0014J\u000e\u0010.\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0014J\u000e\u0010/\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0014J\u000e\u00100\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0014J\u000e\u00101\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0014J\u000e\u00102\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0014J\u000e\u00103\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0014J\b\u00104\u001a\u0004\u0018\u000105J\b\u00106\u001a\u0004\u0018\u000105J/\u00107\u001a\u0002H8\"\u0004\b\u0000\u001082\u0006\u00109\u001a\u00020\u00142\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u0002H80;H\u0002\u00a2\u0006\u0002\u0010=R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00148F@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u0014@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u0014@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001a\u00a8\u0006@"}, d2={"Lcom/intellij/ml/llm/core/models/LlmInfoService;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "config", "Lcom/intellij/ml/llm/core/models/LlmChatConfig;", "loadingInitiated", "Lkotlinx/coroutines/CompletableDeferred;", "", "configLoadedSharedFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "configLoadedFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "getConfigLoadedFlow", "()Lkotlinx/coroutines/flow/SharedFlow;", "hostOverride", "", "value", "host", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "autoModelChatOverride", "getAutoModelChatOverride", "setAutoModelChatOverride", "autoModelEditOverride", "getAutoModelEditOverride", "setAutoModelEditOverride", "initiateLoading", "initiateLoadingForTesting", "loadConfig", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasCloudConfig", "", "getCost", "Lcom/intellij/ml/llm/core/models/ModelCost;", "id", "getDescription", "getTags", "", "isThinking", "isBeta", "isNew", "isFree", "isPopular", "isAutoSelectionForChat", "isAutoSelectionForEdit", "getForceEventForChat", "Lcom/intellij/ml/llm/core/models/ForceModelEvent;", "getForceEventForEdit", "loadFromUrl", "R", "url", "streamProcessor", "Lkotlin/Function1;", "Ljava/io/InputStream;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Endpoints", "LlmConfigActivity", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nLlmInfoService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LlmInfoService.kt\ncom/intellij/ml/llm/core/models/LlmInfoService\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n*L\n1#1,219:1\n80#2:220\n*S KotlinDebug\n*F\n+ 1 LlmInfoService.kt\ncom/intellij/ml/llm/core/models/LlmInfoService\n*L\n92#1:220\n*E\n"})
public final class LlmInfoService {
    @NotNull
    private final CoroutineScope scope;
    @Nullable
    private LlmChatConfig config;
    @NotNull
    private final CompletableDeferred<Unit> loadingInitiated;
    @NotNull
    private final MutableSharedFlow<Unit> configLoadedSharedFlow;
    @NotNull
    private final SharedFlow<Unit> configLoadedFlow;
    @Nullable
    private String hostOverride;
    @Nullable
    private String autoModelChatOverride;
    @Nullable
    private String autoModelEditOverride;

    public LlmInfoService(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
        this.loadingInitiated = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.configLoadedSharedFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.configLoadedFlow = FlowKt.asSharedFlow(this.configLoadedSharedFlow);
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @NotNull
    public final SharedFlow<Unit> getConfigLoadedFlow() {
        return this.configLoadedFlow;
    }

    @NotNull
    public final String getHost() {
        String string = this.hostOverride;
        if (string == null) {
            string = Registry.Companion.stringValue("llm.selector.config.refresh.host");
        }
        return string;
    }

    @TestOnly
    public final void setHost(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.hostOverride = value;
    }

    @Nullable
    public final String getAutoModelChatOverride() {
        return this.autoModelChatOverride;
    }

    @TestOnly
    public final void setAutoModelChatOverride(@Nullable String string) {
        this.autoModelChatOverride = string;
    }

    @Nullable
    public final String getAutoModelEditOverride() {
        return this.autoModelEditOverride;
    }

    @TestOnly
    public final void setAutoModelEditOverride(@Nullable String string) {
        this.autoModelEditOverride = string;
    }

    private final void initiateLoading() {
        if (this.loadingInitiated.isCompleted()) {
            LlmInfoServiceKt.access$getLOG$p().warn("Loading already initiated");
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)new CoroutineName("Load chat selector config")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            long J$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ LlmInfoService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        while (true) {
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = LlmInfoService.access$loadConfig(this.this$0, (Continuation)this);
                            if (v0 == var5_3) {
                                return var5_3;
                            }
                            ** GOTO lbl17
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        refreshInterval = DurationKt.toDuration((int)RangesKt.coerceAtLeast((int)Registry.Companion.intValue("llm.selector.config.refresh.interval", 60), (int)1), (DurationUnit)DurationUnit.MINUTES);
                        this.L$0 = $this$launch;
                        this.J$0 = refreshInterval;
                        this.label = 2;
                        v1 = DelayKt.delay-VtjQ1oo((long)refreshInterval, (Continuation)((Continuation)this));
                        if (v1 == var5_3) {
                            return var5_3;
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        refreshInterval = this.J$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        if (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) ** continue;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.loadingInitiated.complete((Object)Unit.INSTANCE);
    }

    @TestOnly
    @NotNull
    public final CompletableDeferred<Unit> initiateLoadingForTesting(@Nullable String host) {
        this.hostOverride = host;
        this.initiateLoading();
        return this.loadingInitiated;
    }

    public static /* synthetic */ CompletableDeferred initiateLoadingForTesting$default(LlmInfoService llmInfoService, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return llmInfoService.initiateLoadingForTesting(string);
    }

    /*
     * Unable to fully structure code
     */
    private final Object loadConfig(Continuation<? super Unit> $completion) {
        if (!($completion instanceof loadConfig.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ LlmInfoService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LlmInfoService.access$loadConfig(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = RegionUrlMapper.tryMapUrl((String)this.getHost());
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"tryMapUrl(...)");
                $continuation.label = 1;
                v1 = FutureKt.await((CompletionStage)v0, (Continuation)$continuation);
                ** if (v1 != var7_4) goto lbl20
lbl19:
                // 1 sources

                return var7_4;
lbl20:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl26:
                // 2 sources

                effectiveHostUrl = (String)v1;
                v2 = URI.create(effectiveHostUrl);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"create(...)");
                configUri = UriUtilKt.withPath((URI)v2, (String)Endpoints.INSTANCE.getCONFIG());
                json = JsonKt.Json$default(null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, loadConfig$lambda$0(kotlinx.serialization.json.JsonBuilder ), (Lkotlinx/serialization/json/JsonBuilder;)Lkotlin/Unit;)(), (int)1, null);
                LlmInfoServiceKt.access$getLOG$p().info("Loading config from " + configUri);
                v3 = configUri.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toString(...)");
                this.config = (LlmChatConfig)this.loadFromUrl(v3, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, loadConfig$lambda$1(kotlinx.serialization.json.Json java.io.InputStream ), (Ljava/io/InputStream;)Lcom/intellij/ml/llm/core/models/LlmChatConfig;)((Json)json));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)effectiveHostUrl);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)configUri);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)json);
                $continuation.label = 2;
                v4 = this.configLoadedSharedFlow.emit((Object)Unit.INSTANCE, (Continuation)$continuation);
                ** if (v4 != var7_4) goto lbl42
lbl41:
                // 1 sources

                return var7_4;
lbl42:
                // 1 sources

                ** GOTO lbl54
            }
            case 2: {
                json = (Json)$continuation.L$2;
                configUri = (URI)$continuation.L$1;
                effectiveHostUrl = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
                }
                catch (Exception e) {
                    LlmInfoServiceKt.access$getLOG$p().warn("Failed to load config: " + e.getMessage(), (Throwable)e);
                }
lbl54:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean hasCloudConfig() {
        return this.config != null;
    }

    @NotNull
    public final ModelCost getCost(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = this.config;
        if (object == null || (object = object.getCost(id)) == null) {
            object = ModelCost.UNDEFINED;
        }
        return object;
    }

    @NotNull
    public final String getDescription(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = this.config;
        if (object == null || (object = ((LlmChatConfig)object).getDescription(id)) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public final List<String> getTags(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = this.config;
        if (object == null || (object = ((LlmChatConfig)object).getTags(id)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public final boolean isThinking(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = this.config;
        return object != null && (object = ((LlmChatConfig)object).findModelById(id)) != null ? ((ModelDescription)object).isThinking() : false;
    }

    public final boolean isBeta(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = this.config;
        return object != null && (object = ((LlmChatConfig)object).findModelById(id)) != null ? ((ModelDescription)object).isBeta() : false;
    }

    public final boolean isNew(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = this.config;
        return object != null && (object = ((LlmChatConfig)object).findModelById(id)) != null ? ((ModelDescription)object).isNew() : false;
    }

    public final boolean isFree(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = this.config;
        return object != null && (object = ((LlmChatConfig)object).findModelById(id)) != null ? ((ModelDescription)object).isFree() : false;
    }

    public final boolean isPopular(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        LlmChatConfig llmChatConfig = this.config;
        return llmChatConfig != null ? llmChatConfig.isPopular(id) : false;
    }

    public final boolean isAutoSelectionForChat(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.autoModelChatOverride != null) {
            return Intrinsics.areEqual((Object)this.autoModelChatOverride, (Object)id);
        }
        LlmChatConfig llmChatConfig = this.config;
        return llmChatConfig != null ? llmChatConfig.isAutoSelectionForChat(id) : false;
    }

    public final boolean isAutoSelectionForEdit(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.autoModelEditOverride != null) {
            return Intrinsics.areEqual((Object)this.autoModelEditOverride, (Object)id);
        }
        LlmChatConfig llmChatConfig = this.config;
        return llmChatConfig != null ? llmChatConfig.isAutoSelectionForEdit(id) : false;
    }

    @Nullable
    public final ForceModelEvent getForceEventForChat() {
        LlmChatConfig llmChatConfig = this.config;
        return llmChatConfig != null ? llmChatConfig.getForceModelEventForChat() : null;
    }

    @Nullable
    public final ForceModelEvent getForceEventForEdit() {
        LlmChatConfig llmChatConfig = this.config;
        return llmChatConfig != null ? llmChatConfig.getForceModelEventForEdit() : null;
    }

    private final <R> R loadFromUrl(String url, Function1<? super InputStream, ? extends R> streamProcessor) {
        return (R)HttpRequests.request((String)url).productNameAsUserAgent().accept("application/json").connectTimeout(10000).readTimeout(10000).connect(arg_0 -> LlmInfoService.loadFromUrl$lambda$0(streamProcessor, arg_0));
    }

    private static final Unit loadConfig$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setCoerceInputValues(true);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final LlmChatConfig loadConfig$lambda$1(Json $json, InputStream inputStream) {
        void $this$decodeFromStream$iv;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Json json = $json;
        InputStream stream$iv = inputStream;
        boolean $i$f$decodeFromStream = false;
        $this$decodeFromStream$iv.getSerializersModule();
        return (LlmChatConfig)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)LlmChatConfig.Companion.serializer()), (InputStream)stream$iv);
    }

    private static final Object loadFromUrl$lambda$0(Function1 $streamProcessor, HttpRequests.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        InputStream inputStream = request.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        return $streamProcessor.invoke((Object)inputStream);
    }

    public static final /* synthetic */ Object access$loadConfig(LlmInfoService $this, Continuation $completion) {
        return $this.loadConfig((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$initiateLoading(LlmInfoService $this) {
        $this.initiateLoading();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/core/models/LlmInfoService$Endpoints;", "", "<init>", "()V", "VERSION", "", "getVERSION", "()Ljava/lang/String;", "CONFIG", "getCONFIG", "intellij.ml.llm.core"})
    public static final class Endpoints {
        @NotNull
        public static final Endpoints INSTANCE = new Endpoints();
        @NotNull
        private static final String CONFIG = "/llm-selector-config/" + INSTANCE.getVERSION() + "/config.json";

        private Endpoints() {
        }

        @NotNull
        public final String getVERSION() {
            return Registry.Companion.stringValue("llm.selector.config.version");
        }

        @NotNull
        public final String getCONFIG() {
            return CONFIG;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/core/models/LlmInfoService$LlmConfigActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nLlmInfoService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LlmInfoService.kt\ncom/intellij/ml/llm/core/models/LlmInfoService$LlmConfigActivity\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,219:1\n70#2,6:220\n*S KotlinDebug\n*F\n+ 1 LlmInfoService.kt\ncom/intellij/ml/llm/core/models/LlmInfoService$LlmConfigActivity\n*L\n156#1:220,6\n*E\n"})
    public static final class LlmConfigActivity
    implements ProjectActivity {
        /*
         * Unable to fully structure code
         */
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof execute.1)) ** GOTO lbl-1000
            var7_3 = $completion;
            if ((var7_3.label & -2147483648) != 0) {
                var7_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ LlmConfigActivity this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $i$f$serviceAsync = 0;
                    v0 = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplication(...)");
                    $this$serviceAsync$iv$iv = (ComponentManager)v0;
                    $i$f$serviceAsync = 0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv$iv);
                    $continuation.I$0 = $i$f$serviceAsync;
                    $continuation.I$1 = $i$f$serviceAsync;
                    $continuation.label = 1;
                    v1 = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(LlmInfoService.class, (Continuation)$continuation);
                    if (v1 == var8_5) {
                        return var8_5;
                    }
                    ** GOTO lbl35
                }
                case 1: {
                    $i$f$serviceAsync = $continuation.I$1;
                    $i$f$serviceAsync = $continuation.I$0;
                    $this$serviceAsync$iv$iv = (ComponentManager)$continuation.L$1;
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl35:
                    // 2 sources

                    LlmInfoService.access$initiateLoading((LlmInfoService)v1);
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }
}

