/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.models.api;

import ai.grazie.model.cloud.ContentType;
import ai.grazie.model.llm.profile.LLMProfileID;
import ai.grazie.model.llm.prompt.LLMPromptID;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.core.LLMPromptsKt;
import com.intellij.ml.llm.core.models.ChatModePreferableModelProviderKt;
import com.intellij.ml.llm.core.models.LlmInfoService;
import com.intellij.ml.llm.core.models.LlmProfileService;
import com.intellij.ml.llm.core.models.api.AiaLlmProfileID;
import com.intellij.ml.llm.core.providers.ThirdPartyLLMProfileId;
import com.intellij.ml.llm.grazie.GrazieLLMProfileID;
import com.intellij.openapi.application.ApplicationManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u00020\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u00020\t*\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\n\u0010\u000f\u001a\u00020\t*\u00020\u0005\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/core/models/api/AiaLlmProfileIDUtils;", "", "<init>", "()V", "fromString", "Lcom/intellij/ml/llm/core/models/api/AiaLlmProfileID;", "id", "", "isAuto", "", "promptId", "Lai/grazie/model/llm/prompt/LLMPromptID;", "supportsContentType", "type", "Lai/grazie/model/cloud/ContentType;", "supportsImages", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nAiaLlmProfileID.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiaLlmProfileID.kt\ncom/intellij/ml/llm/core/models/api/AiaLlmProfileIDUtils\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,39:1\n42#2,3:40\n42#2,3:43\n42#2,3:46\n*S KotlinDebug\n*F\n+ 1 AiaLlmProfileID.kt\ncom/intellij/ml/llm/core/models/api/AiaLlmProfileIDUtils\n*L\n26#1:40,3\n27#1:43,3\n33#1:46,3\n*E\n"})
public final class AiaLlmProfileIDUtils {
    @NotNull
    public static final AiaLlmProfileIDUtils INSTANCE = new AiaLlmProfileIDUtils();

    private AiaLlmProfileIDUtils() {
    }

    @NotNull
    public final AiaLlmProfileID fromString(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return ThirdPartyLLMProfileId.Companion.isThirdPartyProfileId(id) ? (AiaLlmProfileID)ThirdPartyLLMProfileId.Companion.fromString(id) : (AiaLlmProfileID)new GrazieLLMProfileID(new LLMProfileID(id));
    }

    public final boolean isAuto(@NotNull AiaLlmProfileID $this$isAuto, @NotNull LLMPromptID promptId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isAuto, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)promptId, (String)"promptId");
        if (!($this$isAuto instanceof GrazieLLMProfileID)) {
            return false;
        }
        if (ChatModePreferableModelProviderKt.isChatPrompt(promptId)) {
            boolean $i$f$service = false;
            Class<LlmInfoService> serviceClass$iv = LlmInfoService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            bl = ((LlmInfoService)object).isAutoSelectionForChat(((GrazieLLMProfileID)$this$isAuto).getId());
        } else if (Intrinsics.areEqual((Object)promptId, (Object)LLMPromptsKt.getCODE_GENERATION_FROM_CHAT_PROMPT_ID())) {
            boolean $i$f$service = false;
            Class<LlmInfoService> serviceClass$iv = LlmInfoService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            bl = ((LlmInfoService)object).isAutoSelectionForEdit(((GrazieLLMProfileID)$this$isAuto).getId());
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean supportsContentType(@NotNull AiaLlmProfileID $this$supportsContentType, @NotNull ContentType type) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsContentType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        boolean $i$f$service = false;
        Class<LlmProfileService> serviceClass$iv = LlmProfileService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((LlmProfileService)object).isContentTypeSupported($this$supportsContentType, type);
    }

    public final boolean supportsImages(@NotNull AiaLlmProfileID $this$supportsImages) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsImages, (String)"<this>");
        return this.supportsContentType($this$supportsImages, ContentType.Image.INSTANCE.getJPEG());
    }
}

