/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.postProcessing;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/core/postProcessing/ResponsePostProcessingUtil;", "", "<init>", "()V", "adjustIndentationCharacter", "", "response", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "isToUseTabAsIndent", "", "indentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nResponsePostProcessingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponsePostProcessingUtil.kt\ncom/intellij/ml/llm/core/postProcessing/ResponsePostProcessingUtil\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,58:1\n1069#2,2:59\n*S KotlinDebug\n*F\n+ 1 ResponsePostProcessingUtil.kt\ncom/intellij/ml/llm/core/postProcessing/ResponsePostProcessingUtil\n*L\n56#1:59,2\n*E\n"})
public final class ResponsePostProcessingUtil {
    @NotNull
    public static final ResponsePostProcessingUtil INSTANCE = new ResponsePostProcessingUtil();

    private ResponsePostProcessingUtil() {
    }

    @NotNull
    public final String adjustIndentationCharacter(@NotNull String response, @NotNull Project project, @NotNull Editor editor, int offset) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((Project)project, (Document)editor.getDocument());
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptions(...)");
        CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
        boolean tabsAsIndent = this.isToUseTabAsIndent(editor, offset, project, indentOptions2);
        if (!tabsAsIndent) {
            return response;
        }
        return StringsKt.replace$default((String)response, (String)StringsKt.repeat((CharSequence)" ", (int)indentOptions2.TAB_SIZE), (String)"\t", (boolean)false, (int)4, null);
    }

    private final boolean isToUseTabAsIndent(Editor editor, int offset, Project project, CommonCodeStyleSettings.IndentOptions indentOptions) {
        boolean bl;
        block5: {
            if (!CodeStyle.getSettings((Editor)editor).AUTODETECT_INDENTS) {
                return indentOptions.USE_TAB_CHARACTER;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (psiFile == null) {
                return indentOptions.USE_TAB_CHARACTER;
            }
            PsiFile file = psiFile;
            if (offset > editor.getDocument().getTextLength()) {
                return indentOptions.USE_TAB_CHARACTER;
            }
            int caretLine = editor.getDocument().getLineNumber(offset);
            String caretLineIndent = CodeStyle.getLineIndent((Editor)editor, (Language)file.getLanguage(), (int)editor.getDocument().getLineStartOffset(caretLine), (boolean)false);
            CharSequence charSequence = caretLineIndent;
            if (charSequence == null || charSequence.length() == 0) {
                return indentOptions.USE_TAB_CHARACTER;
            }
            CharSequence $this$all$iv = caretLineIndent;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (it == '\t') continue;
                bl = false;
                break block5;
            }
            bl = true;
        }
        return bl;
    }
}

