/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.DataManager;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.AIAContentFacade;
import com.intellij.ml.llm.core.settings.LLMCompletionDisabledListener;
import com.intellij.ml.llm.core.settings.LLMConfigurableUtils;
import com.intellij.ml.llm.core.settings.LLMSettingsManager;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantAuthorizationEventLogger;
import com.intellij.ml.llm.util.swing.SwingUtilsKt;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007J&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\n\u0010\u0013\u001a\u00020\u0005*\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/core/settings/LLMConfigurableUtils;", "", "<init>", "()V", "navigateToConfigurable", "", "configurableClass", "Ljava/lang/Class;", "Lcom/intellij/openapi/options/Configurable;", "llmActivationButton", "Lcom/intellij/ui/dsl/builder/Cell;", "Ljavax/swing/JButton;", "Lcom/intellij/ui/dsl/builder/Row;", "getProject", "Lkotlin/Function1;", "Lcom/intellij/openapi/project/Project;", "closeSettings", "c", "Ljavax/swing/JComponent;", "listenToCompletionDisabled", "Lcom/intellij/ui/dsl/builder/Panel;", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nLLMConfigurableUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMConfigurableUtils.kt\ncom/intellij/ml/llm/core/settings/LLMConfigurableUtils\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,90:1\n42#2,3:91\n*S KotlinDebug\n*F\n+ 1 LLMConfigurableUtils.kt\ncom/intellij/ml/llm/core/settings/LLMConfigurableUtils\n*L\n53#1:91,3\n*E\n"})
public final class LLMConfigurableUtils {
    @NotNull
    public static final LLMConfigurableUtils INSTANCE = new LLMConfigurableUtils();

    private LLMConfigurableUtils() {
    }

    public final void navigateToConfigurable(@NotNull Class<? extends Configurable> configurableClass) {
        Intrinsics.checkNotNullParameter(configurableClass, (String)"configurableClass");
        DataManager.getInstance().getDataContextFromFocusAsync().then(arg_0 -> LLMConfigurableUtils.navigateToConfigurable$lambda$1(arg_0 -> LLMConfigurableUtils.navigateToConfigurable$lambda$0(configurableClass, arg_0), arg_0));
    }

    @NotNull
    public final Cell<JButton> llmActivationButton(@NotNull Row $this$llmActivationButton, @NotNull Function1<? super JButton, ? extends Project> getProject) {
        Intrinsics.checkNotNullParameter((Object)$this$llmActivationButton, (String)"<this>");
        Intrinsics.checkNotNullParameter(getProject, (String)"getProject");
        return SwingUtilsKt.defaultStyle$default($this$llmActivationButton.button(LLMBundle.message("settings.button.activate.assistant", new Object[0]), arg_0 -> LLMConfigurableUtils.llmActivationButton$lambda$0(getProject, arg_0)), false, 1, null);
    }

    public final void closeSettings(@NotNull JComponent c) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Window window = UIUtil.getWindow((Component)c);
            DialogWrapperDialog dialogWrapperDialog = window instanceof DialogWrapperDialog ? (DialogWrapperDialog)window : null;
            if (dialogWrapperDialog == null || (dialogWrapperDialog = dialogWrapperDialog.getDialogWrapper()) == null) break block0;
            dialogWrapperDialog.doCancelAction();
        }
    }

    public final void listenToCompletionDisabled(@NotNull Panel $this$listenToCompletionDisabled) {
        List<LLMCompletionDisabledListener> listeners;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)$this$listenToCompletionDisabled, (String)"<this>");
                listeners = LLMCompletionDisabledListener.Companion.getEnabled();
                if (listeners.isEmpty()) break block4;
                boolean $i$f$service = false;
                Class<LLMSettingsManager> serviceClass$iv = LLMSettingsManager.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                if (((Boolean)((LLMSettingsManager)object).isInlineCompletionEnabledState().get()).booleanValue()) break block5;
            }
            return;
        }
        Ref.ObjectRef fakeComponent = new Ref.ObjectRef();
        Panel.row$default((Panel)$this$listenToCompletionDisabled, null, arg_0 -> LLMConfigurableUtils.listenToCompletionDisabled$lambda$0(fakeComponent, arg_0), (int)1, null);
        Ref.BooleanRef listenersAttached = new Ref.BooleanRef();
        $this$listenToCompletionDisabled.onApply(() -> LLMConfigurableUtils.listenToCompletionDisabled$lambda$1(listenersAttached, fakeComponent, listeners));
    }

    private static final ActionCallback navigateToConfigurable$lambda$0(Class $configurableClass, DataContext it) {
        ActionCallback actionCallback;
        Intrinsics.checkNotNull((Object)it);
        Settings settings = (Settings)Settings.KEY.getData(it);
        if (settings != null) {
            Settings settings2 = settings;
            boolean bl = false;
            Configurable configurable = settings2.find($configurableClass);
            if (configurable != null) {
                Configurable configurable2 = configurable;
                boolean bl2 = false;
                actionCallback = settings2.select(configurable2);
            } else {
                actionCallback = null;
            }
        } else {
            actionCallback = null;
        }
        return actionCallback;
    }

    private static final ActionCallback navigateToConfigurable$lambda$1(Function1 $tmp0, Object p0) {
        return (ActionCallback)$tmp0.invoke(p0);
    }

    private static final Unit llmActivationButton$lambda$0(Function1 $getProject, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JButton");
        Project project = (Project)$getProject.invoke((Object)((JButton)object));
        if (project == null) {
            return Unit.INSTANCE;
        }
        Project project2 = project;
        Object object2 = it.getSource();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type javax.swing.JButton");
        INSTANCE.closeSettings((JButton)object2);
        AIAContentFacade.Companion.getInstance(project2).activateAction();
        AIAssistantAuthorizationEventLogger.INSTANCE.logGoToActivationClicked(project2);
        return Unit.INSTANCE;
    }

    private static final Unit listenToCompletionDisabled$lambda$0(Ref.ObjectRef $fakeComponent, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $fakeComponent.element = Row.text$default((Row)$this$row, (String)"", (int)0, null, (int)6, null).visible(false).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit listenToCompletionDisabled$lambda$1(Ref.BooleanRef $listenersAttached, Ref.ObjectRef $fakeComponent, List $listeners) {
        block5: {
            JComponent jComponent;
            JComponent jComponent2;
            if ($listenersAttached.element) {
                return Unit.INSTANCE;
            }
            $listenersAttached.element = true;
            DataManager dataManager = DataManager.getInstance();
            if ($fakeComponent.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fakeComponent");
                jComponent2 = null;
            } else {
                jComponent2 = (JComponent)$fakeComponent.element;
            }
            DataContext dataContext = dataManager.getDataContext((Component)jComponent2);
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if ($fakeComponent.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fakeComponent");
                jComponent = null;
            } else {
                jComponent = (JComponent)$fakeComponent.element;
            }
            Window window = UIUtil.getWindow((Component)jComponent);
            if (window == null) break block5;
            window.addWindowListener(new WindowAdapter($listeners, project){
                final /* synthetic */ List<LLMCompletionDisabledListener> $listeners;
                final /* synthetic */ Project $project;
                {
                    this.$listeners = $listeners;
                    this.$project = $project;
                }

                public void windowClosed(WindowEvent e) {
                    boolean $i$f$service = false;
                    Class<LLMSettingsManager> serviceClass$iv = LLMSettingsManager.class;
                    Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                    }
                    if (((Boolean)((LLMSettingsManager)object).isInlineCompletionEnabledState().get()).booleanValue()) {
                        return;
                    }
                    ApplicationKt.getApplication().invokeLater(() -> listenToCompletionDisabled.2.1.windowClosed$lambda$0(this.$listeners, this.$project));
                }

                private static final void windowClosed$lambda$0(List $listeners, Project $project) {
                    Iterable $this$forEach$iv = $listeners;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        LLMCompletionDisabledListener it = (LLMCompletionDisabledListener)element$iv;
                        boolean bl = false;
                        if (!it.isEnabled()) continue;
                        it.completionDisabled($project);
                    }
                }
            });
        }
        return Unit.INSTANCE;
    }
}

