/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.DataSharingSettingsChangeListener;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.settings.LLMDataSharingConsentState;
import com.intellij.ml.llm.core.settings.LLMDataSharingManagerKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\t\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nJ\b\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\b\u0010\u0011\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0003J\u0006\u0010\u0015\u001a\u00020\nJ\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u00020\n@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001c8G\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0013\u0010!\u001a\u0004\u0018\u00010\n8G\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006%"}, d2={"Lcom/intellij/ml/llm/core/settings/LLMDataSharingManager;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/ml/llm/core/settings/LLMDataSharingConsentState;", "isDataSharingEnabled", "", "isDataSharingPermitted", "setDataSharingPermitted", "", "isPermitted", "loadStateAndSubscribeToUpdates", "scheduleLoadState", "loadState", "askDataSharingConsentIfNeeded", "project", "Lcom/intellij/openapi/project/Project;", "shouldShowConsentDialog", "isDataSharingForciblyDisabledForTests", "()Z", "setDataSharingForciblyDisabledForTests", "(Z)V", "updateDataSharingAgreement", "version", "", "text", "consentVersion", "getConsentVersion", "()Ljava/lang/String;", "dataSharingPermission", "getDataSharingPermission", "()Ljava/lang/Boolean;", "Companion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nLLMDataSharingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMDataSharingManager.kt\ncom/intellij/ml/llm/core/settings/LLMDataSharingManager\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,192:1\n230#2,5:193\n1#3:198\n13#4:199\n*S KotlinDebug\n*F\n+ 1 LLMDataSharingManager.kt\ncom/intellij/ml/llm/core/settings/LLMDataSharingManager\n*L\n75#1:193,5\n30#1:199\n*E\n"})
public final class LLMDataSharingManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private MutableStateFlow<LLMDataSharingConsentState> state;
    private boolean isDataSharingForciblyDisabledForTests;
    @NotNull
    private static final Logger LOG;

    public LLMDataSharingManager(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
        this.state = StateFlowKt.MutableStateFlow(null);
        this.loadStateAndSubscribeToUpdates();
    }

    public final boolean isDataSharingEnabled() {
        return this.isDataSharingPermitted() && !LLMDataSharingManagerKt.access$isDataSharingProhibitedByProvisioner() && !ApplicationManager.getApplication().isUnitTestMode() && !this.isDataSharingForciblyDisabledForTests;
    }

    public final boolean isDataSharingPermitted() {
        LLMDataSharingConsentState consentState = (LLMDataSharingConsentState)this.state.getValue();
        return consentState != null && consentState.getPermission() == ConsentOptions.Permission.YES && !consentState.isConfirmationNeeded();
    }

    public final void setDataSharingPermitted(boolean isPermitted) {
        LLMDataSharingConsentState lLMDataSharingConsentState;
        LLMDataSharingConsentState nextValue$iv;
        Object prevValue$iv;
        ConsentOptions.Permission permission = isPermitted ? ConsentOptions.Permission.YES : ConsentOptions.Permission.NO;
        MutableStateFlow<LLMDataSharingConsentState> $this$update$iv = this.state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            LLMDataSharingConsentState it = (LLMDataSharingConsentState)prevValue$iv;
            boolean bl = false;
            lLMDataSharingConsentState = it;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = lLMDataSharingConsentState != null ? LLMDataSharingConsentState.copy$default(lLMDataSharingConsentState, null, false, permission, 1, null) : null)));
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(isPermitted, null){
            int label;
            final /* synthetic */ boolean $isPermitted;
            {
                this.$isPermitted = $isPermitted;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ConsentOptions.getInstance().setAiDataCollectionPermission(this.$isPermitted);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void loadStateAndSubscribeToUpdates() {
        ApplicationManager.getApplication().getMessageBus().connect(this.scope).subscribe(DataSharingSettingsChangeListener.TOPIC, (Object)new DataSharingSettingsChangeListener(this){
            final /* synthetic */ LLMDataSharingManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void consentsUpdated() {
                LLMDataSharingManager.access$getLOG$cp().debug("Consents updated, reloading state");
                LLMDataSharingManager.access$scheduleLoadState(this.this$0);
            }

            public void consentWritten() {
            }
        });
        this.scheduleLoadState();
    }

    private final void scheduleLoadState() {
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ LLMDataSharingManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        LLMDataSharingManager.access$loadState(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void loadState() {
        Pair pair = ConsentOptions.getInstance().getConsents(ConsentOptions.condAiDataCollectionConsent());
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"getConsents(...)");
        Pair pair2 = pair;
        List consents = (List)pair2.component1();
        Boolean isConfirmationNeeded = (Boolean)pair2.component2();
        if (consents.size() != 1) {
            throw new IllegalStateException("Cannot find AI data sharing agreement, it is expected to be bundled");
        }
        Consent consent = (Consent)consents.get(0);
        ConsentOptions.Permission permission = ConsentOptions.getInstance().getAiDataCollectionPermission();
        Intrinsics.checkNotNullExpressionValue((Object)permission, (String)"getAiDataCollectionPermission(...)");
        ConsentOptions.Permission permission2 = permission;
        Intrinsics.checkNotNull((Object)consent);
        Intrinsics.checkNotNull((Object)isConfirmationNeeded);
        LLMDataSharingConsentState loadedState = new LLMDataSharingConsentState(consent, isConfirmationNeeded, permission2);
        this.state.setValue((Object)loadedState);
        LOG.debug("New consent state loaded: " + loadedState);
    }

    @RequiresEdt
    private final void askDataSharingConsentIfNeeded(Project project) {
        if (LLMDataSharingManagerKt.access$isDataSharingProhibitedByProvisioner() || LLMDataSharingManagerKt.access$isNonJetBrainsIDE()) {
            return;
        }
        LLMDataSharingConsentState consentState = (LLMDataSharingConsentState)this.state.getValue();
        if (consentState != null && this.shouldShowConsentDialog()) {
            String string = LLMBundle.message("notification.data.sharing.title", new Object[0]);
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)consentState.getConsent().getText(), (String)"getText(...)");
            boolean isYes = MessageDialogBuilder.Companion.yesNo(string, LLMBundle.message("notification.data.sharing.message.v2", objectArray)).ask(project);
            this.setDataSharingPermitted(isYes);
        }
    }

    public final boolean shouldShowConsentDialog() {
        LLMDataSharingConsentState consentState = (LLMDataSharingConsentState)this.state.getValue();
        return consentState != null && consentState.isConfirmationNeeded() && !ApplicationManager.getApplication().isUnitTestMode() && !this.isDataSharingForciblyDisabledForTests;
    }

    public final boolean isDataSharingForciblyDisabledForTests() {
        return this.isDataSharingForciblyDisabledForTests;
    }

    @TestOnly
    public final void setDataSharingForciblyDisabledForTests(boolean bl) {
        this.isDataSharingForciblyDisabledForTests = bl;
    }

    @TestOnly
    public final void updateDataSharingAgreement(@NotNull String version, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ConsentOptions.getInstance().applyServerUpdates(StringsKt.trimIndent((String)("\n      [\n        {\n          \"consentId\": \"ai.data.collection.and.use.policy\",\n          \"version\": \"" + version + "\",\n          \"text\": \"" + text + "\",\n          \"printableName\": \"JetBrains AI Data Collection and Use Policy\",\n          \"accepted\": \"false\"\n        }\n      ]\n    ")));
    }

    @TestOnly
    @Nullable
    public final String getConsentVersion() {
        LLMDataSharingConsentState lLMDataSharingConsentState = (LLMDataSharingConsentState)this.state.getValue();
        return lLMDataSharingConsentState != null && (lLMDataSharingConsentState = lLMDataSharingConsentState.getConsent()) != null && (lLMDataSharingConsentState = lLMDataSharingConsentState.getVersion()) != null ? lLMDataSharingConsentState.toString() : null;
    }

    @TestOnly
    @Nullable
    public final Boolean getDataSharingPermission() {
        Boolean bl;
        LLMDataSharingConsentState lLMDataSharingConsentState = (LLMDataSharingConsentState)this.state.getValue();
        if (lLMDataSharingConsentState != null && (lLMDataSharingConsentState = lLMDataSharingConsentState.getPermission()) != null) {
            LLMDataSharingConsentState it = lLMDataSharingConsentState;
            boolean bl2 = false;
            bl = it == ConsentOptions.Permission.YES;
        } else {
            bl = null;
        }
        return bl;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$scheduleLoadState(LLMDataSharingManager $this) {
        $this.scheduleLoadState();
    }

    public static final /* synthetic */ void access$loadState(LLMDataSharingManager $this) {
        $this.loadState();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LLMDataSharingManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/core/settings/LLMDataSharingManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "isDataSharingEnabled", "", "askDataSharingConsentIfNeeded", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nLLMDataSharingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMDataSharingManager.kt\ncom/intellij/ml/llm/core/settings/LLMDataSharingManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,192:1\n42#2,3:193\n42#2,3:196\n*S KotlinDebug\n*F\n+ 1 LLMDataSharingManager.kt\ncom/intellij/ml/llm/core/settings/LLMDataSharingManager$Companion\n*L\n32#1:193,3\n42#1:196,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isDataSharingEnabled() {
            boolean $i$f$service = false;
            Class<LLMDataSharingManager> serviceClass$iv = LLMDataSharingManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return ((LLMDataSharingManager)object).isDataSharingEnabled();
        }

        @RequiresEdt
        public final void askDataSharingConsentIfNeeded(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            boolean $i$f$service = false;
            Class<LLMDataSharingManager> serviceClass$iv = LLMDataSharingManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((LLMDataSharingManager)object).askDataSharingConsentIfNeeded(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

