/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.statistics.fus;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.ml.llm.core.AIAssistantKillSwitch;
import com.intellij.ml.llm.core.AIAssistantKillSwitchKt;
import com.intellij.ml.llm.core.chat.promptLibrary.AICustomizablePrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AIAssistantCustomInstructionsStorage;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AIAssistantStoredInstruction;
import com.intellij.ml.llm.core.statistics.fus.PromptIdRuleValidator;
import com.intellij.ml.llm.privacy.aiignore.AiIgnoreFileManager;
import com.intellij.ml.llm.privacy.aiignore.AiIgnoreFilesState;
import com.intellij.ml.llm.privacy.aiignore.AiIgnoreManagerSettings;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/AIAssistantProjectStateCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "isActionCustomized", "", "actionId", "", "Companion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nAIAssistantProjectStateCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantProjectStateCollector.kt\ncom/intellij/ml/llm/core/statistics/fus/AIAssistantProjectStateCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,89:1\n1563#2:90\n1634#2,3:91\n30#3,2:94\n261#4,3:96\n*S KotlinDebug\n*F\n+ 1 AIAssistantProjectStateCollector.kt\ncom/intellij/ml/llm/core/statistics/fus/AIAssistantProjectStateCollector\n*L\n50#1:90\n50#1:91,3\n74#1:94,2\n28#1:96,3\n*E\n"})
public final class AIAssistantProjectStateCollector
extends ProjectUsagesCollector {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final StringEventField ACTION_ID;
    @NotNull
    private static final BooleanEventField IS_CUSTOMIZED;
    @NotNull
    private static final EventId1<AIAssistantKillSwitch.Level> KILL_SWITCH_STATE;
    @NotNull
    private static final EventId2<String, Boolean> SYSTEM_PROMPT_CUSTOMIZATION;
    @NotNull
    private static final BooleanEventField PRIVACY_FIELD_ENABLED;
    @NotNull
    private static final BooleanEventField PRIVACY_FIELD_FILE_CACHE_EXISTS;
    @NotNull
    private static final BooleanEventField PRIVACY_FIELD_HAS_FILE_AIIGNORE;
    @NotNull
    private static final BooleanEventField PRIVACY_FIELD_HAS_FILE_COMPETITORS;
    @NotNull
    private static final VarargEventId PRIVACY;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$map$iv = AICustomizablePrompt.Companion.getAllCustomizablePrompts();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Object object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            void prompt;
            Object item$iv$iv = object.next();
            AICustomizablePrompt aICustomizablePrompt = (AICustomizablePrompt)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SYSTEM_PROMPT_CUSTOMIZATION.metric((Object)prompt.getID(), (Object)this.isActionCustomized(project, prompt.getID())));
        }
        List promptsCustomization = (List)destination$iv$iv;
        boolean privacyEnabled = AiIgnoreManagerSettings.Companion.getInstance(project).isEnabled();
        AiIgnoreFilesState privacyFilesState = (AiIgnoreFilesState)AiIgnoreFileManager.Companion.getInstance(project).getState().getValue();
        boolean privacyFileCacheExists = privacyFilesState != null;
        AiIgnoreFilesState aiIgnoreFilesState = privacyFilesState;
        boolean privacyHasFileAiIgnore = (aiIgnoreFilesState != null ? aiIgnoreFilesState.getPrimaryFile() : null) != null;
        Object object2 = privacyFilesState;
        boolean privacyHasFileCompetitors = object2 != null && (object2 = object2.getCompetitorsFiles()) != null ? !((Collection)object2).isEmpty() : false;
        Object $this$getMetrics_u24lambda_u241 = object = (Set)new LinkedHashSet();
        boolean bl = false;
        $this$getMetrics_u24lambda_u241.addAll(promptsCustomization);
        $this$getMetrics_u24lambda_u241.add(KILL_SWITCH_STATE.metric((Object)AIAssistantKillSwitchKt.getAssistantAllowedLevel(project)));
        EventPair[] eventPairArray = new EventPair[]{PRIVACY_FIELD_ENABLED.with((Object)privacyEnabled), PRIVACY_FIELD_FILE_CACHE_EXISTS.with((Object)privacyFileCacheExists), PRIVACY_FIELD_HAS_FILE_AIIGNORE.with((Object)privacyHasFileAiIgnore), PRIVACY_FIELD_HAS_FILE_COMPETITORS.with((Object)privacyHasFileCompetitors)};
        $this$getMetrics_u24lambda_u241.add(PRIVACY.metric(eventPairArray));
        return object;
    }

    private final boolean isActionCustomized(Project project, String actionId) {
        AICustomizablePrompt aICustomizablePrompt = AICustomizablePrompt.Companion.getCustomizablePrompt(actionId);
        if (aICustomizablePrompt == null || (aICustomizablePrompt = aICustomizablePrompt.getDefaultPrompt()) == null) {
            return true;
        }
        AICustomizablePrompt defaultPrompt = aICustomizablePrompt;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<AIAssistantCustomInstructionsStorage> serviceClass$iv = AIAssistantCustomInstructionsStorage.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        AIAssistantStoredInstruction aIAssistantStoredInstruction = ((AIAssistantCustomInstructionsStorage)object).findById(actionId);
        if (aIAssistantStoredInstruction == null || (aIAssistantStoredInstruction = aIAssistantStoredInstruction.getContent()) == null) {
            return false;
        }
        AIAssistantStoredInstruction storedPrompt = aIAssistantStoredInstruction;
        return !Intrinsics.areEqual((Object)defaultPrompt, (Object)storedPrompt);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$iv;
        Companion = new Companion(null);
        GROUP = new EventLogGroup("llm.project.state", 7, null, 4, null);
        ACTION_ID = EventFields.StringValidatedByCustomRule((String)"action_id", PromptIdRuleValidator.class);
        IS_CUSTOMIZED = EventFields.Boolean((String)"is_customized");
        EventField[] eventFieldArray = EventFields.INSTANCE;
        String name$iv = "level";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        KILL_SWITCH_STATE = GROUP.registerEvent("kill.switch.level", (EventField)new EnumEventField(name$iv, AIAssistantKillSwitch.Level.class, null, transform$iv));
        SYSTEM_PROMPT_CUSTOMIZATION = GROUP.registerEvent("system.prompts.customized", (EventField)ACTION_ID, (EventField)IS_CUSTOMIZED);
        PRIVACY_FIELD_ENABLED = EventFields.Enabled;
        PRIVACY_FIELD_FILE_CACHE_EXISTS = EventFields.Boolean((String)"file_cache_exists");
        PRIVACY_FIELD_HAS_FILE_AIIGNORE = EventFields.Boolean((String)"has_file_aiignore");
        PRIVACY_FIELD_HAS_FILE_COMPETITORS = EventFields.Boolean((String)"has_file_competitors");
        eventFieldArray = new EventField[]{PRIVACY_FIELD_ENABLED, PRIVACY_FIELD_FILE_CACHE_EXISTS, PRIVACY_FIELD_HAS_FILE_AIIGNORE, PRIVACY_FIELD_HAS_FILE_COMPETITORS};
        PRIVACY = GROUP.registerVarargEvent("privacy", eventFieldArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/AIAssistantProjectStateCollector$Companion;", "", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGROUP", "()Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "ACTION_ID", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "IS_CUSTOMIZED", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "KILL_SWITCH_STATE", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "Lcom/intellij/ml/llm/core/AIAssistantKillSwitch$Level;", "getKILL_SWITCH_STATE", "()Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "SYSTEM_PROMPT_CUSTOMIZATION", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "", "getSYSTEM_PROMPT_CUSTOMIZATION", "()Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "PRIVACY_FIELD_ENABLED", "PRIVACY_FIELD_FILE_CACHE_EXISTS", "PRIVACY_FIELD_HAS_FILE_AIIGNORE", "PRIVACY_FIELD_HAS_FILE_COMPETITORS", "PRIVACY", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EventLogGroup getGROUP() {
            return GROUP;
        }

        @NotNull
        public final EventId1<AIAssistantKillSwitch.Level> getKILL_SWITCH_STATE() {
            return KILL_SWITCH_STATE;
        }

        @NotNull
        public final EventId2<String, Boolean> getSYSTEM_PROMPT_CUSTOMIZATION() {
            return SYSTEM_PROMPT_CUSTOMIZATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

