/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.statistics.fus;

import com.intellij.ml.llm.core.models.api.AiaLlmProfileID;
import com.intellij.ml.llm.core.providers.ThirdPartyLLMProfileId;
import com.intellij.ml.llm.grazie.GrazieLLMProfileID;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/AiaLlmProfileIdAllowlist;", "", "<init>", "()V", "ALLOWED_THIRD_PARTY_PROVIDERS_IDS", "", "", "getALLOWED_THIRD_PARTY_PROVIDERS_IDS", "()Ljava/util/List;", "ALLOWED_THIRD_PARTY_LLM_PROFILE_IDS", "toAllowlisted", "profileId", "Lcom/intellij/ml/llm/core/models/api/AiaLlmProfileID;", "extractModelSize", "Lcom/intellij/ml/llm/core/statistics/fus/AiaLlmProfileIdAllowlist$AllowedProfileSize;", "toAllowedProfileSize", "size", "", "isAllowlistedProfileId", "", "isAllowlistedProfileId$intellij_ml_llm_core", "AllowedProfileSize", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nAiaLlmProfileIdAllowlist.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiaLlmProfileIdAllowlist.kt\ncom/intellij/ml/llm/core/statistics/fus/AiaLlmProfileIdAllowlist\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,339:1\n1#2:340\n*E\n"})
public final class AiaLlmProfileIdAllowlist {
    @NotNull
    public static final AiaLlmProfileIdAllowlist INSTANCE = new AiaLlmProfileIdAllowlist();
    @NotNull
    private static final List<String> ALLOWED_THIRD_PARTY_PROVIDERS_IDS;
    @NotNull
    private static final List<String> ALLOWED_THIRD_PARTY_LLM_PROFILE_IDS;

    private AiaLlmProfileIdAllowlist() {
    }

    @NotNull
    public final List<String> getALLOWED_THIRD_PARTY_PROVIDERS_IDS() {
        return ALLOWED_THIRD_PARTY_PROVIDERS_IDS;
    }

    @NotNull
    public final String toAllowlisted(@NotNull AiaLlmProfileID profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        if (profileId instanceof GrazieLLMProfileID) {
            return ((GrazieLLMProfileID)profileId).getId();
        }
        if (profileId instanceof ThirdPartyLLMProfileId) {
            String string;
            String string2;
            String it = string2 = ((ThirdPartyLLMProfileId)profileId).getProviderId();
            boolean bl = false;
            String string3 = ALLOWED_THIRD_PARTY_PROVIDERS_IDS.contains(it) ? string2 : null;
            if (string3 == null) {
                string3 = "unknown";
            }
            String providerId = string3;
            String it2 = string = StringsKt.substringBeforeLast$default((String)((ThirdPartyLLMProfileId)profileId).getProfileId(), (String)":", null, (int)2, null);
            boolean bl2 = false;
            String string4 = ALLOWED_THIRD_PARTY_LLM_PROFILE_IDS.contains(it2) ? string : null;
            if (string4 == null) {
                string4 = "unknown";
            }
            String modelId = string4;
            return providerId + "/" + modelId;
        }
        return "unknown";
    }

    @NotNull
    public final AllowedProfileSize extractModelSize(@NotNull AiaLlmProfileID profileId) {
        block5: {
            Object object;
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
                    if (profileId instanceof GrazieLLMProfileID) {
                        return AllowedProfileSize.UNKNOWN;
                    }
                    if (!(profileId instanceof ThirdPartyLLMProfileId)) break block5;
                    String sizeString = StringsKt.substringAfterLast((String)((ThirdPartyLLMProfileId)profileId).getProfileId(), (String)":", (String)"");
                    if (((CharSequence)sizeString).length() == 0) {
                        return AllowedProfileSize.UNKNOWN;
                    }
                    object = StringsKt.toFloatOrNull((String)StringsKt.dropLast((String)sizeString, (int)1));
                    if (object == null) break block6;
                    float it = ((Number)object).floatValue();
                    boolean bl = false;
                    AllowedProfileSize allowedProfileSize = INSTANCE.toAllowedProfileSize(it);
                    object = allowedProfileSize;
                    if (allowedProfileSize != null) break block7;
                }
                object = AllowedProfileSize.UNKNOWN;
            }
            return object;
        }
        return AllowedProfileSize.UNKNOWN;
    }

    private final AllowedProfileSize toAllowedProfileSize(float size) {
        return size < 0.0f ? AllowedProfileSize.UNKNOWN : (size < 2.0f ? AllowedProfileSize.LESS_THEN_2B : (size < 6.0f ? AllowedProfileSize.SIZE_2B_TO_6B : (size < 10.0f ? AllowedProfileSize.SIZE_6B_TO_10B : (size < 20.0f ? AllowedProfileSize.SIZE_10B_TO_20B : (size < 30.0f ? AllowedProfileSize.SIZE_20B_TO_30B : (size < 40.0f ? AllowedProfileSize.SIZE_30B_TO_40B : AllowedProfileSize.MORE_THEN_40B))))));
    }

    public final boolean isAllowlistedProfileId$intellij_ml_llm_core(@NotNull AiaLlmProfileID profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        if (profileId instanceof GrazieLLMProfileID) {
            return true;
        }
        if (profileId instanceof ThirdPartyLLMProfileId) {
            boolean providerIdIsOk = ALLOWED_THIRD_PARTY_PROVIDERS_IDS.contains(((ThirdPartyLLMProfileId)profileId).getProviderId());
            boolean modelIdIsOk = ALLOWED_THIRD_PARTY_LLM_PROFILE_IDS.contains(((ThirdPartyLLMProfileId)profileId).getProfileId());
            return providerIdIsOk && modelIdIsOk;
        }
        return false;
    }

    static {
        Object[] objectArray = new String[]{"OpenAI", "ollama", "lmstudio", "JetBrains", "llama.cpp", "liteLLM"};
        ALLOWED_THIRD_PARTY_PROVIDERS_IDS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"gpt-oss", "deepseek-r1", "gemma3", "qwen3", "llama3.1", "nomic-embed-text", "llama3.2", "mistral", "qwen2.5", "llama3", "llava", "phi3", "gemma2", "qwen2.5-coder", "gemma", "qwen", "mxbai-embed-large", "phi4", "qwen2", "llama2", "minicpm-v", "codellama", "tinyllama", "dolphin3", "olmo2", "mistral-nemo", "llama3.3", "llama3.2-vision", "deepseek-v3", "bge-m3", "mistral-small", "smollm2", "qwq", "llava-llama3", "mixtral", "all-minilm", "llama2-uncensored", "starcoder2", "deepseek-coder", "deepseek-coder-v2", "codegemma", "snowflake-arctic-embed", "phi", "llama4", "orca-mini", "dolphin-mixtral", "openthinker", "qwen2.5vl", "falcon3", "granite3.1-moe", "gemma3n", "granite3.3", "smollm", "codestral", "dolphin-llama3", "phi4-reasoning", "wizardlm2", "dolphin-mistral", "cogito", "magistral", "qwen3-coder", "phi4-mini", "command-r", "devstral", "hermes3", "phi3.5", "deepscaler", "mistral-small3.2", "dolphin-phi", "yi", "granite3.2-vision", "zephyr", "deepcoder", "mistral-small3.1", "mistral-large", "moondream", "wizard-vicuna-uncensored", "granite-code", "starcoder", "deepseek-llm", "vicuna", "openchat", "mistral-openorca", "deepseek-v2", "codegeex4", "openhermes", "codeqwen", "qwen2-math", "llama2-chinese", "nous-hermes", "exaone-deep", "snowflake-arctic-embed2", "aya", "tinydolphin", "glm4", "falcon", "granite3.2", "stable-code", "nous-hermes2", "neural-chat", "wizardcoder", "command-r-plus", "bakllava", "opencoder", "bge-large", "stablelm2", "sqlcoder", "llama3-chatqa", "llava-phi3", "yi-coder", "granite3.1-dense", "granite3-dense", "wizard-math", "reflection", "llama3-gradient", "exaone3.5", "dbrx", "samantha-mistral", "dolphincoder", "r1-1776", "tulu3", "nemotron-mini", "starling-lm", "paraphrase-multilingual", "solar", "phind-codellama", "internlm2", "xwinlm", "athene-v2", "granite-embedding", "nemotron", "llama3-groq-tool-use", "yarn-llama2", "meditron", "granite3-moe", "wizardlm-uncensored", "aya-expanse", "smallthinker", "llama-guard3", "wizardlm", "orca2", "medllama2", "nous-hermes2-mixtral", "stable-beluga", "deepseek-v2.5", "reader-lm", "llama-pro", "yarn-mistral", "shieldgemma", "command-r7b", "command-a", "phi4-mini-reasoning", "mathstral", "nexusraven", "everythinglm", "codeup", "marco-o1", "stablelm-zephyr", "solar-pro", "duckdb-nsql", "falcon2", "magicoder", "mistrallite", "codebooga", "bespoke-minicheck", "wizard-vicuna", "nuextract", "deepseek-v3.1", "granite3-guardian", "megadolphin", "notux", "open-orca-platypus2", "notus", "sailor2", "firefunction-v2", "goliath", "alfred", "command-r7b-arabic", "embeddinggemma", "JetBrains/Mellum-4b-base", "JetBrains/Mellum-4b-sft-all", "JetBrains/Mellum-4b-sft-python", "JetBrains/Mellum-4b-sft-kotlin", "bytedance/seed-oss-36b", "nousresearch/hermes-4-70b", "qwen/qwen3-4b-thinking-2507", "qwen/qwen3-4b-2507", "openai/gpt-oss-120b", "openai/gpt-oss-20b", "qwen/qwen3-coder-30b", "qwen/qwen3-30b-a3b-2507", "qwen/qwen3-coder-480b", "qwen/qwen3-235b-a22b-2507", "liquid/lfm2-1.2b", "baidu/ernie-4.5-21b-a3b", "mistralai/devstral-small-2507", "google/gemma-3n-e4b", "mistralai/mistral-small-3.2", "mistralai/magistral-small", "deepseek/deepseek-r1-0528-qwen3-8b", "mistralai/devstral-small-2505", "microsoft/phi-4-mini-reasoning", "microsoft/phi-4-reasoning-plus", "qwen/qwen3-235b-a22b", "qwen/qwen3-32b", "qwen/qwen3-30b-a3b", "qwen/qwen3-1.7b", "qwen/qwen3-4b", "qwen/qwen3-14b", "qwen/qwen3-8b", "google/gemma-3-27b", "google/gemma-3-12b", "google/gemma-3-4b", "google/gemma-3-1b", "qwen/qwq-32b", "ibm/granite-3.2-8b", "qwen/qwen2.5-vl-7b", "microsoft/phi-4", "ibm/granite-3.1-8b", "meta/llama-3.3-70b", "qwen/qwen2.5-coder-14b", "qwen/qwen2.5-coder-32b", "mistralai/mistral-nemo-instruct-2407", "mistralai/mathstral-7b-v0.1", "google/gemma-2-9b", "google/gemma-2-27b", "mistralai/codestral-22b-v0.1", "mistralai/mistral-7b-instruct-v0.3", "full-line-code-completion"};
        ALLOWED_THIRD_PARTY_LLM_PROFILE_IDS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/AiaLlmProfileIdAllowlist$AllowedProfileSize;", "", "value", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "UNKNOWN", "LESS_THEN_2B", "SIZE_2B_TO_6B", "SIZE_6B_TO_10B", "SIZE_10B_TO_20B", "SIZE_20B_TO_30B", "SIZE_30B_TO_40B", "MORE_THEN_40B", "intellij.ml.llm.core"})
    public static final class AllowedProfileSize
    extends Enum<AllowedProfileSize> {
        @NotNull
        private final String value;
        public static final /* enum */ AllowedProfileSize UNKNOWN = new AllowedProfileSize("unknown");
        public static final /* enum */ AllowedProfileSize LESS_THEN_2B = new AllowedProfileSize("<2b");
        public static final /* enum */ AllowedProfileSize SIZE_2B_TO_6B = new AllowedProfileSize("2b-6b");
        public static final /* enum */ AllowedProfileSize SIZE_6B_TO_10B = new AllowedProfileSize("6b-10b");
        public static final /* enum */ AllowedProfileSize SIZE_10B_TO_20B = new AllowedProfileSize("10b-20b");
        public static final /* enum */ AllowedProfileSize SIZE_20B_TO_30B = new AllowedProfileSize("20b-30b");
        public static final /* enum */ AllowedProfileSize SIZE_30B_TO_40B = new AllowedProfileSize("30b-40b");
        public static final /* enum */ AllowedProfileSize MORE_THEN_40B = new AllowedProfileSize(">=40b");
        private static final /* synthetic */ AllowedProfileSize[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private AllowedProfileSize(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static AllowedProfileSize[] values() {
            return (AllowedProfileSize[])$VALUES.clone();
        }

        public static AllowedProfileSize valueOf(String value) {
            return Enum.valueOf(AllowedProfileSize.class, value);
        }

        @NotNull
        public static EnumEntries<AllowedProfileSize> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = allowedProfileSizeArray = new AllowedProfileSize[]{AllowedProfileSize.UNKNOWN, AllowedProfileSize.LESS_THEN_2B, AllowedProfileSize.SIZE_2B_TO_6B, AllowedProfileSize.SIZE_6B_TO_10B, AllowedProfileSize.SIZE_10B_TO_20B, AllowedProfileSize.SIZE_20B_TO_30B, AllowedProfileSize.SIZE_30B_TO_40B, AllowedProfileSize.MORE_THEN_40B};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

