/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.statistics.fus.jcp;

import com.intellij.ml.llm.core.statistics.fus.jcp.JcpTokenProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.net.HttpConnectionUtils;
import java.io.Closeable;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.analytics.sending.AnalyticsSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/jcp/JcpAnalyticsSender;", "Lorg/jetbrains/analytics/sending/AnalyticsSender;", "tokenProvider", "Lcom/intellij/ml/llm/core/statistics/fus/jcp/JcpTokenProvider;", "<init>", "(Lcom/intellij/ml/llm/core/statistics/fus/jcp/JcpTokenProvider;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "send", "", "eventsJson", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nJcpAnalyticsClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JcpAnalyticsClient.kt\ncom/intellij/ml/llm/core/statistics/fus/jcp/JcpAnalyticsSender\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n23#2:131\n1#3:132\n*S KotlinDebug\n*F\n+ 1 JcpAnalyticsClient.kt\ncom/intellij/ml/llm/core/statistics/fus/jcp/JcpAnalyticsSender\n*L\n89#1:131\n*E\n"})
public final class JcpAnalyticsSender
implements AnalyticsSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JcpTokenProvider tokenProvider;
    @NotNull
    private final Logger logger;
    @NotNull
    private static final String JCP_ANALYTICS_ENDPOINT_URL_REGISTRY_KEY = "llm.jcp.analytics.endpoint.url";
    @NotNull
    private static final String JCP_ANALYTICS_ENDPOINT_URL_VM_OPTION_NAME = "JCP_ANALYTICS_ENDPOINT";

    public JcpAnalyticsSender(@NotNull JcpTokenProvider tokenProvider) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        this.tokenProvider = tokenProvider;
        JcpAnalyticsSender $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JcpAnalyticsSender.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object send(@NotNull String eventsJson, @NotNull Continuation<? super Boolean> $completion) {
        Object object;
        Object object2;
        block13: {
            block12: {
                object2 = this.tokenProvider.getToken();
                if (object2 == null) break block12;
                String it = object2;
                boolean bl = false;
                String string = "Bearer " + StringsKt.removePrefix((String)it, (CharSequence)"Bearer");
                object2 = string;
                if (string != null) break block13;
            }
            return Boxing.boxBoolean((boolean)false);
        }
        Object token = object2;
        if (Companion.getJcpUrl() == null) {
            return Boxing.boxBoolean((boolean)false);
        }
        this.logger.debug("Sending AI analytics events to JCP. Url: " + Companion.getJcpUrl());
        try {
            String string = Companion.getJcpUrl();
            Intrinsics.checkNotNull((Object)string);
            object = HttpConnectionUtils.openHttpConnection((String)string);
            HttpURLConnection $this$send_u24lambda_u241 = object;
            boolean bl = false;
            $this$send_u24lambda_u241.setRequestMethod("POST");
            $this$send_u24lambda_u241.setRequestProperty("Content-Type", "application/json");
            $this$send_u24lambda_u241.setRequestProperty("Authorization", (String)token);
            $this$send_u24lambda_u241.setDoOutput(true);
            HttpURLConnection connection = object;
            boolean bl2 = false;
            Closeable closeable = connection.getOutputStream();
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl3 = false;
                byte[] byArray = eventsJson.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                it.write(byArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            object = Boxing.boxInt((int)connection.getResponseCode());
        }
        catch (Exception e) {
            this.logger.error("Failed to send JCP analytics events", (Throwable)e);
            object = Unit.INSTANCE;
        }
        HttpURLConnection status = object;
        this.logger.debug("JCP response status: " + status);
        return Boxing.boxBoolean((boolean)Intrinsics.areEqual((Object)status, (Object)Boxing.boxInt((int)200)));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/jcp/JcpAnalyticsSender$Companion;", "", "<init>", "()V", "JCP_ANALYTICS_ENDPOINT_URL_REGISTRY_KEY", "", "JCP_ANALYTICS_ENDPOINT_URL_VM_OPTION_NAME", "jcpUrl", "getJcpUrl", "()Ljava/lang/String;", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nJcpAnalyticsClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JcpAnalyticsClient.kt\ncom/intellij/ml/llm/core/statistics/fus/jcp/JcpAnalyticsSender$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getJcpUrl() {
            String string = System.getenv(JcpAnalyticsSender.JCP_ANALYTICS_ENDPOINT_URL_VM_OPTION_NAME);
            if (string == null && (string = System.getProperty(JcpAnalyticsSender.JCP_ANALYTICS_ENDPOINT_URL_VM_OPTION_NAME)) == null) {
                String string2;
                String it = string2 = Registry.Companion.get(JcpAnalyticsSender.JCP_ANALYTICS_ENDPOINT_URL_REGISTRY_KEY).asString();
                boolean bl = false;
                string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

