/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.grazie;

import ai.grazie.model.llm.chat.LLMChatRole;
import ai.grazie.model.llm.profile.LLMProfileID;
import ai.jetbrains.code.prompt.llm.JetBrainsAIModels;
import ai.koog.prompt.llm.LLModel;
import com.intellij.ml.llm.core.models.api.AiChatMessage;
import com.intellij.ml.llm.core.models.api.AiaLlmChatRole;
import com.intellij.ml.llm.core.models.api.AiaLlmProfileID;
import com.intellij.ml.llm.core.providers.ThirdPartyLLMProfileId;
import com.intellij.ml.llm.grazie.GrazieLLMChatMessageTestUtils;
import com.intellij.ml.llm.grazie.GrazieLLMProfileID;
import com.intellij.ml.llm.grazie.adapters.PrivacySafeLLMChatFunctionMessage;
import com.intellij.ml.llm.grazie.adapters.PrivacySafeLLMChatMessage;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.SystemProperties;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0005\u001a\n\u0010\t\u001a\u00020\u0006*\u00020\u0005\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000b\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000f"}, d2={"grazieIsStaging", "", "getGrazieIsStaging", "()Z", "toLLMProfileID", "Lai/grazie/model/llm/profile/LLMProfileID;", "Lcom/intellij/ml/llm/core/models/api/AiaLlmProfileID;", "toLLModel", "Lai/koog/prompt/llm/LLModel;", "fromLLMProfileID", "toAiChatMessage", "Lcom/intellij/ml/llm/core/models/api/AiChatMessage;", "Lcom/intellij/ml/llm/grazie/adapters/PrivacySafeLLMChatFunctionMessage;", "toLLMChatMessage", "Lcom/intellij/ml/llm/grazie/adapters/PrivacySafeLLMChatMessage;", "intellij.ml.llm.core"})
public final class GrazieUtilsKt {
    public static final boolean getGrazieIsStaging() {
        return SystemProperties.getBooleanProperty((String)"ij.idea.grazie.is.staging", (boolean)false) || Registry.Companion.is("llm.use.grazie.staging.url", false);
    }

    @NotNull
    public static final LLMProfileID toLLMProfileID(@NotNull AiaLlmProfileID $this$toLLMProfileID) {
        LLMProfileID lLMProfileID;
        Intrinsics.checkNotNullParameter((Object)$this$toLLMProfileID, (String)"<this>");
        if ($this$toLLMProfileID instanceof ThirdPartyLLMProfileId) {
            lLMProfileID = new LLMProfileID(((ThirdPartyLLMProfileId)$this$toLLMProfileID).getId());
        } else {
            if (!($this$toLLMProfileID instanceof GrazieLLMProfileID)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            lLMProfileID = ((GrazieLLMProfileID)$this$toLLMProfileID).getLlmProfileID();
        }
        return lLMProfileID;
    }

    @NotNull
    public static final LLModel toLLModel(@NotNull LLMProfileID $this$toLLModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toLLModel, (String)"<this>");
        String profileId = $this$toLLModel.getId();
        LLModel lLModel = JetBrainsAIModels.INSTANCE.getLLModelById(profileId);
        if (lLModel == null) {
            throw new IllegalArgumentException("No LLModel found with id: " + profileId);
        }
        return lLModel;
    }

    @NotNull
    public static final AiaLlmProfileID fromLLMProfileID(@NotNull LLMProfileID $this$fromLLMProfileID) {
        Intrinsics.checkNotNullParameter((Object)$this$fromLLMProfileID, (String)"<this>");
        return ThirdPartyLLMProfileId.Companion.isThirdPartyProfileId($this$fromLLMProfileID.getId()) ? (AiaLlmProfileID)ThirdPartyLLMProfileId.Companion.fromString($this$fromLLMProfileID.getId()) : (AiaLlmProfileID)new GrazieLLMProfileID($this$fromLLMProfileID);
    }

    @NotNull
    public static final AiChatMessage toAiChatMessage(@NotNull PrivacySafeLLMChatFunctionMessage $this$toAiChatMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$toAiChatMessage, (String)"<this>");
        AiaLlmChatRole role = switch (WhenMappings.$EnumSwitchMapping$0[$this$toAiChatMessage.getRole().ordinal()]) {
            case 1 -> AiaLlmChatRole.System;
            case 2 -> AiaLlmChatRole.Assistant;
            case 3 -> AiaLlmChatRole.User;
            case 4 -> AiaLlmChatRole.Function;
            case 5 -> AiaLlmChatRole.Function;
            default -> throw new NoWhenBranchMatchedException();
        };
        return new AiChatMessage(role, $this$toAiChatMessage.getContent(), $this$toAiChatMessage.getFunctionName(), null, null, null, null, 120, null);
    }

    @NotNull
    public static final PrivacySafeLLMChatMessage toLLMChatMessage(@NotNull AiChatMessage $this$toLLMChatMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$toLLMChatMessage, (String)"<this>");
        LLMChatRole grazieRole = switch (WhenMappings.$EnumSwitchMapping$1[$this$toLLMChatMessage.getRole().ordinal()]) {
            case 1 -> LLMChatRole.System;
            case 2 -> LLMChatRole.Assistant;
            case 3 -> LLMChatRole.User;
            case 4 -> LLMChatRole.Function;
            default -> throw new NoWhenBranchMatchedException();
        };
        PrivacySafeLLMChatMessage msg = PrivacySafeLLMChatMessage.Companion.of(grazieRole, $this$toLLMChatMessage.getContent().toPSString(), $this$toLLMChatMessage.getFunctionName(), $this$toLLMChatMessage.getFunctionCallId(), $this$toLLMChatMessage.getThoughtSignature());
        if (StringsKt.contains$default((CharSequence)((CharSequence)$this$toLLMChatMessage.getContent()), (CharSequence)"%s", (boolean)false, (int)2, null)) {
            GrazieLLMChatMessageTestUtils.INSTANCE.getLlmChatMessageToMD().put(msg.unwrap(), $this$toLLMChatMessage.getContent());
        }
        return msg;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LLMChatRole.values().length];
            try {
                nArray[LLMChatRole.System.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMChatRole.Assistant.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMChatRole.User.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMChatRole.Function.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMChatRole.Tool.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AiaLlmChatRole.values().length];
            try {
                nArray[AiaLlmChatRole.System.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiaLlmChatRole.Assistant.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiaLlmChatRole.User.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiaLlmChatRole.Function.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

