/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.grazie.tasks.documentation;

import com.intellij.ml.llm.grazie.tasks.documentation.DatabaseSection;
import com.intellij.ml.llm.grazie.tasks.documentation.PhpEnvironmentDescription;
import com.intellij.ml.llm.grazie.tasks.documentation.PhpFrameworkContext;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0005\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0006\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000b"}, d2={"render", "", "Lcom/intellij/ml/llm/privacy/trustedStringBuilders/ConcatenateBuilder;", "task", "Lcom/intellij/ml/llm/grazie/tasks/documentation/PhpFrameworkContext;", "Lcom/intellij/ml/llm/grazie/tasks/documentation/PhpFrameworkContext$Laravel;", "Lcom/intellij/ml/llm/grazie/tasks/documentation/PhpFrameworkContext$Symfony;", "environment", "Lcom/intellij/ml/llm/grazie/tasks/documentation/PhpEnvironmentDescription;", "dataBases", "Lcom/intellij/ml/llm/grazie/tasks/documentation/DatabaseSection;", "intellij.ml.llm.core"})
public final class PhpFrameworkContextRenderKt {
    public static final void render(@NotNull ConcatenateBuilder $this$render, @NotNull PhpFrameworkContext task) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        PhpFrameworkContext phpFrameworkContext = task;
        if (phpFrameworkContext instanceof PhpFrameworkContext.Laravel) {
            PhpFrameworkContextRenderKt.render($this$render, (PhpFrameworkContext.Laravel)task);
        } else if (phpFrameworkContext instanceof PhpFrameworkContext.Symfony) {
            PhpFrameworkContextRenderKt.render($this$render, (PhpFrameworkContext.Symfony)task);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public static final void render(@NotNull ConcatenateBuilder $this$render, @NotNull PhpFrameworkContext.Laravel task) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{task.getVersion()};
        $this$render.appendLine(ConstantsKt.getPrivacyConst((String)"This is a laravel application. Laravel version is %s").format(pSStringConvertibleArray));
        PhpFrameworkContextRenderKt.render($this$render, task.getEnvironment());
    }

    public static final void render(@NotNull ConcatenateBuilder $this$render, @NotNull PhpFrameworkContext.Symfony task) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{task.getVersion()};
        $this$render.appendLine(ConstantsKt.getPrivacyConst((String)"This is a symfony application. Symfony version is %s").format(pSStringConvertibleArray));
        PhpFrameworkContextRenderKt.render($this$render, task.getDataBases());
    }

    private static final void render(ConcatenateBuilder $this$render, PhpEnvironmentDescription environment) {
        if (environment != null) {
            PSStringConvertible[] pSStringConvertibleArray;
            if (((CharSequence)environment.getAppName()).length() > 0) {
                pSStringConvertibleArray = new PSStringConvertible[]{environment.getAppName()};
                $this$render.appendLine(ConstantsKt.getPrivacyConst((String)"Application name %s.").format(pSStringConvertibleArray));
            }
            if (((CharSequence)environment.getDbName()).length() > 0) {
                pSStringConvertibleArray = new PSStringConvertible[]{environment.getDbName()};
                $this$render.appendLine(ConstantsKt.getPrivacyConst((String)"App uses database %s.").format(pSStringConvertibleArray));
            }
            if (((CharSequence)environment.getQueueConnection()).length() > 0) {
                pSStringConvertibleArray = new PSStringConvertible[]{environment.getQueueConnection()};
                $this$render.appendLine(ConstantsKt.getPrivacyConst((String)"App uses queue connection %s.").format(pSStringConvertibleArray));
            }
        }
    }

    public static final void render(@NotNull ConcatenateBuilder $this$render, @Nullable DatabaseSection dataBases) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        if (dataBases != null) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{dataBases.getDbName()};
            $this$render.appendLine(ConstantsKt.getPrivacyConst((String)"App uses database %s.").format(pSStringConvertibleArray));
        }
    }
}

