/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.hub;

import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtilKt;
import com.intellij.ml.llm.core.chat.ui.LicenseType;
import com.intellij.ml.llm.core.chat.ui.NotificationUI;
import com.intellij.ml.llm.hub.AIHubNotificationManagerKt;
import com.intellij.ml.llm.hub.Notification;
import com.intellij.ml.llm.hub.statistics.AIHubLogger;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/hub/HubLogHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "notification", "Lcom/intellij/ml/llm/hub/Notification;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/hub/Notification;)V", "onShowNotification", "", "onCloseNotification", "onActionNotification", "actionType", "Lcom/intellij/ml/llm/core/chat/ui/NotificationUI$ActionType;", "logActionClicked", "action", "Lcom/intellij/ml/llm/hub/statistics/AIHubLogger$NotificationAction;", "getLogNotificationType", "Lcom/intellij/ml/llm/hub/statistics/AIHubLogger$NotificationType;", "Lcom/intellij/ml/llm/hub/Notification$LicenseDependentNotification;", "intellij.ml.llm.core"})
@ApiStatus.Internal
public final class HubLogHelper {
    @NotNull
    private final Project project;
    @NotNull
    private final Notification notification;

    public HubLogHelper(@NotNull Project project, @NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        this.project = project;
        this.notification = notification;
    }

    public final void onShowNotification() {
        Notification notification = this.notification;
        if (notification instanceof Notification.LicenseDependentNotification) {
            LicenseType newLicenseType = this.notification instanceof Notification.LicenseExpiredFreeEnabled || this.notification instanceof Notification.LicenseExpiredTopUpFreeEnabled ? LicenseType.FREE : (AIHubNotificationManagerKt.isExpired(this.notification) ? AIAssistantUIUtilKt.getLicenseType() : null);
            AIHubLogger.INSTANCE.logNotificationShown(this.project, this.getLogNotificationType((Notification.LicenseDependentNotification)this.notification), ((Notification.LicenseDependentNotification)this.notification).getLicenseType(), newLicenseType);
        } else if (Intrinsics.areEqual((Object)notification, (Object)Notification.NO_LOCAL_MODELS.INSTANCE)) {
            AIHubLogger.INSTANCE.logNoLocalModelsNotificationShown(this.project);
        } else if (!(Intrinsics.areEqual((Object)notification, (Object)Notification.FREE_ENABLED.INSTANCE) || Intrinsics.areEqual((Object)notification, (Object)Notification.QUOTA_ALMOST_REACHED.INSTANCE) || Intrinsics.areEqual((Object)notification, (Object)Notification.THIRD_PARTY_PROVIDERS_BLOCKED.INSTANCE) || Intrinsics.areEqual((Object)notification, (Object)Notification.UPDATE_AVAILABLE.INSTANCE))) {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void onCloseNotification() {
        this.logActionClicked(AIHubLogger.NotificationAction.CLOSE);
    }

    public final void onActionNotification(@NotNull NotificationUI.ActionType actionType) {
        AIHubLogger.NotificationAction action;
        Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
        switch (WhenMappings.$EnumSwitchMapping$0[actionType.ordinal()]) {
            case 1: {
                AIHubLogger.NotificationAction notificationAction = AIHubLogger.NotificationAction.UPGRADE_NOW;
                break;
            }
            case 2: {
                AIHubLogger.NotificationAction notificationAction = AIHubLogger.NotificationAction.RENEW_NOW;
                break;
            }
            case 3: {
                AIHubLogger.NotificationAction notificationAction = AIHubLogger.NotificationAction.UPGRADE_TO_ULTIMATE;
                break;
            }
            case 4: {
                AIHubLogger.NotificationAction notificationAction = AIHubLogger.NotificationAction.ADD_TOP_UP_CREDITS;
                break;
            }
            case 5: {
                AIHubLogger.NotificationAction notificationAction = AIHubLogger.NotificationAction.ABOUT_TOP_UP_CREDITS;
                break;
            }
            default: {
                AIHubLogger.NotificationAction notificationAction = action = null;
            }
        }
        if (action != null) {
            this.logActionClicked(action);
            return;
        }
        if (actionType == NotificationUI.ActionType.LOCAL_MODELS_SETUP) {
            AIHubLogger.INSTANCE.logNoLocalModelsNotificationConfigureClicked(this.project);
            return;
        }
    }

    private final void logActionClicked(AIHubLogger.NotificationAction action) {
        if (!(this.notification instanceof Notification.LicenseDependentNotification)) {
            return;
        }
        AIHubLogger.INSTANCE.logNotificationActionClicked(this.project, this.getLogNotificationType((Notification.LicenseDependentNotification)this.notification), ((Notification.LicenseDependentNotification)this.notification).getLicenseType(), action);
    }

    private final AIHubLogger.NotificationType getLogNotificationType(Notification.LicenseDependentNotification notification) {
        AIHubLogger.NotificationType notificationType;
        Notification.LicenseDependentNotification licenseDependentNotification = notification;
        if (licenseDependentNotification instanceof Notification.LicenseExpiring) {
            notificationType = AIHubLogger.NotificationType.LicenseExpiring;
        } else if (licenseDependentNotification instanceof Notification.LicenseExpired || licenseDependentNotification instanceof Notification.LicenseExpiredFreeEnabled) {
            notificationType = AIHubLogger.NotificationType.LicenseExpired;
        } else if (licenseDependentNotification instanceof Notification.LicenseExpiredTopUp || licenseDependentNotification instanceof Notification.LicenseExpiredTopUpFreeEnabled) {
            notificationType = AIHubLogger.NotificationType.LicenseExpiredTopUp;
        } else if (licenseDependentNotification instanceof Notification.QuotaReaching) {
            notificationType = AIHubLogger.NotificationType.QuotaReaching;
        } else if (licenseDependentNotification instanceof Notification.QuotaReached) {
            notificationType = AIHubLogger.NotificationType.QuotaReached;
        } else if (licenseDependentNotification instanceof Notification.QuotaReachedTopUp) {
            notificationType = AIHubLogger.NotificationType.QuotaReachedTopUp;
        } else if (licenseDependentNotification instanceof Notification.QuotaReachedTopUpExhausting) {
            notificationType = AIHubLogger.NotificationType.QuotaReachedTopUpExhausting;
        } else if (licenseDependentNotification instanceof Notification.QuotaReachedTopUpExhausted) {
            notificationType = AIHubLogger.NotificationType.QuotaReachedTopUpExhausted;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return notificationType;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationUI.ActionType.values().length];
            try {
                nArray[NotificationUI.ActionType.UPGRADE_NOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationUI.ActionType.RENEW_NOW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationUI.ActionType.UPGRADE_TO_ULTIMATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationUI.ActionType.ADD_TOP_UP_CREDITS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationUI.ActionType.ABOUT_TOP_UP_CREDITS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

